/*
 * GetFilesListFromFolder
 * 
 * Purpose: Takes a folder location, and searches for all files in the folder.
 *
 * Parms:
 *		folder= The name of the input folder to scan
 * 		data= The output data set to create.  If unspecified, defaults to work.filelist.
 * 
 */
%macro GetFilesListFromFolder(folder=, data=WORK.FILELIST);

%setoption(off,notes);
data &data.;
	length 

		filename
		extension 
		fullname
		lowext	$256
		folder
		fullpath  $1024
		LastModified 8

	;
	format LastModified DATETIME18.;

	keep filename extension fullname folder fullpath LastModified;

	dnum = 0;

	/* Get folder entries */
	length dir entry $ 256 LastModStr $ 32 fopt $ 32 fref $ 8;

	dir="&FOLDER.";
	rc = filename(fref, dir);
	if rc = 0 then do;
		did = dopen(fref);
		rc = filename(fref);
	end;
	else do;
		msg = sysmsg();
		put msg '(DIROPEN(' dir= ')';
		did = .;
	end;

	if (did>0) then do;
		dnum = dnum(did);
		do i = 1 to dnum;  /* Process each directory entry */
			entry = dread(did, i);
			/* If this entry is a file, then process */
			fid = mopen(did, entry);
			entry = trim(dir) || "&OSSLASH." || entry;
			if fid > 0 then do;
				fopt=foptname(fid, 5); /* 5 is the ID for Last Modified */
				LastModStr=finfo(fid, fopt);
				LastModified=input(LastModStr,NLDATM.);
				rc = fclose(fid);
				fullpath=entry;

				/* Split pieces */
	            fullname  = kscan(fullpath, -1, '/\');
	            posfile   = kindex(fullpath,fullname);
	            folder    = ksubstr(fullpath,1,posfile-2);
	            if ( kindexc( fullname, '.' ) > 0 ) then do;
					filename  = kscan(fullname, -2, '.' );
					extension = kscan(fullname, -1, '.');
	            end;
	            else do;
					filename  = fullname;
					extension = '';
	            end;
				%IF ( %ISYES(AL_OPTION_DEBUG_ENABLED) ) %THEN %DO;
					put "-----";
					put i= / fullpath= / fullname= / folder= / filename= / extension=;
				%END;
				/* Filter only supported file types */
				lowext=klowcase(extension);
				if (lowext eq 'xls')  or 
				   (lowext eq 'xlsb') or 
				   (lowext eq 'xlsm') or 
				   (lowext eq 'xlsx') or 
				   (lowext eq 'csv') or 
				   (lowext eq 'tsv') or 
				   (lowext eq 'tab') or 
				   (lowext eq 'txt') 
				   then do;
				   put i ":" fullname=;
					output;
				end;
			end;
		end;
		rc=dclose(did);
	end;
run;
%setoption(restore,notes);

%mend;
