/*
 * AssignLASRLibrary
 * 
 * Purpose: Uses provided arguments to assign libref to a LASR library.
 *
 * Parms:
 *      libref= The libref to assign for the library.  Defaults to TMPLASR.
 *		host= The LASR Server Host
 *      port= The LASR Server Port
 *		tag= The LASR Server tag
 *		signer= The signer URL
 */
%macro AssignLASRLibrary( libref=TMPLASR, host=, port=, tag=WORK
						, signer=);

	%if ("&host." eq "" ) %then %do;
	   %put ERROR: Host name must be specified with HOST=;
	   %return;
	%end;

	%if ("&port." eq "" ) %then %do;
	   %put ERROR: Port must be specified with HOST=;
	   %return;
	%end;

	/* Assign LASR Library */
	libname &LIBREF. SASIOLA HOST="&HOST." PORT=&PORT. TAG="&TAG."

	%IF ("&SIGNER." ne "") %THEN %DO;
	   SIGNER="&SIGNER."
	%END;

	;

%mend;
