/*
 * AppendTable
 *
 * Purpose: Appends records from DATA onto the end of BASE
 *
 * Parameters:
 *
 *		base=		The table which should be read as the base table.
 *		data=		The table containing the records to be appended.
 *		out=		The table onto which the records are to be appended.
 *
 */ 
%macro AppendTable ( base=
				   , data=
				   , out=
				    );

	%let BASELIB=%SplitLibTable(data=%nrbquote(&BASE.), part=LIBRARY);
	%let BASETBL=%SplitLibTable(data=%nrbquote(&BASE.), part=TABLE);
	%let NLITBASE=%NLITERAL(&BASETBL.);
	%let DATALIB=%SplitLibTable(data=%nrbquote(&DATA.), part=LIBRARY);
	%let DATATBL=%SplitLibTable(data=%nrbquote(&DATA.), part=TABLE);
	%let NLITDATA=%NLITERAL(&DATATBL.);
	%let OUTLIB=%SplitLibTable(data=%nrbquote(&OUT.), part=LIBRARY);
	%let OUTTBL=%SplitLibTable(data=%nrbquote(&OUT.), part=TABLE);
	%let NLITOUT=%NLITERAL(&BASETBL.);

    %if %sysfunc(exist(&BASELIB..&NLITBASE.)) %then %do;
		/* Add rows to base from data */
		data &OUTLIB..&NLITOUT.;
			  set &BASELIB..&NLITBASE. &DATALIB..&NLITDATA.;
		run;
    %end;
    %else %do;
		/* If existing table does not exist ,just copy the source over */
		proc copy out=&OUTLIB. IN=&DATALIB.;
		   select &NLITDATA.;
		run;
	%end;


/*	%let NUMOBS=%datasetnumobs(&BASELIB..&NLITBASE.);*/
/*	data &BASELIB..&NLITBASE.;*/
/*	   numobs=&numobs.;*/
/*	   if (_n_ = 1 ) then */
/*		  modify &BASELIB..&NLITBASE. point=numobs;*/
/*	   else*/
/*	      output;*/
/*	   set &DATALIB..&NLITDATA.;*/
/*	run;*/

/*	data db.ak_append_preexist;*/
/*		if 0 then modify &BASELIB..&NLITBASE.;*/
/*		set &DATALIB..&NLITDATA.;*/
/*		output;*/
/*	run;*/

/*	%let STARTOBS=%DataSetNumObs(&base.);*/
/*	proc datasets;*/
/*		append base=&BASELIB..&NLITBASE. data=&DATALIB..&NLITDATA.;*/
/*	run;*/
/*	%let ENDOBS==%DataSetNumObs(&base.);*/

/*	%global LASTSTEPRC;*/
/*	%if (%eval(&ENDOBS. gt &STARTOBS.)) %then %let LASTSTEPRC=0;*/
/*	%else %let LASTSTEPRC=1;*/

%mend;
						
