#!/bin/sh
# Set GEODE to the product toplevel directory. This script is called by geode-locator-zos.sh
GEODE=$LOCATOR_HOME
GEODE_JARS=$GEODE/lib/geode-dependencies.jar

if [ "x$CLASSPATH" != "x" ]; then
  GEODE_JARS=$GEODE_JARS:$CLASSPATH
fi

GEODE_ARGS="$LOCATOR_HOST-$LOCATOR_PORT --port=$LOCATOR_PORT"

JAVA_ARGS="-Dgemfire.log-file=$LOCATOR_INSTANCE_HOME/gemfire.log -Dgemfire.mcast-port=0 -Djava.net.preferIPv4Stack=$USE_IPV4_STACK -Djava.net.preferIPv6Addresses=$USE_IPv6_ADDRESS -Dgemfire.locators=$LOCATORS"
echo $GEODE_ARGS
echo $GEODE_JARS
GEODE_LOCATOR_COMMAND="nohup -- $GF_JAVA $JAVA_ARGS -classpath $GEODE_JARS org.apache.geode.distributed.LocatorLauncher start $GEODE_ARGS 2>&1 1>$LOCATOR_INSTANCE_HOME/gemfireCommand.log &"
echo $GEODE_LOCATOR_COMMAND
eval $GEODE_LOCATOR_COMMAND
