#!/bin/sh
###################################################################
#
# About: This script is used to setup the required file permission
#        for PWS files.
#
###################################################################

print_usage(){
    echo "----------------------------------------"
    echo "Usage: pwsfilesetup.sh"
    echo "       pwsfilesetup.sh -h"
    echo "----------------------------------------"
    echo "[OPTIONAL] Environment variables to be set:";
    echo "PWS_ROOT_DIR      - Full path to the platform/ webapp directory";
    echo "                  - Example: /usr/tcServer/webapps/platform";
    echo "                  - (By default it assumes the dir is in parent directory.)";
    exit 0;
}

# Check if -h or invalid argument was used
if [ "$1" = "-h" -o "$1" != "" ]; then
    print_usage
fi;

if [ "$PWS_ROOT_DIR" = "" ]; then
    PWS_ROOT_DIR="../platform/"
fi;

ls $PWS_ROOT_DIR > /dev/null
if [ $? != 0 ]; then
    echo "Error (pwsfilesetup.sh): platform directory is missing in the parent directory or specified PWS_ROOT_DIR path.";
    exit 1;
fi

chmod a+x $PWS_ROOT_DIR/WEB-INF/lib/linux-x86_64/getConfigFromHost
chmod a+x $PWS_ROOT_DIR/WEB-INF/lib/aix5-64/getConfigFromHost
chmod a+x $PWS_ROOT_DIR/WEB-INF/lib/sparc-sol10-64/getConfigFromHost
chmod a+x $PWS_ROOT_DIR/WEB-INF/lib/x86-64-sol10/getConfigFromHost
chmod a+x $PWS_ROOT_DIR/WEB-INF/lib/hpuxia64/getConfigFromHost

