options mprint;
                                                                                                                                        
   /* don't change this one - it's code based                                                                                           
    * for backward compatibility.                                                                                                       
    */                                                                                                                                  
   proc format;                                                                                                                         
      value $fcmpui_correct_subtype (default=32)                                                                                        
         'MODPARMS' = 'Model'                                                                                                           
         'MODSPEC' = 'Spec';                                                                                                            
   run;


/*--------------------------------------------------------------
 * Copyright (C), 2010-2013
 * SAS Institute Inc., Cary, NC, USA.  All Rights Reserved
 * version date: 29 Jan 2013
 *
 * NAME:      fcmpui_get_index.sas
 * PURPOSE:   This will generate a dataset that contains the listing of 
 *            the cmp functions which are available from the libraries
 *            defined in the workspace.  
 *
 * USAGE:     %fcmpui_get_index( <see below> )
 *
 *PARAMETERS:
 *    THESE PARAMETERS ARE REQUIRED
 *
 *        index_dataset - 
 *                the name of the dataset write the index into
 *
 *    THESE PARAMETERS ARE OPTIONAL
 *
 *       procname - this is a special setting for risk dimensions.
 *                  risk dimensions has it's own proc known as 
 *                  proc compile which also will publish rd
 *                  methods to the index.
 *
 *       ignore_help_index -  the sashelp library can be very
 *                  large in terms of datasets.  There is a 
 *                  prepublished index dataset of functions for
 *                  sashelp to help preformance.  This parameter
 *                  indicates that the sashelp index should be 
 *                  ignored and the sashelp library examined.
 *
 *        pull_libref_paths - this is the path for where the 
 *                  function is located.
 *
 *        include_other_idx - in some cases, another idx dataset
 *                  can be provided for inclusion .  Risk Dimensions
 *                  has such a dataset for it's distortion measures.
 *
 *        exclude_libs -  there are some libs that we don't want to 
 *                  look in for functions.  There are no functions in
 *                  MAP* etc.
 *
 *-------------------------------------------------------------*/
%macro fcmpui_get_index(
         index_dataset,
         procname=fcmp,
         ignore_help_index=F,
         include_other_idx=,
         exclude_libs=%nrstr('MAPSGFK','MAPS','MAPSSAS','_RISKCWD', '_RISKTMP','_RSKJTMP','_CMPWORK','_RSKWORK','_RISKCUR'),
         func_grp_fmt=fcmpui_func_grp_fmt);
         

   /* 
    * tmp var to help determine where to write 
    */
   %local dsname;
   %let dsname=&index_dataset;

   
   %local nonotes_prevalue;
   %let nonotes_prevalue = %sysfunc(getoption(NONOTES));


   /** get me a unique tmp ds name
    *  for working 
    */
   %local interm_idx_name_prefix;
   %let   interm_idx_name_prefix = _CMPWORK._interm_index_;
   %local tempfunctionholder;
   %let tempfunctionholder   = &interm_idx_name_prefix;
   %local i;

   %do %while(%sysfunc(exist(&tempfunctionholder)));
      %let i = %eval(&i+1);
      %let tempfunctionholder= &interm_idx_name_prefix.&i;
   %end;

   %local tmpds_to_get_libpaths;
   %let tmpds_to_get_libpaths            =;

   /* get a space delimeted list of the current libraries except those we 
    * know will not have functions.
    *
    * it is faster to ask cmpindex for the functions using a specific 
    * list of librefs.  Otherwise it walks all the librefs such as MAPSAS.
    * There are some libs we prefer to skip because we know they have no 
    * functions.
    *
    */
   options nonotes;
proc sql noprint;
    select libname 
         INTO :CMPPULLIBS 
            separated by ' '
    from sashelp.vslib
    where libname not in (

         %if &ignore_help_index eq F %then %do;
            'SASHELP',
         %end;

      
      &exclude_libs);
   run;
   options &nonotes_prevalue;

   /** ask cmp to write the list of functions **/
proc &procname;
    cmpindex file=&tempfunctionholder libnames=(&CMPPULLIBS);
run;
    options nonotes;
    /*
    * There are some index datasets that I know I have to look for.
    */
    
    %if (%sysfunc(libref(risksamp))) %then %do;
    %if (%sysfunc(exist(risksamp._rdcmpidx_))) %then %do;
    %let &include_other_idx = &include_other_idx  risksamp._rdcmpidx_;
    %end;
    %end;
    /* write the combinded function listings into one
    * dataset.  Correct the data that is legacy.
    *
    */
    data &index_dataset;
    set &tempfunctionholder

      /*
      * if an additional predefined index dataset has been specified
      * merge that into the master dataset as well.
      */

   %if %eval(%length(&include_other_idx) ne 0) %then %do;
      &include_other_idx
   %end;

   /* This is the predefined index for the sashelp functions deployed
    * by cmp.
    */
   %if &ignore_help_index eq F %then %do;
      sashelp._cmpidx_
   %end;
   ;

   length group_key $32;

   group_key = put(group,$fcmpui_func_grp_fmt_reverse.);
   group     = put(group,$fcmpui_func_grp_fmt.);
 

   SubType = put(SubType,$fcmpui_correct_subtype.);
   SubTypeUP = upcase(SubtType);
   
   UPKEY=upcase(Key);
   UPFULLNAME=upcase(Fullname);

run;


proc sort data=&index_dataset(where=(Name ne '_empty_'))
out=&index_dataset reverse;
 
by FullName Type subtype;
 run;

proc sql;
 drop table &tempfunctionholder;
 run;

   options &nonotes_prevalue;
   %put ;

%mend fcmpui_get_index;




%macro fcmpui_short_index(
         index_dataset,
         datasets,
         tmp_lib,
         func_grp_fmt=fcmpui_func_grp_fmt);
         
         
data &index_dataset;
set &datasets;
   
   length group_key $32;

   group_key = put(group,$fcmpui_func_grp_fmt_reverse.);
   group     = put(group,$fcmpui_func_grp_fmt.);
 

   Type=Type;
   SubType = put(SubType,$fcmpui_correct_subtype.);
   SubTypeUP = upcase(SubtType);
   
   UPKEY=upcase(trim(Key));
   UPFULLNAME=upcase(trim(Fullname));

run;


proc sql;
create table &tmp_lib..foo362 as
select UPFULLNAME from  &index_dataset  where Type="ETSMODEL" and UPFULLNAME in (select UPFULLNAME from &index_dataset where Type="CATALOG");
delete from &index_dataset where Type="CATALOG" and UPFULLNAME in (select UPFULLNAME from &tmp_lib..foo362 );
drop table &tmp_lib..foo362;
run;

       	      
proc sort data=&index_dataset(where=(Name ne '_empty_'))
out=&index_dataset reverse;
 
by FullName Type subtype;
 run;

%mend fcmpui_short_index;


