<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml" />

<!-- 
    This stylesheet is used to modify the security settings within an ExtractMetadata 
    request. This will be used by the BI Manager plugin in SASMC to allow users
    the option whether or not they would like to export/import security related
    metadata along with the other objects.
    
    The stylesheet simply copies all of the nodes of the existing ExtractMetadata
    request while also modifying the TemplateExpand attributes for AccessControlEntries
    and AccessControlTemplates.
-->

<!--  ****************************************** -->
<!--  Main Template                              -->
<!--  ****************************************** -->
<xsl:template match="/">
   
   <xsl:element name="ExtractMetadata">
      <xsl:apply-templates select="//Metadata" /> 
      <xsl:apply-templates select="//ReposId|//ns|//flags" />
      <xsl:element name="Options">
         <xsl:element name="ExtractTemplates">
            <xsl:apply-templates select="//ExtractTemplates"/>
         </xsl:element>
      </xsl:element>
   </xsl:element>
   
</xsl:template>

<xsl:template match="//Metadata">
   <xsl:copy>
      <xsl:copy-of select="@*|node()" /> 
   </xsl:copy>
</xsl:template>

<xsl:template match="//ReposId|//ns|//flags">
   <xsl:copy>
      <xsl:copy-of select="node()" /> 
   </xsl:copy>
</xsl:template>

<xsl:template match="//ExtractTemplates">
   <xsl:call-template name="ExtractTemplate"/>
</xsl:template>

<xsl:template name="ExtractTemplate">
   <!-- for each object (top level object) -->
   <xsl:for-each select="*">
      <xsl:variable name="nodeName"><xsl:value-of select="name()"/></xsl:variable>
      <xsl:choose>
         <xsl:when test="$nodeName='AccessControlEntry'">
            <!-- call the AccessControl template passing in "yes" for the TemplateExpand attribute -->
            <xsl:call-template name="AccessControl">
               <xsl:with-param name="Expand" select="'yes'"/>
            </xsl:call-template>
         </xsl:when>
         <xsl:when test="$nodeName='AccessControlTemplate'">
            <!-- call the AccessControl template passing in "connect" for the TemplateExpand attribute -->
            <xsl:call-template name="AccessControl">
               <xsl:with-param name="Expand" select="'connect'"/>
            </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
            <xsl:copy>
               <!-- copy each attribute -->
               <xsl:for-each select="@*">
                  <xsl:copy/>
               </xsl:for-each>
               <!-- recusively call the template again -->
	       <xsl:call-template name="ExtractTemplate"/>
            </xsl:copy>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:for-each>

</xsl:template>

<xsl:template name="AccessControl">
   <xsl:param name="Expand"/>
   <xsl:copy>
      <!-- for each attribute -->
      <xsl:for-each select="@*">
         <xsl:variable name="attrName"><xsl:value-of select="name(.)"/></xsl:variable>
         <!-- if not the TemplateExpand attribute -->
         <xsl:if test="not($attrName='TemplateExpand')">
            <!-- copy the attribute -->
            <xsl:copy/>
         </xsl:if>
         <!-- if the TemplateExpand change the value-->
         <xsl:if test="($attrName='TemplateExpand')">
            <xsl:attribute name="TemplateExpand">
               <xsl:value-of select="$Expand"/>
            </xsl:attribute>
         </xsl:if>
      </xsl:for-each>
      <xsl:call-template name="ExtractTemplate"/>
   </xsl:copy>
   
</xsl:template>

</xsl:stylesheet>
