<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
<xsl:output
   method="xml"
   omit-xml-declaration="{0}"
   encoding="utf-8" />


<!-- =======================================================================
     Purpose: An XSL transform to strip attributes
              'MetadataUpdated' and 'MetadataCreated'.
              
              The value "yes" or "no" must be substituted into this
              message format in order to designate whether or not
              an XML declaration should be omitted in the transformed output.
     
     from

      Author: Doug Melzer
        Date: 18Mar2005

     Date       Who  Modification
     =========  ===  =======================================================
     20Sep2002  DKM  Initial creation.
     18Mar2005  DKM  Added a Message format option so that one can take
                     this transform and substitute either "yes" or "no"
                     depending upon whether an XML declaration is desired
                     in the output.
     ======================================================================= -->


<!-- =======================================================================
     Build document structure and static content
     ======================================================================= -->
<xsl:template match="/">
   <xsl:apply-templates select="*"/>
</xsl:template>


<!-- =======================================================================
     Do not copy the MetadataCreated and MetadataUpdated attributes.
     ======================================================================= -->
<xsl:template match="@MetadataCreated | @MetadataUpdated">
</xsl:template>


<!-- =======================================================================
     Copy every attribute.
     ======================================================================= -->
<xsl:template match="@*">
   <xsl:copy/>
</xsl:template>


<!-- =======================================================================
     Copy all other elements including their attributes and subelements.
     ======================================================================= -->
<xsl:template match="*">
   <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="*"/>
   </xsl:copy>
</xsl:template>


</xsl:stylesheet>