<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
<xsl:output method="text" />


<!-- =======================================================================
     Purpose: Translate an XML file containing an "Metadata" root element that
              is used to add metadata specifying a foundation service deployment
              into a SAS Metadata Server.

              SoftwareComponent elements representing foundation service
              deployments optionally matching one or more foundation service
              deployment names (SoftwareComponent.Name). The
              purpose of this XSL transform is to output a text string
              containing just the names of the SoftwareComponent elements. Each
              name will be delimited by an '%' character.

              This XSL transform is used by the foundation service deployment
              importer to ensure that we don't import a foundation service
              deployment that is already defined in a SAS Metadata Server.

      Author: Doug Melzer
        Date: 20Sep2002

     Date       Who  Modification
     =========  ===  =======================================================
     20Sep2002  DKM  Initial creation.
     ======================================================================= -->



<!-- =======================================================================
     Build document structure and static content
     ======================================================================= -->
<xsl:template match="/">
   <xsl:apply-templates select="Metadata/SoftwareComponent"/>
</xsl:template>



<!-- =======================================================================
     Copy the name of the foundation service deployment
     (i.e. SoftwareComponent.Name)
     Leading and trailing white space will be stripped from the name.
     Demarcate each name using a '%' character.
     ======================================================================= -->
<xsl:template match="SoftwareComponent">

   <xsl:copy><xsl:value-of select="normalize-space(@Name)"/>%</xsl:copy>

</xsl:template>


</xsl:stylesheet>