<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
<xsl:output
   method="xml"
   omit-xml-declaration="no"
   encoding="utf-8"
   indent="yes"
   standalone="yes" />


<!-- =======================================================================
     Purpose: An XSL transform to translate an OMI query that retrieved
     a TextStore containing a StoredText attribute whose value is desired
     as text.
     
     from
     
     <GetMetadataObjects>
        <ReposId/>
        <Type/>
        <Objects>
           <TextStore StoredText="&lt;?xml ... &gt;"/>
        </Objects>
     </GetMetadataObjects>
     
     to
     
     &lt;?xml ... &gt;

      Author: Doug Melzer
        Date: 27Oct2005
     ======================================================================= -->


<!-- =======================================================================
     Select the TextStore.
     ======================================================================= -->
<xsl:template match="/">
   <xsl:apply-templates select="GetMetadataObjects/Objects/TextStore"/>
</xsl:template>


<!-- =======================================================================
     Copy the value TextStore element's StoredText attribute.
     ======================================================================= -->
<xsl:template match="TextStore">
  <xsl:copy><xsl:value-of select="@StoredText"/></xsl:copy>
</xsl:template>

</xsl:stylesheet>