<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
<xsl:output
   method="xml"
   omit-xml-declaration="no"
   encoding="utf-8"
   indent="yes"
   standalone="yes" />


<!-- =======================================================================
     Purpose: An XSL transform to translate 
     
     from
     
     <GetMetadataObjects>
        <ReposId/>
        <Type/>
        <Objects>
           <...>
        </Objects>
     </GetMetadataObjects>
     
     to
     
     <Metadata>
        <...>
     </Metadata>

      Author: Doug Melzer
        Date: 23Aug2002

     Date       Who  Modification
     =========  ===  =======================================================
     23Aug2002  DKM  Initial creation.
     28May2003  DKM  Changed root element from MdObjectStore to Metadata
     ======================================================================= -->


<!-- =======================================================================
     Build document structure and static content
     ======================================================================= -->
<xsl:template match="/">
   <xsl:apply-templates select="GetMetadataObjects/Objects"/>
</xsl:template>


<!-- =======================================================================
     Do not copy the GetMetadata element.
     ======================================================================= -->
<xsl:template match="GetMetadataObjects/Objects">
   <xsl:element name="Metadata">
      <xsl:apply-templates select="*" />
   </xsl:element>
</xsl:template>


<!-- =======================================================================
     Copy every attribute.
     ======================================================================= -->
<xsl:template match="@*">
   <xsl:copy/>
</xsl:template>


<!-- =======================================================================
     Copy all other elements including their attributes and subelements.
     ======================================================================= -->
<xsl:template match="*">
   <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="*"/>
   </xsl:copy>
</xsl:template>


</xsl:stylesheet>