%global ErrorProcessing;
%let ErrorProcessing=0;
%let dlmItems=.; /* only necessary for pre-v9.2 datasets */

data _null_;

  length uri cube_uri pers_uri dim_uri hier_uri meas_uri lev_uri $256;
  length itype $13; /* "Person" or "IdentityGroup" */
  length auth $1;   
  length name perm  msg $256;
  length condition $32000;
  length measure level $32;
  length dlmItems   $1 ;
  
   
  uri='';
  cube_uri='';
  pers_uri='';
  dim_uri='';
  hier_uri='';
  meas_uri='';
  lev_uri='';
  itype='';
  name='';
  perm='';
  auth='';
  condition='';
  measure='';
  level='';
   

  dlmItems      = symgetc("dlmItems");
 
  set &aciOLAPTable; 

  /* check version */
  if permission = '' then v=91; else v=92;

  /* Get Cube */
  
  if (trim(left(cube)) ne '' or trim(left(olapschema)) ne '');

  cube_uri = "omsobj:Cube?Cube[@Name='"
             || trim(left(cube))
             || "'][AssociatedOLAPSchema/OLAPSchema[@Name='"
             || trim(left(olapschema)) 
             || "']]";
             
  rc = metadata_getattr(cube_uri, "ID", cube_uri);  
  uri=cube_uri; 
  link checkrc;
  /* Get Identity */
  pers_uri = "omsobj:Person?@Name='" !! trim(left(fullname)) !! "'";
  rc = metadata_getattr(pers_uri,"Id", pers_uri );
  if rc = 0 then do;
    itype='Person';
  end;

  else if rc ne 0 then do;
    pers_uri = "omsobj:IdentityGroup?@Name='" !! trim(left(fullname)) !! "'";
    rc = metadata_getattr(pers_uri,"Id", pers_uri );
    if rc = 0 then do;
      itype='IdentityGroup';
    end;

    else if rc ne 0 then do;
	  msg = trim(left(fullname));
      put "&noPerson " msg;
      put "&recordNo " _n_;
	  call symput('ErrorProcessing','1');	
      stop;
    end;
  end;
  
  if remove_ace = ' ' then remove_ace = 'N';
  /* Get authorization */
  select (upcase(remove_ace));
    when ('Y') auth="R";
    when ('N') do;
      select (upcase(substr(left(perm_type),1,1)));
        when ('D') auth="D";
        when ('G') auth="G";
	    when ('')  auth="G";
	    otherwise do;
	      put "&invalidPerm " perm_type;
		  put "&recordNo " _n_;
		  call symput('ErrorProcessing','1');	
          stop;
	    end;
	  end;
	end;
	otherwise do;
      put "&invalidRemoveACE " remove_ace;
      put "&recordNo " _n_;
      call symput('ErrorProcessing','1');	
      stop;
	end;
  end;

  /* Cube permissions */
  
  if upcase(substr(left(perm_type),2,1)) = 'C' then do;
    uri = cube_uri;
    link SETAUTH;
  end;

  /* Get Dimension ID */
  else do;
    dim_uri = "omsobj:Dimension?Dimension[@Name='"
	          || trim(left(dimension))
	          || "'][Cubes/Cube[@id='"
	          || trim(left(cube_uri))
	          || "']]";
    rc = metadata_getattr(dim_uri, "ID", dim_uri);
      
	select (rc);
	   when (-1) do;
	    put "&noConnect";
	    call symput('ErrorProcessing','1');	
	   end;
	   when (-3) do;
	     msg = "CUBE: " || trim(left(cube)) || " DIMENSION: " || trim(left(dimension)); 
         put "&dimNotFound " msg;
         put "&recordNo " _n_;
         call symput('ErrorProcessing','1');	
       end;
       otherwise;
	 end;
   end; 


  select (upcase(substr(left(perm_type),2,1)));
    /* Dimension */
    when ("D") do;
	  uri = dim_uri;
	   
	  link SETAUTH;
    end;
    /* Hierarchy */
	when ("H") do;
	  hier_uri = "omsobj:Hierarchy?Hierarchy[@Name='"
	             || trim(left(items))
	             || "'][OwningDimension/Dimension[@id='"
	             || trim(left(dim_uri))
	             || "']]";
	  rc = metadata_getattr(hier_uri, "ID", uri);
	  select (rc);
        when (-1) do;
          put "&noConnect";
          call symput('ErrorProcessing','1');	
        end;
	    when (-3) do; 
		  msg = "CUBE: " || trim(left(cube)) || " DIMENSION: " || trim(left(dimension)) || " HIERARCHY: " || trim(left(items)); 
          put "&hierNotFound " msg;
          call symput('ErrorProcessing','1');	
		end;
	    otherwise;
	  end;
	  link SETAUTH;
    end;
	when ("M") do;;
	  n=1;
      do while (n > 0);
        measure = trim(left(SCAN(items,n,dlmItems)));
        varLength=lengthn(measure);
        if varLength=0 then do;
          n=0;
        end;
        else do;
	      meas_uri = "omsobj:Measure?Measure[@Name='"
	                 || trim(left(measure))
	                 || "'][Cubes/Cube[@id='"
	                 || trim(left(cube_uri))
	                 || "']]";
          
	      rc = metadata_getattr(meas_uri, "ID", uri);
          select (rc);
	        when (-1) do;
	          put "&noConnect";
	          call symput('ErrorProcessing','1');	
	        end;
	        when (-3) do; 
		      msg = "CUBE: " || trim(left(cube)) || " MEASURE: " || trim(left(measure)) ; 
              put "&measureNotFound " msg;
              call symput('ErrorProcessing','1');	
		    end;
	      otherwise;
	      end;
	      link SETAUTH;
          n = n+1;
		end;
      end;
	end;
	when ("L") do;
	  n=1;
      do while (n > 0);
        level = trim(left(SCAN(items,n,dlmItems)));
        varLength = lengthn(level);
        if varLength=0 then do;
          n=0;
        end;
        else do;
	      lev_uri = "omsobj:Level?Level[@Name='"
	                || trim(left(level))
  	                || "'][OwningDimension/Dimension[@id='"
	                || trim(left(dim_uri))
	                || "']]";
 	      rc = metadata_getattr(lev_uri, "ID", uri);
	      select (rc);
	        when (-1) do;
	          put "&noConnect";
	          call symput('ErrorProcessing','1');	
	        end;
	        when (-3) do; 
		      msg = "CUBE: " || trim(left(cube)) || " DIMENSION: " || trim(left(dimension)) || " LEVEL: " || trim(left(level)) ; 
              put "&levelNotFound " msg;
              call symput('ErrorProcessing','1');	
		    end;
	        otherwise;
	      end;
	      link SETAUTH;
          n = n+1;
		end;
      end;
	end;

	when ("");
    otherwise;
  end;
  * Permission Condition;
  if mdx_condition > '' then do;
	if dimension > '' then do;
	  if auth ne 'R' then auth='G';
	  rc = METASEC_SETAUTH("", dim_uri, itype, trim(left(fullname)),auth,'Read',trim(left(mdx_condition)));
      if rc ne 0 then do;
        put "&errorSettingPerm  " _n_;
        msg = sysmsg();
	    put rc= msg=;
	    call symput('ErrorProcessing','1');	
      end;
	  else do;
	    put "&successSettingPermCond  " _n_;
	  end;
	end;
  end;
     
  
return;

SETAUTH:
  /* v9.1 */

  if v=91 then do;
    rc = METASEC_SETAUTH("", uri, itype, trim(left(fullname)), auth, 'Read','');
    if rc ne 0 then do;
      put "&errorSettingRead  " _n_;
  	  put uri itype fullname auth; 
      msg = sysmsg();
      put rc= msg=;
    end;
    else do;  
       put "&successSettingRead  " _n_;
    end;
    rc = METASEC_SETAUTH("", uri, itype, trim(left(fullname)), auth, 'ReadMetadata','');
    if rc ne 0 then do;  
      put "&errorSettingReadMetadata " _n_;
      msg = sysmsg();
      put rc= msg=;
    end;
    else do;
      put "&successSettingReadMetadata  " _n_;
    end;
  end;

  /* v9.2 */
  else do;
     
    rc = METASEC_SETAUTH("", uri, itype, trim(left(fullname)), auth, permission,'');
    if rc ne 0 then do;
      put "&errorRecordNumber " _n_;
      put "&errorSettingPerm  " permission;
  	  put uri itype fullname auth; 
      msg = sysmsg();
      put rc= msg=;
      call symput('ErrorProcessing','1');	
    end;
    else do;
       put permission " &permissionSet  " _n_;
    end;

  end;
return;

checkrc:
  select (rc);
    when (-1) put "&noConnectMsg";
    when (-2) put "&noAttrMsg  " uri;
    when (-3) put "&noMatch  " uri;
    when (-4) put "&notFound  " uri;
  
     otherwise;
  end;
  if rc < 0 then  do;
  call symput('ErrorProcessing','1');	
  stop;
  end;
return;


run;

