<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
<xsl:output
   method="xml"
   omit-xml-declaration="no"
   encoding="utf-8"
   standalone="yes"
   indent="yes" />


<!-- =======================================================================
     Purpose: An XSL transform that can be used to replace the value of
              a SoftwareComponent.Name. 
              
              For example, a Foundation Services
              deployment uses SoftwareComponent.Name to represent an
              application's service deployment. When importing a service
              deployment into a SAS Metadata Repository it may be necessary
              to rename the service deployment in order to ensure that
              the name is unique within the repository.

      Author: Doug Melzer
        Date: 11Jul2003

     Date       Who  Modification
     =========  ===  =======================================================
     11Jul2003  DKM  Initial creation.
     ======================================================================= -->


<!-- =======================================================================
     Build document structure and static content
     ======================================================================= -->
<xsl:template match="/">
   <xsl:apply-templates select="*"/>
</xsl:template>


<!-- =======================================================================
     Template to match a SoftwareComponent that has a Name attribute.
     Copy the element, but replace the value of its Name attribute.
     
     <xsl:copy>
            <xsl:call-template name="replace-string">
               <xsl:with-param name="text"    select="."/>
               <xsl:with-param name="replace" select="."/>
               <xsl:with-param name="with"    select="'SoftwareComponent.Name'"/>
            </xsl:call-template>
         </xsl:copy>
     ======================================================================= -->
<xsl:template match="SoftwareComponent[@Name]">

   <xsl:copy>
   
   
   <xsl:for-each select="@*">
   <xsl:choose>
      <xsl:when test="name()='Name'">
         <xsl:attribute name="Name">
            <xsl:value-of select="'%SoftwareComponent.Name%'"/>
         </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy/>
      </xsl:otherwise>
   </xsl:choose>
   
   </xsl:for-each>
         
      <xsl:apply-templates select="*"/>
               
   </xsl:copy>
      
</xsl:template>



<!-- =======================================================================
     Copy every attribute.
     ======================================================================= -->
<xsl:template match="@*">
   <xsl:copy/>
</xsl:template>

<!-- =======================================================================
     Copy all other elements including their attributes and subelements.
     ======================================================================= -->
<xsl:template match="*">
   <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="*"/>
   </xsl:copy>
</xsl:template>


<!-- =======================================================================
     Template: string replacement
     ======================================================================= -->
  <xsl:template name="replace-string">
    <xsl:param name="text"/>
    <xsl:param name="replace"/>
    <xsl:param name="with"/>
    <xsl:choose>
      <xsl:when test="contains($text,$replace)">
        <xsl:value-of select="substring-before($text,$replace)"/>
        <xsl:value-of select="$with"/>
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text"    select="substring-after($text,$replace)"/>
          <xsl:with-param name="replace" select="$replace"/>
          <xsl:with-param name="with"    select="$with"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>