<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
<xsl:output
   method="xml"
   omit-xml-declaration="no"
   encoding="utf-8"
   standalone="yes" />


<!-- =======================================================================
     Purpose: Parse XML representing a platform service deployment that can be
              imported into an Open Metadata Repository (OMR) to obtain
              just the name(s) of the platform service deployment(s) defined
              in the metadata.

              This XSL transform is used by the
              Platform Service Manager Plug-In's service deployment import
              capability.

      Author: Doug Melzer
        Date: 15Mar2002

     Date       Who  Modification
     =========  ===  =======================================================
     15Mar2002  DKM  Initial creation.
     22Aug2002  DKM  File syntax changed. 
                     Root element is now "MdObjectStore"
     ======================================================================= -->



<!-- =======================================================================
     Build document structure and static content
     ======================================================================= -->
<xsl:template match="/">
   <xsl:apply-templates select="*"/>
</xsl:template>


<!-- =======================================================================
     Copy the Metadata element and all of its sub-elements.
     ======================================================================= -->
<xsl:template match="Metadata">
   <xsl:copy>
      <xsl:apply-templates select="*" />
   </xsl:copy>
</xsl:template>


<!-- =======================================================================
     Copy every attribute.
     ======================================================================= -->
<xsl:template match="@*">
   <xsl:copy/>
</xsl:template>


<!-- =======================================================================
     Copy all other elements including their attributes and subelements.
     ======================================================================= -->
<xsl:template match="*">
   <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="*"/>
   </xsl:copy>
</xsl:template>


</xsl:stylesheet>