<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
<xsl:output
   method="xml"
   omit-xml-declaration="no"
   encoding="utf-8"
   standalone="yes" />

<!-- =======================================================================
     Purpose: An XSL transform to translate the metadata IDs in a services
     XML file to temporary IDs by prefixing each ID with a $ character and
     to strip the MetadataUpdated and MetadataCreated attributes.
     
     from

      Author: Doug Melzer
        Date: 03Feb2006

     Date       Who  Modification
     =========  ===  =======================================================
     03Feb2006  DKM  Initial creation.
     ======================================================================= -->


<!-- =======================================================================
     Build document structure and static content
     ======================================================================= -->
<xsl:template match="/">
   <xsl:apply-templates select="MdObjectStore"/>
   <xsl:apply-templates select="Metadata"/>
</xsl:template>


<!-- =======================================================================
     Do not copy the GetMetadata element.
     ======================================================================= -->
<xsl:template match="MdObjectStore">
   <MdObjectStore><xsl:apply-templates select="*" /></MdObjectStore>
</xsl:template>


<xsl:template match="Metadata">
   <Metadata><xsl:apply-templates select="*" /></Metadata>
</xsl:template>


<!-- =======================================================================
     Do not copy the MetadataCreated and MetadataUpdated attributes.
     ======================================================================= -->
<xsl:template match="@MetadataCreated | @MetadataUpdated">
</xsl:template>


<!-- =======================================================================
     Copy ObjRef attribute, but update its ID to prefix a $
     ======================================================================= -->
<xsl:template match="@ObjRef[not(starts-with(., '$'))]">
   <xsl:attribute name="ObjRef">
      <xsl:value-of select="concat('$', string(.))" />
   </xsl:attribute>
</xsl:template>


<!-- =======================================================================
     Copy Id attribute, but update its repository ID to prefix a $
     ======================================================================= -->
<xsl:template match="@Id[not(starts-with(., '$'))]">
   <xsl:attribute name="Id">
      <xsl:value-of select="concat('$', string(.))" />
   </xsl:attribute>
</xsl:template>


<!-- =======================================================================
     Copy every attribute.
     ======================================================================= -->
<xsl:template match="@*">
   <xsl:copy/>
</xsl:template>


<!-- =======================================================================
     Copy all other elements including their attributes and subelements.
     ======================================================================= -->
<xsl:template match="*">
   <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="*"/>
   </xsl:copy>
</xsl:template>


</xsl:stylesheet>