<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:NonHtml="http://www.progress.com/StylusStudio/NonHtml" exclude-result-prefixes="NonHtml">
<xsl:output method="html"/>

<xsl:param name="title" select="'Column Standardization Report'"/>
<xsl:param name="subtitle" select="'Non-Standard columns selected for Standardization'"/>
<xsl:param name="groupDetails" select="'GROUP DETAILS:'"/>
<xsl:param name="groupDetails_parameter" select="'Parameter'"/>
<xsl:param name="groupDetails_value" select="'Value'"/>
<xsl:param name="groupDetails_groupName" select="'Group Name'"/>
<xsl:param name="groupDetails_searchCriteria" select="'Search criteria'"/>
<xsl:param name="groupDetails_totalCount" select="'Total Count'"/>
<xsl:param name="groupDetails_includedColumnCount" select="'Total Included Column Count'"/>
<xsl:param name="groupDetails_updatedColumnCount" select="'Total Updated Column Count'"/>
<xsl:param name="columnDetails" select="'COLUMN DETAILS'"/>
<xsl:param name="columnDetails_colId" select="'Column ID'"/>
<xsl:param name="columnDetails_tableName" select="'Table Name'"/>
<xsl:param name="columnDetails_libName" select="'Library Name'"/>
<xsl:param name="columnDetails_colType" select="'Column Type'"/>
<xsl:param name="columnDetails_colLength" select="'Column Length'"/>
<xsl:param name="columnDetails_sasLibName" select="'SAS Library Name'"/>
<xsl:param name="columnDetails_colMetadataId" select="'Column Metadata ID'"/>
<xsl:param name="columnDetails_sortOrder" select="'Sort order'"/>
<xsl:param name="columnDetails_description" select="'Description'"/>
<xsl:param name="columnDetails_objType" select="'Object Type'"/>
<xsl:param name="columnDetails_sasFormat" select="'SAS Format'"/>
<xsl:param name="columnDetails_isNullable" select="'Is Nullable'"/>
<xsl:param name="columnDetails_summaryRole" select="'Summary Role'"/>
<xsl:param name="columnDetails_sasColumnName" select="'SAS Column Name'"/>
<xsl:param name="columnDetails_sasInformat" select="'SAS Informat'"/>
<xsl:param name="columnDetails_DatabaseSchemaName" select="'Database Schema Name'"/>
<xsl:param name="columnDetails_ExternalTableName" select="'External Table Name'"/>

<xsl:param name="Note" select="'*UPDATE IGNORED : The existing metadata values are same to specified standard values hence metadata update is ignroed.'"/>

<xsl:template match="/">
	<html><head><title><xsl:value-of select="$title"/></title></head>
		<body>
			<p align="center">
				<strong>
					<font size="5"><xsl:value-of select="$title"/></font>
				</strong>
			</p>
			<p align="center">
				<strong>
					<font size="5"><xsl:value-of select="$subtitle"/></font>
				</strong>
			</p>
			<xsl:for-each select="report/header">
			<p align="center">
				<strong>
				
					<font size="5"/><xsl:value-of select="@headervalue"/>
				</strong>
			</p>
			</xsl:for-each>
			<xsl:for-each select="report/group">
				<p align="center">
				<strong>
					<font size="5"/>
				</strong>
			</p>
				<p>&#160; </p>
				<p><xsl:value-of select="$groupDetails"/> :</p>
				<p>
					<table width="100%" border="1">
						<tbody>
							<tr>
								<td width="50%"><xsl:value-of select="$groupDetails_parameter"/></td>
								<td width="50%"><xsl:value-of select="$groupDetails_value"/></td>
							</tr>
							<tr>
								<td width="50%"><xsl:value-of select="$groupDetails_groupName"/></td>
								<td width="50%">
									<xsl:value-of select="@name"/>
								
								</td>
							</tr>
							<tr>
								<td width="50%"><xsl:value-of select="$groupDetails_searchCriteria"/></td>
								<td width="50%"/>
							</tr>
							<tr>
								<td width="50%"><xsl:value-of select="$groupDetails_totalCount"/></td>
								<td width="50%">
									<xsl:value-of select="@count"/>
								</td>
							</tr>
							<tr>
								<td width="50%"><xsl:value-of select="$groupDetails_includedColumnCount"/></td>
								<td width="50%">
									<xsl:value-of select="@includedcount"/>
								</td>
							</tr>
							<tr>
								<td width="50%"><xsl:value-of select="$groupDetails_updatedColumnCount"/></td>
								<td width="50%">
									<xsl:value-of select="@updatecount"/>
								</td>
							</tr>
						</tbody>
					</table>
				</p><xsl:value-of select="$columnDetails"/><![CDATA[ ]]>
				<xsl:for-each select="column">
				<p>
				<table width="100%">
					<tbody>
						<tr>
							<td><xsl:value-of select="$columnDetails_colId"/> = 
								<xsl:value-of select="@ColumnId"/>
							</td>
							<td align="right">
								<xsl:value-of select="@valuechanged"/>
							</td>
						</tr>
					</tbody>
				</table>
				</p>
					<table width="100%" border="1" empty-cell="show">
							<tbody>
								
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_tableName"/></td>
									<td width="50%">
										<xsl:value-of select="@table"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_ExternalTableName"/></td>
									<td width="50%">
										<xsl:value-of select="@ExternalTableName"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_libName"/></td>
									<td width="50%">
										<xsl:value-of select="@library"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_colType"/></td>
									<td width="50%">
										<xsl:value-of select="@SASColumnType"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_colLength"/></td>
									<td width="50%">
										<xsl:value-of select="@SASColumnLength"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_sasLibName"/></td>
									<td width="50%">
										<xsl:value-of select="@SASLibraryName"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_DatabaseSchemaName"/></td>
									<td width="50%">
										<xsl:value-of select="@SchemaName"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_colMetadataId"/></td>
									<td width="50%">
										<xsl:value-of select="@ColumnId"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_sortOrder"/></td>
									<td width="50%">
										<xsl:value-of select="@SortOrder"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_description"/></td>
									<td width="50%">
										<xsl:value-of select="@Desc"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_objType"/></td>
									<td width="50%">
										<xsl:value-of select="@MetadataObjectType"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_sasFormat"/></td>
									<td width="50%">
										<xsl:value-of select="@SASFormat"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_isNullable"/></td>
									<td width="50%">
										<xsl:value-of select="@IsNullable"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_summaryRole"/></td>
									<td width="50%">
										<xsl:value-of select="@SummaryRole"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_sasColumnName"/></td>
									<td width="50%">
										<xsl:value-of select="@SASColumnName"/>
									</td>
								</tr>
								<tr>
									<td width="50%"><xsl:value-of select="$columnDetails_sasInformat"/></td>
									<td width="50%">
										<xsl:value-of select="@SASInformat"/>
									</td>
								</tr>
							</tbody>
						</table>
					
					<p/>
				</xsl:for-each>
				<p>&#160;</p>
			</xsl:for-each>
			
			<p><xsl:value-of select="$Note"/></p>
		</body>
	</html>
</xsl:template>

</xsl:stylesheet><!-- Stylus Studio meta-information - (c) 2004-2006. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="GroupByXMl.xml" htmlbaseurl="" outputurl="" processortype="internal" useresolver="yes" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext="" validateoutput="no" validator="internal" customvalidator=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition><TemplateContext></TemplateContext><MapperFilter side="source"></MapperFilter></MapperMetaTag>
</metaInformation>
-->