/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.util.UsageVersion;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractVersionedObjectManager;
import com.sas.workspace.models.SimpleObject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.rmi.RemoteException;

public class VersionValidator {
    public static final String VERSION_INCOMPATIBLE_EVENT = "VersionIncompatibleEvent";
    public static final String VERSION_COMPATIBLE_EVENT = "VersionCompatibleEvent";
    private static final Object classLock = VersionValidator.class;
    private static VersionValidator myInstance;
    private WsAbstractVersionedObjectManager manager = WsAbstractVersionedObjectManager.getInstance();
    private final PropertyChangeSupport versionInfoListeners = new PropertyChangeSupport(this);

    private VersionValidator() {
        if (this.manager == null) {
            throw new IllegalStateException("Unable to create a versioned object manager");
        }
        if (this.versionInfoListeners == null) {
            throw new IllegalStateException("Unable to obtain version validator PropertyChangeSupport");
        }
        this.registerVersions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionValidator getInstance() {
        Object object = classLock;
        synchronized (object) {
            if (myInstance == null) {
                myInstance = new VersionValidator();
            }
        }
        return myInstance;
    }

    private void registerVersions() {
        UsageVersion defaultMin = new UsageVersion(1, 0);
        UsageVersion defaultMax = new UsageVersion(1, 0);
        UsageVersion deployJobMax = new UsageVersion(2, 0);
        UsageVersion cubeAttrMax = new UsageVersion(5, 0);
        UsageVersion cubeAttrMin = new UsageVersion(4, 0);
        if (!this.manager.isRegistered("Cube")) {
            this.manager.registerVersion("Cube", cubeAttrMin, cubeAttrMax);
        }
        if (!this.manager.isRegistered("OLAPSchema")) {
            this.manager.registerVersion("OLAPSchema", defaultMin, defaultMax);
        }
        if (!this.manager.isRegistered("SharedDimension")) {
            this.manager.registerVersion("SharedDimension", defaultMin, defaultMax);
        }
        if (!this.manager.isRegistered("DeployedJob")) {
            this.manager.registerVersion("DeployedJob", defaultMin, deployJobMax);
        }
        if (!this.manager.isRegistered("Job.CubeBuild")) {
            this.manager.registerVersion("Job.CubeBuild", defaultMin, defaultMax);
        }
        if (!this.manager.isRegistered("Table")) {
            this.manager.registerVersion("Table", defaultMin, defaultMax);
        }
        if (!this.manager.isRegistered("Library")) {
            this.manager.registerVersion("Library", defaultMin, defaultMax);
        }
        if (!this.manager.isRegistered("Note")) {
            this.manager.registerVersion("Note", defaultMin, defaultMax);
        }
        if (!this.manager.isRegistered("Document")) {
            this.manager.registerVersion("Document", defaultMin, defaultMax);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            PropertyChangeListener[] list = this.versionInfoListeners.getPropertyChangeListeners();
            boolean containsListener = false;
            for (int i = 0; i < list.length; ++i) {
                PropertyChangeListener current = list[i];
                if (!listener.equals(current)) continue;
                containsListener = true;
                break;
            }
            if (!containsListener) {
                this.versionInfoListeners.addPropertyChangeListener(listener);
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.versionInfoListeners.removePropertyChangeListener(listener);
    }

    private boolean isVersionSupported(String publicType, UsageVersion instanceVersion) {
        boolean returnValue = true;
        if (this.manager != null && !this.manager.isVersionSupported(publicType, instanceVersion)) {
            returnValue = false;
        } else {
            UsageVersion max = this.manager.getCurrentVersion(publicType);
            if (instanceVersion.compareMajorMinor(max) > 0) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    public boolean isVersionSupported(SimpleObject obj) {
        boolean returnValue = true;
        if (obj != null && obj instanceof SimpleObject) {
            try {
                String publicType;
                LogicalObjectInterface lo = ObjectConverter.getInstance().convertToLogicalObject(obj);
                if (lo != null && (publicType = lo.getTypeInterface().getPublicType()) != null && publicType.length() > 0) {
                    UsageVersion instanceVersion = lo.getUsageVersion();
                    returnValue = this.isVersionSupported(publicType, instanceVersion);
                    if (!returnValue) {
                        this.versionInfoListeners.firePropertyChange(VERSION_INCOMPATIBLE_EVENT, instanceVersion, obj);
                    } else {
                        this.versionInfoListeners.firePropertyChange(VERSION_COMPATIBLE_EVENT, instanceVersion, obj);
                    }
                }
            }
            catch (MdException me) {
                Workspace.getDefaultLogger().error((Object)me.getLocalizedMessage(), (Throwable)me);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (LogicalTypeException e) {
                Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }

    public boolean isSupportedForVersioning(SimpleObject sObject) {
        boolean returnValue = true;
        String publicType = sObject.getPublicType();
        if (publicType != null && publicType.length() > 0) {
            if (this.manager != null) {
                UsageVersion uv = this.manager.getMinimumSupportedVersion(publicType);
                if (uv == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return returnValue;
    }

    public boolean isUpgradeable(SimpleObject sObject) {
        boolean returnValue = true;
        String sType = sObject.getPublicType();
        if (sType == null || sType.length() == 0) {
            return false;
        }
        LogicalObjectInterface lo = null;
        try {
            lo = ObjectConverter.getInstance().convertToLogicalObject(sObject);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (LogicalTypeException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (lo != null) {
            if (!WsAbstractVersionedObjectManager.isUpgradeable((String)sType, (UsageVersion)lo.getUsageVersion())) {
                return false;
            }
        } else {
            return false;
        }
        return returnValue;
    }

    public boolean isVersionSupported(String publicType, IComplexPersistableObject obj) {
        UsageVersion instanceVersion;
        boolean returnValue = true;
        if (publicType != null && publicType.length() > 0 && (instanceVersion = obj.getArchitectureVersionNumber()) != null) {
            returnValue = this.isVersionSupported(publicType, instanceVersion);
            if (!returnValue) {
                this.versionInfoListeners.firePropertyChange(VERSION_INCOMPATIBLE_EVENT, instanceVersion, obj);
            } else {
                this.versionInfoListeners.firePropertyChange(VERSION_COMPATIBLE_EVENT, instanceVersion, obj);
            }
        }
        return returnValue;
    }

    public void clearObjectCache() {
        ObjectConverter.getInstance().clearObjectCache();
    }
}

