/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MLSCaptionTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.ReachThruTable;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.model.TableClassifierMap;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.util.XMLUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableSet
implements MdObjectFactoryListener {
    private static WAdminResource bundle = new WAdminResource(TableSet.class);
    private OLAPCube owningCube;
    private OLAPSharedDimension owningSharedDimension;
    private MdObjectStore objectStore;
    private List tables;
    private List classifierMaps;
    private String loadType;
    private LoadTable loadTable;
    private AggregationTable defaultAggregationTable;
    private List generatedLibnames;
    private List librefsFromMetadata;
    private ReachThruTable reachthruTable;
    private boolean reachthruMetadataRetrieved;
    private Map tablesByLibrefs;
    private List listeners;
    private boolean isMdObjectFactoryListener;
    private boolean loadTableMetadataRetrieved;
    private boolean isCube;
    public static String DETAIL_TABLE;
    public static String STAR_SCHEMA;
    public static String FULLY_SUMMARIZED;
    private static String PHYSICAL_TABLE;
    public static final String METADATA_TEMPLATE = "<Templates><Name/><Id/><Type/></Templates>";

    TableSet(OLAPCube inputOwningCube) {
        this.owningCube = inputOwningCube;
        this.reachthruMetadataRetrieved = false;
        this.loadTableMetadataRetrieved = false;
        this.isCube = true;
    }

    TableSet(OLAPSharedDimension inputDim) {
        this.owningSharedDimension = inputDim;
        this.reachthruMetadataRetrieved = false;
        this.loadTableMetadataRetrieved = false;
    }

    public void addToMetadataListener() {
        try {
            if (!this.isMdObjectFactoryListener) {
                this.isMdObjectFactoryListener = true;
                Workspace.getMdFactory().addMdObjectFactoryListener((MdObjectFactoryListener)this);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public List checkForLanguageTables(PhysicalTable baseTable) throws OLAPException, RemoteException, MdException, ServiceException {
        ArrayList<String> missingTables = new ArrayList<String>();
        LanguageSet languageSet = null;
        if (this.owningCube != null) {
            languageSet = this.owningCube.getLanguageSet();
        } else if (this.owningSharedDimension != null) {
            languageSet = this.owningSharedDimension.getLanguageSet();
        }
        List locales = languageSet.getSelectedLocales();
        if (!locales.isEmpty()) {
            String baseName = baseTable.getSASTableName();
            AssociationList packages = baseTable.getTablePackages();
            String id = "";
            String type = "";
            if (!packages.isEmpty()) {
                CMetadata obj = (CMetadata)packages.get(0);
                id = obj.getFQID();
                type = "SASLibrary";
                if (obj instanceof DatabaseSchema) {
                    type = "DatabaseSchema";
                }
            }
            for (int i = 1; i < locales.size(); ++i) {
                String locale = (String)locales.get(i);
                String name = baseName.concat(locale);
                StringBuffer buffer = new StringBuffer();
                buffer.append("<XMLSelect Search=\"PhysicalTable");
                buffer.append("[@SASTableName='" + XMLUtil.normalize((String)name) + '\'' + ']');
                if (!ModelUtilities.isBlank(id)) {
                    buffer.append("[TablePackage/" + type + "[@id='" + id + "']]\"");
                }
                buffer.append(" />\n");
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                Filter filter = new Filter();
                filter.setOMRFlags(8576);
                filter.setExplicitSearchString("omi", buffer.toString());
                filter.setType("PhysicalTable");
                List lObjects = server.browseSearch((FilterInterface)filter);
                if (lObjects.size() > 0) continue;
                String text = languageSet.getCountry(locale) + "  " + name;
                missingTables.add(text);
            }
        }
        return missingTables;
    }

    void cleanseTables() throws OLAPException {
        if (this.tables != null) {
            int i;
            AggregationSet aggregationSet = this.owningCube.getAggregationSet();
            aggregationSet.cleanseTables();
            OLAPList aggregationTables = aggregationSet.getTables();
            DimensionSet dimensionSet = this.owningCube.getDimensionSet();
            dimensionSet.cleanseTables();
            OLAPList dimensionTables = dimensionSet.getTables();
            this.tables.clear();
            this.tables.add(this.loadTable);
            if (this.reachthruTable == null) {
                this.getReachThruTable();
            }
            if (this.reachthruTable != null) {
                this.tables.add(this.reachthruTable);
            }
            for (i = aggregationTables.size() - 1; i >= 0; --i) {
                this.tables.add(aggregationTables.get(i));
            }
            for (i = dimensionTables.size() - 1; i >= 0; --i) {
                this.tables.add(dimensionTables.get(i));
            }
            if (this.owningCube != null && this.owningCube.getLanguageSet().isCubeMultipleLanguageSupported()) {
                MLSCaptionTable cubeCaptionTable = this.owningCube.getMLSCaptionTable();
                if (cubeCaptionTable != null) {
                    this.tables.add(cubeCaptionTable);
                }
                OLAPList listOfDimensions = dimensionSet.getCubeDimensions();
                int size = listOfDimensions.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    OLAPDimension dim = (OLAPDimension)listOfDimensions.get(i2);
                    MLSCaptionTable dimTable = dim.getMLSCaptionTable();
                    if (dimTable == null || this.tables.contains(dimTable)) continue;
                    this.tables.add(dimTable);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.removeFromMetadataListener();
        super.finalize();
    }

    public String getLibnameCode(int flags) throws OLAPException, MdException, RemoteException {
        boolean loadTableCodeGen = OLAPCube.getCodegenFlag(flags, 1);
        boolean initializeCodeGen = OLAPCube.getCodegenFlag(flags, 4);
        boolean genRCSetCalls = OLAPCube.getCodegenFlag(flags, 8);
        return this.getLibnameCode(loadTableCodeGen, initializeCodeGen, genRCSetCalls);
    }

    public String getLibnameCode(PhysicalTable table) throws OLAPException, MdException, RemoteException {
        String source = "";
        WsAppServer appserver = WsAppServer.createDefaultAppServer();
        CodegenRequest codegenRequest = null;
        codegenRequest = new CodegenRequest((CMetadata)table, appserver, 1, true);
        codegenRequest.genReturnCodeSetup();
        codegenRequest.setGenerateRCSetCalls(true);
        codegenRequest.m_serverID = appserver.getServerContext().getFQID();
        codegenRequest.setCurrentServer((DeployedComponent)appserver.getServerContext());
        PhysicalTableCG tablecg = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
        tablecg.accessPath(codegenRequest);
        if (codegenRequest != null) {
            codegenRequest.doCodegen();
            source = codegenRequest.getSource();
            codegenRequest.cleanupCodeGen();
        }
        if (appserver != null) {
            appserver.closeSASCodeSession();
        }
        return source;
    }

    private String getLibnameCode(boolean loadTableCodeGen, boolean initializeCodeGen, boolean genRCSetCalls) throws OLAPException, MdException, RemoteException {
        WsAppServer appserver = WsAppServer.createDefaultAppServer();
        CodegenRequest codegenRequest = null;
        String source = "";
        if (this.isCube) {
            if (this.tables == null) {
                this.getTables();
            }
            this.cleanseTables();
        } else {
            this.tables.clear();
            SharedDimensionTable table = this.owningSharedDimension.getSharedDimensionTable();
            this.tables.add(table);
        }
        for (int i = this.tables.size() - 1; i >= 0; --i) {
            OLAPTable table = (OLAPTable)this.tables.get(i);
            boolean isLoadTable = false;
            if (this.owningCube != null) {
                isLoadTable = table.equals(this.getLoadTable());
            }
            if (!(!isLoadTable | isLoadTable & loadTableCodeGen)) continue;
            PhysicalTable physicalTable = table.getTable();
            if (codegenRequest == null) {
                codegenRequest = new CodegenRequest((CMetadata)physicalTable, appserver, 1, true);
                if (initializeCodeGen) {
                    codegenRequest.genReturnCodeSetup();
                    codegenRequest.setGenerateRCSetCalls(true);
                } else {
                    codegenRequest.setGenerateRCSetCalls(genRCSetCalls);
                }
                codegenRequest.m_serverID = appserver.getServerContext().getFQID();
                codegenRequest.setCurrentServer((DeployedComponent)appserver.getServerContext());
            }
            PhysicalTableCG tablecg = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)physicalTable);
            tablecg.accessPath(codegenRequest);
        }
        if (codegenRequest != null) {
            codegenRequest.doCodegen();
            source = codegenRequest.getSource();
            codegenRequest.cleanupCodeGen();
        }
        if (appserver != null) {
            appserver.closeSASCodeSession();
        }
        return source;
    }

    StringBuffer generateCode() throws OLAPException {
        MLSCaptionTable cubeCaptionTable;
        StringBuffer libnames = new StringBuffer();
        List usedTables = this.getUsedTables();
        usedTables.add(this.loadTable);
        if (this.loadTable == null) {
            this.getLoadTable();
        }
        if (this.loadTable != null) {
            usedTables.add(this.loadTable);
        }
        if (this.reachthruTable == null) {
            this.getReachThruTable();
        }
        if (this.reachthruTable != null) {
            usedTables.add(this.reachthruTable);
        }
        if (this.owningCube != null && (cubeCaptionTable = this.owningCube.getMLSCaptionTable()) != null) {
            usedTables.add(cubeCaptionTable);
        }
        for (int i = usedTables.size() - 1; i >= 0; --i) {
            OLAPTable table = (OLAPTable)usedTables.get(i);
            StringBuffer code = table.generateCode(null);
            if (code.length() <= 1) continue;
            libnames.append(code);
            if (i <= 0) continue;
            libnames.append(ModelUtilities.newline);
        }
        this.generatedLibnames.clear();
        return libnames;
    }

    StringBuffer generateSharedDimCode() throws OLAPException {
        StringBuffer libnames = new StringBuffer();
        if (this.owningSharedDimension != null) {
            SharedDimensionTable table = this.owningSharedDimension.getSharedDimensionTable();
            try {
                SASLibrary sasLibrary = LibraryUtil.getLibrary((DataTable)table.getTable(), null);
                if (sasLibrary != null) {
                    libnames.append(ModelUtilities.trim(LibraryUtil.getAccessPath((SASLibrary)sasLibrary).toString().replaceAll("\n", ModelUtilities.newline)));
                }
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
            catch (MdException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return libnames;
    }

    public AggregationTable getAggregationTable(PhysicalTable inputTable) throws OLAPException {
        if (inputTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"A Table must be selected as input to the cube.");
            }
            throw new IllegalStateException("An illegal use of the getAggregationTable method was encountered.");
        }
        AggregationTable table = (AggregationTable)this.getTable(inputTable, AggregationTable.class);
        if (table == null) {
            table = new AggregationTable(this, inputTable);
        }
        if (this.loadTable.equals(table)) {
            this.defaultAggregationTable = table;
        }
        return table;
    }

    AggregationTable getDefaultAggregationTable() throws OLAPException {
        if (this.defaultAggregationTable == null && this.isLoadClassicSAS()) {
            PhysicalTable table = this.loadTable.getTable();
            this.defaultAggregationTable = table != null ? this.getAggregationTable(table) : new AggregationTable(this, null);
        }
        return this.defaultAggregationTable;
    }

    public DimensionTable getDimensionTable(PhysicalTable inputTable) throws OLAPException {
        if (inputTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"A Table must be selected as input to the cube.");
            }
            throw new IllegalArgumentException("An illegal use of the getDimensionTable method was encountered.");
        }
        DimensionTable table = (DimensionTable)this.getTable(inputTable, DimensionTable.class);
        if (table == null) {
            table = new DimensionTable(this, inputTable);
        }
        return table;
    }

    public SharedDimensionTable getSharedDimensionTable(PhysicalTable inputTable) throws OLAPException {
        if (inputTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"A Table must be selected as input to the cube.");
            }
            throw new IllegalArgumentException("An illegal use of the getDimensionTable method was encountered.");
        }
        SharedDimensionTable table = (SharedDimensionTable)this.getTable(inputTable, SharedDimensionTable.class);
        if (table == null) {
            table = new SharedDimensionTable(this, inputTable);
        }
        return table;
    }

    private List getUsedTables() throws OLAPException {
        ArrayList<TableClassifierMap> usedTables = new ArrayList<TableClassifierMap>();
        AggregationSet aggregationSet = this.owningCube.getAggregationSet();
        DimensionSet dimensionSet = this.owningCube.getDimensionSet();
        OLAPList storedAggregations = aggregationSet.getStoredAggregations();
        for (int i = storedAggregations.size() - 1; i >= 0; --i) {
            OLAPAggregation aggregation = (OLAPAggregation)storedAggregations.get(i);
            AggregationTable table = aggregation.getAggregationTable();
            if (usedTables.contains(table)) continue;
            usedTables.add(table);
        }
        OLAPList dimensions = dimensionSet.getCubeDimensions();
        for (int i = dimensions.size() - 1; i >= 0; --i) {
            OLAPDimension dimension = (OLAPDimension)dimensions.get(i);
            DimensionTable table = dimension.getTable();
            if (usedTables.contains(table)) continue;
            usedTables.add(table);
        }
        return usedTables;
    }

    private void firePhysicalTablesCreated() {
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.physicalTablesCreated();
            }
        }
    }

    private void fireSASLibrariesCreated() {
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.sasLibrariesCreated();
            }
        }
    }

    List getClassifierMaps() throws OLAPException {
        if (this.classifierMaps == null) {
            this.classifierMaps = new ArrayList();
            if (this.isCube && this.owningCube.metadataObject != null) {
                Cube cube = (Cube)this.owningCube.metadataObject;
                try {
                    AssociationList maps = cube.getTargetClassifierMaps(false);
                    if (maps.size() > 0) {
                        this.classifierMaps.add(maps.elementAt(0));
                    }
                    if ((maps = cube.getTargetTransformations(false)).size() > 0) {
                        int size = maps.size();
                        for (int i = 0; i < size; ++i) {
                            this.classifierMaps.add(maps.elementAt(i));
                        }
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        return this.classifierMaps;
    }

    public LoadTable getLoadTable() throws OLAPException {
        if (this.loadTable == null) {
            for (int i = this.getTables().size() - 1; i >= 0; --i) {
                OLAPTable table = (OLAPTable)this.tables.get(i);
                if (!(table instanceof LoadTable)) continue;
                this.loadTable = (LoadTable)table;
                return this.loadTable;
            }
            if (!this.loadTableMetadataRetrieved) {
                try {
                    ClassifierMap loadMap;
                    AssociationList sources;
                    this.loadTableMetadataRetrieved = true;
                    if (!this.getClassifierMaps().isEmpty() && !(sources = (loadMap = (ClassifierMap)this.classifierMaps.get(0)).getClassifierSources(false)).isEmpty()) {
                        PhysicalTable jomaTable = (PhysicalTable)sources.elementAt(0);
                        this.setLoadTable(jomaTable);
                    }
                    if (this.loadTable == null && !this.owningCube.isNewObject()) {
                        new LoadTable(this, null);
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        return this.loadTable;
    }

    public ReachThruTable getReachThruTable() throws OLAPException {
        if (this.reachthruTable == null & !this.reachthruMetadataRetrieved) {
            for (int i = this.getTables().size() - 1; i >= 0; --i) {
                OLAPTable table = (OLAPTable)this.tables.get(i);
                if (!(table instanceof ReachThruTable)) continue;
                this.reachthruTable = (ReachThruTable)table;
            }
            if (this.reachthruTable == null && this.owningCube.metadataObject != null) {
                this.reachthruMetadataRetrieved = true;
                Cube jomaCube = (Cube)this.owningCube.metadataObject;
                AssociationList reachthruTables = null;
                try {
                    reachthruTables = jomaCube.getReachThruTables(false);
                }
                catch (MdException error) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                if (!reachthruTables.isEmpty()) {
                    PhysicalTable jomaTable = (PhysicalTable)reachthruTables.get(0);
                    this.reachthruTable = new ReachThruTable(this, jomaTable);
                }
            }
        }
        return this.reachthruTable;
    }

    public MLSCaptionTable getMLSCaptionTable(PhysicalTable inputTable) throws OLAPException {
        if (inputTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"A Table must be selected as input to the cube.");
            }
            throw new IllegalArgumentException("An illegal use of the getDimensionTable method was encountered.");
        }
        MLSCaptionTable table = null;
        if (this.owningCube != null) {
            table = this.owningCube.getMLSCaptionTable();
        }
        if (table == null) {
            table = new MLSCaptionTable(this, inputTable);
        } else if (table.getTable() != inputTable) {
            table.setTable(inputTable);
        }
        return table;
    }

    public MLSCaptionTable getMLSCaptionTable(PhysicalTable inputTable, OLAPDimension inputDim) throws OLAPException {
        if (inputTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"A Table must be selected as input to the cube.");
            }
            throw new IllegalArgumentException("An illegal use of the getDimensionTable method was encountered.");
        }
        MLSCaptionTable table = null;
        if (inputDim != null) {
            table = inputDim.getMLSCaptionTable();
        }
        if (table == null) {
            table = new MLSCaptionTable(this, inputTable, inputDim);
        } else if (table.getTable() != inputTable) {
            table.setTable(inputTable);
        }
        return table;
    }

    void setDefaultAggregationTable(AggregationTable inputTable) {
        this.defaultAggregationTable = inputTable;
    }

    void setLoadTable(LoadTable inputLoadTable) {
        this.loadTable = inputLoadTable;
    }

    public void setLoadTable(PhysicalTable inputTable) throws OLAPException {
        if (inputTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The PhysicalTable parameter cannot be null.");
            }
            throw new IllegalArgumentException("Illegal argument passed to the setLoadTable method.");
        }
        if (inputTable != null && this.loadTable == null) {
            this.loadTable = new LoadTable(this, inputTable);
        } else {
            this.loadTable.setTable(inputTable);
        }
        if (this.isLoadClassicSAS()) {
            AggregationSet aggregationSet = this.owningCube.getAggregationSet();
            OLAPAggregation defaultAggregation = aggregationSet.getDefaultAggregation();
            AggregationTable defaultAggrTable = defaultAggregation.getAggregationTable();
            PhysicalTable physicalTable = null;
            if (defaultAggrTable != null) {
                physicalTable = defaultAggrTable.getTable();
            }
            if (defaultAggrTable == null || !defaultAggrTable.equals(inputTable)) {
                AggregationTable newTable = this.getAggregationTable(inputTable);
                defaultAggregation.setAggregationTable(newTable);
                aggregationSet.cleanseTables();
            }
            if (physicalTable != null && !physicalTable.equals(inputTable)) {
                AggregationTable oldAggrTable = this.getAggregationTable(physicalTable);
                oldAggrTable.setLoadTable(false);
                oldAggrTable.setSources(physicalTable);
                MeasureSet measureSet = this.owningCube.getMeasureSet();
                OLAPList listOfMeasures = measureSet.getMeasures();
                OLAPList listOfColumns = oldAggrTable.getColumns();
                int size = listOfMeasures.size();
                for (int i = 0; i < size; ++i) {
                    OLAPMeasure measure = (OLAPMeasure)listOfMeasures.get(i);
                    if (!measure.isStoredStatistic().booleanValue()) continue;
                    OLAPColumn nextColumn = measure.getAggregateColumn(oldAggrTable);
                    String nameOfColumn = nextColumn.getSASColumnName();
                    OLAPColumn aggregateColumn = null;
                    int t = 0;
                    int sizeT = listOfColumns.size();
                    while (t < sizeT & aggregateColumn == null) {
                        OLAPColumn findColumn = (OLAPColumn)listOfColumns.get(t);
                        String nameOfFoundColumn = findColumn.getSASColumnName();
                        if (nameOfFoundColumn.equalsIgnoreCase(nameOfColumn)) {
                            aggregateColumn = findColumn;
                        }
                        ++t;
                    }
                    if (aggregateColumn == null) continue;
                    measure.setAggregateColumn(oldAggrTable, aggregateColumn);
                }
            }
        }
    }

    String getMetadataTemplate(String libraryId, int thirdPartyDB, String databaseID) throws RemoteException {
        StringBuilder template = new StringBuilder();
        if (thirdPartyDB == 1) {
            template.append("<XMLSelect Search=\"PhysicalTable[TablePackage/DatabaseSchema[@Id='" + databaseID + "']]\"/>");
        } else {
            template.append("<XMLSelect Search=\"PhysicalTable[TablePackage/SASLibrary[@Id='" + libraryId + "']]\"/>");
        }
        template.append("<Templates><Tables Id=\"\" Name=\"\" /> </Templates>");
        return template.toString();
    }

    public String getLoadType() throws OLAPException {
        if (ModelUtilities.isBlank(this.loadType)) {
            String tempLoadType = bundle.getString("LoadTable.DetailedData.txt");
            if (!this.getOwningCube().isNewObject()) {
                ClassifierMap loadClassifierMap = null;
                List maps = this.getClassifierMaps();
                boolean mapFound = false;
                int size = maps.size();
                for (int i = 0; i < size && !mapFound; ++i) {
                    loadClassifierMap = (ClassifierMap)maps.get(i);
                    try {
                        String transformRole = loadClassifierMap.getTransformRole();
                        mapFound = true;
                        if (transformRole.equalsIgnoreCase("BASE")) {
                            tempLoadType = DETAIL_TABLE;
                            continue;
                        }
                        if (transformRole.equalsIgnoreCase("STARDIM") || transformRole.equalsIgnoreCase("STARFACT")) {
                            tempLoadType = STAR_SCHEMA;
                            continue;
                        }
                        if (transformRole.equalsIgnoreCase("NWAY")) {
                            tempLoadType = FULLY_SUMMARIZED;
                            continue;
                        }
                        mapFound = false;
                        continue;
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                    }
                }
                if (!mapFound) {
                    AggregationSet aggregationSet = this.owningCube.getAggregationSet();
                    OLAPAggregation defaultAggr = aggregationSet.getDefaultAggregation();
                    tempLoadType = defaultAggr != null && defaultAggr.getType().equals("ROLAP") ? FULLY_SUMMARIZED : DETAIL_TABLE;
                }
            }
            this.loadType = tempLoadType;
        }
        return this.loadType;
    }

    OLAPCube getOwningCube() {
        return this.owningCube;
    }

    OLAPSharedDimension getOwningSharedDimension() {
        return this.owningSharedDimension;
    }

    private OLAPTable getTable(PhysicalTable inputTable, Class inputClassType) {
        OLAPTable table = null;
        int i = this.getTables().size() - 1;
        while (i >= 0 & table == null) {
            OLAPTable olapTable = (OLAPTable)this.tables.get(i);
            if (olapTable.equals(inputTable) & olapTable.getClass().equals(inputClassType)) {
                table = olapTable;
            }
            --i;
        }
        return table;
    }

    List getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList();
        }
        return this.tables;
    }

    public boolean isLoadClassicSAS() throws OLAPException {
        return this.getLoadType().equals(FULLY_SUMMARIZED);
    }

    public boolean isLoadStarSchema() throws OLAPException {
        if (this.owningSharedDimension != null) {
            return true;
        }
        return this.getLoadType().equals(bundle.getString("LoadTable.StarSchema.txt"));
    }

    public boolean isLoadDetailTable() throws OLAPException {
        return this.getLoadType().equals(bundle.getString("LoadTable.DetailedData.txt"));
    }

    public void MdObjectCreated(MdEvent p0, String p1) {
    }

    public void MdObjectsCreated(MdEvent event, List inputNewObjects) {
        boolean fireSASLibrariesCreated = false;
        boolean firePhysicalTablesCreated = false;
        try {
            this.getLibraries();
        }
        catch (OLAPException impossibleError) {
            Workspace.getDefaultLogger().warn((Object)impossibleError.getLocalizedMessage());
        }
        this.objectStore = null;
        if (this.owningCube != null) {
            this.objectStore = this.owningCube.getObjectStore();
        } else if (this.owningSharedDimension != null) {
            this.objectStore = this.owningSharedDimension.getObjectStore();
        }
        try {
            for (int i = inputNewObjects.size() - 1; i >= 0; --i) {
                String id = (String)inputNewObjects.get(i);
                CMetadata metadata = Workspace.getMdFactory().getObject(id);
                boolean found = false;
                if (metadata instanceof SASLibrary) {
                    SASLibrary sasLibrary = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject(this.objectStore, metadata);
                    int size = this.librefsFromMetadata.size();
                    for (int t = 0; t < size && !found; ++t) {
                        HashMap mapOfLibraries = (HashMap)this.librefsFromMetadata.get(t);
                        String libraryId = (String)mapOfLibraries.get("Id");
                        if (!libraryId.equals(id)) continue;
                        found = true;
                    }
                    if (found) continue;
                    HashMap<String, String> mapofNewObject = new HashMap<String, String>();
                    mapofNewObject.put("Name", sasLibrary.getName());
                    mapofNewObject.put("MetadataObjectType", "SASLibrary");
                    mapofNewObject.put("Id", sasLibrary.getId());
                    this.librefsFromMetadata.add(mapofNewObject);
                    fireSASLibrariesCreated = true;
                    continue;
                }
                if (!(metadata instanceof PhysicalTable)) continue;
                PhysicalTable newTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(this.objectStore, metadata);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)newTable, null, MetadataTemplate.getTableAssociations(), "<Templates></Templates>", 524300);
                AssociationList tempLibraries = newTable.getTablePackages();
                if (tempLibraries.isEmpty()) continue;
                List tablesByLibrary = null;
                String libraryId = null;
                CMetadata object = (CMetadata)tempLibraries.get(0);
                if (object instanceof SASLibrary) {
                    SASLibrary sasLibrary = (SASLibrary)object;
                    libraryId = sasLibrary.getId();
                    tablesByLibrary = this.getPhysicalTablesByLibraries(libraryId, 0, "");
                } else if (object instanceof DatabaseSchema) {
                    DatabaseSchema databaseSchema = (DatabaseSchema)object;
                    String databaseId = databaseSchema.getId();
                    SASLibrary sasLibrary = LibraryUtil.getLibrary((DataTable)newTable, null);
                    libraryId = sasLibrary.getId();
                    tablesByLibrary = this.getPhysicalTablesByLibraries(libraryId, 1, databaseId);
                }
                int size = tablesByLibrary.size();
                for (int t = 0; t < size && !found; ++t) {
                    HashMap mapOfATable = (HashMap)tablesByLibrary.get(t);
                    String tableId = (String)mapOfATable.get("Id");
                    if (!tableId.equals(id)) continue;
                    found = true;
                }
                if (found) continue;
                HashMap<String, String> mapofNewObject = new HashMap<String, String>();
                mapofNewObject.put("Name", newTable.getName());
                mapofNewObject.put("MetadataObjectType", "PhysicalTable");
                mapofNewObject.put("Id", newTable.getId());
                tablesByLibrary.add(mapofNewObject);
                firePhysicalTablesCreated = true;
            }
        }
        catch (MdException impossibleError) {
            Workspace.getDefaultLogger().warn((Object)impossibleError.getLocalizedMessage());
        }
        catch (RemoteException impossibleError2) {
            Workspace.getDefaultLogger().warn((Object)impossibleError2.getLocalizedMessage());
        }
        if (fireSASLibrariesCreated) {
            this.fireSASLibrariesCreated();
        }
        if (firePhysicalTablesCreated) {
            this.firePhysicalTablesCreated();
        }
    }

    public void MdObjectDeleted(MdEvent inputEvent, String inputEventName) {
    }

    public void removeFromMetadataListener() {
        this.isMdObjectFactoryListener = false;
        try {
            Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)this);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void reset() throws OLAPException {
        int i;
        this.loadTable = null;
        if (this.tables != null) {
            for (i = this.tables.size() - 1; i >= 0; --i) {
                OLAPTable table = (OLAPTable)this.tables.get(i);
                boolean isTableReachThru = table instanceof ReachThruTable;
                if (isTableReachThru) continue;
                this.tables.remove(i);
            }
        }
        if (this.classifierMaps != null) {
            int size = this.classifierMaps.size();
            for (i = 0; i < size; ++i) {
                ClassifierMap classifierMap = (ClassifierMap)this.classifierMaps.get(i);
                try {
                    String nameOfCM = classifierMap.getName();
                    Job cubeJob = null;
                    if (nameOfCM.equalsIgnoreCase("Load Map")) {
                        cubeJob = ModelUtilities.getJobCube((Cube)this.owningCube.metadataObject);
                    }
                    classifierMap.delete();
                    if (cubeJob == null) continue;
                    cubeJob.delete();
                    continue;
                }
                catch (MdException mdE) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdE, 12);
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
            }
            this.classifierMaps.clear();
        }
    }

    void setMapToStructure() throws OLAPException {
        this.loadTable.setSources();
        if (this.defaultAggregationTable == null && this.isLoadClassicSAS()) {
            AggregationSet aggregationSet = this.owningCube.getAggregationSet();
            OLAPAggregation defaultAggregation = aggregationSet.getDefaultAggregation();
            this.defaultAggregationTable = defaultAggregation.getAggregationTable();
        }
        if (this.defaultAggregationTable != null) {
            this.defaultAggregationTable.setSources(this.loadTable.getTable());
        }
        if (this.isLoadStarSchema()) {
            DimensionSet dimensionSet = this.owningCube.getDimensionSet();
            OLAPList dimensions = dimensionSet.getCubeDimensions();
            for (int i = dimensions.size() - 1; i >= 0; --i) {
                OLAPDimension dimension = (OLAPDimension)dimensions.get(i);
                DimensionTable table = dimension.getTable();
                if (!table.isLoadTable()) continue;
                PhysicalTable physicalTable = this.loadTable.getTable();
                table.setSources(physicalTable);
            }
        }
    }

    public void setReachThruTable(PhysicalTable inputTable) throws OLAPException {
        this.getReachThruTable();
        if (this.reachthruTable != null && inputTable == null) {
            this.getTables();
            this.tables.remove(this.reachthruTable);
            this.reachthruTable = null;
        } else if (this.reachthruTable != null && inputTable != null && !this.reachthruTable.equals(inputTable)) {
            this.reachthruTable.setTable(inputTable);
        } else if (this.reachthruTable == null && inputTable != null) {
            this.reachthruTable = new ReachThruTable(this, inputTable);
        }
    }

    public void setLoadType(String inputLoadType) throws OLAPException {
        if (this.loadType != null && !this.loadType.equalsIgnoreCase(inputLoadType)) {
            AggregationSet aggregationSet;
            this.getLoadTable();
            if (this.loadTable != null && inputLoadType.equalsIgnoreCase(bundle.getString("LoadTable.StarSchema.txt"))) {
                this.loadTable.setMetadataUtilOptions(8204);
                this.loadTable.setTableAssociations(MetadataTemplate.getFactTableAssociations());
                this.loadTable.setTemplate("<Templates><Column><ForeignKeyAssociations/></Column><ForeignKey><KeyedColumns/><KeyAssociations/><PartnerUniqueKey/></ForeignKey></Templates>");
            } else if (this.loadTable != null) {
                this.loadTable.setMetadataUtilOptions(12);
                this.loadTable.setTableAssociations(MetadataTemplate.getTableAssociations());
                this.loadTable.setTemplate("<Templates></Templates>");
            }
            this.loadType = inputLoadType;
            if (this.loadTable != null && inputLoadType.equalsIgnoreCase(bundle.getString("LoadTable.Summary.txt"))) {
                aggregationSet = this.owningCube.getAggregationSet();
                aggregationSet.setNwayGenerated(true);
            }
            if (this.isLoadClassicSAS()) {
                this.owningCube.getAggregationSet().setHasStoredAggregations(true);
                LoadTable loadTable = this.getLoadTable();
                if (loadTable != null) {
                    AggregationSet aggregationSet2 = this.owningCube.getAggregationSet();
                    OLAPAggregation defaultAggregation = aggregationSet2.getDefaultAggregation();
                    AggregationTable table = this.getAggregationTable(loadTable.getTable());
                    if (table != null) {
                        defaultAggregation.setAggregationTable(table);
                    }
                }
            } else {
                aggregationSet = this.owningCube.getAggregationSet();
                OLAPAggregation defaultAggregation = aggregationSet.getDefaultAggregation();
                AggregationTable table = defaultAggregation.getAggregationTable();
                if (table != null) {
                    defaultAggregation.setAggregationTable(null);
                }
            }
        }
    }

    public StringBuffer verifyMetadata() {
        StringBuffer message;
        block10: {
            message = new StringBuffer();
            try {
                Cube cube;
                SASLibrary library;
                this.getLoadTable();
                if (this.loadTable.getTable() == null) {
                    this.owningCube.setErrorLevel(1);
                    message.append(bundle.getString("LoadTable.NoLoadTable.txt"));
                }
                if (this.loadTable != null && this.loadTable.getTable() != null && (library = this.loadTable.getSASLibrary()) == null) {
                    try {
                        this.owningCube.setErrorLevel(2);
                        message.append(bundle.formatString("LoadTable.MissingLibrary.fmt.txt", (Object)this.loadTable.getTable().getName()));
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
                    }
                }
                if ((cube = (Cube)this.owningCube.metadataObject) == null) break block10;
                AssociationList properties = null;
                try {
                    properties = cube.getProperties(false);
                    StringBuffer propertyName = new StringBuffer();
                    propertyName.append(this.owningCube.getName()).append("_options");
                    StringBuffer newPropertyName = new StringBuffer();
                    newPropertyName.append("LoadTable").append("_options");
                    for (int i = properties.size() - 1; i >= 0; --i) {
                        Property property = (Property)properties.get(i);
                        if (!property.getPropertyName().equals(propertyName.toString())) continue;
                        property.setName(newPropertyName.toString());
                        property.setDesc(newPropertyName.toString());
                        property.setPropertyName(newPropertyName.toString());
                    }
                }
                catch (MdException error) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
            }
            catch (OLAPException error) {
                message.append(error.getLocalizedMessage());
                this.owningCube.setErrorLevel(1);
            }
        }
        return message;
    }

    public PhysicalTable getPhysicalTable(String fqid) throws OLAPException {
        PhysicalTable table = null;
        try {
            ArrayList simpleList = new ArrayList();
            int metadataUtilOptions = 12;
            table = this.owningCube != null ? (PhysicalTable)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)this.owningCube.getObjectStore(), PHYSICAL_TABLE, fqid, simpleList, MetadataTemplate.getTableAssociations(), "<Templates></Templates>", metadataUtilOptions) : (PhysicalTable)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)this.owningSharedDimension.getObjectStore(), PHYSICAL_TABLE, fqid, simpleList, MetadataTemplate.getTableAssociations(), "<Templates></Templates>", metadataUtilOptions);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return table;
    }

    public List getPhysicalTablesByLibraries(String idOfSASLibrary, int thirdPartyDB, String databaseID) throws RemoteException, MdException {
        List listOfTables;
        if (this.tablesByLibrefs == null) {
            this.tablesByLibrefs = new HashMap();
        }
        if ((listOfTables = (ArrayList)this.tablesByLibrefs.get(idOfSASLibrary)) == null) {
            int flags = 8580;
            String metadataTableTemplate = this.getMetadataTemplate(idOfSASLibrary, thirdPartyDB, databaseID);
            String reposid = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
            listOfTables = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsNoCache("PhysicalTable", reposid, metadataTableTemplate, flags);
            this.tablesByLibrefs.put(idOfSASLibrary, listOfTables);
        }
        return listOfTables;
    }

    List getGeneratedLibnames() {
        if (this.generatedLibnames == null) {
            this.generatedLibnames = new ArrayList();
        }
        return this.generatedLibnames;
    }

    public List getLibraries() throws OLAPException {
        if (this.librefsFromMetadata == null || this.librefsFromMetadata != null && this.librefsFromMetadata.isEmpty()) {
            try {
                int flags = 8452;
                String reposid = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
                this.librefsFromMetadata = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsNoCache("SASLibrary", reposid, METADATA_TEMPLATE, flags);
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            if (this.librefsFromMetadata == null) {
                this.librefsFromMetadata = new ArrayList();
            }
        }
        return this.librefsFromMetadata;
    }

    public List getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return this.listeners;
    }

    void updateMetadata() throws OLAPException {
        this.getLoadTable();
        if (this.loadTable == null) {
            throw new IllegalStateException("A Table must be selected as input to the cube.");
        }
        this.loadTable.updateMetadata();
        this.getReachThruTable();
        if (this.reachthruTable != null) {
            this.reachthruTable.updateMetadata();
        } else {
            Cube jomaCube = (Cube)this.owningCube.metadataObject;
            try {
                jomaCube.getReachThruTables(false).clear();
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        this.cleanseTables();
        AggregationSet aggregationSet = this.owningCube.getAggregationSet();
        OLAPList tables = aggregationSet.getTables();
        for (int i = tables.size() - 1; i >= 0; --i) {
            AggregationTable table = (AggregationTable)tables.get(i);
            table.updateMetadata();
        }
        DimensionSet dimensionSet = this.owningCube.getDimensionSet();
        tables = dimensionSet.getTables();
        for (int i = tables.size() - 1; i >= 0; --i) {
            DimensionTable table = (DimensionTable)tables.get(i);
            table.updateMetadata();
        }
    }

    static {
        PHYSICAL_TABLE = "PhysicalTable";
        DETAIL_TABLE = bundle.getString("LoadTable.DetailedData.txt");
        STAR_SCHEMA = bundle.getString("LoadTable.StarSchema.txt");
        FULLY_SUMMARIZED = bundle.getString("LoadTable.Summary.txt");
    }

    public static interface Listener
    extends EventListener {
        public void sasLibrariesCreated();

        public void physicalTablesCreated();
    }
}

