/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public final class Statistic {
    static WAdminResource bundle = new WAdminResource(Statistic.class);
    private String captionFormatKey;
    private boolean derived;
    private String label;
    private String name;
    private static Statistic nunique;
    private String standardFormat;
    private BitSet index;
    private static OLAPList possibleStoredStatistics;
    private static Map statisticIndexes;
    private static Map statisticsMap;
    private static OLAPList statistics;
    private static final String NMISS_STANDARD_FORMAT = "10.0";
    private static final String N_STANDARD_FORMAT = "12.0";
    private static final String NUNIQUE_STANDARD_FORMAT = "12.0";
    private static final String USS_STANDARD_FORMAT = "BEST.";
    private static final String CSS_STANDARD_FORMAT = "BEST.";
    private static final String VAR_STANDARD_FORMAT = "BEST.";
    private static final String CV_STANDARD_FORMAT = "8.2";
    private static final String T_STANDARD_FORMAT = "7.3";
    private static final String PRT_STANDARD_FORMAT = "6.4";
    public static final String SUM_NAME = "SUM";
    public static final String N_NAME = "N";
    public static final String MIN_NAME = "MIN";
    public static final String MAX_NAME = "MAX";
    public static final String NMISS_NAME = "NMISS";
    public static final String USS_NAME = "USS";
    public static final String AVG_NAME = "AVG";
    public static final String RANGE_NAME = "RANGE";
    public static final String CSS_NAME = "CSS";
    public static final String VAR_NAME = "VAR";
    public static final String STD_NAME = "STD";
    public static final String STDERR_NAME = "STDERR";
    public static final String CV_NAME = "CV";
    public static final String T_NAME = "T";
    public static final String PRT_NAME = "PRT";
    public static final String LCLM_NAME = "LCLM";
    public static final String UCLM_NAME = "UCLM";
    public static final String NUNIQUE_NAME = "NUNIQUE";
    private static final int MAX_INDEX = 0;
    private static final int MIN_INDEX = 1;
    private static final int N_INDEX = 2;
    private static final int SUM_INDEX = 3;
    private static final int USS_INDEX = 4;
    private static final int RANGE_INDEX = 5;
    private static final int AVG_INDEX = 6;
    private static final int CSS_UCLM_INDEX = 7;
    private static final OLAPList EMPTY_LIST;

    private Statistic(String inputName, String inputStandardFormat, boolean inputDerived) {
        this.derived = inputDerived;
        this.name = inputName;
        this.standardFormat = inputStandardFormat;
        StringBuffer labelKey = new StringBuffer("Statistics.");
        StringBuffer captionKey = new StringBuffer("Statistics.");
        this.label = bundle.getString(labelKey.append(inputName).append(".label.txt").toString());
        this.captionFormatKey = captionKey.append(inputName).append(".defaultCaption.fmt.txt").toString();
        statisticsMap.put(this.name, this);
        if (!inputName.equals(NUNIQUE_NAME)) {
            statistics.add(this);
            if (!this.derived) {
                possibleStoredStatistics.add(this);
            }
        } else {
            nunique = this;
        }
    }

    public String getDefaultMeasureCaption(String measureName) {
        if (this.name.equals(NUNIQUE_NAME)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"A level name and an hierarchy name must be given to determine the caption of the NUNIQUE measure.");
            }
            throw new IllegalStateException("An illegal use of the getDefaultMeasureCaption method was encountered.");
        }
        return bundle.formatString(this.captionFormatKey, (Object)measureName);
    }

    public String getDefaultMeasureCaption(String levelName, String hierarchyName) {
        if (!this.name.equals(NUNIQUE_NAME)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Only the measure name needs to be given to determine the caption.");
            }
            throw new IllegalStateException("An illegal use of the getDefaultMeasureCaption method was encountered.");
        }
        return bundle.formatString(this.captionFormatKey, (Object)levelName, (Object)hierarchyName);
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public static Statistic getNunique() {
        return nunique;
    }

    private static OLAPList getPossibleStatistics(OLAPList inputStatistics) {
        OLAPList returnedStatistcs = null;
        BitSet index = new BitSet();
        if (inputStatistics != null) {
            int size = inputStatistics.size();
            for (int i = 0; i < size; ++i) {
                Statistic statistic = (Statistic)inputStatistics.get(i);
                BitSet bitIndex = statistic.index;
                if (bitIndex == null) continue;
                index.or(bitIndex);
            }
        }
        if ((returnedStatistcs = (OLAPList)statisticIndexes.get(index)) == null) {
            returnedStatistcs = EMPTY_LIST;
        }
        return returnedStatistcs;
    }

    public static OLAPList getPossibleDerivedStatistics(OLAPList storedStatistics) {
        if (storedStatistics != null) {
            for (int i = storedStatistics.size() - 1; i >= 0; --i) {
                Statistic derivedStatistic = (Statistic)storedStatistics.get(i);
                if (!derivedStatistic.isDerived()) continue;
                throw new IllegalStateException("To get a list of possible derived statistics, the given statistic list must contain all stored statistics.");
            }
        }
        return Statistic.getPossibleStatistics(storedStatistics);
    }

    public String getStandardFormat() {
        return this.standardFormat;
    }

    public static Statistic getStatistic(String statisticName) {
        return (Statistic)statisticsMap.get(statisticName.toUpperCase());
    }

    public static OLAPList getStatistics() {
        return statistics;
    }

    public static OLAPList getStoredStatistics() {
        return possibleStoredStatistics;
    }

    public static OLAPList getRequiredStoredStatistics(OLAPList derivedStatistics) {
        if (derivedStatistics != null) {
            for (int i = derivedStatistics.size() - 1; i >= 0; --i) {
                Statistic derivedStatistic = (Statistic)derivedStatistics.get(i);
                if (derivedStatistic.isDerived()) continue;
                throw new IllegalStateException("To get a list of required stored statistics, the given statistic list must contain all derived statistics.");
            }
        }
        return Statistic.getPossibleStatistics(derivedStatistics);
    }

    private static BitSet initializeBitSet(int bit0) {
        BitSet bitSet = new BitSet();
        bitSet.set(bit0);
        return bitSet;
    }

    private static BitSet initializeBitSet(int bit0, int bit1) {
        BitSet bitSet = Statistic.initializeBitSet(bit0);
        bitSet.set(bit1);
        return bitSet;
    }

    private static BitSet initializeBitSet(int bit0, int bit1, int bit2) {
        BitSet bitSet = Statistic.initializeBitSet(bit0, bit1);
        bitSet.set(bit2);
        return bitSet;
    }

    private static BitSet initializeBitSet(int bit0, int bit1, int bit2, int bit3) {
        BitSet bitSet = Statistic.initializeBitSet(bit0, bit1, bit2);
        bitSet.set(bit3);
        return bitSet;
    }

    private static BitSet initializeBitSet(int bit0, int bit1, int bit2, int bit3, int bit4) {
        BitSet bitSet = Statistic.initializeBitSet(bit0, bit1, bit2, bit3);
        bitSet.set(bit4);
        return bitSet;
    }

    private static void initializeDerivedStatisticIndexes() {
        Statistic.initializeStatisticIndexes(RANGE_NAME, 5);
        Statistic.initializeStatisticIndexes(AVG_NAME, 6);
        Statistic.initializeStatisticIndexes(CSS_NAME, 7);
        Statistic.initializeStatisticIndexes(VAR_NAME, 7);
        Statistic.initializeStatisticIndexes(STD_NAME, 7);
        Statistic.initializeStatisticIndexes(STDERR_NAME, 7);
        Statistic.initializeStatisticIndexes(CV_NAME, 7);
        Statistic.initializeStatisticIndexes(T_NAME, 7);
        Statistic.initializeStatisticIndexes(PRT_NAME, 7);
        Statistic.initializeStatisticIndexes(LCLM_NAME, 7);
        Statistic.initializeStatisticIndexes(UCLM_NAME, 7);
        OLAPList range = Statistic.initializeDerivedStatisticList(new String[]{MIN_NAME, MAX_NAME});
        OLAPList avg = Statistic.initializeDerivedStatisticList(new String[]{N_NAME, SUM_NAME});
        OLAPList rangeAvg = Statistic.initializeDerivedStatisticList(new String[]{MIN_NAME, MAX_NAME, N_NAME, SUM_NAME});
        OLAPList avgCssUclm = Statistic.initializeDerivedStatisticList(new String[]{N_NAME, SUM_NAME, USS_NAME});
        OLAPList avgRangeCssUclm = Statistic.initializeDerivedStatisticList(new String[]{MIN_NAME, MAX_NAME, N_NAME, SUM_NAME, USS_NAME});
        OLAPList nSum = Statistic.initializeDerivedStatisticList(new String[]{AVG_NAME});
        OLAPList minMax = Statistic.initializeDerivedStatisticList(new String[]{RANGE_NAME});
        OLAPList nSumMinMax = Statistic.initializeDerivedStatisticList(new String[]{AVG_NAME, RANGE_NAME});
        OLAPList nSumUss = Statistic.initializeDerivedStatisticList(new String[]{AVG_NAME, CSS_NAME, VAR_NAME, STD_NAME, STDERR_NAME, CV_NAME, T_NAME, PRT_NAME, LCLM_NAME, UCLM_NAME});
        OLAPList nSumMinMaxUss = Statistic.initializeDerivedStatisticList(new String[]{AVG_NAME, RANGE_NAME, CSS_NAME, VAR_NAME, STD_NAME, STDERR_NAME, CV_NAME, T_NAME, PRT_NAME, LCLM_NAME, UCLM_NAME});
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(1, 0), minMax);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(2, 1, 0), minMax);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(3, 1, 0), minMax);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(2, 3), nSum);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(2, 3, 0), nSum);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(2, 3, 1), nSum);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(2, 3, 1, 0), nSumMinMax);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(4, 1, 0), minMax);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(4, 2, 1, 0), minMax);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(4, 3, 1, 0), minMax);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(4, 3, 2), nSumUss);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(4, 3, 2, 0), nSumUss);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(4, 3, 2, 1), nSumUss);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(4, 3, 2, 1, 0), nSumMinMaxUss);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(5), range);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(6), avg);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(5, 6), rangeAvg);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(7), avgCssUclm);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(7, 5), avgRangeCssUclm);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(7, 6), avgCssUclm);
        Statistic.initializeDerivedStatisticIndexes(Statistic.initializeBitSet(7, 5, 6), avgRangeCssUclm);
    }

    private static void initializeDerivedStatisticIndexes(BitSet indexSet, OLAPList inputStatistics) {
        statisticIndexes.put(indexSet, inputStatistics);
    }

    private static OLAPList initializeDerivedStatisticList(String[] statisticNames) {
        OLAPList derivedStatistics = new OLAPList(Statistic.class);
        for (int i = statisticNames.length - 1; i >= 0; --i) {
            derivedStatistics.add(Statistic.getStatistic(statisticNames[i]));
        }
        derivedStatistics.sort();
        derivedStatistics.setModifiable(false);
        return derivedStatistics;
    }

    private static void initializeStatistics() {
        new Statistic(SUM_NAME, "", false);
        new Statistic(N_NAME, "12.0", false);
        new Statistic(AVG_NAME, "", true);
        new Statistic(MAX_NAME, "", false);
        new Statistic(MIN_NAME, "", false);
        new Statistic(RANGE_NAME, "", true);
        new Statistic(USS_NAME, "BEST.", false);
        new Statistic(CSS_NAME, "BEST.", true);
        new Statistic(VAR_NAME, "BEST.", true);
        new Statistic(STD_NAME, "", true);
        new Statistic(STDERR_NAME, "", true);
        new Statistic(CV_NAME, CV_STANDARD_FORMAT, true);
        new Statistic(T_NAME, T_STANDARD_FORMAT, true);
        new Statistic(PRT_NAME, PRT_STANDARD_FORMAT, true);
        new Statistic(LCLM_NAME, "", true);
        new Statistic(UCLM_NAME, "", true);
        new Statistic(NMISS_NAME, NMISS_STANDARD_FORMAT, false);
        new Statistic(NUNIQUE_NAME, "12.0", true);
        statistics.setModifiable(false);
        possibleStoredStatistics.sort();
        possibleStoredStatistics.setModifiable(false);
    }

    private static void initializeStoredStatisticIndexes() {
        Statistic.initializeStatisticIndexes(MAX_NAME, 0);
        Statistic.initializeStatisticIndexes(MIN_NAME, 1);
        Statistic.initializeStatisticIndexes(N_NAME, 2);
        Statistic.initializeStatisticIndexes(SUM_NAME, 3);
        Statistic.initializeStatisticIndexes(USS_NAME, 4);
    }

    private static void initializeStatisticIndexes(String statisticName, int index) {
        Statistic statistic = Statistic.getStatistic(statisticName);
        BitSet storedStatistics = new BitSet();
        storedStatistics.set(index);
        statistic.index = storedStatistics;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public String toString() {
        String returnLabel = this.label;
        if (ModelUtilities.isBlank(this.label)) {
            returnLabel = this.name;
        }
        return returnLabel;
    }

    static {
        possibleStoredStatistics = new OLAPList(Statistic.class);
        statisticIndexes = new HashMap();
        statisticsMap = new HashMap();
        statistics = new OLAPList(Statistic.class);
        EMPTY_LIST = new OLAPList(Statistic.class);
        Statistic.initializeStatistics();
        Statistic.initializeStoredStatisticIndexes();
        Statistic.initializeDerivedStatisticIndexes();
        EMPTY_LIST.setModifiable(false);
    }
}

