/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.iom.SASIOMCommon.ISessionAdmin;
import com.sas.iom.SASIOMCommon.ISessionAdminHelper;
import com.sas.iom.SASIOMDefs.BooleanSeqHolder;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.SASMDX.IMDXAdmin;
import com.sas.iom.SASMDX.IMDXAdminHelper;
import com.sas.iom.SASMDX.IMDXAdmin_1_1;
import com.sas.iom.SASMDX.IMDXAdmin_1_1Helper;
import com.sas.iom.SASMDX.ISession;
import com.sas.iom.SASMDX.ISessionHelper;
import com.sas.iom.SASMDX.NoSuchSession;
import com.sas.iom.SASMDX.ResultSetType;
import com.sas.iom.SASMDX.ResultSetTypeSeqHolder;
import com.sas.olapadmin.designer.model.MetadataQuery;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.model.Query;
import com.sas.services.connection.ConnectionInterface;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;

public class Session {
    private static WAdminResource bundle = new WAdminResource(Session.class);
    private OlapServer server;
    private UUID id;
    private String name;
    private String owner;
    private String description;
    private int secondsInactive;
    private int openSets;
    private ArrayList currentDataQueries;
    private String cubeNames;

    public Session(OlapServer inServer, UUID inId, String inOwner, String inName, String inDesc, int inInactive, int inOpen) {
        this.server = inServer;
        this.id = inId;
        this.name = inName;
        this.owner = inOwner;
        this.description = inDesc;
        this.secondsInactive = inInactive;
        this.openSets = inOpen;
    }

    public void close() throws OLAPException {
        if (!this.server.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        try {
            ConnectionInterface connection = this.server.getConnection();
            Object obj = connection.getObject();
            IMDXAdmin mdxAdmin = IMDXAdminHelper.narrow((Object)obj);
            mdxAdmin.CloseMDXSession(this.id, true);
        }
        catch (Exception e) {
            if (e instanceof COMM_FAILURE) {
                this.server.disconnect();
            }
            String messageText = bundle.getString("OlapServer.GenericError.txt");
            throw new OLAPException(messageText, e, 0);
        }
    }

    public String getCubeNames() {
        return this.cubeNames;
    }

    public String getDescription() {
        return this.description;
    }

    public UUID getId() {
        return this.id;
    }

    public ArrayList getMetadataQueries() throws OLAPException {
        ArrayList<MetadataQuery> queries;
        block7: {
            if (!this.server.isConnected()) {
                throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
            }
            queries = new ArrayList<MetadataQuery>();
            try {
                ConnectionInterface connection = this.server.getConnection();
                Object obj = connection.getObject();
                IMDXAdmin_1_1 mdxAdmin_1_1 = IMDXAdmin_1_1Helper.narrow((Object)obj);
                if (mdxAdmin_1_1 != null) {
                    StringSeqHolder nameHolder = new StringSeqHolder();
                    StringSeqHolder updtTimeHolder = new StringSeqHolder();
                    LongSeqHolder numHolder = new LongSeqHolder();
                    UUIDSeqHolder idHolder = new UUIDSeqHolder();
                    StringSeqHolder cubeHolder = new StringSeqHolder();
                    mdxAdmin_1_1.ListMDXRowsets(this.id, idHolder, nameHolder, numHolder, cubeHolder, updtTimeHolder);
                    String[] rowsetNames = nameHolder.value;
                    UUID[] ids = idHolder.value;
                    int numQueries = rowsetNames.length;
                    int[] numCubes = numHolder.value;
                    String[] cubes = cubeHolder.value;
                    Arrays.sort(cubes, String.CASE_INSENSITIVE_ORDER);
                    int lastCube = 0;
                    for (int i = 0; i < numQueries; ++i) {
                        int j;
                        String cubeNames = "";
                        for (j = lastCube; j < lastCube + numCubes[i]; ++j) {
                            cubeNames = ModelUtilities.isBlank(cubeNames) ? cubes[j] : cubeNames + "," + cubes[j];
                        }
                        lastCube = j;
                        MetadataQuery query = new MetadataQuery(this.server, this, rowsetNames[i], ids[i], cubeNames);
                        queries.add(query);
                    }
                    break block7;
                }
                throw new OLAPException(bundle.getString("Session.OperationNotAllowed.txt"), 0);
            }
            catch (Exception e) {
                String messageText = bundle.getString("OlapServer.GenericError.txt");
                if (e instanceof COMM_FAILURE) {
                    this.server.disconnect();
                }
                throw new OLAPException(messageText, e, 0);
            }
        }
        return queries;
    }

    public String getName() {
        return this.name;
    }

    public int getOpenSets() {
        return this.openSets;
    }

    public String getOwner() {
        return this.owner;
    }

    public List getQueries() throws OLAPException {
        if (!this.server.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        if (this.currentDataQueries == null) {
            this.currentDataQueries = new ArrayList();
        } else {
            this.currentDataQueries.clear();
        }
        try {
            ConnectionInterface connection = this.server.getConnection();
            Object obj = connection.getObject();
            IMDXAdmin_1_1 mdxAdmin_1 = IMDXAdmin_1_1Helper.narrow((Object)obj);
            StringSeqHolder stmtHolder = new StringSeqHolder();
            StringSeqHolder updtTimeHolder = new StringSeqHolder();
            ResultSetTypeSeqHolder typeHolder = new ResultSetTypeSeqHolder();
            BooleanSeqHolder runningFlagHolder = new BooleanSeqHolder();
            LongSeqHolder sizeHolder = new LongSeqHolder();
            UUIDSeqHolder idHolder = new UUIDSeqHolder();
            LongSeqHolder totalCellHolder = new LongSeqHolder();
            LongSeqHolder readCellHolder = new LongSeqHolder();
            if (mdxAdmin_1 == null) {
                ISessionAdmin sessionAdmin = ISessionAdminHelper.narrow((Object)obj);
                Object sobj = sessionAdmin.GetSession(this.id);
                ISession mdxSession = ISessionHelper.narrow((Object)sobj);
                mdxSession.ListQueries(stmtHolder, typeHolder, runningFlagHolder, sizeHolder);
                String[] mdxStrings = stmtHolder.value;
                ResultSetType[] types = typeHolder.value;
                int[] sizes = sizeHolder.value;
                int numQueries = mdxStrings.length;
                for (int i = 0; i < numQueries; ++i) {
                    Query query = new Query(this.server, this, null, mdxStrings[i], types[i], sizes[i]);
                    this.currentDataQueries.add(query);
                }
            } else {
                mdxAdmin_1.ListMDXQueries(this.id, idHolder, stmtHolder, typeHolder, updtTimeHolder, sizeHolder, totalCellHolder, readCellHolder);
                UUID[] ids = idHolder.value;
                String[] mdxStrings = stmtHolder.value;
                ResultSetType[] types = typeHolder.value;
                int[] sizes = sizeHolder.value;
                int[] totalCells = totalCellHolder.value;
                int[] readCells = readCellHolder.value;
                int numQueries = mdxStrings.length;
                for (int i = 0; i < numQueries; ++i) {
                    Query query = new Query(this.server, this, ids[i], mdxStrings[i], types[i], sizes[i], totalCells[i], readCells[i]);
                    this.currentDataQueries.add(query);
                }
            }
        }
        catch (Exception e) {
            String messageText = bundle.getString("OlapServer.GenericError.txt");
            if (e instanceof NoSuchSession || e instanceof OBJECT_NOT_EXIST) {
                messageText = bundle.getString("OlapServer.SessionNotExist.txt");
            }
            if (e instanceof COMM_FAILURE) {
                this.server.disconnect();
            }
            throw new OLAPException(messageText, e, 0);
        }
        return this.currentDataQueries;
    }

    public int getSecondsInactive() {
        return this.secondsInactive;
    }

    public OlapServer getServer() {
        return this.server;
    }

    public int getSize() throws OLAPException {
        int sessionSize = -1;
        if (this.currentDataQueries == null || this.currentDataQueries.size() < 1) {
            this.getQueries();
        }
        sessionSize = 0;
        for (int i = 0; i < this.currentDataQueries.size(); ++i) {
            Query query = (Query)this.currentDataQueries.get(i);
            int querySize = query.getSizeInBytes();
            sessionSize += querySize;
        }
        return sessionSize;
    }

    public boolean exists() throws OLAPException {
        boolean sessionExists = false;
        if (this.server.isConnected() && this.server.isAdminister()) {
            ConnectionInterface connection = this.server.getConnection();
            Object obj = connection.getObject();
            try {
                ISessionAdmin sessionAdmin = ISessionAdminHelper.narrow((Object)obj);
                sessionAdmin.GetSession(this.id);
                sessionExists = true;
            }
            catch (Exception e) {
                if (e instanceof COMM_FAILURE) {
                    this.server.disconnect();
                }
                sessionExists = false;
            }
        }
        return sessionExists;
    }

    public void setCubeNames(String cubes) {
        this.cubeNames = cubes;
    }
}

