/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.Option;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OptionSet {
    static WAdminResource bundle = new WAdminResource(OptionSet.class);
    private OLAPCube owningCube;
    private OLAPDimension owningDimension;
    private OLAPSharedDimension owningSharedDim;
    static final String CUBE_OPTION_VERSION = "OLAPVersion";
    static final String CUBE_OPTION_VERSION_NAME = "Version";
    static final String CUBE_OPTION_CUBE_FOLDER = "CUBEFOLDER";
    static final String CUBE_OPTION_GENFOLDER = "GENFOLDER";
    static final String CUBE_OPTION_NONWAY = "NO_NWAY";
    static final String CUBE_OPTION_WORKPATH = "WORKPATH";
    static final String RAGGED_OPTION_EMPTYCHAR = "EMPTY_CHAR";
    static final String RAGGED_OPTION_EMPTYNUM = "EMPTY_NUM";
    static final String RAGGED_OPTION_EMPTY = "EMPTY";
    static final String RAGGED_OPTION_IGNOREEMPTY = "IGNORE_EMPTY";
    public static final String PERFORMANCE_OPTION_COMPRESS = "COMPRESS";
    public static final String PERFORMANCE_OPTION_CONCURRENT = "CONCURRENT";
    public static final String PERFORMANCE_OPTION_DATAPATH = "DATAPATH";
    public static final String PERFORMANCE_OPTION_INDEX = "INDEX";
    public static final String PERFORMANCE_OPTION_INDEXPATH = "INDEXPATH";
    public static final String PERFORMANCE_OPTION_INDEXSORTSIZE = "INDEXSORTSIZE";
    public static final String PERFORMANCE_OPTION_PARTSIZE = "PARTSIZE";
    public static final String PERFORMANCE_OPTION_MAXTHREADS = "MAXTHREADS";
    public static final String PERFORMANCE_OPTION_ASYNCINDEXLIMIT = "ASYNCINDEXLIMIT";
    public static final String PERFORMANCE_OPTION_SEGSIZE = "SEGSIZE";
    public static final String NUMBER_OF_RACKS = "NRACKS";
    static final String OLAP_OPTION = "OLAPOption";
    static final String OLAP_LINGUISTIC = "OLAP Linguistic";
    static final String OLAP_TABLE_OPTION_NAME = "_options";
    static final String CAPTION_MLS_PREFIX = "_cappref";
    static final String Caption_MLS_TABLE = "_CaptionTable";
    static final String OLAP_SHARED_DIM_TABLE_OPTION_NAME = "DimensionTable_options";
    static final String AGGREGATIONTABLE_OPTION = "AggregationTable_options";
    static final String OLAP_ALL_MEMBER_CAPTION = "OLAPAllMemberCaption";
    static final String OLAP_TABLE_OPTION = "OLAP Table Options";
    static final String ALL_MEMBER_CAPTION = "AllMemberCaption";
    static final String DEFAULT_MEMBER_NAME = "Default Member";
    static final String LINGUISTIC_OPTION = "Linguistic";
    static final String COLLATION_OPTION = "Collation";
    static final String LOCALE_OPTION = "Locale";
    static final String MLSID_OPTION = "MLSID";
    static final String ALL_MEMBER_MLSID_OPTION = "All Member MLSID";
    static Integer OWNING_TYPE_BOOLEAN;
    static Integer OWNING_TYPE_INTEGER;
    static Integer OWNING_TYPE_STRING;
    static String OWNING_TYPE_BOOLEAN_NAME;
    static String OWNING_TYPE_INTEGER_NAME;
    static String OWNING_TYPE_STRING_NAME;
    static final String OWNING_TYPE_STRING_ARRAY_NAME = "StringArray";
    public static final String OPTION_IS_ON = "1";
    public static final String OPTION_IS_OFF = "0";
    static final String CUBE_COMPACT = "COMPACT_NWAY";
    static final String CUBE_MISSING_KEYS = "IGNORE_MISSING_DIMKEYS";
    static final String DIMENSION_MLS_NAME = "_mempref";
    static final String MLS_ROLE = "OLAP UDT";
    static final String DRILLTHRU_MLS_PREFIX = "DTMEMPREF";
    static final String ESRI_MAP_FIELD = "ESRI Map Field";
    static final String NO_DIMENSION_UPDATE = "NONUPDATEABLE";
    static final String INCLUDE_CALCULATED_MEMBERS = "INCLUDE_CALCULATED_MEMBERS";
    static final String SECURITY_SUBSET = "SECURITY_SUBSET";
    static final String REORGANIZE_REQUIRED = "REORGANIZE_REQUIRED";
    static final String NOINCLUDE_CALCULATED_MEMBERS = "NOINCLUDE_CALCULATED_MEMBERS";
    static final String CALC_MEMBER_SOLVE_ORDER = "SOLVE_ORDER";
    static final String OLAP_CALCULATION_PROPERTY_ROLE = "OLAPCalculationProperty";
    private Map options;
    private static final Map optionTypes;
    private static final Map optionTypeNames;
    private Map owningTypes;
    private List performanceOptionTypes;

    OptionSet(OLAPCube inputOwningCube) {
        this.owningCube = inputOwningCube;
    }

    OptionSet(OLAPSharedDimension inputSharedDimension) {
        this.owningSharedDim = inputSharedDimension;
    }

    OptionSet(OLAPDimension inputOwningDimension) {
        this.owningDimension = inputOwningDimension;
    }

    Option getOption(AbstractOLAPModel owningObject, String optionName, String optionRole) throws OLAPException {
        Option option = null;
        AssociationList properties = null;
        List objectOptions = null;
        if (this.options != null) {
            objectOptions = (List)this.options.get(owningObject);
        }
        if (objectOptions != null) {
            int i = 0;
            int size = objectOptions.size();
            while (i < size & option == null) {
                Option tempOption = (Option)objectOptions.get(i);
                if (tempOption.getName().equalsIgnoreCase(optionName) & tempOption.getPropertyRole().equalsIgnoreCase(optionRole)) {
                    option = tempOption;
                }
                ++i;
            }
        }
        try {
            int metadataVersion;
            if (owningObject.metadataObject != null & option == null) {
                properties = owningObject.metadataObject.getProperties(false);
                boolean found = false;
                int size = properties.size();
                for (int i = 0; i < size && !found; ++i) {
                    Property property = (Property)properties.elementAt(i);
                    if (!(property.getPropertyName().equalsIgnoreCase(optionName) & property.getPropertyRole().equalsIgnoreCase(optionRole))) continue;
                    option = new Option(this, owningObject);
                    option.metadataObject = property;
                    option.setName(property.getName());
                    option.setDesc(property.getDesc());
                    option.setPropertyName(property.getPropertyName());
                    option.setPropertyRole(property.getPropertyRole());
                    option.setDefaultValue(property.getDefaultValue());
                    int owningType = property.getSQLType();
                    PropertyType propertyType = property.getOwningType();
                    if (propertyType != null) {
                        owningType = propertyType.getSQLType();
                    }
                    option.setOwningType(Integer.valueOf(String.valueOf(owningType)));
                    option.setPropertyOption(true);
                    found = true;
                }
                properties = owningObject.metadataObject.getPropertySets();
                int sizeSets = properties.size();
                for (int t = 0; t < sizeSets; ++t) {
                    PropertySet propertySet = (PropertySet)properties.elementAt(t);
                    AssociationList listOfProperties = propertySet.getSetProperties();
                    found = false;
                    int size2 = listOfProperties.size();
                    for (int i = 0; i < size2 && !found; ++i) {
                        Property property = (Property)listOfProperties.elementAt(i);
                        if (!(property.getPropertyName().equalsIgnoreCase(optionName) & property.getPropertyRole().equalsIgnoreCase(optionRole))) continue;
                        option = new Option(this, owningObject);
                        option.metadataObject = property;
                        option.setName(property.getName());
                        option.setDesc(property.getDesc());
                        option.setPropertyName(property.getPropertyName());
                        option.setPropertyRole(property.getPropertyRole());
                        option.setDefaultValue(property.getDefaultValue());
                        int owningType = property.getSQLType();
                        PropertyType propertyType = property.getOwningType();
                        if (propertyType != null) {
                            owningType = propertyType.getSQLType();
                        }
                        option.setOwningType(Integer.valueOf(String.valueOf(owningType)));
                        option.setPropertyOption(true);
                        found = true;
                    }
                }
            }
            if ((metadataVersion = Workspace.getMetadataServerVersionNumber()) >= 9200 && option == null && owningObject.metadataObject != null) {
                properties = owningObject.metadataObject.getCustomAssociations(false);
                boolean found = false;
                for (int i = properties.size() - 1; i >= 0 && !found; --i) {
                    CustomAssociation custom = (CustomAssociation)properties.get(i);
                    String customName = custom.getName();
                    if (!customName.equalsIgnoreCase(optionName)) continue;
                    option = new Option(this, owningObject);
                    option.metadataObject = custom;
                    option.setName(custom.getName());
                    option.setPropertyName(custom.getName());
                    option.setDesc(custom.getDesc());
                    option.setPropertyRole(OLAP_OPTION);
                    option.setPropertyOption(false);
                    AssociationList objects = custom.getAssociatedObjects(false);
                    if (objects.isEmpty()) continue;
                    String directoryName = "";
                    directoryName = this.concatenatePath(objects);
                    option.setDefaultValue(directoryName);
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return option;
    }

    private String concatenatePath(AssociationList objects) {
        StringBuffer path = new StringBuffer();
        try {
            if (objects.size() == 1) {
                Directory directory = (Directory)objects.get(0);
                path.append(directory.getDirectoryName());
            } else {
                int sizeI = objects.size();
                for (int i = 0; i < sizeI; ++i) {
                    Directory directory = (Directory)objects.get(i);
                    String directoryName = directory.getDirectoryName();
                    if (directoryName.indexOf("\"") >= 0) {
                        StringBuffer replaceString = new StringBuffer();
                        int sizeJ = directoryName.length();
                        for (int j = 0; j < sizeJ; ++j) {
                            char character = directoryName.charAt(j);
                            if (character == '\"') {
                                replaceString.append('\\');
                            }
                            replaceString.append(character);
                        }
                        directoryName = replaceString.toString();
                    }
                    path.append("\"").append(directoryName).append("\"");
                    if (i >= sizeI - 1) continue;
                    path.append(" ");
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return path.toString();
    }

    List getOptions(AbstractOLAPModel owningObject) {
        ArrayList objectOptions;
        if (this.options == null) {
            this.options = new HashMap();
        }
        if ((objectOptions = (ArrayList)this.options.get(owningObject)) == null) {
            objectOptions = new ArrayList();
            this.options.put(owningObject, objectOptions);
        }
        return objectOptions;
    }

    OLAPCube getOwningCube() {
        return this.owningCube;
    }

    OLAPSharedDimension getOwningSharedDimension() {
        return this.owningSharedDim;
    }

    PropertyType getOwningType(Integer owningType) throws OLAPException {
        PropertyType propertyType = null;
        try {
            if (this.owningTypes == null) {
                this.getOwningTypes();
            }
            if ((propertyType = (PropertyType)this.owningTypes.get(owningType)) == null) {
                MdObjectStore objectStore = null;
                String shortFQID = "";
                if (this.owningCube != null) {
                    objectStore = this.owningCube.getObjectStore();
                    shortFQID = this.owningCube.getRepositoryShortFQID();
                } else {
                    shortFQID = this.owningDimension.getRepositoryShortFQID();
                }
                propertyType = (PropertyType)MetadataTemplate.createMetadata(objectStore, "PropertyType", shortFQID);
                if (owningType.equals(OWNING_TYPE_BOOLEAN)) {
                    propertyType.setName(OWNING_TYPE_BOOLEAN_NAME);
                    propertyType.setSQLType(-7);
                } else if (owningType.equals(OWNING_TYPE_INTEGER)) {
                    propertyType.setName(OWNING_TYPE_INTEGER_NAME);
                    propertyType.setSQLType(4);
                } else if (owningType.equals(OWNING_TYPE_STRING)) {
                    propertyType.setName(OWNING_TYPE_STRING_NAME);
                    propertyType.setSQLType(12);
                    PropertyType propertyStringArray = (PropertyType)MetadataTemplate.createMetadata(objectStore, "PropertyType", shortFQID);
                    propertyStringArray.setName(OWNING_TYPE_STRING_ARRAY_NAME);
                    propertyStringArray.setSQLType(2003);
                    propertyStringArray.setElementType(propertyType);
                }
                this.owningTypes.put(owningType, propertyType);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return propertyType;
    }

    private void getOwningTypes() {
        boolean stringTypeFound = false;
        boolean integerTypeFound = false;
        boolean booleanTypeFound = false;
        this.owningTypes = new HashMap();
        if (this.owningCube != null && this.owningCube.metadataObject != null) {
            Cube cube = (Cube)this.owningCube.metadataObject;
            try {
                int i;
                int jSize;
                ArrayList<AssociationList> allProperties = new ArrayList<AssociationList>();
                allProperties.add(cube.getProperties(false));
                AssociationList dimensions = cube.getDimensions(false);
                int size = dimensions.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    Dimension dimension = (Dimension)dimensions.elementAt(i2);
                    allProperties.add(dimension.getProperties(false));
                    AssociationList levels = dimension.getLevels(false);
                    jSize = levels.size();
                    for (int j = 0; j < jSize; ++j) {
                        Level level = (Level)levels.elementAt(j);
                        allProperties.add(level.getProperties(false));
                    }
                    AssociationList hierarchies = dimension.getHierarchies(false);
                    int jSize2 = hierarchies.size();
                    for (int j = 0; j < jSize2; ++j) {
                        Hierarchy hierarchy = (Hierarchy)hierarchies.elementAt(j);
                        allProperties.add(hierarchy.getProperties(false));
                    }
                }
                AssociationList aggregations = cube.getAggregations(false);
                int size2 = aggregations.size();
                for (i = 0; i < size2; ++i) {
                    Aggregation aggregation = (Aggregation)aggregations.elementAt(i);
                    allProperties.add(aggregation.getProperties(false));
                }
                i = 0;
                size2 = allProperties.size();
                while (i < size2 & !(stringTypeFound & integerTypeFound & booleanTypeFound)) {
                    AssociationList properties = (AssociationList)allProperties.get(i);
                    int j = 0;
                    jSize = properties.size();
                    while (j < jSize & !(stringTypeFound & integerTypeFound & booleanTypeFound)) {
                        Property property = (Property)properties.elementAt(j);
                        PropertyType owningType = property.getOwningType();
                        String propertyType = owningType.getName();
                        PropertyType knownType = (PropertyType)this.owningTypes.get(propertyType);
                        if (knownType == null) {
                            this.owningTypes.put(optionTypeNames.get(propertyType), owningType);
                        }
                        Set keys = this.owningTypes.keySet();
                        if (!stringTypeFound) {
                            stringTypeFound = keys.contains(OWNING_TYPE_STRING);
                        }
                        if (!integerTypeFound) {
                            integerTypeFound = keys.contains(OWNING_TYPE_INTEGER);
                        }
                        if (!booleanTypeFound) {
                            booleanTypeFound = keys.contains(OWNING_TYPE_BOOLEAN);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (MdException allProperties) {
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    List getPerformanceTypes() {
        if (this.performanceOptionTypes == null) {
            this.performanceOptionTypes = new ArrayList();
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_INDEXSORTSIZE);
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_MAXTHREADS);
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_CONCURRENT);
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_PARTSIZE);
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_SEGSIZE);
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_INDEXPATH);
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_DATAPATH);
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_COMPRESS);
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_INDEX);
            this.performanceOptionTypes.add(PERFORMANCE_OPTION_ASYNCINDEXLIMIT);
        }
        return this.performanceOptionTypes;
    }

    static {
        OWNING_TYPE_BOOLEAN_NAME = "Boolean";
        OWNING_TYPE_INTEGER_NAME = "Integer";
        OWNING_TYPE_STRING_NAME = "String";
        OWNING_TYPE_BOOLEAN = Integer.valueOf("-7");
        OWNING_TYPE_INTEGER = Integer.valueOf("4");
        OWNING_TYPE_STRING = Integer.valueOf("12");
        optionTypes = new HashMap();
        optionTypes.put(CUBE_OPTION_VERSION, OWNING_TYPE_INTEGER);
        optionTypes.put(CUBE_OPTION_NONWAY, OWNING_TYPE_STRING);
        optionTypes.put(CUBE_OPTION_WORKPATH, OWNING_TYPE_STRING);
        optionTypes.put(RAGGED_OPTION_EMPTYCHAR, OWNING_TYPE_STRING);
        optionTypes.put(RAGGED_OPTION_EMPTYNUM, OWNING_TYPE_STRING);
        optionTypes.put(RAGGED_OPTION_IGNOREEMPTY, OWNING_TYPE_BOOLEAN);
        optionTypes.put(PERFORMANCE_OPTION_COMPRESS, OWNING_TYPE_BOOLEAN);
        optionTypes.put(PERFORMANCE_OPTION_CONCURRENT, OWNING_TYPE_INTEGER);
        optionTypes.put(PERFORMANCE_OPTION_DATAPATH, OWNING_TYPE_STRING);
        optionTypes.put(PERFORMANCE_OPTION_INDEX, OWNING_TYPE_BOOLEAN);
        optionTypes.put(PERFORMANCE_OPTION_INDEXPATH, OWNING_TYPE_STRING);
        optionTypes.put(PERFORMANCE_OPTION_INDEXSORTSIZE, OWNING_TYPE_INTEGER);
        optionTypes.put(PERFORMANCE_OPTION_PARTSIZE, OWNING_TYPE_INTEGER);
        optionTypes.put(PERFORMANCE_OPTION_MAXTHREADS, OWNING_TYPE_INTEGER);
        optionTypes.put(PERFORMANCE_OPTION_ASYNCINDEXLIMIT, OWNING_TYPE_INTEGER);
        optionTypes.put(PERFORMANCE_OPTION_SEGSIZE, OWNING_TYPE_INTEGER);
        optionTypes.put(NUMBER_OF_RACKS, OWNING_TYPE_INTEGER);
        optionTypes.put(OLAP_TABLE_OPTION, OWNING_TYPE_STRING);
        optionTypes.put(ALL_MEMBER_CAPTION, OWNING_TYPE_STRING);
        optionTypes.put(DEFAULT_MEMBER_NAME, OWNING_TYPE_STRING);
        optionTypes.put(CUBE_COMPACT, OWNING_TYPE_BOOLEAN);
        optionTypes.put(CUBE_MISSING_KEYS, OWNING_TYPE_STRING);
        optionTypes.put(DIMENSION_MLS_NAME, OWNING_TYPE_STRING);
        optionTypes.put(ESRI_MAP_FIELD, OWNING_TYPE_STRING);
        optionTypes.put(NO_DIMENSION_UPDATE, OWNING_TYPE_BOOLEAN);
        optionTypes.put(INCLUDE_CALCULATED_MEMBERS, OWNING_TYPE_BOOLEAN);
        optionTypes.put(SECURITY_SUBSET, OWNING_TYPE_STRING);
        optionTypes.put(REORGANIZE_REQUIRED, OWNING_TYPE_BOOLEAN);
        optionTypes.put(DRILLTHRU_MLS_PREFIX, OWNING_TYPE_STRING);
        optionTypes.put(CALC_MEMBER_SOLVE_ORDER, OWNING_TYPE_INTEGER);
        optionTypeNames = new HashMap();
        optionTypeNames.put(OWNING_TYPE_BOOLEAN_NAME, OWNING_TYPE_BOOLEAN);
        optionTypeNames.put(OWNING_TYPE_INTEGER_NAME, OWNING_TYPE_INTEGER);
        optionTypeNames.put(OWNING_TYPE_STRING_NAME, OWNING_TYPE_STRING);
    }
}

