/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Option
extends AbstractOLAPModel {
    static WAdminResource bundle = new WAdminResource(Option.class);
    private String defaultValue;
    private String propertyName;
    private String propertyRole;
    private Integer owningType;
    private AbstractOLAPModel owningObject;
    private boolean isPropertyOption;
    private boolean isPropertySetOption;

    Option(OptionSet inputOptionSet, AbstractOLAPModel inputOwningObject) {
        this.optionSet = inputOptionSet;
        this.owningCube = this.optionSet.getOwningCube();
        if (this.owningCube == null) {
            this.owningSharedDimension = this.optionSet.getOwningSharedDimension();
        }
        this.owningObject = inputOwningObject;
        this.optionSet.getOptions(this.owningObject).add(this);
        this.isPropertyOption = true;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyRole() {
        return this.propertyRole;
    }

    public void setDefaultValue(String inputDefaultValue) {
        this.defaultValue = inputDefaultValue;
    }

    public void setPropertyName(String inputPropertyName) {
        this.propertyName = inputPropertyName;
    }

    public void setPropertyRole(String inputPropertyRole) {
        this.propertyRole = inputPropertyRole;
    }

    public void setOwningType(Integer inputPropertyType) {
        this.owningType = inputPropertyType;
    }

    void setPropertyOption(boolean inputPropertyOption) {
        this.isPropertyOption = inputPropertyOption;
    }

    void setPropertySetOption(boolean inputPropertyOption) {
        this.isPropertySetOption = inputPropertyOption;
    }

    private void updateMetadataProperty() throws OLAPException {
        try {
            if (this.metadataObject == null && this.owningCube != null) {
                this.metadataObject = (Property)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Property", this.owningCube.getRepositoryShortFQID());
            } else if (this.metadataObject == null && this.owningSharedDimension != null) {
                this.metadataObject = (Property)MetadataTemplate.createMetadata(this.owningSharedDimension.getObjectStore(), "Property", this.owningSharedDimension.getRepositoryShortFQID());
            }
            Property property = (Property)this.metadataObject;
            super.updateMetadata();
            property.setPropertyName(this.getPropertyName());
            property.setPropertyRole(this.getPropertyRole());
            property.setDefaultValue(this.getDefaultValue());
            PropertyType propertyType = property.getOwningType();
            int metadataVersion = Workspace.getMetadataServerVersionNumber();
            if (metadataVersion >= 9200) {
                property.setSQLType(this.owningType.intValue());
                if (propertyType != null) {
                    propertyType.delete();
                }
            } else {
                PropertyType newPropertyType = this.optionSet.getOwningType(this.owningType);
                property.setSQLType(this.owningType.intValue());
                property.setOwningType(newPropertyType);
            }
            if (!this.isPropertySetOption) {
                AssociationList properties = this.owningObject.metadataObject.getProperties();
                if (properties.indexOf((Object)property) < 0) {
                    properties.add((Object)property);
                }
            } else {
                AssociationList setProperties;
                AssociationList listOfPropertySets = null;
                if (this.owningCube != null) {
                    Cube jomaCube = (Cube)this.owningCube.metadataObject;
                    listOfPropertySets = jomaCube.getPropertySets();
                } else if (this.owningSharedDimension != null) {
                    SharedDimension dimension = (SharedDimension)this.owningSharedDimension.metadataObject;
                    listOfPropertySets = dimension.getPropertySets();
                }
                PropertySet linguisticPropertySet = null;
                int iSize = listOfPropertySets.size();
                for (int i = 0; i < iSize; ++i) {
                    PropertySet propertySet = (PropertySet)listOfPropertySets.elementAt(i);
                    String name = propertySet.getName();
                    if (!name.equals("Linguistic")) continue;
                    linguisticPropertySet = propertySet;
                }
                if (linguisticPropertySet == null) {
                    if (this.owningCube != null) {
                        linguisticPropertySet = (PropertySet)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "PropertySet", this.owningCube.getRepositoryShortFQID());
                    } else if (this.owningSharedDimension != null) {
                        linguisticPropertySet = (PropertySet)MetadataTemplate.createMetadata(this.owningSharedDimension.getObjectStore(), "PropertySet", this.owningSharedDimension.getRepositoryShortFQID());
                    }
                    linguisticPropertySet.setName("Linguistic");
                    linguisticPropertySet.setSetRole("OLAP Linguistic");
                    linguisticPropertySet.setPropertySetName("Linguistic");
                    listOfPropertySets.addElement((Object)linguisticPropertySet);
                }
                if ((setProperties = linguisticPropertySet.getSetProperties()).indexOf((Object)property) < 0) {
                    setProperties.add((Object)property);
                }
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private List getConcatenatedPaths(Map olapPaths, String inputPath) throws MdException, RemoteException, OLAPException {
        ArrayList<Directory> paths = new ArrayList<Directory>();
        if (!ModelUtilities.isBlank(inputPath)) {
            String fixedString = ModelUtilities.trim(inputPath);
            if (fixedString.startsWith("(") && (fixedString = fixedString.substring(1)).endsWith(")")) {
                fixedString = fixedString.substring(0, fixedString.length() - 1);
            }
            String delimiter = String.valueOf('\"');
            if (fixedString.startsWith("'")) {
                delimiter = "'";
            }
            String[] inputPaths = fixedString.split(delimiter);
            for (int i = 0; i < inputPaths.length; ++i) {
                String nextDirectory = inputPaths[i];
                if (ModelUtilities.isBlank(nextDirectory)) continue;
                Directory directory = (Directory)olapPaths.get(nextDirectory);
                if (directory == null && this.owningCube != null) {
                    directory = this.owningCube.getDirectory(nextDirectory);
                }
                paths.add(directory);
            }
        }
        return paths;
    }

    private void updateMetadataCustom() throws OLAPException {
        try {
            int i;
            if (this.metadataObject == null) {
                this.metadataObject = (CustomAssociation)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "CustomAssociation", this.owningCube.getRepositoryShortFQID());
            }
            AssociationList properties = this.metadataObject.getProperties(false);
            boolean found = false;
            for (int i2 = properties.size() - 1; i2 >= 0 && !found; --i2) {
                Property property = (Property)properties.get(i2);
                String tempPropertyName = property.getPropertyName();
                if (!tempPropertyName.equalsIgnoreCase(this.getName())) continue;
                property.delete();
            }
            CustomAssociation custom = null;
            if (this.metadataObject instanceof CustomAssociation) {
                custom = (CustomAssociation)this.metadataObject;
            } else {
                custom = (CustomAssociation)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "CustomAssociation", this.owningCube.getRepositoryShortFQID());
                this.metadataObject.delete();
                this.metadataObject = custom;
            }
            super.updateMetadata();
            custom.setName(this.getPropertyName());
            custom.setPartnerName(this.getPropertyName());
            custom.setisOwned(1);
            AssociationList customs = this.owningObject.metadataObject.getCustomAssociations(false);
            if (customs.indexOf((Object)custom) < 0) {
                customs.add((Object)custom);
            }
            AssociationList directories = custom.getAssociatedObjects(false);
            HashMap<String, Directory> olapPaths = new HashMap<String, Directory>();
            for (int i3 = directories.size() - 1; i3 >= 0; --i3) {
                Directory directory = (Directory)directories.get(i3);
                if (directory.getDirectoryRole().equalsIgnoreCase("OLAPPath")) {
                    olapPaths.put(directory.getDirectoryName(), directory);
                    continue;
                }
                directories.remove((Object)directory);
            }
            List paths = this.getConcatenatedPaths(olapPaths, this.getDefaultValue());
            for (i = directories.size() - 1; i >= 0; --i) {
                Directory directory = (Directory)directories.get(i);
                if (paths.contains(directory)) continue;
                MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)directory, "", bundle.getString("MdException.GenericError.txt"));
            }
            directories.clear();
            for (i = paths.size() - 1; i >= 0; --i) {
                directories.add(paths.get(i));
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    @Override
    public void updateMetadata() throws OLAPException {
        if (this.isPropertyOption) {
            this.updateMetadataProperty();
        } else {
            this.updateMetadataCustom();
        }
    }
}

