/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerAdministration;
import com.sas.iom.SASIOMCommon.IServerAdministrationHelper;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMCommon.IServerStatus;
import com.sas.iom.SASIOMCommon.IServerStatusHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.BooleanSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.SASMDX.CommandFlag;
import com.sas.iom.SASMDX.IMDXAdmin;
import com.sas.iom.SASMDX.IMDXAdminHelper;
import com.sas.iom.SASMDX.IMDXAdmin_1_1;
import com.sas.iom.SASMDX.IMDXAdmin_1_1Helper;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.IMDXServerHelper;
import com.sas.iom.SASMDX.ISession;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Transformation;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.Session;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.services.connection.omr.OMRConnectionFactoryConfiguration;
import com.sas.services.connection.omr.RemoteUtil;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.omg.CORBA.Any;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;

public class OlapServer {
    private static final String PAUSED = "Paused";
    private static final String RUNNING = "Running";
    private static WAdminResource bundle = new WAdminResource(OlapServer.class);
    private String userId;
    private String password;
    private LogicalServer logicalServer;
    private OLAPSchema schema;
    private ServerComponent serverComponent;
    private ConnectionInterface connection;
    private static final String OLAP_CLASS_ID = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
    private AssociationList serverContexts;
    private OLAPDataSet olapData;
    private boolean administer;
    private ServerContext serverContext;

    public OlapServer(Cube inputCube) throws OLAPException {
        try {
            this.schema = inputCube.getAssociatedOLAPSchema();
            if (this.schema == null) {
                throw new OLAPException(bundle.formatString("OlapServer.NoSchemaForCube.fmt.txt", (java.lang.Object)inputCube.getName()), 0);
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
        }
        this.logicalServer = this.getLogicalServerFromOLAPSchema(this.schema);
    }

    public OlapServer(LogicalServer inputLogical) throws OLAPException {
        this.setMetadataObject(inputLogical);
    }

    public OlapServer(AbstractOLAPModel object) throws OLAPException {
        this.schema = object instanceof OLAPCube ? ((OLAPCube)object).getAssociatedOLAPSchema() : ((OLAPSharedDimension)object).getAssociatedOLAPSchema();
        if (this.schema == null) {
            throw new OLAPException(bundle.formatString("OlapServer.NoSchemaForCube.fmt.txt", (java.lang.Object)object.getName()), 0);
        }
        this.logicalServer = this.getLogicalServerFromOLAPSchema(this.schema);
    }

    public OlapServer(SharedDimension sharedDimension) throws OLAPException {
        try {
            this.schema = sharedDimension.getAssociatedOLAPSchema();
            if (this.schema == null) {
                throw new OLAPException(bundle.formatString("OlapServer.NoSchemaForSharedDimension.fmt.txt", (java.lang.Object)sharedDimension.getName()), 0);
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
        }
        this.logicalServer = this.getLogicalServerFromOLAPSchema(this.schema);
    }

    public void connect() throws OLAPException {
        UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
        this.connect(userContext);
    }

    public void connect(UserContextInterface userContext) throws OLAPException {
        if (this.logicalServer == null && this.schema != null) {
            this.logicalServer = this.getLogicalServerFromOLAPSchema(this.schema);
        }
        if (this.logicalServer == null) {
            this.serverContext = this.promptForServerContext();
            this.logicalServer = this.getLogicalServerFromServerContext(this.serverContext);
        }
        if (this.logicalServer == null) {
            throw new OLAPException(bundle.getString("OlapServer.NoServerSelected.txt"), 0);
        }
        String name = "";
        try {
            name = this.logicalServer.getName();
            MdOMRConnection metadataWorkspace = Workspace.getMdFactory().getConnection();
            IOMI iomiHandle = metadataWorkspace.getCMRHandle();
            OMRConnectionFactoryConfiguration cxfConfig = new OMRConnectionFactoryConfiguration(iomiHandle, this.logicalServer.getId());
            PlatformConnectionFactoryInterface p_cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            this.connection = p_cxf.getConnection(userContext);
            String version = this.getVersion();
            if (version.startsWith("9.01") || version.startsWith("9.00")) {
                this.disconnect();
                throw new OLAPException(bundle.formatString("OlapServer.WrongVersion.txt", (java.lang.Object)version), 0);
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (ConnectionFactoryException e2) {
            throw new OLAPException(bundle.formatString("OlapServer.CannotConnect.fmt.txt", (java.lang.Object)name), e2, 0);
        }
        catch (Exception e) {
            throw new OLAPException(bundle.formatString("OlapServer.CannotConnect.fmt.txt", (java.lang.Object)name), e, 0);
        }
        this.setAdminister(true);
    }

    public void disableCube(String cubeName) throws OLAPException {
        this.enableDisableCube(cubeName, true);
    }

    public void disconnect() throws OLAPException {
        try {
            if (this.olapData != null) {
                this.olapData.close();
            }
        }
        catch (com.sas.storage.olap.OLAPException e) {
            throw new OLAPException(e.getLocalizedMessage(), e, 0);
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
        }
    }

    public void enableCube(String cubeName) throws OLAPException {
        this.enableDisableCube(cubeName, false);
    }

    private void enableDisableCube(String cubeName, boolean disable) throws OLAPException {
        block17: {
            String message = bundle.getString("OlapServer.GenericError.txt");
            try (ConnectionInterface cx = null;){
                UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.logicalServer, null, null, "<Templates><LogicalServer Name=\"\" ClassIdentifier=\"\" UsageVersion=\"\"><ServiceTypes/><InitProcesses/><SoftwareTrees/><UsingComponents/><Properties/></LogicalServer><ServiceType Name=\"\"/><Transformation TransformRole=\"\"><TransformationSources/></Transformation><Tree TreeType=\"\"><Members/></Tree><ServerComponent Name=\"\" PublicType=\"\"><AssociatedMachine/><ServiceTypes/><SoftwareTrees/><SourceConnections/><Properties/></ServerComponent><Group><Members/><Properties/></Group><Login Password=\"\" UserID=\"\"><Domain/><AssociatedIdentity/></Login><AuthenticationDomain Name=\"\"/><Identity><Logins/></Identity><Person><Logins/></Person><IdentityGroup Name=\"\"><Logins/></IdentityGroup><Property PropertyName=\"\" DefaultValue=\"\"/><ServiceType Name=\"\"/><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" ApplicationProtocol=\"\" HostName=\"\" Port=\"\"><Properties/><Domain/></TCPIPConnection><Machine Name=\"\"><Implementors/></Machine><Implementor PublicType=\"\"><SourceConnections/></Implementor></Templates>", 12);
                java.lang.Object resolve = RemoteUtil.resolve((LogicalServer)this.logicalServer, null);
                if (!(resolve instanceof Cluster[])) break block17;
                Cluster[] clusterArr = (Cluster[])resolve;
                for (int i = 0; i < clusterArr.length; ++i) {
                    Cluster cluster = clusterArr[i];
                    Server[] serverArr = cluster.getServerArray();
                    int howManyFailed = 0;
                    for (int j = 0; j < serverArr.length; ++j) {
                        Server server = serverArr[j];
                        ManualConnectionFactoryConfiguration cxFactoryConfig = new ManualConnectionFactoryConfiguration(server, true);
                        PlatformConnectionFactoryManager cxFactoryManager = new PlatformConnectionFactoryManager();
                        PlatformConnectionFactoryInterface cxFactory = cxFactoryManager.getPlatformFactory((ConnectionFactoryConfiguration)cxFactoryConfig);
                        try {
                            cx = cxFactory.getConnection(userContext);
                        }
                        catch (ConnectionFactoryException e) {
                            if (cx != null) {
                                cx.close();
                            }
                            if (++howManyFailed != serverArr.length) continue;
                            throw new OLAPException(message, e, 0);
                        }
                        Object obj = cx.getObject();
                        IMDXAdmin_1_1 mdxa = IMDXAdmin_1_1Helper.narrow((Object)obj);
                        String[] cubenames = new String[]{cubeName};
                        if (disable) {
                            mdxa.DisableCubes(cubenames);
                        } else {
                            mdxa.EnableCubes(cubenames);
                        }
                        cx.close();
                        cx = null;
                    }
                }
            }
        }
    }

    public void executeCommand(String command) throws OLAPException {
        if (!this.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        ISession session = null;
        try {
            Object obj = this.connection.getObject();
            IMDXServer mdxServer = IMDXServerHelper.narrow((Object)obj);
            CommandFlag cFlag = CommandFlag.from_int((int)0);
            session = mdxServer.CreateSession(Locale.getDefault().toString());
            session.MDXCommand(command, cFlag);
        }
        catch (Exception e) {
            String message = bundle.formatString("OlapServer.CommandError.fmt.txt", (java.lang.Object)command);
            if (e instanceof NO_PERMISSION) {
                this.setAdminister(false);
                message = bundle.formatString("OlapServer.NoPermission.Command.fmt.txt", (java.lang.Object)command);
            }
            if (e instanceof COMM_FAILURE) {
                this.disconnect();
            }
            throw new OLAPException(message, e, 0);
        }
        finally {
            try {
                if (session != null && this.isConnected()) {
                    session.Close();
                }
            }
            catch (GenericError e) {
                throw new OLAPException(e.getLocalizedMessage(), e, 0);
            }
        }
    }

    public ConnectionInterface getConnection() {
        return this.connection;
    }

    public PasswordAuthentication getCredentials() {
        PasswordAuthentication credential = new PasswordAuthentication(this.userId, this.password.toCharArray());
        return credential;
    }

    public Metadata getCubeMetadataSet() throws OLAPException {
        if (!this.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        Metadata metadataSet = null;
        try {
            Object obj = this.connection.getObject();
            IMDXServer mdxServer = IMDXServerHelper.narrow((Object)obj);
            if (mdxServer != null) {
                metadataSet = new Metadata(mdxServer);
            }
        }
        catch (com.sas.storage.olap.OLAPException e) {
            throw new OLAPException(e.getLocalizedMessage(), e, 0);
        }
        return metadataSet;
    }

    public Metadata getSharedDimensionMetadataSet() throws OLAPException {
        if (!this.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        Metadata metadataSet = null;
        try {
            Object obj = this.connection.getObject();
            IMDXServer mdxServer = IMDXServerHelper.narrow((Object)obj);
            if (mdxServer != null) {
                metadataSet = new Metadata(mdxServer);
            }
        }
        catch (com.sas.storage.olap.OLAPException e) {
            throw new OLAPException(e.getLocalizedMessage(), e, 0);
        }
        return metadataSet;
    }

    public Map getCubes() throws OLAPException {
        HashMap cubeInfo = new HashMap();
        try {
            Object obj;
            IMDXAdmin_1_1 mdxAdmin1;
            if (this.isConnected() && this.isAdminister() && (mdxAdmin1 = IMDXAdmin_1_1Helper.narrow((Object)(obj = this.connection.getObject()))) != null) {
                StringSeqHolder cubeHolder = new StringSeqHolder();
                LongSeqHolder countHolder = new LongSeqHolder();
                BooleanSeqHolder enabledHolder = new BooleanSeqHolder();
                mdxAdmin1.ListCubes(cubeHolder, enabledHolder, countHolder);
                String[] listcubes = cubeHolder.value;
                boolean[] enabled = enabledHolder.value;
                int[] counts = countHolder.value;
                int size = listcubes.length;
                for (int i = 0; i < size; ++i) {
                    ArrayList<java.lang.Object> cube = new ArrayList<java.lang.Object>();
                    cube.add(0, listcubes[i]);
                    cube.add(1, enabled[i]);
                    cube.add(2, new Integer(counts[i]));
                    cubeInfo.put(listcubes[i], cube);
                }
            }
        }
        catch (Exception e) {
            String message = bundle.getString("OlapServer.GenericError.txt");
            if (e instanceof NO_PERMISSION) {
                this.setAdminister(false);
                message = bundle.getString("OlapServer.NoPermission.txt");
            }
            if (e instanceof COMM_FAILURE) {
                this.disconnect();
            }
            throw new OLAPException(message, e, 0);
        }
        return cubeInfo;
    }

    public String getHostName() throws OLAPException {
        String hostName = "";
        try {
            this.getServerComponent();
            if (this.serverComponent != null) {
                hostName = this.serverComponent.getAssociatedMachine().getName();
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return hostName;
    }

    private LogicalServer getLogicalServerFromOLAPSchema(OLAPSchema schema1) throws OLAPException {
        LogicalServer logicalOLAPServer = null;
        try {
            WorkspaceFile ws = Workspace.getWorkspace().getWorkspaceFile();
            String appserverId = ws.getPropertyString("AppServer.Default");
            this.serverContext = null;
            this.serverContexts = schema1.getDeployedComponents(true);
            if (this.serverContexts.size() == 1) {
                this.serverContext = (ServerContext)this.serverContexts.get(0);
            } else if (!ModelUtilities.isBlank(appserverId)) {
                int size = this.serverContexts.size();
                for (int i = 0; i < size && this.serverContext == null; ++i) {
                    DeployedComponent component = (DeployedComponent)this.serverContexts.get(i);
                    if (!component.getFQID().equals(appserverId)) continue;
                    this.serverContext = (ServerContext)component;
                }
            }
            if (this.serverContext != null) {
                logicalOLAPServer = this.getLogicalServerFromServerContext(this.serverContext);
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return logicalOLAPServer;
    }

    private LogicalServer getLogicalServerFromServerContext(ServerContext inputContext) throws OLAPException {
        LogicalServer logicalOLAPServer = null;
        try {
            if (inputContext != null) {
                AssociationList logicalServers = inputContext.getUsingComponents(true);
                int size = logicalServers.size();
                for (int i = 0; i < size && logicalOLAPServer == null; ++i) {
                    LogicalServer logicalServer1 = (LogicalServer)logicalServers.elementAt(i);
                    if (!logicalServer1.getClassIdentifier().equals(OLAP_CLASS_ID)) continue;
                    logicalOLAPServer = logicalServer1;
                }
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return logicalOLAPServer;
    }

    public CMetadata getMetadataObject() {
        return this.logicalServer;
    }

    public OLAPDataSet getOLAPDataSet(String query) throws OLAPException {
        if (!this.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        try {
            Object obj = this.connection.getObject();
            IMDXServer mdxServer = IMDXServerHelper.narrow((Object)obj);
            this.olapData = new OLAPDataSet((java.lang.Object)mdxServer, query);
        }
        catch (com.sas.storage.olap.OLAPException e) {
            throw new OLAPException(e.getLocalizedMessage(), e, 0);
        }
        return this.olapData;
    }

    public OLAPSchema getOLAPSchema() throws OLAPException {
        try {
            if (this.logicalServer != null) {
                AssociationList contexts;
                if (this.serverContext == null && (contexts = this.logicalServer.getUsedByComponents(true)).size() > 0) {
                    this.serverContext = (ServerContext)contexts.get(0);
                }
                if (this.serverContext != null) {
                    OLAPSchema newSchema = null;
                    AssociationList dataPackages = this.serverContext.getDataPackages(true);
                    int size = dataPackages.size();
                    for (int i = 0; i < size && newSchema == null; ++i) {
                        DeployedDataPackage dataPackage = (DeployedDataPackage)dataPackages.get(i);
                        if (!(dataPackage instanceof OLAPSchema)) continue;
                        newSchema = (OLAPSchema)dataPackage;
                    }
                    if (newSchema != null) {
                        this.schema = newSchema;
                    }
                }
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("OlapServer.GetContextError.txt"), e, 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return this.schema;
    }

    public int getPort() throws OLAPException {
        int portNumber = 0;
        try {
            AssociationList listOfSourceConnections;
            this.getServerComponent();
            if (this.serverComponent != null && !(listOfSourceConnections = this.serverComponent.getSourceConnections(true)).isEmpty()) {
                TCPIPConnection sourceConnection = (TCPIPConnection)listOfSourceConnections.get(0);
                portNumber = sourceConnection.getPort();
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return portNumber;
    }

    public ServerComponent getServerComponent() throws OLAPException {
        try {
            AssociationList components;
            if (this.logicalServer == null) {
                this.serverContext = this.promptForServerContext();
                this.logicalServer = this.getLogicalServerFromServerContext(this.serverContext);
            }
            if (this.logicalServer == null) {
                throw new OLAPException(bundle.getString("OlapServer.NoServerSelected.txt"), 0);
            }
            if (this.logicalServer != null && (components = this.logicalServer.getUsingComponents(true)).size() > 0) {
                this.serverComponent = (ServerComponent)components.elementAt(0);
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return this.serverComponent;
    }

    public AssociationList getServerContexts() {
        return this.serverContexts;
    }

    public Session[] getSessions() throws OLAPException {
        Session[] sessions = null;
        try {
            if (this.isConnected() && this.isAdminister()) {
                Object obj = this.connection.getObject();
                IMDXAdmin_1_1 mdxAdmin1 = IMDXAdmin_1_1Helper.narrow((Object)obj);
                IMDXAdmin mdxAdmin = IMDXAdminHelper.narrow((Object)obj);
                UUIDSeqHolder uid = new UUIDSeqHolder();
                StringSeqHolder s1 = new StringSeqHolder();
                StringSeqHolder s2 = new StringSeqHolder();
                StringSeqHolder s3 = new StringSeqHolder();
                LongSeqHolder l1 = new LongSeqHolder();
                LongSeqHolder l2 = new LongSeqHolder();
                LongSeqHolder l3 = new LongSeqHolder();
                StringSeqHolder s4 = new StringSeqHolder();
                String userFilter = "";
                String cubeFilter = "";
                if (mdxAdmin1 == null) {
                    mdxAdmin.ListMDXSessions(userFilter, uid, s1, s2, s3, l1, l2);
                } else {
                    mdxAdmin1.ListMDXSessions_2(userFilter, cubeFilter, uid, s1, s2, s3, l1, l2, l3, s4);
                }
                UUID[] sessionids = uid.value;
                String[] owners = s1.value;
                String[] names = s2.value;
                String[] descriptions = s3.value;
                int[] secondsInactive = l1.value;
                int[] openResults = l2.value;
                int numSessions = owners.length;
                int[] numActiveCubes = l3.value;
                String[] sessionCubes = s4.value;
                sessions = new Session[numSessions];
                int cubeCount = 0;
                for (int i = 0; i < numSessions; ++i) {
                    sessions[i] = new Session(this, sessionids[i], owners[i], names[i], descriptions[i], secondsInactive[i], openResults[i]);
                    String cubeString = "";
                    if (numActiveCubes.length > 0) {
                        for (int j = cubeCount; j < cubeCount + numActiveCubes[i]; ++j) {
                            if (!ModelUtilities.isBlank(cubeString)) {
                                cubeString = cubeString + ", ";
                            }
                            cubeString = cubeString + "[" + sessionCubes[j] + "]";
                        }
                        cubeCount += numActiveCubes[i];
                    }
                    sessions[i].setCubeNames(cubeString);
                }
            }
        }
        catch (Exception e) {
            String message = bundle.getString("OlapServer.GenericError.txt");
            if (e instanceof NO_PERMISSION) {
                this.setAdminister(false);
                message = bundle.getString("OlapServer.NoPermission.txt");
            }
            if (e instanceof COMM_FAILURE) {
                this.disconnect();
            }
            throw new OLAPException(message, e, 0);
        }
        return sessions;
    }

    public String getState() throws OLAPException {
        String state = "";
        if (this.isConnected()) {
            try {
                Object obj = this.connection.getObject();
                IServerInformation serverInfo = IServerInformationHelper.narrow((Object)obj);
                IFilteredList list = serverInfo.UseCategory("Information", "");
                AnySeqHolder attrs = new AnySeqHolder();
                list.GetAttribute("IOM.ServerState", "value", attrs);
                Any[] values = attrs.value;
                state = values[0].extract_string();
            }
            catch (Exception e) {
                if (e instanceof COMM_FAILURE) {
                    this.disconnect();
                }
                throw new OLAPException(bundle.getString("OlapServer.GenericError.txt"), e, 0);
            }
        } else {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        return state;
    }

    public String getVersion() throws OLAPException {
        String version = "";
        if (this.isConnected()) {
            try {
                Object obj = this.connection.getObject();
                java.lang.Object serverInfo = null;
                if (serverInfo != null) {
                    IFilteredList list = serverInfo.UseCategory("Information", "");
                    AnySeqHolder attrs = new AnySeqHolder();
                    list.GetAttribute("Server.Version", "value", attrs);
                    Any[] values = attrs.value;
                    version = values[0].extract_string();
                }
                StringSeqHolder s1 = new StringSeqHolder();
                IServerStatus s = IServerStatusHelper.narrow((Object)obj);
                s.ServerStatusGetInfo(s1);
                String[] info = s1.value;
                version = info[1];
            }
            catch (Exception e) {
                if (e instanceof COMM_FAILURE) {
                    this.disconnect();
                }
                throw new OLAPException(bundle.getString("OlapServer.GenericError.txt"), e, 0);
            }
        } else {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        return version;
    }

    public boolean isAdminister() {
        return this.administer;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public boolean isLoadBalanced() throws OLAPException {
        boolean isLoadBalanced = false;
        if (this.logicalServer != null) {
            try {
                java.lang.Object obj;
                AssociationList processes = this.logicalServer.getInitProcesses(true);
                if (processes != null && !processes.isEmpty() && (obj = processes.get(0)) != null && obj instanceof Transformation) {
                    Transformation transform = (Transformation)obj;
                    isLoadBalanced = "Load Balancing".equalsIgnoreCase(transform.getTransformRole());
                }
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("OlapServer.GenericError.txt"), e, 0);
            }
            catch (MdException e) {
                throw new OLAPException(bundle.getString("OlapServer.GenericError.txt"), e, 0);
            }
        }
        return isLoadBalanced;
    }

    public boolean isPaused() throws OLAPException {
        return this.getState().equals(PAUSED);
    }

    public boolean isRunning() throws OLAPException {
        return this.getState().equals(RUNNING);
    }

    public void pause() throws OLAPException {
        if (!this.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        try {
            Object obj = this.connection.getObject();
            IServerAdministration srvAdministration = IServerAdministrationHelper.narrow((Object)obj);
            srvAdministration.PauseServer();
        }
        catch (Exception e) {
            if (e instanceof COMM_FAILURE) {
                this.disconnect();
            }
            if (e instanceof NO_PERMISSION) {
                this.setAdminister(false);
                throw new OLAPException(bundle.getString("OlapServer.NoPermission.txt"), e, 0);
            }
            throw new OLAPException(bundle.getString("OlapServer.GenericError.txt"), e, 0);
        }
    }

    private ServerContext promptForServerContext() throws OLAPException {
        ServerContext context = null;
        if (!this.serverContexts.isEmpty()) {
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ChooseServer.Title.txt"), true);
            SelectServerPanel serverPanel = new SelectServerPanel();
            dialog.setMainPanel((WAPanel)serverPanel);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                context = serverPanel.getSelectedContext();
            }
            if (context == null) {
                throw new OLAPException(bundle.getString("OlapServer.NoServerSelected.txt"), 0);
            }
        } else {
            throw new OLAPException(bundle.getString("OlapServer.NoServersAvailable.txt"), 0);
        }
        return context;
    }

    public void quiesce() throws OLAPException {
        if (!this.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        try {
            Object obj = this.connection.getObject();
            IServerAdministration srvAdministration = IServerAdministrationHelper.narrow((Object)obj);
            srvAdministration.DeferredStopServer();
        }
        catch (Exception e) {
            if (e instanceof COMM_FAILURE) {
                this.disconnect();
            }
            if (e instanceof NO_PERMISSION) {
                this.setAdminister(false);
                throw new OLAPException(bundle.getString("OlapServer.NoPermission.txt"), e, 0);
            }
            throw new OLAPException(bundle.getString("OlapServer.GenericError.txt"), e, 0);
        }
    }

    public void refreshCube(String cubename) throws OLAPException {
        block15: {
            String message = bundle.getString("OlapServer.GenericError.txt");
            try (ConnectionInterface cx = null;){
                UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.logicalServer, null, null, "<Templates><LogicalServer Name=\"\" ClassIdentifier=\"\" UsageVersion=\"\"><ServiceTypes/><InitProcesses/><SoftwareTrees/><UsingComponents/><Properties/></LogicalServer><ServiceType Name=\"\"/><Transformation TransformRole=\"\"><TransformationSources/></Transformation><Tree TreeType=\"\"><Members/></Tree><ServerComponent Name=\"\" PublicType=\"\"><AssociatedMachine/><ServiceTypes/><SoftwareTrees/><SourceConnections/><Properties/></ServerComponent><Group><Members/><Properties/></Group><Login Password=\"\" UserID=\"\"><Domain/><AssociatedIdentity/></Login><AuthenticationDomain Name=\"\"/><Identity><Logins/></Identity><Person><Logins/></Person><IdentityGroup Name=\"\"><Logins/></IdentityGroup><Property PropertyName=\"\" DefaultValue=\"\"/><ServiceType Name=\"\"/><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" ApplicationProtocol=\"\" HostName=\"\" Port=\"\"><Properties/><Domain/></TCPIPConnection><Machine Name=\"\"><Implementors/></Machine><Implementor PublicType=\"\"><SourceConnections/></Implementor></Templates>", 12);
                java.lang.Object resolve = RemoteUtil.resolve((LogicalServer)this.logicalServer, null);
                if (!(resolve instanceof Cluster[])) break block15;
                Cluster[] clusterArr = (Cluster[])resolve;
                for (int i = 0; i < clusterArr.length; ++i) {
                    Cluster cluster = clusterArr[i];
                    Server[] serverArr = cluster.getServerArray();
                    int howManyFailed = 0;
                    for (int j = 0; j < serverArr.length; ++j) {
                        Server server = serverArr[j];
                        ManualConnectionFactoryConfiguration cxFactoryConfig = new ManualConnectionFactoryConfiguration(server, true);
                        PlatformConnectionFactoryManager cxFactoryManager = new PlatformConnectionFactoryManager();
                        PlatformConnectionFactoryInterface cxFactory = cxFactoryManager.getPlatformFactory((ConnectionFactoryConfiguration)cxFactoryConfig);
                        try {
                            cx = cxFactory.getConnection(userContext);
                        }
                        catch (ConnectionFactoryException e) {
                            if (cx != null) {
                                cx.close();
                            }
                            if (++howManyFailed != serverArr.length) continue;
                            throw new OLAPException(message, e, 0);
                        }
                        Object obj = cx.getObject();
                        String command = "REFRESH CUBE [" + cubename + "]";
                        IMDXServer mdxServer = IMDXServerHelper.narrow((Object)obj);
                        CommandFlag cFlag = CommandFlag.from_int((int)0);
                        ISession session = mdxServer.CreateSession(Locale.getDefault().toString());
                        session.MDXCommand(command, cFlag);
                        session.Close();
                        cx.close();
                        cx = null;
                    }
                }
            }
        }
    }

    public void resume() throws OLAPException {
        if (!this.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        try {
            Object obj = this.connection.getObject();
            IServerAdministration srvAdministration = IServerAdministrationHelper.narrow((Object)obj);
            srvAdministration.ContinueServer();
        }
        catch (Exception e) {
            if (e instanceof COMM_FAILURE) {
                this.disconnect();
            }
            if (e instanceof NO_PERMISSION) {
                this.setAdminister(false);
                throw new OLAPException(bundle.getString("OlapServer.NoPermission.txt"), e, 0);
            }
            throw new OLAPException(bundle.getString("OlapServer.GenericError.txt"), e, 0);
        }
    }

    public void setAdminister(boolean b) {
        this.administer = b;
    }

    public void stop() throws OLAPException {
        if (!this.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        try {
            Object obj = this.connection.getObject();
            IServerAdministration srvAdministration = IServerAdministrationHelper.narrow((Object)obj);
            srvAdministration.StopServer();
            this.connection = null;
            this.olapData = null;
        }
        catch (Exception e) {
            if (e instanceof COMM_FAILURE) {
                this.disconnect();
            }
            if (e instanceof NO_PERMISSION) {
                this.setAdminister(false);
                throw new OLAPException(bundle.getString("OlapServer.NoPermission.txt"), e, 0);
            }
            throw new OLAPException(bundle.getString("OlapServer.GenericError.txt"), e, 0);
        }
    }

    public void verifyMdx(String mdxString) throws OLAPException {
        if (!this.isConnected()) {
            throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
        }
        ISession session = null;
        try {
            Object obj = this.connection.getObject();
            IMDXServer mdxServer = IMDXServerHelper.narrow((Object)obj);
            if (mdxServer != null) {
                session = mdxServer.CreateSession(Locale.getDefault().toString());
                IntHolder numaxes = new IntHolder();
                session.MDXQuery(mdxString, numaxes);
            }
        }
        catch (Exception e) {
            if (e instanceof COMM_FAILURE) {
                this.disconnect();
            }
            throw new OLAPException(bundle.formatString("OlapServer.MdxVerifyError.fmt.txt", (java.lang.Object)mdxString), e, 0);
        }
        finally {
            try {
                if (session != null && this.isConnected()) {
                    session.Close();
                }
            }
            catch (GenericError e) {
                throw new OLAPException(e.getLocalizedMessage(), e, 0);
            }
        }
    }

    public void setMetadataObject(LogicalServer obj) throws OLAPException {
        this.logicalServer = obj;
        try {
            if (this.logicalServer != null) {
                this.serverContexts = this.logicalServer.getUsedByComponents();
                this.serverContext = this.serverContexts.size() > 0 ? (ServerContext)this.serverContexts.get(0) : null;
                AssociationList components = this.logicalServer.getUsingComponents(true);
                if (components.size() > 0) {
                    this.serverComponent = (ServerComponent)components.elementAt(0);
                }
                this.schema = this.getOLAPSchema();
            } else {
                this.serverContexts = null;
                this.serverContext = null;
                this.serverComponent = null;
                this.schema = null;
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    class SelectServerPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        private JList serverList;

        public SelectServerPanel() {
            this.layoutWidgets();
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            ModelUtilities.setLabelTextAndMnemonic(label, bundle.getString("SelectServer.label.txt"));
            this.serverList = new JList(new DefaultListModel());
            this.serverList.addFocusListener(new ServerListFocusAdapter());
            this.serverList.setSelectionMode(0);
            label.setLabelFor(this.serverList);
            this.add(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
            JScrollPane serverListPane = new JScrollPane(this.serverList);
            serverListPane.setPreferredSize(new Dimension(100, 150));
            this.add(serverListPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }

        public void moveDataToView() throws MdException, RemoteException {
            DefaultListModel model = (DefaultListModel)this.serverList.getModel();
            int size = OlapServer.this.serverContexts.size();
            for (int i = 0; i < size; ++i) {
                model.addElement(OlapServer.this.serverContexts.get(i));
            }
        }

        public void populateStore() throws MdException, RemoteException {
            this.setStorePopulated(true);
        }

        public boolean validateData() {
            boolean dataOK = false;
            if (this.serverList.isSelectionEmpty()) {
                MessageUtil.displayMessage((String)bundle.getString("SelectServer.ServerMustBeSelected.txt"), (int)0);
            } else {
                dataOK = true;
            }
            return dataOK;
        }

        public ServerContext getSelectedContext() {
            return (ServerContext)this.serverList.getSelectedValue();
        }

        class ServerListFocusAdapter
        implements FocusListener {
            ServerListFocusAdapter() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (SelectServerPanel.this.serverList.isSelectionEmpty()) {
                    SelectServerPanel.this.serverList.setSelectedIndex(0);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        }
    }
}

