/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OLAPTable
implements Comparable {
    static WAdminResource bundle = new WAdminResource(OLAPTable.class);
    public static String numeric = "N";
    private List allNumericColumns;
    OLAPList columns;
    private SASLibrary libraryObject;
    private int metadataUtilOptions = 12;
    boolean metadataRetrieved;
    String name;
    PhysicalTable table;
    private List tableAssociations = MetadataTemplate.getTableAssociations();
    TableSet tableSet;
    private String template = "<Templates></Templates>";
    private Boolean isLoadTable;

    OLAPTable() {
    }

    public int compareTo(Object obj) {
        int compareNum = this.toString().compareTo(obj.toString());
        return compareNum;
    }

    public boolean equals(PhysicalTable inputTable) {
        boolean returnEquals = true;
        if (inputTable == null) {
            returnEquals = false;
        } else {
            if (this.table == null && inputTable != null) {
                return false;
            }
            returnEquals = this.table.equals(inputTable);
        }
        return returnEquals;
    }

    public boolean equals(OLAPTable inputTable) {
        boolean returnEquals;
        boolean bl = returnEquals = this == inputTable;
        if (inputTable != null && this.table != null) {
            try {
                boolean bl2 = returnEquals = inputTable.isLoadTable() && this.isLoadTable();
                if (returnEquals) {
                    returnEquals = this.table.equals(inputTable.getTable());
                }
            }
            catch (OLAPException error) {
                returnEquals = false;
            }
        }
        if (!returnEquals && this.table != null && inputTable != null && !returnEquals) {
            returnEquals = this.table.equals(inputTable.getTable());
        }
        if (!returnEquals && inputTable != null && this.table == null && inputTable.getTable() == null) {
            try {
                boolean bl3 = returnEquals = this.isLoadTable() && inputTable.isLoadTable();
                if (returnEquals && this.table != null) {
                    returnEquals = this.table.equals(inputTable.getTable());
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return returnEquals;
    }

    StringBuffer generateCode(ServerContext context) throws OLAPException {
        SASLibrary sasLibrary = null;
        StringBuffer sasLibraryCode = new StringBuffer();
        if (this.table != null) {
            try {
                sasLibrary = LibraryUtil.getLibrary((DataTable)this.table, (ServerContext)context);
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
            List generatedLibnames = this.tableSet.getGeneratedLibnames();
            if (!generatedLibnames.contains(sasLibrary)) {
                try {
                    sasLibraryCode.append(ModelUtilities.trim(LibraryUtil.getAccessPath((SASLibrary)sasLibrary).toString().replaceAll("\n", ModelUtilities.newline)));
                    generatedLibnames.add(sasLibrary);
                }
                catch (MdException error) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        return sasLibraryCode;
    }

    public OLAPList getColumns() throws OLAPException {
        if (this.columns == null) {
            this.columns = new OLAPList(OLAPColumn.class);
        }
        if (this.columns.isEmpty() && this.table != null) {
            this.getMetadata();
            try {
                AssociationList columnObjects = this.table.getColumns(false);
                for (int i = columnObjects.size() - 1; i >= 0; --i) {
                    Column jomaColumn = (Column)columnObjects.get(i);
                    this.columns.add(new OLAPColumn(jomaColumn));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.columns;
    }

    Map getColumnMap(PhysicalTable inputTable) throws OLAPException {
        HashMap<String, Column> inputColumnMap = null;
        try {
            inputColumnMap = new HashMap<String, Column>();
            AssociationList inputColumns = inputTable.getColumns(true);
            for (int i = inputColumns.size() - 1; i >= 0; --i) {
                Column inputColumn = (Column)inputColumns.get(i);
                String inputColumnName = inputColumn.getSASColumnName().toUpperCase();
                inputColumnMap.put(inputColumnName, inputColumn);
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return inputColumnMap;
    }

    public OLAPColumn getColumn(String inputColumnName) throws OLAPException {
        if (this.columns == null) {
            this.getColumns();
        }
        OLAPColumn column = null;
        int i = this.columns.size() - 1;
        while (i >= 0 & column == null) {
            OLAPColumn tableColumn = (OLAPColumn)this.columns.get(i);
            if (tableColumn.getSASColumnName().equalsIgnoreCase(inputColumnName)) {
                column = tableColumn;
            }
            --i;
        }
        return column;
    }

    OLAPColumn getColumn(Column inputColumn) throws OLAPException {
        if (this.columns == null) {
            this.getColumns();
        }
        OLAPColumn column = null;
        int i = this.columns.size() - 1;
        while (i >= 0 & column == null) {
            OLAPColumn tableColumn = (OLAPColumn)this.columns.get(i);
            Column jomaColumn = tableColumn.metadataObject;
            if (jomaColumn.equals(inputColumn)) {
                column = tableColumn;
            }
            --i;
        }
        return column;
    }

    public List getAllNumericColumns() throws OLAPException {
        if (this.allNumericColumns == null) {
            this.allNumericColumns = new ArrayList();
        }
        if (this.allNumericColumns.isEmpty()) {
            this.getColumns();
            for (int i = this.columns.size() - 1; i >= 0; --i) {
                OLAPColumn column = (OLAPColumn)this.columns.get(i);
                if (!column.getSASColumnType().equals(numeric)) continue;
                this.allNumericColumns.add(column);
            }
            Collections.sort(this.allNumericColumns);
        }
        return Collections.unmodifiableList(this.allNumericColumns);
    }

    public String getSASTableName() {
        try {
            if (this.name == null & this.table != null) {
                this.name = this.table.getSASTableName();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.name;
    }

    public String getRepositoryShortFQID() {
        String id = "";
        try {
            id = this.table.getRepositoryID();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return id;
    }

    public String toString() {
        String name = "";
        try {
            name = this.table.getName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return name;
    }

    void getMetadata() throws OLAPException {
        try {
            if (!this.metadataRetrieved) {
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.table, null, this.tableAssociations, this.template, this.metadataUtilOptions);
                this.metadataRetrieved = true;
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public PhysicalTable getTable() {
        return this.table;
    }

    public boolean isLoadTable() throws OLAPException {
        if (this.isLoadTable == null) {
            boolean tempIsLoadTable;
            LoadTable loadTable = this.tableSet.getLoadTable();
            boolean bl = tempIsLoadTable = this == loadTable;
            if (!tempIsLoadTable) {
                PhysicalTable physicalTable = loadTable.getTable();
                tempIsLoadTable = this.table != null && physicalTable != null && this.table == physicalTable;
            }
            this.isLoadTable = tempIsLoadTable;
        }
        return this.isLoadTable;
    }

    public boolean isSimilar(PhysicalTable inputTable) throws OLAPException {
        boolean similar = this.equals(inputTable);
        if (!similar) {
            Map inputColumnMap = this.getColumnMap(inputTable);
            similar = true;
            for (int i = this.getColumns().size() - 1; i >= 0 && similar; --i) {
                OLAPColumn olapColumn = (OLAPColumn)this.columns.get(i);
                String olapColumnName = olapColumn.getSASColumnName().toUpperCase();
                Column column = (Column)inputColumnMap.get(olapColumnName);
                similar = column != null;
            }
        }
        return similar;
    }

    public SASLibrary getSASLibrary() throws OLAPException {
        try {
            if (this.libraryObject == null && this.table != null) {
                this.libraryObject = LibraryUtil.getLibrary((DataTable)this.table, null);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return this.libraryObject;
    }

    void reset(PhysicalTable inputTable, boolean similar) throws OLAPException {
        this.table = inputTable;
        try {
            this.name = inputTable.getSASTableName();
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        this.libraryObject = null;
        if (this.columns != null) {
            if (!similar) {
                this.columns.clear();
                this.getColumns();
            } else {
                this.resetColumns(this.getColumnMap(inputTable));
            }
        }
        if (this.allNumericColumns != null) {
            this.allNumericColumns.clear();
            this.getAllNumericColumns();
        }
    }

    private void resetColumns(Map inputTableMap) throws OLAPException {
        Collection tempColumns = inputTableMap.values();
        if (this.columns == null) {
            this.columns = new OLAPList(OLAPColumn.class);
            this.columns.setModifiable(false);
        }
        for (int i = this.columns.size() - 1; i >= 0; --i) {
            OLAPColumn olapColumn = (OLAPColumn)this.columns.get(i);
            String olapColumnName = olapColumn.getSASColumnName().toUpperCase();
            Column jomaColumn = (Column)inputTableMap.get(olapColumnName);
            if (jomaColumn == null) {
                this.columns.getTheList().remove(i);
                continue;
            }
            olapColumn.setColumn(jomaColumn);
            tempColumns.remove(jomaColumn);
        }
        for (Column jomaColumn : tempColumns) {
            this.columns.getTheList().add(new OLAPColumn(jomaColumn));
        }
    }

    void setLoadTable(boolean inputIsLoadTable) {
        this.isLoadTable = inputIsLoadTable;
    }

    void setMapToTable(PhysicalTable inputTable, Map inputColumns) throws OLAPException {
        this.resetColumns(inputColumns);
        this.table = inputTable;
        try {
            this.name = inputTable.getSASTableName();
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        this.libraryObject = null;
        if (this.allNumericColumns != null) {
            this.allNumericColumns.clear();
            this.getAllNumericColumns();
        }
    }

    void setMetadataUtilOptions(int inputOptions) {
        this.metadataRetrieved = false;
        this.metadataUtilOptions = inputOptions;
    }

    public void setSASLibrary() throws OLAPException {
        this.getSASLibrary();
    }

    void setTableAssociations(List inputTableAssociations) {
        this.metadataRetrieved = false;
        this.tableAssociations = inputTableAssociations;
    }

    void setTemplate(String inputTemplate) {
        this.metadataRetrieved = false;
        this.template = inputTemplate;
    }
}

