/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CalculatedMember;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.TableCollection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OLAPSharedDimension
extends OLAPDimension {
    static WAdminResource bundle = new WAdminResource(OLAPSharedDimension.class);
    public static final int NO_ERROR = -1;
    public static final int ERROR_MISSING_TABLE = 1;
    public static final int ERROR_MISSING_TABLE_LIBRARY = 2;
    public static final int WARNING_OLAPSHARED_DIMENSION = 3;
    public static final int SEVERE_METADATA_EXCEPTION = 4;
    public static final String USE_DIMENSION = "   USE_DIMENSION ";
    public static final String PATH = "      PATH             = '";
    public static final String SHARED = "      SHARED              ";
    public static final String SHARED_DIMENSION = "DIMENSION";
    private static final String RUN = "RUN;";
    private static final String DIMGENFOLDER = "DimensionGenfolder";
    private static final String FACTKEYDIMENSION = "FactKeyDimension";
    private final int maximumDimensionsHierarchiesPerCube = 128;
    private final int maximumLevelsPerCube = 256;
    static final String STARDIM = "STARDIM";
    static final String OLAP_PATH = "OLAPPath";
    private boolean addData;
    MdObjectStore objectStore;
    int errorLevel;
    boolean errorLevelChecked;
    StringBuffer sharedDimVerifyMessage;
    LanguageSet languageSet;
    OLAPSchema schema;
    Tree folder;
    String path;
    OLAPSchema originalSchema;
    String originalName;
    Tree originalFolder;
    SharedDimensionTable inputSharedTable;
    private boolean resetDimensionTableTranslations;
    private boolean resetSASCode;
    private boolean resetRaggedHierarchyOptions;
    private Map displayHierarchies;
    private Map mappedLevels;
    private Column newDimensionKey;
    private OLAPColumn unMappedDimensionKey;
    private String sasCode;
    private List unMappedMessage;
    private OLAPList unMappedLevels;
    protected Option collation;
    protected Option locale;
    protected boolean deleteCollation;
    protected boolean deleteLocale;
    protected boolean deleteDimensionKey;
    private List dimMessage;
    private boolean wasDeleted;
    private boolean metadataCreated;

    public OLAPSharedDimension(MdObjectStore inStore) throws OLAPException {
        this.objectStore = inStore;
        this.setUpSets(null);
        this.errorLevel = -1;
        this.owningSharedDimension = this;
        this.onlyShared = true;
        this.shared = true;
    }

    public OLAPSharedDimension(MdObjectStore inStore, OLAPCube cube) throws OLAPException {
        this.objectStore = inStore;
        this.setUpSets(cube);
        this.errorLevel = -1;
        this.shared = true;
    }

    public OLAPSharedDimension(SharedDimension metadataDimension) throws OLAPException {
        try {
            this.metadataObject = metadataDimension;
            this.objectStore = (MdObjectStore)this.metadataObject.getObjectStore();
            this.setUpSets(null);
            this.owningSharedDimension = this;
            this.onlyShared = true;
            this.shared = true;
            this.errorLevel = -1;
            this.readDimension();
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    public OLAPSharedDimension(SharedDimension metadataDimension, OLAPCube cube) throws OLAPException {
        try {
            this.metadataObject = metadataDimension;
            this.objectStore = (MdObjectStore)this.metadataObject.getObjectStore();
            this.setUpSets(cube);
            this.errorLevel = -1;
            this.shared = true;
            this.readDimension();
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    @Override
    OLAPLevel createOLAPLevel(Level inputMetadataObject) throws OLAPException {
        String levelEmptyChar;
        OLAPLevel olapLevel = new OLAPLevel(inputMetadataObject);
        olapLevel.setDimensionSet(this.getDimensionSet());
        olapLevel.setDimension(this);
        olapLevel.setOptionSet(this.getOptionSet());
        olapLevel.setOwningSharedDimension(this);
        String levelIgnoreEmpty = olapLevel.getIgnoreEmpty();
        if (levelIgnoreEmpty != null) {
            olapLevel.setUpChanges("setIgnoreEmpty", String.class, levelIgnoreEmpty);
        }
        if ((levelEmptyChar = olapLevel.getEmpty()) != null) {
            olapLevel.setUpChanges("setEmpty", String.class, levelEmptyChar);
        }
        olapLevel.apply();
        return olapLevel;
    }

    @Override
    public OLAPLevel createOLAPLevel(OLAPColumn column) throws OLAPException {
        String levelName;
        OLAPLevel olapLevel = new OLAPLevel(column);
        this.aggregationSet = this.getAggregationSet();
        olapLevel.setDimensionSet(this.getDimensionSet());
        olapLevel.setDimension(this);
        olapLevel.setOwningSharedDimension(this);
        olapLevel.setOptionSet(this.getOptionSet());
        olapLevel.name = levelName = this.getUniqueLevelName(olapLevel.getColumn().getSASColumnName());
        olapLevel.changedName = true;
        this.getLevels().add(olapLevel);
        return olapLevel;
    }

    @Override
    public OLAPLevel createOLAPSuppliedTimeLevel(OLAPColumn column, String suppliedLevelName) throws OLAPException {
        this.verifyMaximumLevelsPerCube();
        OLAPLevel olapLevel = new OLAPLevel(column);
        olapLevel.setDimensionSet(this.getDimensionSet());
        this.aggregationSet = this.getAggregationSet();
        olapLevel.setDimension(this);
        olapLevel.setOptionSet(this.getOptionSet());
        String levelName = this.getUniqueLevelName(suppliedLevelName);
        olapLevel.setOwningSharedDimension(this);
        olapLevel.name = levelName;
        olapLevel.changedName = true;
        this.getLevels().add(olapLevel);
        return olapLevel;
    }

    @Override
    OLAPHierarchy createOLAPHierarchy(Hierarchy inputMetadataObject) {
        OLAPHierarchy olapHierarchy = new OLAPHierarchy(inputMetadataObject);
        olapHierarchy.setOwningSharedDimension(this);
        olapHierarchy.setDimension(this);
        olapHierarchy.setDimensionSet(this.getDimensionSet());
        olapHierarchy.setOptionSet(this.getOptionSet());
        return olapHierarchy;
    }

    public boolean canActionBePerformed() throws OLAPException {
        int numberOfCubesCanSee;
        int totalNumberOfCubes = ModelUtilities.isSharedDimensionContainCubes(this);
        return totalNumberOfCubes == (numberOfCubesCanSee = this.getNumberOfCubesUserCanSee());
    }

    void clearVerifyMessage() {
        this.errorLevelChecked = true;
        this.sharedDimVerifyMessage = null;
    }

    @Override
    public OLAPHierarchy createOLAPHierarchy() throws OLAPException {
        OLAPHierarchy olapHierarchy = new OLAPHierarchy();
        olapHierarchy.setOwningSharedDimension(this);
        olapHierarchy.setDimension(this);
        olapHierarchy.setDimensionSet(this.getDimensionSet());
        olapHierarchy.setOptionSet(this.getOptionSet());
        this.dimensionSet.getHierarchies().getTheList().add(olapHierarchy);
        int numberOfHierarchies = this.getHierarchies().size();
        if (numberOfHierarchies < 0) {
            olapHierarchy.setName(this.getName());
        }
        olapHierarchy.setName(this.getUniqueHierarchyName(this.getName()));
        this.getHierarchies().add(olapHierarchy);
        return olapHierarchy;
    }

    public OLAPSchema getAssociatedOLAPSchema() throws OLAPException {
        if (this.schema == null && this.metadataObject != null) {
            SharedDimension jomaDim = (SharedDimension)this.metadataObject;
            try {
                OLAPSchema tempSchema = jomaDim.getAssociatedOLAPSchema();
                if (tempSchema != null) {
                    this.schema = ModelUtilities.getOLAPSchema(tempSchema.getName(), this.getObjectStore());
                }
            }
            catch (MdException oError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), oError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.schema;
    }

    public String getCollation() throws OLAPException {
        String returnOption = null;
        if (this.optionSet == null) {
            this.getOptionSet();
        }
        if (this.collation == null && this.metadataObject != null && !this.deleteCollation) {
            this.collation = this.optionSet.getOption(this, "Collation", "OLAP Linguistic");
        }
        if (this.collation != null) {
            this.collation.setPropertyOption(true);
            this.collation.setPropertySetOption(true);
            returnOption = this.collation.getDefaultValue();
        }
        return returnOption;
    }

    @Override
    public OLAPColumn getDimensionKey() throws OLAPException {
        this.getSharedDimensionTable();
        if (this.inputSharedTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Cannot get the dimension key without a dimension table.");
            }
            throw new IllegalStateException("Illegal use of the getDimensionKey method was encountered.");
        }
        if (!this.inputSharedTable.metadataRetrieved) {
            this.inputSharedTable.getMetadata();
        }
        if (this.dimensionKey == null && this.metadataObject != null && !this.deleteDimensionKey) {
            SharedDimension dimensionObject = (SharedDimension)this.metadataObject;
            try {
                CustomAssociation custom = null;
                AssociationList customs = dimensionObject.getCustomAssociations();
                if (!customs.isEmpty()) {
                    int i = 0;
                    int size = customs.size();
                    while (i < size & custom == null) {
                        CustomAssociation nextCustom;
                        CMetadata object = (CMetadata)customs.elementAt(i);
                        if (object.getCMetadataType().equalsIgnoreCase("CustomAssociation") && (nextCustom = (CustomAssociation)object).getPartnerName().equals("DimKeyDimension")) {
                            custom = nextCustom;
                        }
                        ++i;
                    }
                    AssociationList associatedObjects = custom.getAssociatedObjects();
                    int t = 0;
                    int aosize = associatedObjects.size();
                    while (t < aosize & this.dimensionKey == null) {
                        CMetadata column = (CMetadata)associatedObjects.elementAt(t);
                        if (column.getCMetadataType().equalsIgnoreCase("Column")) {
                            this.dimensionKey = this.inputSharedTable.getColumn((Column)column);
                        }
                        ++t;
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.dimensionKey;
    }

    public OLAPColumn getSharedDimensionFactKey(OLAPCube cube) throws OLAPException {
        if (this.factKey == null && this.metadataObject != null) {
            SharedDimension dimensionObject = (SharedDimension)this.metadataObject;
            try {
                AssociationList listOfCustomAss = dimensionObject.getReferencedObjects();
                int size = listOfCustomAss.size();
                for (int i = 0; i < size; ++i) {
                    String nameOfJomaCube;
                    CustomAssociation customAss = (CustomAssociation)listOfCustomAss.get(i);
                    String partnerName = customAss.getPartnerName();
                    if (!partnerName.equalsIgnoreCase(FACTKEYDIMENSION)) continue;
                    Root jomaCube = customAss.getOwningObject();
                    String nameOfCube = cube.getName();
                    if (!nameOfCube.equalsIgnoreCase(nameOfJomaCube = jomaCube.getName())) continue;
                    AssociationList listOfAssObjects = customAss.getAssociatedObjects();
                    int sizeList = listOfAssObjects.size();
                    for (int t = 0; t < sizeList; ++t) {
                        CMetadata object = (CMetadata)listOfAssObjects.get(t);
                        if (!(object instanceof Column)) continue;
                        this.factKey = this.tableSet.getLoadTable().getColumn((Column)object);
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.factKey;
    }

    @Override
    public DimensionSet getDimensionSet() {
        if (this.dimensionSet == null) {
            this.dimensionSet = new DimensionSet();
        }
        return this.dimensionSet;
    }

    public boolean getUpdateMetadataStatus() {
        return this.metadataCreated;
    }

    public String getDimFolder() {
        String returnValue = "";
        try {
            AssociationList properties = this.metadataObject.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                Property prop = (Property)properties.get(i);
                String propName = prop.getPropertyName();
                if (!propName.equalsIgnoreCase("DIMFOLDER")) continue;
                returnValue = prop.getDefaultValue();
            }
        }
        catch (RemoteException e) {
            returnValue = "";
        }
        catch (MdException e) {
            returnValue = "";
        }
        return returnValue;
    }

    @Override
    public PhysicalTable getAddDataTable() throws OLAPException {
        SharedDimensionTable dimTable;
        if (this.addDataTable == null && (dimTable = this.getSharedDimensionTable()) != null) {
            this.addDataTable = dimTable.getTable();
            this.setAddDataTableName(ModelUtilities.generateTableName(this.addDataTable));
        }
        return this.addDataTable;
    }

    public AggregationSet getAggregationSet() {
        return this.aggregationSet;
    }

    Directory getDirectory(String directoryName) throws MdException, RemoteException, OLAPException {
        Directory directory = (Directory)MetadataTemplate.createMetadata(this.getObjectStore(), "Directory", this.getRepositoryShortFQID());
        directory.setDirectoryName(directoryName);
        directory.setIsRelative(0);
        directory.setName(directoryName);
        directory.setDirectoryRole(OLAP_PATH);
        return directory;
    }

    public OLAPMemberPropertySet getOLAPMemberPropertySet() {
        if (this.propertySet == null) {
            this.propertySet = new OLAPMemberPropertySet(this);
        }
        return this.propertySet;
    }

    public int getErrorLevel() {
        this.errorLevelChecked = true;
        return this.errorLevel;
    }

    public Tree getFolder() throws OLAPException {
        if (this.folder == null) {
            AssociationList trees = null;
            if (!this.isNewObject()) {
                try {
                    SharedDimension dimension = (SharedDimension)this.metadataObject;
                    trees = dimension.getTrees();
                    if (!trees.isEmpty()) {
                        this.folder = (Tree)trees.get(0);
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
            }
            if (this.folder == null) {
                this.folder = ModelUtilities.getDefaultFolder(this.objectStore);
            }
            if (this.folder == null) {
                this.getAssociatedOLAPSchema();
                if (this.schema != null) {
                    this.folder = ModelUtilities.getDefaultFolder(this.schema, this.objectStore);
                }
            }
        }
        if (this.folder != null) {
            try {
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.folder, null, null, "", 8);
            }
            catch (MdException e) {
                this.folder = null;
            }
            catch (RemoteException e) {
                this.folder = null;
            }
        }
        return this.folder;
    }

    public StringBuffer getVerifyMessage() {
        if (this.sharedDimVerifyMessage == null) {
            this.sharedDimVerifyMessage = new StringBuffer();
        }
        this.errorLevelChecked = true;
        return this.sharedDimVerifyMessage;
    }

    public OptionSet getOptionSet() {
        if (this.optionSet == null) {
            this.optionSet = new OptionSet(this);
        }
        return this.optionSet;
    }

    @Override
    public String getRepositoryShortFQID() throws OLAPException {
        this.verifyDeleted();
        String repositoryShortFQID = "";
        try {
            Tree folder = this.getFolder();
            if (folder != null) {
                repositoryShortFQID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getProjectRepositoryId() : ModelUtilities.getRepositoryFQID(folder).substring(9, 17);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return repositoryShortFQID;
    }

    Tree getOriginalFolder() throws OLAPException {
        if (this.originalFolder == null && this.metadataObject != null) {
            try {
                SharedDimension dimension = (SharedDimension)this.metadataObject;
                AssociationList trees = dimension.getTrees();
                if (!trees.isEmpty()) {
                    this.originalFolder = (Tree)trees.get(0);
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.originalFolder;
    }

    public MdObjectStore getObjectStore() {
        return this.objectStore;
    }

    private OLAPSchema getOriginalSchema() {
        OLAPSchema tempSchema = this.originalSchema;
        if (tempSchema == null) {
            tempSchema = this.schema;
        }
        return tempSchema;
    }

    public String getPath() throws OLAPException {
        try {
            SharedDimension jomaDim;
            Directory file;
            if (this.path == null && !this.isNewObject() && (file = (jomaDim = (SharedDimension)this.metadataObject).getAssociatedDirectory()) != null) {
                this.path = file.getDirectoryName();
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return this.path;
    }

    public LanguageSet getLanguageSet() throws OLAPException {
        if (this.languageSet == null) {
            this.languageSet = new LanguageSet(this);
        }
        return this.languageSet;
    }

    @Override
    public OLAPList getLevels() throws OLAPException {
        if (this.levels == null) {
            if (this.onlyShared) {
                this.dimensionSet.getLevels(this);
            } else {
                this.dimensionSet.getLevels();
            }
        }
        return this.levels;
    }

    @Override
    public OLAPList getHierarchies() throws OLAPException {
        if (this.hierarchies == null) {
            if (this.onlyShared) {
                this.dimensionSet.getHierarchies(this);
            } else {
                this.dimensionSet.getHierarchies();
            }
        }
        return this.hierarchies;
    }

    public String getLocale() throws OLAPException {
        String returnOption = null;
        if (this.optionSet == null) {
            this.getOptionSet();
        }
        if (this.locale == null && this.metadataObject != null && !this.deleteLocale) {
            this.locale = this.optionSet.getOption(this, "Locale", "OLAP Linguistic");
        }
        if (this.locale != null) {
            this.locale.setPropertyOption(true);
            this.locale.setPropertySetOption(true);
            returnOption = this.locale.getDefaultValue();
        }
        return returnOption;
    }

    public Map getDisplayHierarchies() throws OLAPException {
        if (this.displayHierarchies == null) {
            this.displayHierarchies = new HashMap();
        }
        if (this.metadataObject != null) {
            SharedDimension dimensionObject = (SharedDimension)this.metadataObject;
            AssociationList dimensionHierarchies = null;
            try {
                dimensionHierarchies = dimensionObject.getHierarchies();
                int size = dimensionHierarchies.size();
                for (int t = 0; t < size; ++t) {
                    Hierarchy jomaHierarchy = (Hierarchy)dimensionHierarchies.elementAt(t);
                    ArrayList<String> listOfLevels = new ArrayList<String>();
                    this.displayHierarchies.put(jomaHierarchy.getName(), listOfLevels);
                    AssociationList listOfJomaLevels = jomaHierarchy.getLevels();
                    int levelSize = listOfJomaLevels.size();
                    for (int i = 0; i < levelSize; ++i) {
                        Level jomaLevel = (Level)listOfJomaLevels.get(i);
                        listOfLevels.add(jomaLevel.getName());
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.displayHierarchies;
    }

    public TableSet getTableSet() {
        if (this.tableSet == null) {
            this.tableSet = new TableSet(this);
        }
        return this.tableSet;
    }

    public SharedDimensionTable getSharedDimensionTable() throws OLAPException {
        if (this.inputSharedTable == null && this.metadataObject != null) {
            SharedDimension jomaSharedDimension = (SharedDimension)this.metadataObject;
            try {
                PhysicalTable table = null;
                AssociationList classifierMapList = jomaSharedDimension.getTargetTransformations();
                if (!classifierMapList.isEmpty()) {
                    AssociationList sources;
                    ClassifierMap classiferMap = (ClassifierMap)classifierMapList.get(0);
                    if (classiferMap.getTransformRole().contains(STARDIM) && !(sources = classiferMap.getTransformationSources()).isEmpty()) {
                        table = (PhysicalTable)sources.get(0);
                        this.inputSharedTable = this.tableSet.getSharedDimensionTable(table);
                    }
                    if (this.inputSharedTable == null && !this.isNewObject()) {
                        this.inputSharedTable = new SharedDimensionTable(this.getTableSet(), null);
                    }
                }
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.inputSharedTable;
    }

    public String getSASCode() throws OLAPException {
        if (this.sasCode == null && this.metadataObject != null) {
            TextStore storedSASCode = null;
            try {
                SharedDimension sharedDim = (SharedDimension)this.metadataObject;
                AssociationList dimNotes = sharedDim.getNotes();
                boolean found = false;
                int i = dimNotes.size() - 1;
                while (i >= 0 & !found) {
                    TextStore note = (TextStore)dimNotes.elementAt(i);
                    if (note.getName().equals("OLAPSASCode")) {
                        storedSASCode = note;
                        found = true;
                    }
                    --i;
                }
                if (storedSASCode != null) {
                    this.sasCode = storedSASCode.getStoredText();
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        if (this.sasCode == null) {
            this.sasCode = "";
        }
        return this.sasCode;
    }

    @Override
    public String getTableOptions() throws OLAPException {
        String returnValue = "";
        if (this.tableOptions == null & this.metadataObject != null & !this.deleteTableOptions) {
            this.tableOptions = this.optionSet.getOption(this, "DimensionTable_options", "OLAP Table Options");
        }
        if (this.tableOptions != null) {
            returnValue = this.tableOptions.getDefaultValue();
        }
        return returnValue;
    }

    @Override
    public String getUniqueName() {
        String uniqueName = null;
        try {
            if (this.metadataObject != null) {
                SharedDimension jomaDimension = (SharedDimension)this.metadataObject;
                uniqueName = jomaDimension.getUniqueName();
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return uniqueName;
    }

    @Override
    public String getUniqueHierarchyName(String currentName) throws OLAPException {
        OLAPList listOfHierarchies = this.getHierarchies();
        boolean found = false;
        int count = 0;
        String currentNameCompare = currentName.toUpperCase();
        Pattern id = Pattern.compile("_[0-9]+");
        Matcher matchId = id.matcher(currentNameCompare);
        currentNameCompare = matchId.replaceAll("");
        int size = listOfHierarchies.size();
        for (int i = 0; i < size; ++i) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)listOfHierarchies.get(i);
            String nameCompare = hierarchy.getName().toUpperCase();
            if (nameCompare.indexOf(currentNameCompare) != 0) continue;
            ++count;
        }
        int lengthOfCompare = currentNameCompare.length();
        String newName = currentName.substring(0, lengthOfCompare);
        int countIncremented = count;
        do {
            String newNameConcat = newName + "_" + count;
            countIncremented = count;
            int size2 = listOfHierarchies.size();
            for (int i = 0; i < size2 && count == countIncremented; ++i) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)listOfHierarchies.get(i);
                String nextName = hierarchy.getName();
                if (!nextName.equalsIgnoreCase(newNameConcat)) continue;
                ++count;
            }
            if (count != countIncremented) continue;
            found = true;
        } while (!found);
        if (count > 0) {
            return newName + "_" + count;
        }
        return currentName;
    }

    @Override
    ClassifierMap getMapClassifierMap() throws OLAPException {
        if (this.mapInfoClassifierMap == null & this.metadataObject != null) {
            try {
                SharedDimension jomaDimension = (SharedDimension)this.metadataObject;
                AssociationList classifierMaps = jomaDimension.getTargetClassifierMaps();
                if (classifierMaps.isEmpty()) {
                    classifierMaps = jomaDimension.getTargetTransformations(false);
                }
                if (!classifierMaps.isEmpty()) {
                    for (int i = classifierMaps.size() - 1; i >= 0 && this.mapInfoClassifierMap == null; --i) {
                        Object temp = classifierMaps.elementAt(i);
                        if (temp instanceof ClassifierMap) {
                            this.mapInfoClassifierMap = (ClassifierMap)temp;
                            String transformRole = this.mapInfoClassifierMap.getTransformRole();
                            if (ModelUtilities.trim(transformRole).equalsIgnoreCase("ESRI Map File")) continue;
                            this.mapInfoClassifierMap = null;
                            continue;
                        }
                        this.mapInfoClassifierMap = null;
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 0);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
            }
        }
        return this.mapInfoClassifierMap;
    }

    public Column getMappedLevel(OLAPLevel inputLevel) {
        Column mappedColumn = null;
        if (this.mappedLevels != null && inputLevel != null) {
            mappedColumn = (Column)this.mappedLevels.get(inputLevel);
        }
        return mappedColumn;
    }

    public StringBuffer generateCodeCreate() throws OLAPException {
        StringBuffer codeCreate = new StringBuffer();
        if (this.metadataObject != null) {
            codeCreate.append(this.generateCodeShortForm(true, false, true));
        }
        return codeCreate;
    }

    private StringBuffer generateCodeShortForm(boolean inputGenerateLoadTableLibrefs, boolean saveProcCode, boolean initializeCodeGen) throws OLAPException {
        int flags = 0;
        flags = ModelUtilities.setCodegenFlag(flags, 1, inputGenerateLoadTableLibrefs);
        flags = ModelUtilities.setCodegenFlag(flags, 4, initializeCodeGen);
        flags = ModelUtilities.setCodegenFlag(flags, 8, initializeCodeGen);
        flags = ModelUtilities.setCodegenFlag(flags, 2, saveProcCode);
        return this.generateCodeShortForm(flags);
    }

    public StringBuffer generateCodeShortForm(int codegenFlags) throws OLAPException {
        StringBuffer shortForm = new StringBuffer();
        boolean saveProcCode = ModelUtilities.getCodegenFlag(codegenFlags, 2);
        this.genLibnames(codegenFlags, shortForm);
        shortForm.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        shortForm.append(this.generateCodeSasCode());
        shortForm.append(ModelUtilities.newline).append(ModelUtilities.newline);
        shortForm.append("PROC OLAP").append(ModelUtilities.getReconnectionString()).append(";").append(ModelUtilities.newline);
        shortForm.append(this.generateCodeMetasrvStatement(this.getAssociatedOLAPSchema(), saveProcCode));
        shortForm.append(ModelUtilities.newline);
        shortForm.append(this.generateCodeProcOlapEquals(this.getFolder(), false)).append(ModelUtilities.newline);
        shortForm.append(";");
        shortForm.append(this.generateCodeRunStatement());
        return shortForm;
    }

    public StringBuffer generateCodeReorganizeAll() throws OLAPException {
        StringBuffer proc = new StringBuffer();
        proc.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        proc.append("PROC OLAP").append(ModelUtilities.getReconnectionString());
        proc.append(ModelUtilities.newline).append("   REORGANIZE_LEVELS ");
        proc.append(";").append(ModelUtilities.newline);
        proc.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), false));
        proc.append(this.generateCodeProcOlapEquals(this.getFolder(), false));
        proc.append(";").append(ModelUtilities.newline);
        proc.append(this.generateCodeRunStatement());
        return proc;
    }

    public StringBuffer generateCodeReorganizeLevels(List levels) throws RemoteException, OLAPException, MdException {
        StringBuffer proc = new StringBuffer();
        proc.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        proc.append("PROC OLAP").append(ModelUtilities.getReconnectionString());
        proc.append(";").append(ModelUtilities.newline);
        proc.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), false));
        proc.append(this.generateCodeProcOlapEquals(this.getFolder(), false));
        proc.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        for (int i = 0; i < levels.size(); ++i) {
            OLAPLevel level = (OLAPLevel)levels.get(i);
            String name = level.getName();
            proc.append("   REORGANIZE_LEVEL ").append(name).append(";");
            proc.append(ModelUtilities.newline);
        }
        proc.append(this.generateCodeRunStatement());
        return proc;
    }

    public StringBuffer generateCodeUpdateDisplayNames(HashMap newCaptions, HashMap newDesc, HashMap memberChanges) throws OLAPException {
        StringBuffer proc = new StringBuffer();
        proc.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        proc.append("PROC OLAP");
        proc.append("   UPDATE_DISPLAY_NAMES");
        proc.append(";");
        proc.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        proc.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), false));
        proc.append("   DIMENSION ").append(ModelUtilities.getSasName(this.getName()).append("   SHARED "));
        if (newCaptions.containsKey(this) || newDesc.containsKey(this)) {
            this.generateCaptionChanges(newCaptions, newDesc, proc, this);
        }
        proc.append(";").append(ModelUtilities.newline);
        OLAPList hierarchies = this.getHierarchies();
        for (int hierNum = 0; hierNum < hierarchies.size(); ++hierNum) {
            OLAPHierarchy hier = (OLAPHierarchy)hierarchies.get(hierNum);
            if (!newCaptions.containsKey(hier) && !newDesc.containsKey(hier) && !memberChanges.containsKey(hier)) continue;
            proc.append("   HIERARCHY ").append(ModelUtilities.getSasName(hier.getName()));
            if (memberChanges.containsKey(hier)) {
                proc.append("     DEFAULT_MEMBER = ");
                String member = (String)memberChanges.get(hier);
                String memberQuoted = Strings.quoteForSAS((String)member);
                proc.append(memberQuoted).append(ModelUtilities.newline);
            }
            this.generateCaptionChanges(newCaptions, newDesc, proc, hier);
            proc.append(";").append(ModelUtilities.newline);
        }
        OLAPList levels = this.getLevels();
        for (int levNum = 0; levNum < levels.size(); ++levNum) {
            OLAPLevel level = (OLAPLevel)levels.get(levNum);
            if (newCaptions.containsKey(level) || newDesc.containsKey(level)) {
                proc.append("   LEVEL ").append(ModelUtilities.getSasName(level.getName()));
                this.generateCaptionChanges(newCaptions, newDesc, proc, level);
                proc.append(";").append(ModelUtilities.newline);
            }
            OLAPList properties = level.getOLAPProperties();
            for (int propNum = 0; propNum < properties.size(); ++propNum) {
                OLAPMemberProperty property = (OLAPMemberProperty)properties.get(propNum);
                if (!newCaptions.containsKey(property) && !newDesc.containsKey(property)) continue;
                proc.append("   PROPERTY ").append(ModelUtilities.getSasName(property.getName()));
                proc.append("   LEVEL ").append("=").append(ModelUtilities.getSasName(level.getName()));
                this.generateCaptionChanges(newCaptions, newDesc, proc, property);
                proc.append(";").append(ModelUtilities.newline);
            }
        }
        proc.append(this.generateCodeRunStatement());
        return proc;
    }

    private void generateCaptionChanges(HashMap newCaptions, HashMap newDesc, StringBuffer proc, AbstractOLAPModel olapobj) {
        if (newCaptions.containsKey(olapobj)) {
            String caption = (String)newCaptions.get(olapobj);
            proc.append("     CAPTION = '").append(caption).append("'");
        }
        if (newDesc.containsKey(olapobj)) {
            String desc = (String)newDesc.get(olapobj);
            proc.append(ModelUtilities.newline);
            proc.append("     DESCRIPTION = '").append(desc).append("'");
        }
    }

    private StringBuffer generateCodeUserDefinedTranslations() throws OLAPException {
        StringBuffer userDefinedTranslations = new StringBuffer();
        if (this.languageSet == null) {
            this.getLanguageSet();
        }
        List locales = this.languageSet.getSelectedLocales();
        int size = locales.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                userDefinedTranslations.append(ModelUtilities.newline).append("   USER_DEFINED_TRANSLATIONS");
            }
            userDefinedTranslations.append(" ").append(locales.get(i));
        }
        if (userDefinedTranslations.length() > 0) {
            userDefinedTranslations.append(";").append(ModelUtilities.newline);
        }
        return userDefinedTranslations;
    }

    private void genLibnames(int flags, StringBuffer code) throws OLAPException {
        boolean noPrompt = ModelUtilities.getCodegenFlag(flags, 16);
        if (this.tableSet == null) {
            this.getTableSet();
        }
        if (noPrompt) {
            code.append(this.tableSet.generateSharedDimCode());
        } else {
            try {
                code.append(this.tableSet.getLibnameCode(flags));
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    private StringBuffer generateCodeDefaultMembers() throws OLAPException {
        StringBuffer defaultMembers = new StringBuffer();
        StringBuffer updateStatement = new StringBuffer();
        this.getHierarchies();
        int size = this.hierarchies.size();
        for (int i = 0; i < size; ++i) {
            OLAPHierarchy hier = (OLAPHierarchy)this.hierarchies.get(i);
            String defaultMember = hier.getUserDefaultMember();
            if (defaultMember == null) continue;
            defaultMembers.append("   HIERARCHY ").append(hier.getName());
            defaultMembers.append(ModelUtilities.newline).append("    ");
            defaultMembers.append("     DEFAULT_MEMBER = ").append(Strings.quoteForSAS((String)defaultMember));
            defaultMembers.append(";");
            defaultMembers.append(ModelUtilities.newline);
        }
        if (defaultMembers.length() > 0) {
            updateStatement.append(ModelUtilities.newline).append(ModelUtilities.newline);
            updateStatement.append("PROC OLAP").append(ModelUtilities.newline);
            updateStatement.append("   UPDATE_DISPLAY_NAMES");
            updateStatement.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
            updateStatement.append(this.generateCodeMetasrvStatement(this.getAssociatedOLAPSchema(), false));
            updateStatement.append(ModelUtilities.newline).append(ModelUtilities.newline);
            updateStatement.append(this.generateCodeProcOlapEquals(this.getFolder(), false)).append(ModelUtilities.newline);
            updateStatement.append(";");
            updateStatement.append(ModelUtilities.newline).append(ModelUtilities.newline);
            updateStatement.append(defaultMembers);
            updateStatement.append(ModelUtilities.newline);
            updateStatement.append(this.generateCodeRunStatement());
        }
        return updateStatement;
    }

    public StringBuffer generateCodeLongForm() throws OLAPException {
        String sortOrder;
        String desc;
        StringBuffer dimensionStatement = new StringBuffer();
        dimensionStatement.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        dimensionStatement.append(this.generateCodeSasCode()).append(ModelUtilities.newline);
        try {
            SASLibrary sasLibrary = LibraryUtil.getLibrary((DataTable)this.getSharedDimensionTable().getTable(), null);
            dimensionStatement.append(ModelUtilities.trim(LibraryUtil.getAccessPath((SASLibrary)sasLibrary).toString().replaceAll("\n", ModelUtilities.newline)));
            dimensionStatement.append(ModelUtilities.newline).append(ModelUtilities.newline).append("PROC OLAP").append(ModelUtilities.getReconnectionString());
            AssociationList listOfPropertySets = null;
            PropertySet linguisticPropertySet = null;
            if (this.metadataObject != null) {
                listOfPropertySets = this.metadataObject.getPropertySets();
                int iSize = listOfPropertySets.size();
                for (int i = 0; i < iSize; ++i) {
                    PropertySet propSet = (PropertySet)listOfPropertySets.elementAt(i);
                    String name = propSet.getName();
                    if (!name.equals("Linguistic")) continue;
                    linguisticPropertySet = propSet;
                }
            }
            String collationValue = this.getCollation();
            String localeValue = this.getLocale();
            if (linguisticPropertySet != null || collationValue != null || localeValue != null) {
                dimensionStatement.append(ModelUtilities.newline);
                dimensionStatement.append("   SORTSEQ = LINGUISTIC").append(ModelUtilities.newline);
                if (collationValue != null || localeValue != null) {
                    dimensionStatement.append("                       (").append(ModelUtilities.newline);
                    if (collationValue != null) {
                        dimensionStatement.append("                         COLLATION = ").append(collationValue).append(ModelUtilities.newline);
                    }
                    if (localeValue != null) {
                        dimensionStatement.append("                         LOCALE = ").append(localeValue).append(ModelUtilities.newline);
                    }
                    dimensionStatement.append("                       )").append(ModelUtilities.newline);
                }
            }
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        catch (MdException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        dimensionStatement.append(";").append(ModelUtilities.newline);
        dimensionStatement.append(this.generateCodeMetasrvStatement(this.getAssociatedOLAPSchema(), true));
        dimensionStatement.append(ModelUtilities.newline);
        dimensionStatement.append(this.generateCodeProcOlapEquals(this.getFolder(), false)).append(ModelUtilities.newline);
        dimensionStatement.append(PATH).append(this.getPath()).append("'").append(ModelUtilities.newline);
        OLAPList listOfDimensionLevels = this.getLevels();
        OLAPList listOfHierarchies = this.getHierarchies();
        if (this.isGeography()) {
            TableCollection collection = this.getMapService();
            String serviceName = null;
            try {
                if (collection != null) {
                    serviceName = collection.getName();
                }
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
            if (serviceName != null) {
                dimensionStatement.append(ModelUtilities.newline).append("      MAP_SERVICE      = '").append(serviceName).append("'");
            }
        }
        StringBuffer allHierarchies = new StringBuffer();
        int size = listOfHierarchies.size();
        for (int j = 0; j < size; ++j) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)listOfHierarchies.get(j);
            StringBuffer hierarchyStatement = hierarchy.generateCode();
            allHierarchies.append(hierarchyStatement);
        }
        String caption = this.getDesc();
        if (!ModelUtilities.isBlank(caption)) {
            caption = ModelUtilities.internalQuote(ModelUtilities.trim(caption));
        }
        if (!ModelUtilities.isBlank(desc = this.getNotes())) {
            desc = ModelUtilities.internalQuote(ModelUtilities.trim(desc));
        }
        if (caption.length() > 0) {
            dimensionStatement.append(ModelUtilities.newline).append("      CAPTION          = '").append(caption).append("'");
        }
        if (desc.length() > 0) {
            dimensionStatement.append(ModelUtilities.newline).append("      DESC             = '").append(desc).append("'");
        }
        String dimType = this.getType();
        if (!this.isUpdateable()) {
            dimensionStatement.append(ModelUtilities.newline).append("   ").append("   NONUPDATEABLE");
        }
        if (!dimType.equals("STANDARD")) {
            dimensionStatement.append(ModelUtilities.newline).append("      TYPE             = ").append(dimType);
        }
        if (!ModelUtilities.isBlank(sortOrder = this.getSortOrder())) {
            dimensionStatement.append(ModelUtilities.newline).append("      SORT_ORDER       = ").append(this.getSortOrder());
        }
        SharedDimensionTable dimTable = this.getSharedDimensionTable();
        SASLibrary libname = dimTable.getSASLibrary();
        StringBuffer dimensionTableName = new StringBuffer();
        try {
            dimensionTableName.append(libname.getLibref()).append(".").append(ModelUtilities.getSasName(dimTable.getSASTableName()));
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        this.getDimensionKey();
        if (this.dimensionKey != null) {
            CharSequence datasetOptions;
            this.getLanguageSet();
            if (this.languageSet.isCubeMultipleLanguageSupported()) {
                try {
                    datasetOptions = ModelUtilities.internalQuote(this.getTableOptions());
                    dimensionStatement.append(ModelUtilities.newline).append("      DIMTABLELIBREF   = ").append(libname.getLibref());
                    dimensionStatement.append(ModelUtilities.newline).append("      DIMTABLEMEMPREF  = ").append(ModelUtilities.getSasName(dimTable.getSASTableName()));
                    if (!ModelUtilities.isBlank((String)datasetOptions)) {
                        dimensionStatement.append(ModelUtilities.newline).append("      MEMPREFOPTS      = ").append("'").append((String)datasetOptions).append("'");
                    }
                    dimensionStatement.append(ModelUtilities.newline).append("      DIMKEY           = ").append(ModelUtilities.getSasName(this.dimensionKey.getSASColumnName()));
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
            } else {
                datasetOptions = new StringBuffer(this.getTableOptions());
                if (((StringBuffer)datasetOptions).length() > 0) {
                    ((StringBuffer)datasetOptions).insert(0, "(").append(")");
                }
                dimensionTableName.append((StringBuffer)datasetOptions);
                dimensionStatement.append(ModelUtilities.newline).append("      DIMTBL           = ").append(dimensionTableName);
                dimensionStatement.append(ModelUtilities.newline).append("      DIMKEY           = ").append(ModelUtilities.getSasName(this.dimensionKey.getSASColumnName()));
            }
        }
        String emptyCharValue = ModelUtilities.internalQuote(this.getEmptyChar());
        String emptyNumValue = ModelUtilities.internalQuote(this.getEmptyNum());
        String emptyIgnore = this.getIgnoreEmpty();
        if (!ModelUtilities.isBlank(emptyCharValue)) {
            dimensionStatement.append(ModelUtilities.newline).append("      EMPTY_CHAR       = ").append("'").append(emptyCharValue).append("'");
        } else if (emptyCharValue != null) {
            dimensionStatement.append(ModelUtilities.newline).append("      EMPTY_CHAR       = ").append("' '");
        }
        if (!ModelUtilities.isBlank(emptyNumValue)) {
            dimensionStatement.append(ModelUtilities.newline).append("      EMPTY_NUM        = ").append("'").append(emptyNumValue).append("'");
        } else if (emptyNumValue != null) {
            dimensionStatement.append(ModelUtilities.newline).append("      EMPTY_NUM        = ").append("' '");
        }
        dimensionStatement.append(ModelUtilities.newline).append("      HIERARCHIES      = (");
        dimensionStatement.append(ModelUtilities.listFormatter(listOfHierarchies, "         ", " "));
        dimensionStatement.append("         ) /* HIERARCHIES */");
        if (emptyIgnore != null && emptyIgnore.equals("1")) {
            dimensionStatement.append(ModelUtilities.newline).append("      IGNORE_EMPTY");
        }
        dimensionStatement.append(";");
        dimensionStatement.append(allHierarchies);
        int size2 = listOfDimensionLevels.size();
        for (int j = 0; j < size2; ++j) {
            OLAPLevel level = (OLAPLevel)listOfDimensionLevels.get(j);
            StringBuffer levelStatement = level.generateCode();
            dimensionStatement.append(levelStatement);
        }
        if (dimensionStatement.length() > 0) {
            dimensionStatement.append(ModelUtilities.newline);
        }
        dimensionStatement.append(this.propertySet.generateCode()).append(ModelUtilities.newline);
        dimensionStatement.append(this.generateCodeUserDefinedTranslations());
        dimensionStatement.append(ModelUtilities.newline).append(RUN);
        dimensionStatement.append(ModelUtilities.newline);
        dimensionStatement.append(this.generateCodeDefaultMembers());
        return dimensionStatement;
    }

    @Override
    public StringBuffer generateCode() throws OLAPException {
        StringBuffer dimensionStatement = new StringBuffer();
        dimensionStatement.append(ModelUtilities.newline);
        try {
            dimensionStatement.append(USE_DIMENSION).append(" ").append(ModelUtilities.getSasName(this.getName())).append(ModelUtilities.newline);
            String cubeSchema = this.owningCube.getAssociatedOLAPSchema().getName();
            String dimSchema = this.getAssociatedOLAPSchema().getName();
            if (!cubeSchema.equals(dimSchema)) {
                dimensionStatement.append("      OLAP_SCHEMA = ").append("\"").append(dimSchema).append("\"").append(ModelUtilities.newline);
            }
            dimensionStatement.append("      FACTKEY          = ").append(this.getSharedDimensionFactKey(this.owningCube)).append(";").append(ModelUtilities.newline);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return dimensionStatement;
    }

    public StringBuffer generateCodeDelete(boolean saveProcCode) throws OLAPException {
        StringBuffer delete = new StringBuffer();
        delete.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline).append(ModelUtilities.newline);
        delete.append("PROC OLAP").append("   DELETE").append(";").append(ModelUtilities.newline);
        delete.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), saveProcCode)).append(ModelUtilities.newline);
        Tree folderToUse = this.getOriginalFolder();
        if (folderToUse == null) {
            folderToUse = this.getFolder();
        }
        delete.append(this.generateCodeProcOlapEquals(folderToUse, true));
        delete.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        delete.append(this.generateCodeRunStatement());
        return delete;
    }

    public StringBuffer generateCodeDeletePhysical(boolean saveProcCode) throws OLAPException {
        StringBuffer deletePhysical = new StringBuffer();
        if (this.metadataObject != null || this.metadataObject == null && saveProcCode) {
            deletePhysical.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline).append(ModelUtilities.newline);
            deletePhysical.append("PROC OLAP").append("   DELETE_PHYSICAL").append(";").append(ModelUtilities.newline);
            deletePhysical.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), saveProcCode)).append(ModelUtilities.newline);
            Tree folderToUse = this.getOriginalFolder();
            if (folderToUse == null) {
                folderToUse = this.getFolder();
            }
            deletePhysical.append(this.generateCodeProcOlapEquals(folderToUse, true)).append(ModelUtilities.newline);
            deletePhysical.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
            deletePhysical.append(this.generateCodeRunStatement());
        }
        return deletePhysical;
    }

    StringBuffer generateCodeMetasrvStatement(OLAPSchema inputSchema, boolean saveProcCode) throws OLAPException {
        StringBuffer procOlapMetasrv = new StringBuffer();
        String schemaName = null;
        try {
            schemaName = inputSchema.getName();
            procOlapMetasrv.append(ModelUtilities.newline).append("   METASVR").append(ModelUtilities.newline);
            if (saveProcCode) {
                OMIServer metaServer = Workspace.getWorkspace().getMetadataServer();
                String host = metaServer.getHost();
                int port = metaServer.getPort();
                procOlapMetasrv.append("      HOST        = ").append("\"").append(host).append("\"").append(ModelUtilities.newline);
                procOlapMetasrv.append("      PORT        = ").append(port).append(ModelUtilities.newline);
            }
            procOlapMetasrv.append("      OLAP_SCHEMA = ").append("\"").append(schemaName).append("\"");
            procOlapMetasrv.append(";").append(ModelUtilities.newline);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (ServiceException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return procOlapMetasrv;
    }

    StringBuffer generateCodeProcOlapEquals(Tree inputFolder, boolean useOriginalName) throws OLAPException {
        StringBuffer proc = new StringBuffer();
        String pathFolder = null;
        String nameToUse = null;
        nameToUse = useOriginalName && !ModelUtilities.isBlank(this.originalName) ? this.originalName : this.getName();
        try {
            CMetadata repository;
            MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
            if (inputFolder != null) {
                pathFolder = mdUtil.getObjectPath((MdObjectStore)inputFolder.getObjectStore(), (PrimaryType)inputFolder, false);
            }
            if (ModelUtilities.isBlank(pathFolder)) {
                proc.append(SHARED_DIMENSION).append(" ").append(nameToUse).append("  ");
            } else {
                proc.append(SHARED_DIMENSION).append(" \"").append(pathFolder).append("/").append(nameToUse).append("\"");
            }
            proc.append(ModelUtilities.newline).append(SHARED);
            if (Workspace.getWorkspace().isChangeManagementOn() && (repository = Workspace.getWorkspace().getProjectRepository()) != null) {
                proc.append(ModelUtilities.newline).append("   PROJECT                = ").append("\"").append(repository.getName()).append("\"");
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(re.getLocalizedMessage(), 12);
        }
        return proc;
    }

    StringBuffer generateCodeRunStatement() {
        StringBuffer procOlapRun = new StringBuffer();
        return procOlapRun.append(ModelUtilities.newline).append("   RUN;");
    }

    StringBuffer generateCodeSasCode() throws OLAPException {
        StringBuffer code = new StringBuffer();
        String sasCode = this.getSASCode();
        code.append(sasCode);
        if (code.length() > 0) {
            code.append(ModelUtilities.newline).append(ModelUtilities.newline);
        }
        return code;
    }

    OLAPList getUnmappedLevels() throws OLAPException {
        if (this.mappedLevels != null && this.unMappedLevels == null) {
            this.unMappedLevels = new OLAPList(OLAPLevel.class);
            OLAPList dimensionLevels = this.getLevels();
            for (int j = dimensionLevels.size() - 1; j >= 0; --j) {
                OLAPLevel level = (OLAPLevel)dimensionLevels.get(j);
                if (this.mappedLevels.containsKey(level)) continue;
                this.unMappedLevels.add(level);
            }
            this.unMappedLevels.sort();
            this.unMappedLevels.setModifiable(false);
        }
        return this.unMappedLevels;
    }

    OLAPColumn getUnMappedDimensionKey() throws OLAPException {
        return this.unMappedDimensionKey;
    }

    StringBuffer getMappedRatio() {
        StringBuffer message = new StringBuffer();
        StringBuffer levelMessage = this.getMappedRatioLevel();
        if (levelMessage.length() > 0) {
            levelMessage.append("\n");
        }
        message.append(levelMessage);
        return message;
    }

    private StringBuffer getMappedRatioLevel() {
        int mappedSize;
        int totalSize;
        StringBuffer message = new StringBuffer();
        if (this.mappedLevels != null && (totalSize = (mappedSize = this.mappedLevels.size()) + this.unMappedLevels.size()) > 0) {
            message.append(bundle.formatString("OLAPDimension.MappedLevelRatio.fmt.txt", (Object)String.valueOf(mappedSize), (Object)String.valueOf(totalSize)));
        }
        return message;
    }

    public List getMessages() {
        if (this.dimMessage == null) {
            this.dimMessage = new ArrayList();
        }
        return this.dimMessage;
    }

    public List getUnMappedMessage() {
        if (this.unMappedMessage == null) {
            this.unMappedMessage = new ArrayList();
        }
        return this.unMappedMessage;
    }

    public boolean hasStructure() throws OLAPException {
        boolean structure = true;
        OLAPList levels = this.getLevels();
        structure = levels.size() > 0;
        return structure;
    }

    public boolean mapHasValidStructure() throws OLAPException {
        boolean oneValidMappedLevel = true;
        try {
            if (this.mappedLevels != null && oneValidMappedLevel) {
                oneValidMappedLevel = false;
                this.getLevels();
                for (int i = this.levels.size() - 1; i >= 0 && !oneValidMappedLevel; --i) {
                    OLAPLevel level = (OLAPLevel)this.levels.get(i);
                    Column column = (Column)this.mappedLevels.get(level);
                    oneValidMappedLevel = column != null;
                }
            }
        }
        catch (OLAPException error) {
            oneValidMappedLevel = false;
        }
        return oneValidMappedLevel;
    }

    public void clearMapping() {
        if (this.mappedLevels != null) {
            this.mappedLevels.clear();
        }
        if (this.unMappedLevels != null) {
            this.unMappedLevels.getTheList().clear();
        }
        this.unMappedLevels = null;
    }

    public void mapLevel(OLAPLevel inputLevel, Column inputColumn) {
        if (this.mappedLevels == null) {
            this.mappedLevels = new HashMap();
        }
        try {
            Column mappedColumn = (Column)this.mappedLevels.get(inputLevel);
            if (mappedColumn != inputColumn && this.isOnlyShared()) {
                SharedDimensionTable dimTable = this.getSharedDimensionTable();
                dimTable.setIsMapChanged(true);
            }
            this.mappedLevels.put(inputLevel, inputColumn);
            this.unMappedLevels.getTheList().remove(inputLevel);
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
    }

    public boolean isWasDeleted() {
        return this.wasDeleted;
    }

    @Override
    public boolean isSimilar(PhysicalTable table) throws OLAPException {
        boolean similar;
        boolean bl = similar = this.getSharedDimensionTable() != null;
        if (similar) {
            similar = this.inputSharedTable.isSimilar(this, table);
        }
        return similar;
    }

    @Override
    public boolean isStarDimension() {
        return true;
    }

    @Override
    public boolean isOnlyShared() {
        return this.onlyShared;
    }

    public boolean physicallyExists() {
        boolean exists = false;
        try {
            if (this.metadataObject != null) {
                SharedDimension dim = (SharedDimension)this.metadataObject;
                exists = !ModelUtilities.isBlank(dim.getUniqueName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return exists;
    }

    void mapTable(Map mappedTable) throws OLAPException {
        if (this.mappedLevels == null) {
            this.mappedLevels = new HashMap();
        }
        this.getLevels();
        for (int j = this.levels.size() - 1; j >= 0; --j) {
            OLAPLevel level = (OLAPLevel)this.levels.get(j);
            OLAPColumn oldColumn = level.getColumn();
            String requiredColumnName = "";
            requiredColumnName = oldColumn != null ? oldColumn.getSASColumnName().toUpperCase() : level.getName().toUpperCase();
            Column newLevelColumn = (Column)mappedTable.get(requiredColumnName);
            if (newLevelColumn == null) continue;
            this.mappedLevels.put(level, newLevelColumn);
        }
        this.getUnmappedLevels();
    }

    public boolean isPhysicalAndMetadataCubesExist() throws OLAPException {
        boolean associatedCubesExist = false;
        try {
            SharedDimension dim;
            AssociationList listOfCubes;
            if (this.metadataObject != null && !(listOfCubes = (dim = (SharedDimension)this.metadataObject).getCubes()).isEmpty()) {
                associatedCubesExist = true;
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return associatedCubesExist;
    }

    public List physicallyExistingCubes() throws OLAPException {
        ArrayList<String> listOfExistingCubes = new ArrayList<String>();
        try {
            if (this.metadataObject != null) {
                SharedDimension dim = (SharedDimension)this.metadataObject;
                AssociationList listOfCubes = dim.getCubes();
                int size = listOfCubes.size();
                for (int i = 0; i < size; ++i) {
                    Cube cube = (Cube)listOfCubes.get(i);
                    String nameOfCube = cube.getCubeName();
                    if (ModelUtilities.isBlank(nameOfCube)) continue;
                    listOfExistingCubes.add(nameOfCube);
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return listOfExistingCubes;
    }

    public int getNumberOfCubesUserCanSee() throws OLAPException {
        int numberOfCubes = 0;
        try {
            if (this.metadataObject != null) {
                SharedDimension dim = (SharedDimension)this.metadataObject;
                AssociationList listOfCubes = dim.getCubes();
                numberOfCubes = listOfCubes.size();
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return numberOfCubes;
    }

    private void readDimension() throws OLAPException {
        String tableOptions;
        String updateOption;
        String dimensionEmptyNum;
        String dimensionEmptyChar;
        try {
            if (this.owningCube == null) {
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.metadataObject, null, MetadataTemplate.getSharedDimsAssociations(), "<Templates><Cube><Aggregations search=\"*[@Nway='1']\"/> </Cube><CustomAssociation><AssociatedObjects/><OwningObject/></CustomAssociation><Hierarchy><Levels/><OLAPProperties/><Notes/><Properties/></Hierarchy><OLAPProperty><Properties/><Notes/></OLAPProperty><Property><DefaultValue/><StoredConfiguration/><OwningType/></Property><ClassifierMap><ClassifierSources/><ClassifierTargets/><TransformationSources/><TransformationTargets/><SourceCode/><Steps/></ClassifierMap><Level><Notes/><Properties/><OLAPProperties/></Level><PropertySet><SetProperties/></PropertySet><Transformation><TransformationSources/></Transformation><TableCollection><CollectionLocations/></TableCollection></Templates>", 524300);
            } else {
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.metadataObject, null, MetadataTemplate.getSharedDimsAssociations(), "<Templates><CustomAssociation><AssociatedObjects/><OwningObject/></CustomAssociation><Hierarchy><Levels/><OLAPProperties/><Notes/><Properties/></Hierarchy><OLAPProperty><Properties/><Notes/></OLAPProperty><Property><DefaultValue/><StoredConfiguration/><OwningType/></Property><ClassifierMap><ClassifierSources/><ClassifierTargets/><TransformationSources/><TransformationTargets/><SourceCode/><Steps/></ClassifierMap><Level><Notes/><Properties/><OLAPProperties/></Level><PropertySet><SetProperties/></PropertySet><Transformation><TransformationSources/></Transformation><TableCollection><CollectionLocations/></TableCollection></Templates>", 524300);
            }
            ArrayList<String> levelAssociations = new ArrayList<String>();
            levelAssociations.add("TargetFeatureMaps");
            levelAssociations.add("TargetTransformations");
            levelAssociations.add("OLAPProperties");
            SharedDimension jomaDimension = (SharedDimension)this.metadataObject;
            AssociationList levels = jomaDimension.getLevels();
            for (int k = levels.size() - 1; k >= 0; --k) {
                Level level = (Level)levels.get(k);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)level, null, levelAssociations, "<Templates><FeatureMap><AssociatedClassifierMap/><FeatureSources/><TransformationSources/></FeatureMap><OLAPProperty><TargetFeatureMaps/><TargetTransformations/></OLAPProperty></Templates>", 524300);
            }
            if (this.onlyShared) {
                this.verifyMetadata();
            }
            this.originalSchema = this.getAssociatedOLAPSchema();
            this.originalFolder = this.getOriginalFolder();
            this.originalName = this.getName();
            this.setType(jomaDimension.getDimensionType());
            if (this.getType().equalsIgnoreCase("TIME")) {
                this.wasTime = true;
            }
            this.setSortOrder(jomaDimension.getSortOrder());
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        String dimensionIgnoreEmpty = this.getIgnoreEmpty();
        if (dimensionIgnoreEmpty != null) {
            this.setUpChanges("setIgnoreEmpty", String.class, dimensionIgnoreEmpty);
        }
        if ((dimensionEmptyChar = this.getEmptyChar()) != null) {
            this.setUpChanges("setEmptyChar", String.class, dimensionEmptyChar);
        }
        if ((dimensionEmptyNum = this.getEmptyNum()) != null) {
            this.setUpChanges("setEmptyNum", String.class, dimensionEmptyNum);
        }
        if ((updateOption = this.getUpdateable()) != null) {
            this.setUpChanges("setUpdateable", String.class, updateOption);
        }
        if ((tableOptions = this.getTableOptions()) != null) {
            this.setUpChanges("setTableOptions", String.class, tableOptions);
        }
        this.apply();
    }

    public void reset() throws OLAPException {
        this.getLevels();
        this.getLanguageSet();
        if (this.levels != null || !ModelUtilities.isBlank(this.getSASCode()) || this.getEmptyChar() != null || this.getEmptyNum() != null || this.languageSet.getSelectedLocales().size() > 0) {
            if (this.dimensionSet != null) {
                this.dimensionSet.resetSharedDimension(this);
            }
            if (this.propertySet != null) {
                this.propertySet.reset();
            }
            this.resetOptions();
        }
    }

    public void resetOptions() throws OLAPException {
        if (this.resetDimensionTableTranslations) {
            if (this.languageSet == null) {
                this.getLanguageSet();
            }
            this.languageSet.reset();
        }
        if (this.resetSASCode) {
            this.setSASCode("");
        }
        if (this.resetRaggedHierarchyOptions) {
            this.setEmptyChar(null);
            this.setEmptyNum(null);
        }
    }

    public void removeCubeMetadata() throws OLAPException {
        try {
            Cube jomaCube = (Cube)this.owningCube.metadataObject;
            SharedDimension sharedDim = (SharedDimension)this.metadataObject;
            AssociationList listOfDims = jomaCube.getDimensions();
            AssociationList listOfHierarchies = jomaCube.getHierarchies();
            AssociationList listOfCustomAss = jomaCube.getCustomAssociations();
            boolean foundGen = false;
            boolean foundFact = false;
            boolean bothFound = false;
            for (int i = listOfCustomAss.size() - 1; i > -1 && !bothFound; --i) {
                AssociationList listOfAssocObject;
                CMetadata nextItem = (CMetadata)listOfCustomAss.elementAt(i);
                if (!nextItem.getCMetadataType().equalsIgnoreCase("CustomAssociation")) continue;
                CustomAssociation custom = (CustomAssociation)nextItem;
                if (custom.getPartnerName().equalsIgnoreCase(FACTKEYDIMENSION)) {
                    listOfAssocObject = custom.getAssociatedObjects();
                    if (listOfAssocObject.contains((Object)sharedDim)) {
                        listOfCustomAss.remove((Object)custom);
                        foundFact = true;
                    }
                } else if (custom.getPartnerName().equalsIgnoreCase(DIMGENFOLDER) && (listOfAssocObject = custom.getAssociatedObjects()).contains((Object)sharedDim)) {
                    listOfCustomAss.remove((Object)custom);
                    foundGen = true;
                }
                if (!foundGen || !foundFact) continue;
                bothFound = true;
            }
            listOfDims.removeElement((Object)sharedDim);
            AssociationList listOfDimHierarchies = sharedDim.getHierarchies();
            listOfHierarchies.removeAll((Collection)listOfDimHierarchies);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    void removeUnmappedSharedDimLevelStructure() throws OLAPException {
        if (this.unMappedLevels != null && !this.unMappedLevels.isEmpty()) {
            List messageList = this.getMessages();
            this.getDimensionSet();
            List hierarchyDeleteList = this.dimensionSet.getHierarchyDeleteList();
            SharedDimensionTable sharedTable = this.getSharedDimensionTable();
            PhysicalTable mappedTable = sharedTable.getMappedTable();
            for (int i = this.unMappedLevels.size() - 1; i >= 0; --i) {
                OLAPLevel level = (OLAPLevel)this.unMappedLevels.get(i);
                OLAPDimension dimension = level.getDimension();
                try {
                    messageList.add(bundle.formatString("OLAPLevel.LevelRemoved.fmt.txt", (Object)level.getName(), (Object)mappedTable.getName(), (Object)dimension.getName()));
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
                OLAPList dimensionLevels = dimension.getLevels();
                dimensionLevels.remove(level);
                OLAPList dimensionHierarchies = dimension.getHierarchies();
                for (int j = dimensionHierarchies.size() - 1; j >= 0; --j) {
                    OLAPHierarchy hierarchy = (OLAPHierarchy)dimensionHierarchies.get(j);
                    OLAPList hierarchyLevels = hierarchy.getLevels();
                    hierarchyLevels.getTheList().remove(level);
                    if (!hierarchyLevels.isEmpty()) continue;
                    messageList.add(bundle.formatString("OLAPHierarchy.HierarchyRemoved.fmt.txt", (Object)hierarchy.getName(), (Object)dimension.getName()));
                    dimensionHierarchies.getTheList().remove(hierarchy);
                    if (hierarchyDeleteList.indexOf(hierarchy) >= 0) continue;
                    hierarchyDeleteList.add(hierarchy);
                }
                this.unMappedLevels.getTheList().remove(level);
            }
            messageList.add(bundle.getString("DimensionSet.Reset.Aggregations.txt"));
        }
    }

    public void setAddData(boolean inputAddData) {
        this.addData = inputAddData;
    }

    void setErrorLevel(int inputErrorLevel) {
        this.errorLevel = inputErrorLevel;
        if (this.errorLevel == -1) {
            this.errorLevelChecked = true;
        }
    }

    @Override
    public void setFactKey(OLAPColumn inputFactKey) {
        this.factKey = inputFactKey;
        this.changedMetadata = true;
        this.checkDimensionFactKey = false;
        this.setUpChanges("setFactKey", OLAPColumn.class, inputFactKey);
    }

    public void setFolder(Tree inputFolder) throws OLAPException {
        if (inputFolder == null) {
            throw new IllegalArgumentException("The folder cannot be null");
        }
        if (!this.isNewObject()) {
            this.getFolder();
            if (this.folder != null) {
                String repositoryFQID = ModelUtilities.getRepositoryShortFQID(this.folder);
                String fqid = ModelUtilities.getRepositoryShortFQID(inputFolder);
                if (!fqid.equals(repositoryFQID)) {
                    try {
                        throw new OLAPException(bundle.formatString("OLAPSharedDimension.ChangeFolderRepository.fmt.txt", (Object)inputFolder.getName(), (Object)ModelUtilities.getRepositoryName(inputFolder)), 0);
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                    }
                }
            }
            this.folder = inputFolder;
        } else {
            this.folder = inputFolder;
        }
    }

    public void setLocale(String inputLocale) throws OLAPException {
        if (this.optionSet == null) {
            this.optionSet = this.getOptionSet();
        }
        this.locale = this.optionSet.getOption(this, "Locale", "OLAP Linguistic");
        if (inputLocale != null) {
            this.deleteLocale = false;
            if (this.locale == null) {
                this.locale = new Option(this.optionSet, this);
                this.locale.setName("Locale");
                this.locale.setDesc("Locale");
                this.locale.setPropertyRole("OLAP Linguistic");
                this.locale.setPropertyName("Locale");
                this.locale.setOwningType(OptionSet.OWNING_TYPE_STRING);
                this.locale.setPropertyOption(true);
                this.locale.setPropertySetOption(true);
            }
            String[] parts = inputLocale.split("_");
            String localeToStore = inputLocale;
            if (parts.length > 0) {
                localeToStore = parts[0].toLowerCase() + "_" + parts[1];
            }
            this.locale.setDefaultValue(localeToStore);
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.locale) >= 0) {
                objectOptions.remove(this.locale);
            }
            this.locale = null;
            this.deleteLocale = true;
        }
    }

    public void setSharedDimensionTable(SharedDimensionTable table) {
        this.inputSharedTable = table;
        this.changedMetadata = true;
        this.checkDimensionTable = false;
        this.setUpChanges("setSharedDimensionTable", SharedDimensionTable.class, table);
    }

    @Override
    public void setTableOptions(String optionValue) throws OLAPException {
        if (optionValue != null & !ModelUtilities.isBlank(optionValue)) {
            this.deleteTableOptions = false;
            this.getTableOptions();
            if (this.tableOptions == null) {
                this.tableOptions = new Option(this.optionSet, this);
                this.tableOptions.setName("DimensionTable_options");
                this.tableOptions.setDesc("OLAP Table Options");
                this.tableOptions.setPropertyName("DimensionTable_options");
                this.tableOptions.setPropertyRole("OLAP Table Options");
                this.tableOptions.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.tableOptions.setDefaultValue(optionValue);
        } else if (this.tableOptions != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.tableOptions) >= 0) {
                objectOptions.remove(this.tableOptions);
            }
            this.tableOptions = null;
            this.deleteTableOptions = true;
        }
        this.changedMetadata = true;
        this.setUpChanges("setTableOptions", String.class, optionValue);
    }

    public void setWasDeleted(Boolean deleted) {
        this.wasDeleted = deleted;
    }

    public void setSASCode(String inputCode) {
        this.sasCode = inputCode;
    }

    public void setPath(String inputPath) {
        this.path = inputPath;
    }

    void setMapToStructure() throws OLAPException {
        OLAPList unmappedLevels;
        this.getSharedDimensionTable();
        if (this.mappedLevels != null) {
            OLAPList dimensionLevels = this.getLevels();
            for (int j = dimensionLevels.size() - 1; j >= 0; --j) {
                OLAPLevel level = (OLAPLevel)dimensionLevels.get(j);
                Column jomaColumn = (Column)this.mappedLevels.get(level);
                if (jomaColumn == null) continue;
                OLAPColumn olapColumn = this.inputSharedTable.getColumn(jomaColumn);
                level.setColumn(olapColumn);
            }
        }
        if (this.mappedLevels != null) {
            this.mappedLevels.clear();
            this.mappedLevels = null;
        }
        if ((unmappedLevels = this.getDimensionSet().getUnmappedLevels()) != null) {
            unmappedLevels.getTheList().clear();
            unmappedLevels = null;
        }
        this.getOLAPMemberPropertySet().setMapToStructure();
    }

    public void setAssociatedOLAPSchema(OLAPSchema inputSchema) {
        this.schema = inputSchema;
        this.getOriginalSchema();
    }

    public void setCollation(String inputCollation) throws OLAPException {
        if (this.optionSet == null) {
            this.optionSet = this.getOptionSet();
        }
        this.collation = this.optionSet.getOption(this, "Collation", "OLAP Linguistic");
        if (inputCollation != null) {
            this.deleteCollation = false;
            if (this.collation == null) {
                this.collation = new Option(this.optionSet, this);
                this.collation.setName("Collation");
                this.collation.setDesc("Collation");
                this.collation.setPropertyRole("OLAP Linguistic");
                this.collation.setPropertyName("Collation");
                this.collation.setOwningType(OptionSet.OWNING_TYPE_STRING);
                this.collation.setPropertyOption(true);
                this.collation.setPropertySetOption(true);
            }
            this.collation.setDefaultValue(inputCollation);
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.collation) >= 0) {
                objectOptions.remove(this.collation);
            }
            this.collation = null;
            this.deleteCollation = true;
        }
    }

    @Override
    public void setDimensionKey(OLAPColumn inputKey) {
        this.deleteDimensionKey = inputKey == null;
        this.isStarDimension = Boolean.TRUE;
        this.dimensionKey = inputKey;
        this.changedMetadata = true;
        this.checkDimensionKey = false;
        this.setUpChanges("setDimensionKey", OLAPColumn.class, inputKey);
    }

    public void deleteFromCube() throws OLAPException {
        this.dimensionSet.getSharedDimensions().remove(this);
        this.setDeleted(true);
    }

    @Override
    public void delete() throws OLAPException {
        if (this.metadataObject != null) {
            this.dimensionSet.getDimensionDeleteList().add(this);
        }
        this.getLevels();
        for (int i = this.levels.size() - 1; i > -1; --i) {
            OLAPLevel level = (OLAPLevel)this.levels.get(i);
            level.delete();
        }
        this.setDeleted(true);
    }

    private void setUpSets(OLAPCube cube) throws OLAPException {
        if (cube != null) {
            this.owningCube = cube;
            this.dimensionSet = cube.getDimensionSet();
            this.setOptionSet(cube.getOptionsSet());
            this.setTableSet(cube.getTableSet());
            this.languageSet = cube.getLanguageSet();
            this.setOLAPMemberPropertySet(cube.getOLAPMemberPropertySet());
            this.aggregationSet = cube.getAggregationSet();
        } else {
            this.dimensionSet = this.getDimensionSet();
            this.setOptionSet(this.getOptionSet());
            this.setTableSet(this.getTableSet());
            this.languageSet = this.getLanguageSet();
            this.setOLAPMemberPropertySet(this.getOLAPMemberPropertySet());
        }
    }

    public void updateCubeMetadata() throws OLAPException {
        try {
            Cube jomaCube = (Cube)this.owningCube.metadataObject;
            AssociationList listOfDims = jomaCube.getDimensions();
            SharedDimension sharedDim = (SharedDimension)this.metadataObject;
            AssociationList listOfHierarchies = jomaCube.getHierarchies();
            if (!listOfDims.contains((Object)sharedDim)) {
                listOfDims.addElement((Object)sharedDim);
                AssociationList listOfDimHierarchies = sharedDim.getHierarchies();
                listOfHierarchies.addAll((Collection)listOfDimHierarchies);
                AssociationList listOfReferenceObj = sharedDim.getReferencedObjects();
                OLAPColumn column = this.getSharedDimensionFactKey(this.owningCube);
                Column jomaColumn = column.metadataObject;
                CustomAssociation factCustom = (CustomAssociation)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "CustomAssociation", this.owningCube.getRepositoryShortFQID());
                factCustom.setName(this.getName() + "_" + "FactKey");
                factCustom.setisOwned(0);
                factCustom.setPartnerName(FACTKEYDIMENSION);
                listOfReferenceObj.add((Object)factCustom);
                AssociationList listOfAssObjects = factCustom.getAssociatedObjects();
                listOfAssObjects.clear();
                listOfAssObjects.add((Object)jomaColumn);
                listOfAssObjects.add((Object)sharedDim);
                jomaCube.getCustomAssociations().add((Object)factCustom);
                AssociationList listOfCubes = sharedDim.getCubes();
                listOfCubes.add((Object)jomaCube);
            } else {
                AssociationList listOfCustomAss = jomaCube.getCustomAssociations();
                boolean found = false;
                for (int i = listOfCustomAss.size() - 1; i > -1 && !found; --i) {
                    AssociationList listofAssocObject;
                    CMetadata nextItem = (CMetadata)listOfCustomAss.elementAt(i);
                    if (!nextItem.getCMetadataType().equalsIgnoreCase("CustomAssociation")) continue;
                    CustomAssociation custom = (CustomAssociation)nextItem;
                    if (custom.getPartnerName().equalsIgnoreCase(DIMGENFOLDER)) {
                        AssociationList listOfAssocObject = custom.getAssociatedObjects();
                        if (!listOfAssocObject.contains((Object)sharedDim)) continue;
                        listOfCustomAss.remove((Object)custom);
                        found = true;
                        continue;
                    }
                    if (!custom.getPartnerName().equalsIgnoreCase(FACTKEYDIMENSION) || !(listofAssocObject = custom.getAssociatedObjects()).contains((Object)sharedDim)) continue;
                    this.getSharedDimensionFactKey(this.owningCube);
                    listofAssocObject.clear();
                    listofAssocObject.add((Object)sharedDim);
                    Column col = this.factKey.metadataObject;
                    listofAssocObject.add((Object)col);
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    @Override
    public void updateMetadata() throws OLAPException {
        this.metadataCreated = true;
        if (!this.checkVerifyName) {
            this.verifyName();
        }
        if (!this.checkDimensionTable) {
            this.verifyStarSchemaTable();
        }
        if (!this.checkDimensionKey) {
            this.verifyStarSchemaKey();
        }
        this.verifyOLAPSchema();
        this.verifyPath();
        this.verifyLevelsList();
        this.verifyHierarchyList();
        this.verifyAllLevelsUsed();
        boolean newObject = true;
        if (this.metadataObject == null) {
            this.metadataObject = (SharedDimension)MetadataTemplate.createMetadata(this.objectStore, "SharedDimension", this.getRepositoryShortFQID());
        } else {
            newObject = false;
        }
        SharedDimension dimensionObject = (SharedDimension)this.metadataObject;
        try {
            List hierarchyDeleteList;
            List levelDeleteList;
            OLAPHierarchy defaultHierarchy;
            int whereIsHierarchy;
            int i;
            this.getAssociatedOLAPSchema();
            this.getOriginalSchema();
            if (this.schema != this.originalSchema) {
                AssociationList schemas = dimensionObject.getAssociatedOLAPSchemas();
                schemas.clear();
                schemas.add((Object)this.schema);
                AssociationList listOfDimensions = this.schema.getDimensions();
                listOfDimensions.add((Object)dimensionObject);
            }
            if (newObject) {
                AssociationList listOfDimensions = this.schema.getDimensions();
                listOfDimensions.add((Object)dimensionObject);
            }
            dimensionObject.setPublicType("SharedDimension");
            UsageVersion usageVersion = new UsageVersion(Integer.parseInt("1"), Integer.parseInt("0"), Integer.parseInt("0"));
            dimensionObject.setUsageVersion(usageVersion.encode());
            super.updateMetadata();
            this.inputSharedTable.updateMetadata();
            this.getSortOrder();
            this.updatePathFile();
            if (ModelUtilities.isBlank(this.sortOrder)) {
                this.sortOrder = "ASCENDING";
            }
            dimensionObject.setSortOrder(this.sortOrder);
            if (this.getType() == null || ModelUtilities.isBlank(this.type)) {
                this.type = "STANDARD";
            }
            dimensionObject.setDimensionType(this.type);
            this.updateFolderMetadata();
            this.updateNotesMetadata();
            this.getHierarchies();
            this.getLevels();
            int size = this.levels.size();
            for (i = 0; i < size; ++i) {
                OLAPLevel level = (OLAPLevel)this.levels.get(i);
                level.updateLevelMetadata();
            }
            size = this.hierarchies.size();
            for (i = 0; i < size; ++i) {
                OLAPHierarchy hier = (OLAPHierarchy)this.hierarchies.get(i);
                hier.updateHierarchyMetadata();
            }
            if (this.hierarchies.size() > 1 && (whereIsHierarchy = this.hierarchies.indexOf(defaultHierarchy = this.getDefault())) > 0) {
                this.hierarchies.getTheList().remove(whereIsHierarchy);
                this.hierarchies.getTheList().add(0, defaultHierarchy);
            }
            this.updateKey();
            this.updateOptionsMetadata();
            this.getLanguageSet().updateMetadata();
            if (this.isGeography()) {
                this.updateMapInfo();
            }
            OLAPMemberPropertySet propertySet = this.getOLAPMemberPropertySet();
            propertySet.updateMetadata();
            if (this.hierarchies.size() > 1) {
                Hierarchy defaultHierarchy2 = (Hierarchy)this.getDefault().metadataObject;
                SharedDimension jomaDimension = (SharedDimension)this.metadataObject;
                AssociationList listOfHierarchies = jomaDimension.getHierarchies();
                int whereIsHierarchy2 = listOfHierarchies.indexOf((Object)defaultHierarchy2);
                if (whereIsHierarchy2 > 0) {
                    listOfHierarchies.remove(whereIsHierarchy2);
                    listOfHierarchies.add(0, (Object)defaultHierarchy2);
                }
            }
            if ((levelDeleteList = this.dimensionSet.getLevelDeleteList()) != null) {
                int size2 = levelDeleteList.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    OLAPLevel olapLevel = (OLAPLevel)levelDeleteList.get(i2);
                    Level jomaLevel = (Level)olapLevel.metadataObject;
                    AssociationList sourceTrans = jomaLevel.getSourceTransformations();
                    for (int src = sourceTrans.size() - 1; src >= 0; --src) {
                        Transformation t = (Transformation)sourceTrans.get(src);
                        AssociationList targets = t.getTransformationTargets();
                        for (int m = targets.size() - 1; m >= 0; --m) {
                            Object obj = targets.get(m);
                            if (!(obj instanceof Measure)) continue;
                            Measure jomaMeasure = (Measure)obj;
                            Workspace.getMdFactory().deletePublicObject((CMetadata)jomaMeasure, "<Template TemplateName=\"Measure\"><Measure><AccessControls><AccessControlTemplate TemplateExpand=\"CONNECT\"/><AccessControlEntry/></AccessControls><Extensions/><Keywords/><Notes/><Properties/><PropertySets/><TargetFeatureMaps/><TargetTransformations/></Measure><AccessControlEntry><AssociatedCondition/><Permissions><Permission TemplateExpand=\"connect\" ConnectionAction=\"W\"/></Permissions><Identities><Identity TemplateExpand=\"connect\" ConnectionAction=\"W\" /></Identities></AccessControlEntry><Property><StoredConfiguration/><OwningType/></Property><PropertySet><SetProperties/></PropertySet><PropertyType><ArrayTypes/></PropertyType></Template>");
                        }
                    }
                    MetadataTemplate.deleteMetadata(this.getObjectStore(), (CMetadata)jomaLevel, "", "");
                }
            }
            if ((hierarchyDeleteList = this.dimensionSet.getHierarchyDeleteList()) != null) {
                int size3 = hierarchyDeleteList.size();
                for (int i3 = 0; i3 < size3; ++i3) {
                    OLAPHierarchy olapHierarchy = (OLAPHierarchy)hierarchyDeleteList.get(i3);
                    Hierarchy jomaHierarchy = (Hierarchy)olapHierarchy.metadataObject;
                    AssociationList calcMbrs = jomaHierarchy.getCalculatedMembers();
                    for (int cm = calcMbrs.size() - 1; cm >= 0; --cm) {
                        CalculatedMember mbr = (CalculatedMember)calcMbrs.get(cm);
                        mbr.delete();
                    }
                    MetadataTemplate.deleteMetadata(this.getObjectStore(), (CMetadata)jomaHierarchy, "", "");
                }
            }
            this.updateAssociatedCubes();
            if (this.metadataCreated) {
                dimensionObject.touch();
                dimensionObject.updateMetadataAll();
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    public void updateAssociatedCubes() throws OLAPException {
        try {
            boolean dimIsTimeOrGeo = this.isGeography() || this.isTime();
            SharedDimension jomaSharedDim = (SharedDimension)this.metadataObject;
            AssociationList cubes = jomaSharedDim.getCubes();
            boolean neededUpdate = false;
            ArrayList<String> hierNamesWithinCubes = new ArrayList<String>();
            ArrayList<String> levelNamesWithinCubes = new ArrayList<String>();
            ArrayList<String> addedLevels = new ArrayList<String>();
            ArrayList<String> addedHiers = new ArrayList<String>();
            ArrayList<String> containDuplicateTypes = new ArrayList<String>();
            for (int cubeNum = 0; cubeNum < cubes.size(); ++cubeNum) {
                int i;
                Cube cube = (Cube)cubes.get(cubeNum);
                if (dimIsTimeOrGeo) {
                    AssociationList dimensionsList = cube.getDimensions();
                    boolean found = false;
                    int size = dimensionsList.size();
                    for (int i2 = 0; i2 < size && !found; ++i2) {
                        Dimension dim = (Dimension)dimensionsList.get(i2);
                        if (jomaSharedDim == dim) continue;
                        String type = dim.getDimensionType();
                        if (this.isTime() && type.equals("TIME")) {
                            found = true;
                        } else if (!this.isTime() && type.equals("GEO")) {
                            found = true;
                        }
                        if (!found) continue;
                        containDuplicateTypes.add(cube.getName());
                    }
                }
                neededUpdate = false;
                AssociationList cubeHierarchies = cube.getHierarchies();
                int currentHiersSize = cubeHierarchies.size();
                for (int i3 = 0; i3 < currentHiersSize; ++i3) {
                    hierNamesWithinCubes.add(((Hierarchy)cubeHierarchies.get(i3)).getName().toUpperCase());
                }
                for (int hierNum = 0; hierNum < this.hierarchies.size(); ++hierNum) {
                    OLAPHierarchy olapHier = (OLAPHierarchy)this.hierarchies.get(hierNum);
                    Hierarchy hier = (Hierarchy)olapHier.metadataObject;
                    if (cubeHierarchies.contains((Object)hier)) continue;
                    cubeHierarchies.add((Object)hier);
                    addedHiers.add(hier.getName().toUpperCase());
                    neededUpdate = true;
                }
                AssociationList aggregations = cube.getAggregations();
                for (int aggrNum = 0; aggrNum < aggregations.size(); ++aggrNum) {
                    Aggregation aggr = (Aggregation)aggregations.get(aggrNum);
                    if (aggr.getNway() != 1) continue;
                    AssociationList aggrlevels = aggr.getLevels();
                    int aggrLevelsSize = aggrlevels.size();
                    for (int i4 = 0; i4 < aggrLevelsSize; ++i4) {
                        levelNamesWithinCubes.add(((Level)aggrlevels.get(i4)).getName().toUpperCase());
                    }
                    for (int levNum = 0; levNum < this.levels.size(); ++levNum) {
                        OLAPLevel olapLevel = (OLAPLevel)this.levels.get(levNum);
                        Level level = (Level)olapLevel.metadataObject;
                        if (aggrlevels.contains((Object)level)) continue;
                        aggrlevels.add((Object)level);
                        addedLevels.add(level.getName().toUpperCase());
                        neededUpdate = true;
                    }
                }
                if (!containDuplicateTypes.isEmpty()) {
                    this.metadataCreated = false;
                    String indentBuffer = "   ";
                    String delimeter = ", ";
                    Object message = null;
                    if (this.isTime()) {
                        MessageUtil.displayMessage((String)bundle.formatString("OLAPSharedDimension.DuplicateTIME.Cubes.fmt.txt", (Object)ModelUtilities.stringListFormatter(containDuplicateTypes, indentBuffer, delimeter)));
                    } else {
                        MessageUtil.displayMessage((String)bundle.formatString("OLAPSharedDimension.DuplicateGEO.Cubes.fmt.txt", (Object)ModelUtilities.stringListFormatter(containDuplicateTypes, indentBuffer, delimeter)));
                    }
                }
                if (!neededUpdate) continue;
                ArrayList<String> duplicatedNames = new ArrayList<String>();
                int hierSize = addedHiers.size();
                for (i = 0; i < hierSize; ++i) {
                    String name = ((String)addedHiers.get(i)).toUpperCase();
                    if (!hierNamesWithinCubes.contains(name)) continue;
                    duplicatedNames.add(name);
                }
                int levelSize = addedLevels.size();
                for (i = 0; i < levelSize; ++i) {
                    String name = ((String)addedLevels.get(i)).toUpperCase();
                    if (!levelNamesWithinCubes.contains(name)) continue;
                    duplicatedNames.add(name);
                }
                if (!duplicatedNames.isEmpty()) {
                    this.metadataCreated = false;
                    String indentBuffer = "   ";
                    String delimeter = ", ";
                    MessageUtil.displayMessage((String)bundle.formatString("OLAPSharedDimension.DuplicateNames.Cubes.fmt.txt", (Object)ModelUtilities.stringListFormatter(duplicatedNames, indentBuffer, delimeter)));
                    continue;
                }
                cube.touch();
                cube.updateMetadataAll();
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void updateFolderMetadata() throws OLAPException {
        SharedDimension jomaSharedDim = (SharedDimension)this.metadataObject;
        try {
            AssociationList listOfFolders = jomaSharedDim.getTrees();
            listOfFolders.clear();
            this.getFolder();
            if (this.folder != null) {
                listOfFolders.add((Object)this.folder);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    public void updateMetadataOlapSchemaOnly() throws OLAPException {
        if (this.metadataObject != null) {
            SharedDimension dim = (SharedDimension)this.metadataObject;
            try {
                AssociationList schemas = dim.getAssociatedOLAPSchemas();
                schemas.clear();
                schemas.add((Object)this.getAssociatedOLAPSchema());
                dim.touch();
                dim.updateMetadataAll();
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
    }

    void updateNotesMetadata() throws OLAPException {
        this.getSASCode();
        TextStore storedSASCode = null;
        SharedDimension dimension = (SharedDimension)this.metadataObject;
        try {
            AssociationList dimNotes = dimension.getNotes();
            for (int i = 0; i < dimNotes.size(); ++i) {
                TextStore note = (TextStore)dimNotes.elementAt(i);
                if (!note.getName().equals("OLAPSASCode")) continue;
                storedSASCode = note;
            }
            if (storedSASCode != null) {
                if (!ModelUtilities.isBlank(this.sasCode)) {
                    storedSASCode.setStoredText(this.sasCode);
                } else {
                    storedSASCode.delete();
                }
            } else if (!ModelUtilities.isBlank(this.sasCode)) {
                storedSASCode = (TextStore)MetadataTemplate.createMetadata(this.objectStore, "TextStore", this.getRepositoryShortFQID());
                storedSASCode.setName("OLAPSASCode");
                storedSASCode.setTextRole("Olap SASCODE Description");
                storedSASCode.setTextType("Plain Text");
                storedSASCode.setStoredText(this.sasCode);
                dimNotes.addElement((Object)storedSASCode);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    @Override
    void updateOptionsMetadata() throws OLAPException {
        if (this.optionSet != null) {
            try {
                CMetadata custom;
                Property property;
                int i;
                List options = this.optionSet.getOptions(this);
                HashMap<String, Property> metadataOptions = new HashMap<String, Property>();
                AssociationList properties = this.metadataObject.getProperties();
                int size = options.size();
                for (i = 0; i < size; ++i) {
                    Option option = (Option)options.get(i);
                    option.updateMetadata();
                }
                for (i = properties.size() - 1; i >= 0; --i) {
                    Property property2 = (Property)properties.elementAt(i);
                    String propertyName = property2.getName();
                    if (propertyName.equalsIgnoreCase("GENFOLDER")) {
                        MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)property2, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                        continue;
                    }
                    metadataOptions.put(property2.getPropertyName(), property2);
                }
                if (this.deleteIgnoreEmpty & this.ignoreEmpty == null && (property = (Property)metadataOptions.get("IGNORE_EMPTY")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteEmptyChar & this.emptyChar == null && (property = (Property)metadataOptions.get("EMPTY_CHAR")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteEmptyNum & this.emptyNum == null && (property = (Property)metadataOptions.get("EMPTY_NUM")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteTableOptions & this.tableOptions == null && (property = (Property)metadataOptions.get(this.getName() + "_options")) != null && property.getPropertyRole().equals("OLAP Table Options")) {
                    MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteMLS & this.MLSOption == null && (property = (Property)metadataOptions.get(this.getName() + "_mempref")) != null && property.getPropertyRole().equals("OLAP UDT")) {
                    MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteUpdateableDimension & this.updateableDimension == null && (property = (Property)metadataOptions.get("NONUPDATEABLE")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteCaptionPref & this.captionPref == null && (property = (Property)metadataOptions.get(this.getName() + "_cappref")) != null && property.getPropertyName().equals(this.getName() + "_cappref")) {
                    MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteCaptionTable & this.mlsCaptionTable == null && (custom = (CMetadata)metadataOptions.get("CaptionTableObject")) != null && custom.getName().equalsIgnoreCase(this.getName() + "_CaptionTable")) {
                    MetadataTemplate.deleteMetadata(this.objectStore, custom, "", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteCollation & this.collation == null || this.deleteLocale & this.locale == null) {
                    AssociationList listOfPropertySets = this.metadataObject.getPropertySets();
                    PropertySet linguisticPropertySet = null;
                    int iSize = listOfPropertySets.size();
                    for (int i2 = 0; i2 < iSize; ++i2) {
                        PropertySet propertySet = (PropertySet)listOfPropertySets.elementAt(i2);
                        String name = propertySet.getName();
                        if (!name.equals("Linguistic")) continue;
                        linguisticPropertySet = propertySet;
                    }
                    if (linguisticPropertySet != null) {
                        Property collationProperty = null;
                        Property localeProperty = null;
                        AssociationList propSetProps = linguisticPropertySet.getSetProperties();
                        for (int propNum = 0; propNum < propSetProps.size(); ++propNum) {
                            Property prop = (Property)propSetProps.get(propNum);
                            if ("Collation".equalsIgnoreCase(prop.getName())) {
                                collationProperty = prop;
                                continue;
                            }
                            if (!"Locale".equalsIgnoreCase(prop.getName())) continue;
                            localeProperty = prop;
                        }
                        if (this.collation == null && collationProperty != null) {
                            MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)collationProperty, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                        }
                        if (this.locale == null && localeProperty != null) {
                            MetadataTemplate.deleteMetadata(this.objectStore, localeProperty, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                        }
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
    }

    public void setResetDimensionTableTranslations(boolean inputResetDimensionTableTranslations) {
        this.resetDimensionTableTranslations = inputResetDimensionTableTranslations;
    }

    public void setResetRaggedHierarchyOptions(boolean inputResetRaggedHierarchyOptions) {
        this.resetRaggedHierarchyOptions = inputResetRaggedHierarchyOptions;
    }

    public void setResetSasCode(boolean inputResetSASCode) {
        this.resetSASCode = inputResetSASCode;
    }

    void updatePathFile() throws OLAPException {
        try {
            this.getPath();
            boolean getNewDirectory = false;
            SharedDimension dim = (SharedDimension)this.metadataObject;
            AssociationList directories = dim.getAssociatedDirectorys();
            Directory directory = null;
            if (directories.size() > 0) {
                directory = (Directory)directories.elementAt(0);
                directory.setDirectoryName(this.path);
                directory.setIsRelative(0);
                directory.setName(this.path);
                directory.setDirectoryRole(OLAP_PATH);
            } else {
                directory = (Directory)MetadataTemplate.createMetadata(this.objectStore, "Directory", this.getRepositoryShortFQID());
                directory.setDirectoryName(this.path);
                directory.setIsRelative(0);
                directory.setName(this.path);
                directory.setDirectoryRole(OLAP_PATH);
                directories.addElement((Object)directory);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void updateKey() throws OLAPException {
        try {
            if (this.dimensionKey != null) {
                SharedDimension dimensionObject = (SharedDimension)this.metadataObject;
                CustomAssociation dimCustom = null;
                AssociationList listOfCustomAssociations = dimensionObject.getCustomAssociations();
                int size = listOfCustomAssociations.size();
                for (int i = 0; i < size; ++i) {
                    CustomAssociation nextCustom;
                    CMetadata object = (CMetadata)listOfCustomAssociations.elementAt(i);
                    if (!object.getCMetadataType().equalsIgnoreCase("CustomAssociation") || !(nextCustom = (CustomAssociation)object).getPartnerName().equals("DimKeyDimension")) continue;
                    dimCustom = nextCustom;
                }
                if (dimCustom == null) {
                    dimCustom = (CustomAssociation)MetadataTemplate.createMetadata(this.objectStore, "CustomAssociation", this.getRepositoryShortFQID());
                    dimCustom.setName(this.getName() + "_" + "DimKey");
                    dimCustom.setisOwned(0);
                    dimCustom.setPartnerName("DimKeyDimension");
                    listOfCustomAssociations.add((Object)dimCustom);
                }
                AssociationList dimAssociatedObjects = dimCustom.getAssociatedObjects();
                for (int t = dimAssociatedObjects.size() - 1; t > -1; --t) {
                    CMetadata nextItem = (CMetadata)dimAssociatedObjects.elementAt(t);
                    if (nextItem.getCMetadataType().equalsIgnoreCase("Column")) {
                        Column nextColumn = (Column)nextItem;
                        dimAssociatedObjects.remove((Object)nextColumn);
                    }
                    if (!nextItem.getCMetadataType().equalsIgnoreCase("PhysicalTable")) continue;
                    PhysicalTable nextTable = (PhysicalTable)nextItem;
                    dimAssociatedObjects.remove((Object)nextTable);
                }
                this.getSharedDimensionTable();
                dimAssociatedObjects.add((Object)this.dimensionKey.metadataObject);
                dimAssociatedObjects.add((Object)this.inputSharedTable.getTable());
            }
            this.getLanguageSet();
            this.MLSOption = this.getMLS();
            if (this.languageSet.isCubeMultipleLanguageSupported() && this.MLSOption == null) {
                this.setMLS(this.getSharedDimensionTable().getSASTableName());
            } else if (!this.languageSet.isCubeMultipleLanguageSupported() && this.MLSOption != null) {
                this.setMLS(null);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void verifyMetadataPath() throws OLAPException {
        try {
            SharedDimension jomaDim = (SharedDimension)this.metadataObject;
            if (jomaDim != null) {
                Directory file = jomaDim.getAssociatedDirectory();
                if (file != null) {
                    this.path = file.getDirectoryName();
                }
                if (file == null || ModelUtilities.isBlank(this.path)) {
                    this.sharedDimVerifyMessage.append(bundle.getString("OLAPSharedDimension.PathMissing.txt"));
                    this.errorLevel = 3;
                }
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public void verifyPath() throws OLAPException {
        this.getPath();
        if (ModelUtilities.isBlank(this.path)) {
            throw new OLAPException(bundle.getString("OLAPSharedDimension.SpecifyPath.txt"), 0);
        }
    }

    public void verifyFolder() throws OLAPException {
        this.getFolder();
        if (this.folder == null) {
            throw new OLAPException(bundle.getString("OLAPCube.MissingFolder.txt"), 0);
        }
        try {
            MdFactory factory;
            MdSecurityUtil securityUtil;
            if (this.folder != this.originalFolder && !(securityUtil = (factory = this.objectStore.getFactory()).getSecurityUtil()).isFolderWriteAuthorized(this.folder.getId())) {
                throw new OLAPException(bundle.formatString("OLAPCube.NoWriteFolder.fmt.txt", (Object)this.folder.getName()), 0);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public void verifyLevelNameUnique(OLAPLevel inLevel) throws OLAPException {
        if (inLevel == null) {
            throw new IllegalStateException("The level parameter cannot be null.");
        }
        OLAPList listOfAllLevels = this.getLevels();
        String checkLevelName = inLevel.getName();
        int size = listOfAllLevels.size();
        for (int i = 0; i < size; ++i) {
            String nameOfLevel;
            OLAPLevel level = (OLAPLevel)listOfAllLevels.get(i);
            if (inLevel.equals(level) || !(nameOfLevel = level.getName()).equalsIgnoreCase(checkLevelName)) continue;
            throw new OLAPException(bundle.formatString("OLAPLevel.DuplicateLevelName.txt", (Object)nameOfLevel), 0);
        }
    }

    @Override
    public void verifyStarSchemaTable() throws OLAPException {
        if (this.getSharedDimensionTable() == null) {
            throw new OLAPException(bundle.formatString("OLAPDimension.NoDimDefined.fmt.txt", (Object)this.name), 0);
        }
        this.checkDimensionTable = true;
    }

    @Override
    public StringBuffer verifyMetadata() {
        this.getVerifyMessage();
        try {
            SASLibrary library;
            this.verifyVersionNumber();
            this.verifyMetadataOLAPSchema();
            this.verifyMetadataPath();
            SharedDimensionTable dimensionTable = this.getSharedDimensionTable();
            if (dimensionTable.getTable() == null) {
                this.setErrorLevel(1);
                this.sharedDimVerifyMessage.append(bundle.getString("LoadTable.NoLoadTable.txt"));
            }
            if (dimensionTable != null && dimensionTable.getTable() != null && (library = dimensionTable.getSASLibrary()) == null) {
                try {
                    this.setErrorLevel(2);
                    this.sharedDimVerifyMessage.append(bundle.formatString("LoadTable.MissingLibrary.fmt.txt", (Object)dimensionTable.getTable().getName()));
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
                }
            }
            this.getLevels();
            if (this.getLevels().size() == 0) {
                this.sharedDimVerifyMessage.append(bundle.getString("DimensionSet.NoLevels.txt"));
            }
            ArrayList<OLAPLevel> deletedLevels = new ArrayList<OLAPLevel>();
            Object[] allLevels = this.levels.toArray();
            Arrays.sort(allLevels);
            for (int i = allLevels.length - 1; i >= 0; --i) {
                OLAPLevel level = (OLAPLevel)allLevels[i];
                StringBuffer levelMessage = level.verifySharedLevelMetadata();
                if (ModelUtilities.isBlank(levelMessage.toString())) continue;
                this.sharedDimVerifyMessage.append(levelMessage);
                deletedLevels.add(level);
            }
            if (this.sharedDimVerifyMessage.length() == 0) {
                StringBuffer memberProperties;
                StringBuffer UDTTables;
                StringBuffer mapInfo;
                if (this.isGeography() && !ModelUtilities.isBlank((mapInfo = this.verifyMapInfo()).toString())) {
                    this.sharedDimVerifyMessage.append(mapInfo);
                }
                this.getDimensionKey();
                if (this.dimensionKey == null) {
                    this.sharedDimVerifyMessage.append(bundle.formatString("OLAPDimension.MissingKey.fmt.txt", (Object)this.getName()));
                }
                if (!ModelUtilities.isBlank((UDTTables = this.verifyUDTTables()).toString())) {
                    this.sharedDimVerifyMessage.append(UDTTables);
                }
                if (!ModelUtilities.isBlank((memberProperties = this.propertySet.verifyMetadata()).toString())) {
                    this.sharedDimVerifyMessage.append(memberProperties);
                }
            }
            if (this.errorLevel == -1 && this.sharedDimVerifyMessage.length() > 0) {
                this.errorLevel = 3;
            }
        }
        catch (OLAPException error) {
            this.sharedDimVerifyMessage.append(error.getLocalizedMessage());
            this.setErrorLevel(4);
        }
        return this.sharedDimVerifyMessage;
    }

    @Override
    public void verifyName() throws OLAPException {
        this.getName();
        this.name = this.getName();
        if (this.name == null || ModelUtilities.isBlank(this.name)) {
            throw new OLAPException(bundle.getString("Model.NameRequired.txt"), null, 0);
        }
        if (this.name.length() > 32) {
            throw new OLAPException(bundle.getString("Model.SASName.txt"), null, 0);
        }
        ModelUtilities.verifyPublicTypeName(this.name);
        OLAPSchema newSchema = this.getAssociatedOLAPSchema();
        Tree newFolder = this.getFolder();
        String newName = this.getName();
        if (this.originalName == null || !this.originalName.equalsIgnoreCase(newName)) {
            if (!ModelUtilities.isSharedDimensionNameUniqueToFolder(newName, newFolder)) {
                throw new OLAPException(bundle.getString("OLAPSharedDimension.NameUniqueToFolder.txt"), 0);
            }
            if (!ModelUtilities.isSharedDimensionNameUniqueToOLAPSchema(newName, newSchema)) {
                throw new OLAPException(bundle.getString("OLAPSharedDimension.NameUniqueToSchema.txt"), 0);
            }
        }
        if (this.originalSchema != newSchema && !ModelUtilities.isCubeNameUniqueToOLAPSchema(newName, newSchema)) {
            throw new OLAPException(bundle.getString("OLAPSharedDimension.NameUniqueToSchema.txt"), 0);
        }
        if (this.originalFolder != newFolder && !ModelUtilities.isCubeNameUniqueToFolder(newName, newFolder)) {
            throw new OLAPException(bundle.getString("OLAPSharedDimension.NameUniqueToFolder.txt"), 0);
        }
        this.checkVerifyName = true;
    }

    private void verifyMetadataOLAPSchema() throws OLAPException {
        try {
            AssociationList schemas;
            SharedDimension jomaDim = (SharedDimension)this.metadataObject;
            if (jomaDim != null && (schemas = jomaDim.getAssociatedOLAPSchemas()).isEmpty()) {
                this.sharedDimVerifyMessage.append(bundle.getString("OLAPSharedDimension.NoSchemaSelected.txt"));
                this.errorLevel = 3;
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public void verifyOLAPSchema() throws OLAPException {
        if (this.schema == null) {
            throw new OLAPException(bundle.getString("OLAPSharedDimension.NoSchemaSelected.txt"), 0);
        }
        try {
            MdFactory factory;
            MdSecurityUtil securityUtil;
            if (this.schema != this.originalSchema && !(securityUtil = (factory = this.objectStore.getFactory()).getSecurityUtil()).isWriteAuthorized(this.schema.getCMetadataType(), this.schema.getId())) {
                throw new OLAPException(bundle.formatString("OLAPcube.NoWriteSchema.fmt.txt", (Object)this.schema.getName()), 0);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    @Override
    StringBuffer verifyUDTTables() throws OLAPException {
        StringBuffer udtTables = new StringBuffer();
        LanguageSet language = this.getLanguageSet();
        try {
            PhysicalTable physicalTable;
            AssociationList tablePackage;
            if (language.isCubeMultipleLanguageSupported() && !(tablePackage = (physicalTable = this.inputSharedTable.getTable()).getTablePackages()).isEmpty()) {
                List listOfTables = null;
                String libraryId = null;
                CMetadata object = (CMetadata)tablePackage.get(0);
                if (object instanceof SASLibrary) {
                    SASLibrary sasLibrary = (SASLibrary)object;
                    libraryId = sasLibrary.getId();
                    listOfTables = this.tableSet.getPhysicalTablesByLibraries(libraryId, 0, "");
                } else if (object instanceof DatabaseSchema) {
                    DatabaseSchema databaseSchema = (DatabaseSchema)object;
                    String databaseId = databaseSchema.getId();
                    SASLibrary sasLibrary = LibraryUtil.getLibrary((DataTable)physicalTable, null);
                    libraryId = sasLibrary.getId();
                    listOfTables = this.tableSet.getPhysicalTablesByLibraries(libraryId, 1, databaseId);
                }
                List languages = language.getSelectedLocales();
                boolean found = false;
                int i = 1;
                int size = languages.size();
                while (i < size & !found) {
                    found = false;
                    String nameOfTable = this.inputSharedTable.getTable().getName() + (String)languages.get(i);
                    int t = 0;
                    int tableSize = listOfTables.size();
                    while (t < tableSize & !found) {
                        HashMap mapOfTables = (HashMap)listOfTables.get(t);
                        String tableName = (String)mapOfTables.get("Name");
                        if (nameOfTable.equalsIgnoreCase(tableName)) {
                            found = true;
                        }
                        ++t;
                    }
                    if (!found) {
                        udtTables.append(bundle.formatString("OLAPDimension.DimensionPanel.NoUDTTable.fmt.txt", (Object)nameOfTable, (Object)this.name));
                    }
                    ++i;
                }
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        return udtTables;
    }

    public void verifyMaximumLevelsPerCube() throws OLAPException {
        int sizeOfLevels = this.getLevels().size();
        if (sizeOfLevels + 1 > 256) {
            throw new OLAPException(bundle.getString("OLAPLevel.TooManyLevelsPerCube.txt"), 0);
        }
    }

    public void verifyMaximumHierarchiesPerCube() throws OLAPException {
        this.getHierarchies();
        if (this.hierarchies.size() + 1 > 128) {
            throw new OLAPException(bundle.getString("OLAPHierarchy.TooManyHierarchiesPerCube.txt"), 0);
        }
    }

    @Override
    public void deleteMapInformation() throws OLAPException {
        ClassifierMap classifierMap = this.getMapClassifierMap();
        if (classifierMap != null) {
            MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)classifierMap, "", bundle.getString("MdException.GenericError.txt"));
        }
        this.mapInfoClassifierMap = null;
        this.getLevels();
        for (int i = 0; i < this.levels.size(); ++i) {
            OLAPLevel level = (OLAPLevel)this.levels.get(i);
            level.deleteMapInformation();
        }
        this.setMapServer(null);
        this.setMapService(null);
    }

    private void verifyVersionNumber() throws OLAPException {
        SharedDimension dimension = (SharedDimension)this.metadataObject;
        try {
            UsageVersion usageVersion;
            if (dimension != null && !(usageVersion = UsageVersion.decode((double)dimension.getUsageVersion())).isCompatible(new UsageVersion(1, 0, 0), new UsageVersion(1, 0, 0))) {
                throw new OLAPException(bundle.formatString("OLAPSharedDimension.WrongVersion.fmt.txt", (Object)String.valueOf(usageVersion.getMajorVersion())), 0);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }
}

