/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPProperty;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.olapadmin.designer.model.AbstractInputTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.util.Strings;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class OLAPMemberProperty
extends AbstractOLAPModel {
    static WAdminResource bundle = new WAdminResource(OLAPMemberProperty.class);
    private OLAPLevel associatedLevel;
    private boolean changedAssociatedLevel;
    private boolean changedColumn;
    boolean changedSASFormat;
    private OLAPColumn column;
    private OLAPList hierarchies;
    private String sasFormat;
    private List backUpHierarchies;
    private boolean changedMetadata;
    private boolean checkVerifyUnique;
    private boolean checkVerifyName;
    private boolean checkVerifyHierarchies;
    private boolean checkVerifyLevel;
    private boolean checkVerifyColumn;
    private static final String PROPERTY = "   PROPERTY ";
    private static final String LEVEL = "      LEVEL          = ";
    private static final String HIERARCHY = "      HIERARCHY      = (";
    private static final String HIERARCHYS_INDENT = "         ";
    private static final String HIERARCHYS_END = "         ) /* HIERARCHIES */";
    private static final String COLUMN = "      COLUMN         = ";
    private static final String MP_MLSID = "      MLSID          = ";
    private static final String CAPTION = "      CAPTION        = '";
    private static final String DESCRIPTION = "      DESCRIPTION    = '";
    private static final String ESRI_MAP_FIELD = "      ESRI_MAP_FIELD = '";
    private static final String SAS_MEMBER_DATE = "SAS_MEMBER_DATE";

    OLAPMemberProperty() {
        this.changedMetadata = true;
    }

    OLAPMemberProperty(OLAPProperty inputMetadataObject) {
        this.metadataObject = inputMetadataObject;
    }

    boolean changedColumn() {
        if (!this.changedColumn) {
            try {
                this.changedColumn = this.getColumn().isChanged();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return this.changedColumn;
    }

    @Override
    public void clear() throws OLAPException {
        super.clear();
        this.associatedLevel = null;
        this.setColumn(null);
        this.setSASFormat("");
        this.changedAssociatedLevel = false;
        this.changedColumn = false;
        this.changedSASFormat = false;
    }

    public void delete() throws OLAPException {
        this.propertySet.getOLAPProperties().remove(this);
    }

    StringBuffer generateCode() throws OLAPException {
        Integer number;
        StringBuffer olapPropertyStatement = new StringBuffer();
        this.getAssociatedLevel();
        olapPropertyStatement.append(ModelUtilities.newline).append(PROPERTY).append(ModelUtilities.getSasName(this.getName()));
        olapPropertyStatement.append(ModelUtilities.newline).append(LEVEL).append(ModelUtilities.getSasName(this.associatedLevel.getName()));
        OLAPList allHierarchies = this.getHierarchies();
        this.getColumn();
        olapPropertyStatement.append(ModelUtilities.newline).append(COLUMN).append(ModelUtilities.getSasName(this.column.getSASColumnName()));
        String desc = ModelUtilities.internalQuote(ModelUtilities.trim(this.getDesc()));
        String tempNotes = ModelUtilities.internalQuote(ModelUtilities.trim(this.getNotes()));
        if (!ModelUtilities.isBlank(this.getDesc())) {
            olapPropertyStatement.append(ModelUtilities.newline).append(CAPTION).append(desc).append("'");
        }
        if (!ModelUtilities.isBlank(this.getNotes())) {
            olapPropertyStatement.append(ModelUtilities.newline).append(DESCRIPTION).append(tempNotes).append("'");
        }
        if ((number = this.getMLSID()) != null) {
            olapPropertyStatement.append(ModelUtilities.newline).append(MP_MLSID).append(number.toString()).append(ModelUtilities.newline);
        }
        if (this.getName().equalsIgnoreCase("SAS_SPATIAL_ID")) {
            try {
                Property propObj = this.associatedLevel.getMapFieldId();
                if (propObj != null) {
                    String columnName = propObj.getName();
                    olapPropertyStatement.append(ModelUtilities.newline).append(ESRI_MAP_FIELD).append(columnName).append("'");
                }
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        olapPropertyStatement.append(ModelUtilities.newline).append(HIERARCHY);
        olapPropertyStatement.append(ModelUtilities.listFormatter(allHierarchies, HIERARCHYS_INDENT, " "));
        olapPropertyStatement.append(HIERARCHYS_END);
        olapPropertyStatement.append(";");
        return olapPropertyStatement;
    }

    public OLAPLevel getAssociatedLevel() throws OLAPException {
        this.verifyDeleted();
        try {
            if (this.associatedLevel == null & this.metadataObject != null) {
                OLAPProperty jomaObject = (OLAPProperty)this.metadataObject;
                Level jomaLevel = jomaObject.getAssociatedLevel();
                this.associatedLevel = (OLAPLevel)this.dimensionSet.metaLevelLevel.get(jomaLevel);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return this.associatedLevel;
    }

    private List getFeatureMaps(OLAPProperty propertyObject) throws MdException, RemoteException {
        int i;
        ArrayList<Object> featureMaps = new ArrayList<Object>();
        AssociationList targetFeatureMaps = propertyObject.getTargetFeatureMaps();
        AssociationList targetTransformations = propertyObject.getTargetTransformations();
        for (i = targetFeatureMaps.size() - 1; i >= 0; --i) {
            featureMaps.add(targetFeatureMaps.get(i));
        }
        for (i = targetTransformations.size() - 1; i >= 0; --i) {
            featureMaps.add(targetTransformations.get(i));
        }
        return featureMaps;
    }

    public OLAPColumn getColumn() throws OLAPException {
        this.verifyDeleted();
        if (this.column == null & this.metadataObject != null) {
            try {
                OLAPProperty jomaObject = (OLAPProperty)this.metadataObject;
                List targetFeatureMaps = this.getFeatureMaps(jomaObject);
                boolean foundFM = false;
                FeatureMap featureMap = null;
                for (int kk = 0; kk < targetFeatureMaps.size() && !foundFM; ++kk) {
                    featureMap = (FeatureMap)targetFeatureMaps.get(kk);
                    if (!featureMap.getTransformRole().equalsIgnoreCase("ONETOONE")) continue;
                    foundFM = true;
                }
                if (foundFM) {
                    AssociationList sources = featureMap.getFeatureSources();
                    if (sources.isEmpty()) {
                        sources = featureMap.getTransformationSources();
                    }
                    if (!sources.isEmpty()) {
                        Column jomaColumn = (Column)sources.elementAt(0);
                        PhysicalTable table = (PhysicalTable)jomaColumn.getTable();
                        if (!this.propertySet.isShared()) {
                            DimensionTable dimTable = this.tableSet.getDimensionTable(table);
                            this.column = dimTable.getColumn(jomaColumn);
                        } else {
                            SharedDimensionTable dimTable = this.tableSet.getSharedDimensionTable(table);
                            this.column = dimTable.getColumn(jomaColumn);
                        }
                    }
                }
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.column;
    }

    public OLAPList getHierarchies() throws OLAPException {
        this.verifyDeleted();
        try {
            if (this.hierarchies == null) {
                this.hierarchies = new OLAPList(OLAPHierarchy.class);
                this.hierarchies.setParentObject(this);
                this.backUpHierarchies = new ArrayList();
                if (this.metadataObject != null) {
                    OLAPProperty jomaObject = (OLAPProperty)this.metadataObject;
                    boolean found = false;
                    OLAPList allHierarchies = this.dimensionSet.getHierarchies();
                    AssociationList tempHierarchies = jomaObject.getHierarchies(false);
                    int size = tempHierarchies.size();
                    for (int i = 0; i < size; ++i) {
                        found = false;
                        Hierarchy jomaHierarchy = (Hierarchy)tempHierarchies.elementAt(i);
                        int t = 0;
                        int tsize = allHierarchies.size();
                        while (t < tsize & !found) {
                            OLAPHierarchy olapHierarchy = (OLAPHierarchy)allHierarchies.get(t);
                            Hierarchy dimensionHierarchy = (Hierarchy)olapHierarchy.metadataObject;
                            if (dimensionHierarchy != null && dimensionHierarchy.equals(jomaHierarchy)) {
                                this.hierarchies.add(olapHierarchy);
                                this.backUpHierarchies.add(olapHierarchy);
                                found = true;
                            }
                            ++t;
                        }
                    }
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return this.hierarchies;
    }

    public OLAPMemberPropertySet getOLAPMemberPropertySet() {
        return this.propertySet;
    }

    public String getSASFormat() {
        this.verifyDeleted();
        try {
            if (ModelUtilities.isBlank(this.sasFormat) && this.metadataObject != null) {
                OLAPProperty tempMetadataObject = (OLAPProperty)this.metadataObject;
                this.sasFormat = tempMetadataObject.getSASFormat();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.sasFormat;
    }

    @Override
    public boolean isMetadataUpdated() {
        if (this.changedAssociatedLevel || this.changedColumn() || this.changedSASFormat) {
            this.changedMetadata = true;
        }
        if (!this.changedMetadata) {
            this.changedMetadata = super.isMetadataUpdated();
        }
        return this.changedMetadata;
    }

    public boolean isHierarchiesUpdated() {
        return this.hierarchies != null && !this.hierarchies.equals(this.backUpHierarchies);
    }

    @Override
    public void setName(String inputName) {
        super.setName(inputName);
        this.checkVerifyName = false;
        this.setUpChanges("setName", String.class, inputName);
    }

    @Override
    public void setDesc(String inputDesc) {
        super.setDesc(inputDesc);
        this.setUpChanges("setDesc", String.class, inputDesc);
    }

    @Override
    public void setNotes(String inputNotes) {
        super.setNotes(inputNotes);
        this.setUpChanges("setNotes", String.class, inputNotes);
    }

    public void setAssociatedLevel(OLAPLevel inputAssociatedLevel) throws OLAPException {
        this.verifyDeleted();
        this.changedAssociatedLevel = true;
        this.associatedLevel = inputAssociatedLevel;
        OLAPList listOfProperties = this.associatedLevel.getOLAPProperties();
        if (!listOfProperties.contains(this)) {
            listOfProperties.add(this);
        }
        this.checkVerifyLevel = false;
        this.setUpChanges("setAssociatedLevel", OLAPLevel.class, inputAssociatedLevel);
    }

    public void setColumn(OLAPColumn inputColumn) {
        this.verifyDeleted();
        this.changedColumn = true;
        this.column = inputColumn;
        this.checkVerifyColumn = false;
        this.setUpChanges("setColumn", OLAPColumn.class, inputColumn);
    }

    public void setSASFormat(String inputSasFormat) {
        this.verifyDeleted();
        this.sasFormat = inputSasFormat;
        this.changedSASFormat = true;
        this.setUpChanges("setSASFormat", String.class, inputSasFormat);
    }

    private void updateColumnMetadata() throws OLAPException {
        try {
            this.getColumn();
            if (!this.checkVerifyColumn) {
                this.verifyColumn();
            }
            OLAPProperty olapProperty = (OLAPProperty)this.metadataObject;
            PhysicalTable table = this.column.getTable();
            DimensionTable dimTable = this.tableSet.getDimensionTable(table);
            ClassifierMap classifierMap = dimTable.getClassifierMap();
            List targetFeatureMaps = this.getFeatureMaps(olapProperty);
            FeatureMap featureMap = null;
            if (!targetFeatureMaps.isEmpty()) {
                featureMap = (FeatureMap)targetFeatureMaps.get(0);
            } else {
                featureMap = (FeatureMap)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "FeatureMap", this.owningCube.getRepositoryShortFQID());
                featureMap.setName("OLAPPROPERTY_map");
                featureMap.setTransformRole("ONETOONE");
                featureMap.getFeatureTargets().addElement((Object)olapProperty);
                featureMap.setAssociatedClassifierMap(classifierMap);
            }
            AssociationList featureSources = featureMap.getFeatureSources();
            AssociationList transformationSources = featureMap.getTransformationSources();
            featureSources.clear();
            AssociationList featureMaps = olapProperty.getTargetFeatureMaps();
            AssociationList transformations = olapProperty.getTargetTransformations();
            featureMaps.remove((Object)featureMap);
            transformations.remove((Object)featureMap);
            if (this.tableSet == null) {
                this.tableSet = this.owningCube.getTableSet();
            }
            if (!this.tableSet.isLoadStarSchema() || this.tableSet.isLoadStarSchema() && dimTable.isLoadTable()) {
                featureMaps.add((Object)featureMap);
                featureSources.addElement((Object)this.column.metadataObject);
            } else {
                transformations.add((Object)featureMap);
                transformationSources.addElement((Object)this.column.metadataObject);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        this.changedColumn = false;
    }

    private void updateColumnSharedDimensionMetadata() throws OLAPException {
        try {
            this.getColumn();
            if (!this.checkVerifyColumn) {
                this.verifyColumn();
            }
            OLAPProperty olapProperty = (OLAPProperty)this.metadataObject;
            PhysicalTable table = this.column.getTable();
            SharedDimensionTable dimTable = this.tableSet.getSharedDimensionTable(table);
            ClassifierMap classifierMap = dimTable.getClassifierMap();
            List targetFeatureMaps = this.getFeatureMaps(olapProperty);
            FeatureMap featureMap = null;
            if (!targetFeatureMaps.isEmpty()) {
                featureMap = (FeatureMap)targetFeatureMaps.get(0);
            } else {
                featureMap = (FeatureMap)MetadataTemplate.createMetadata(this.owningSharedDimension.getObjectStore(), "FeatureMap", this.owningSharedDimension.getRepositoryShortFQID());
                featureMap.setName("OLAPPROPERTY_map");
                featureMap.setTransformRole("ONETOONE");
                featureMap.getFeatureTargets().addElement((Object)olapProperty);
                featureMap.setAssociatedClassifierMap(classifierMap);
            }
            AssociationList featureSources = featureMap.getFeatureSources();
            AssociationList transformationSources = featureMap.getTransformationSources();
            featureSources.clear();
            AssociationList featureMaps = olapProperty.getTargetFeatureMaps();
            AssociationList transformations = olapProperty.getTargetTransformations();
            featureMaps.remove((Object)featureMap);
            transformations.remove((Object)featureMap);
            if (this.tableSet == null) {
                this.tableSet = this.owningSharedDimension.getTableSet();
            }
            transformations.add((Object)featureMap);
            transformationSources.addElement((Object)this.column.metadataObject);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        this.changedColumn = false;
    }

    private void updateHierarchiesMetadata() throws OLAPException {
        try {
            OLAPHierarchy olapHierarchy;
            int i;
            if (!this.checkVerifyHierarchies) {
                this.verifyHierarchies();
            }
            OLAPProperty olapProperty = (OLAPProperty)this.metadataObject;
            AssociationList listOfHierarchies = olapProperty.getHierarchies(false);
            this.getHierarchies();
            int size = this.hierarchies.size();
            for (i = 0; i < size; ++i) {
                olapHierarchy = (OLAPHierarchy)this.hierarchies.get(i);
                OLAPList listOfMemberProperties = olapHierarchy.getOLAPProperties();
                if (!listOfMemberProperties.contains(this)) {
                    Hierarchy jomaHierarchy = (Hierarchy)olapHierarchy.metadataObject;
                    AssociationList jomaListOfMemberProperties = jomaHierarchy.getOLAPProperties(false);
                    jomaListOfMemberProperties.add((Object)olapProperty);
                }
                if (this.backUpHierarchies.contains(olapHierarchy)) continue;
                listOfHierarchies.add((Object)olapHierarchy.metadataObject);
            }
            size = this.backUpHierarchies.size();
            for (i = 0; i < size; ++i) {
                olapHierarchy = (OLAPHierarchy)this.backUpHierarchies.get(i);
                if (this.hierarchies.contains(olapHierarchy)) continue;
                listOfHierarchies.remove((Object)olapHierarchy.metadataObject);
                Hierarchy jomaHierarchy = (Hierarchy)olapHierarchy.metadataObject;
                AssociationList jomaListOfMemberProperties = jomaHierarchy.getOLAPProperties(false);
                jomaListOfMemberProperties.remove((Object)olapProperty);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    @Override
    public void updateMetadata() throws OLAPException {
        if (this.metadataObject == null && this.owningCube != null) {
            this.metadataObject = (OLAPProperty)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "OLAPProperty", this.owningCube.getRepositoryShortFQID());
        } else if (this.metadataObject == null && this.owningSharedDimension != null) {
            this.metadataObject = (OLAPProperty)MetadataTemplate.createMetadata(this.owningSharedDimension.getObjectStore(), "OLAPProperty", this.owningSharedDimension.getRepositoryShortFQID());
        }
        OLAPProperty olapProperty = (OLAPProperty)this.metadataObject;
        OLAPLevel level = this.getAssociatedLevel();
        Level jomaLevel = (Level)this.getAssociatedLevel().metadataObject;
        OLAPDimension dim = level.getDimension();
        if (dim.wasTime && !dim.isTime() && this.getName().equalsIgnoreCase(SAS_MEMBER_DATE)) {
            this.propertySet.getOLAPMemberPropertyDeleteList().add(this);
            return;
        }
        if (!this.checkVerifyName) {
            this.verifyName();
        }
        if (!this.checkVerifyUnique) {
            this.verifyUniqueOLAPMemberProperty();
        }
        super.updateMetadata();
        if (this.changedAssociatedLevel & !this.checkVerifyLevel) {
            this.verifyAssociatedLevel();
        }
        try {
            olapProperty.setAssociatedLevel(jomaLevel);
            if (this.owningCube != null) {
                this.updateColumnMetadata();
            } else if (this.owningSharedDimension != null) {
                this.updateColumnSharedDimensionMetadata();
            }
            if (!this.backUpHierarchies.equals(this.hierarchies)) {
                this.updateHierarchiesMetadata();
            }
            if (this.changedSASFormat) {
                olapProperty.setSASFormat(Strings.removeWhitespace((String)this.getSASFormat()));
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        this.updateOptionsMetadata();
        this.changedSASFormat = false;
        this.changedColumn = false;
        this.changedAssociatedLevel = false;
        this.changedMetadata = false;
    }

    private void updateOptionsMetadata() throws OLAPException {
        if (this.owningCube != null) {
            this.optionSet = this.owningCube.getOptionsSet();
        } else if (this.owningSharedDimension != null) {
            this.optionSet = this.owningSharedDimension.getOptionSet();
        }
        if (this.optionSet != null) {
            List options = this.optionSet.getOptions(this);
            int size = options.size();
            for (int i = 0; i < size; ++i) {
                Option option = (Option)options.get(i);
                option.updateMetadata();
            }
        }
    }

    public void verifyColumn() throws OLAPException {
        OLAPColumn tempColumn = this.getColumn();
        if (tempColumn == null) {
            if (this.associatedLevel != null) {
                throw new OLAPException(bundle.formatString("OLAPMemberProperty.NoPropertyForLevel.fmt.txt", (Object)this.associatedLevel.getName()), 0);
            }
            throw new OLAPException(bundle.getString("OLAPMemberProperty.NoProperty.txt"), 0);
        }
        this.checkVerifyColumn = true;
    }

    public void verifyAssociatedLevel() throws OLAPException {
        OLAPLevel level = this.getAssociatedLevel();
        if (level == null) {
            throw new OLAPException(bundle.formatString("OLAPMemberProperty.NoLevelsForMemberProperty.fmt.txt", (Object)this.name), 0);
        }
        this.checkVerifyLevel = true;
    }

    public void verifyHierarchies() throws OLAPException {
        this.getHierarchies();
        if (this.hierarchies.isEmpty()) {
            throw new OLAPException(bundle.formatString("OLAPMemberProperty.NoHierarchyForLevel.fmt.txt", (Object)this.name), 0);
        }
        this.checkVerifyHierarchies = true;
    }

    StringBuffer verifyMetadata() throws OLAPException {
        AbstractInputTable inputTable;
        StringBuffer propertyMessage = new StringBuffer();
        OLAPMemberPropertySet propertySet = null;
        if (this.owningCube != null) {
            propertySet = this.owningCube.getOLAPMemberPropertySet();
        } else if (this.owningSharedDimension != null) {
            propertySet = this.owningSharedDimension.getOLAPMemberPropertySet();
        }
        OLAPList starSchemaProperties = propertySet.getStarSchemaProperties();
        PhysicalTable loadTable = null;
        MdObjectStore objectStore = null;
        if (this.owningCube != null) {
            this.tableSet = this.owningCube.getTableSet();
            inputTable = this.tableSet.getLoadTable();
            if (inputTable != null) {
                loadTable = inputTable.getTable();
            }
            objectStore = this.owningCube.getObjectStore();
        } else if (this.owningSharedDimension != null) {
            this.tableSet = this.owningSharedDimension.getTableSet();
            inputTable = this.owningSharedDimension.getSharedDimensionTable();
            if (inputTable != null) {
                loadTable = inputTable.getTable();
            }
            objectStore = this.owningSharedDimension.getObjectStore();
        }
        boolean isStarDim = starSchemaProperties.contains(this);
        if (this.metadataObject != null && (isStarDim || !isStarDim && loadTable != null)) {
            OLAPProperty jomaProperty = (OLAPProperty)this.metadataObject;
            try {
                List propertyList = this.getFeatureMaps(jomaProperty);
                boolean foundFM = false;
                FeatureMap featureMap = null;
                for (int kk = 0; kk < propertyList.size() && !foundFM; ++kk) {
                    featureMap = (FeatureMap)propertyList.get(kk);
                    if (!featureMap.getTransformRole().equalsIgnoreCase("ONETOONE")) continue;
                    foundFM = true;
                }
                AssociationList sources = null;
                if (foundFM) {
                    sources = featureMap.getFeatureSources();
                    if (sources.isEmpty()) {
                        sources = featureMap.getTransformationSources();
                    }
                    if (sources == null || sources != null && sources.isEmpty()) {
                        ClassifierMap classifierMap = featureMap.getAssociatedClassifierMap();
                        String tableName = "";
                        if (classifierMap != null) {
                            AssociationList classifierSources = classifierMap.getClassifierSources(false);
                            if (classifierSources.isEmpty()) {
                                classifierSources = classifierMap.getTransformationSources(false);
                            }
                            if (!classifierSources.isEmpty()) {
                                PhysicalTable table = (PhysicalTable)classifierSources.get(0);
                                tableName = table.getName();
                            }
                        }
                        objectStore.removeObjectFromStore((CMetadata)jomaProperty, "<Templates><TargetFeatureMaps/><Properties/></Templates>");
                        propertyMessage.append(bundle.formatString("OLAPMemberProperty.OLAPPropertyRemoved.fmt.txt", (Object)this.getName(), (Object)tableName));
                        propertySet.getOLAPProperties().getTheList().remove(this);
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return propertyMessage;
    }

    @Override
    public void verifyName() throws OLAPException {
        super.verifyName();
        this.verifySASName();
        this.checkVerifyName = true;
    }

    public void verifyUniqueOLAPMemberProperty() throws OLAPException {
        OLAPList allProperties = this.propertySet.getOLAPProperties();
        this.getName();
        OLAPList selectedHierarchies = this.getHierarchies();
        for (int i = 0; i < allProperties.size(); ++i) {
            OLAPMemberProperty OLAPProperty2 = (OLAPMemberProperty)allProperties.get(i);
            if (!(this.name.equalsIgnoreCase(OLAPProperty2.getName()) & !OLAPProperty2.equals(this))) continue;
            OLAPLevel thisOLAPPropertyLevel = this.getAssociatedLevel();
            OLAPLevel checkOLAPPropertyLevel = OLAPProperty2.getAssociatedLevel();
            if (thisOLAPPropertyLevel == null || !thisOLAPPropertyLevel.equals(checkOLAPPropertyLevel)) continue;
            OLAPList currentHierarchyList = OLAPProperty2.getHierarchies();
            for (int t = 0; t < selectedHierarchies.size(); ++t) {
                OLAPHierarchy nextHierarchy = (OLAPHierarchy)selectedHierarchies.get(t);
                if (!currentHierarchyList.contains(nextHierarchy)) continue;
                throw new OLAPException(bundle.formatString("OLAPMemberProperty.DuplicateMemberProperty.fmt.txt", (Object)thisOLAPPropertyLevel.getName(), (Object)nextHierarchy.getName()), 0);
            }
        }
        this.checkVerifyUnique = true;
    }
}

