/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidAuthType;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.swing.visuals.util.Util;
import com.sas.util.Strings;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.StringHolder;

public class ModelUtilities {
    static WAdminResource bundle = new WAdminResource(ModelUtilities.class);
    private static final String latinSASCharacters = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String latinFirstCharacters = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String newline = System.getProperty("line.separator");
    private static List EMPTY_LIST;
    public static String[] formats;
    public static List dateCheck;
    public static String[] characterFormat;
    public static String[] numericFormats;
    static final String FORMAT_SEARCH = "OPTIONS FMTSEARCH = (";
    static final String PROC_OLAP = "PROC OLAP";
    static final String CUBE_EQUALS = "   CUBE                   = ";
    static final String PROJECT_EQUALS = "   PROJECT                = ";
    static final String DATA_EQUALS = "   DATA                   = ";
    static final String NO_DIMENSION_UPDATE = "   NONUPDATEABLE";
    static final String FACT_EQUALS = "   FACT                   = ";
    static final String DRILLTHROUGH_EQUALS = "   DRILLTHROUGH_TABLE     = ";
    static final String PATH_EQUALS = "   PATH                   = ";
    static final String DESCRIPTION_EQUALS = "   DESCRIPTION            = ";
    static final String WORKPATH_EQUALS = "   WORKPATH               = ";
    static final String ESRI_SERVER = "   ESRI_MAP_SERVER        = '";
    static final String MAX_RETRIES = "   MAX_RETRIES            = ";
    static final String MAX_RETRY_WAIT = "   MAX_RETRY_WAIT         = ";
    static final String MIN_RETRY_WAIT = "   MIN_RETRY_WAIT         = ";
    static final String EMPTY_CHAR_EQUALS = "   EMPTY_CHAR             = ";
    static final String EMPTY_NUM_EQUALS = "   EMPTY_NUM              = ";
    static final String IGNORE_MISSING_DIMKEYS = "   IGNORE_MISSING_DIMKEYS = ";
    static final String DATAPATH_EQUALS = "   DATAPATH               = ";
    static final String INDEXPATH_EQUALS = "   INDEXPATH              = ";
    static final String INDEXSORTSIZE_EQUALS = "   INDEXSORTSIZE          = ";
    static final String MAXTHREADS_EQUALS = "   MAXTHREADS             = ";
    static final String ASYNCINDEXLIMIT_EQUALS = "   ASYNCINDEXLIMIT        = ";
    static final String CONCURRENT_EQUALS = "   CONCURRENT             = ";
    static final String PARTSIZE_EQUALS = "   PARTSIZE               = ";
    static final String SEGSIZE_EQUALS = "   SEGSIZE                = ";
    static final String NAME_EQUALS = "   NAME                   = ";
    static final String DTMEMPREF_EQUALS = "   DTMEMPREF              = ";
    static final String DTLIBREF_EQUALS = "   DTLIBREF               = ";
    static final String DTMEMPREFOPTS_EQUALS = "   DTMEMPREFOPTS          = ";
    static final String COALESCE_AGGREGATIONS = "   COALESCE_AGGREGATIONS ";
    static final String COALESCE_AGGREGATION = "   COALESCE_AGGREGATION ";
    static final String DEFINE = "   DEFINE ";
    static final String COMPRESS = "   COMPRESS";
    static final String NOCOMPRESS = "   NOCOMPRESS";
    static final String INDEX = "   INDEX";
    static final String NOINDEX = "   NOINDEX";
    static final String COMPACT_NWAY = "   COMPACT_NWAY";
    static final String NO_NWAY = "   NO_NWAY";
    static final String DELETE = "   DELETE";
    static final String DELETE_PHYSICAL = "   DELETE_PHYSICAL";
    static final String SYNCRONIZE_LEVELS = "   SYNCHRONIZE_LEVELS";
    static final String ADD_DATA = "   ADD_DATA";
    static final String SHARED_DIMENSION = "\tDIMENSION ";
    static final String SHARED = "   SHARED ";
    static final String DIM_TABLE = "   DIMTABLE = ";
    static final String UPDATE_INPLACE = "   UPDATE_INPLACE";
    static final String UPDATE_DISPLAY_NAMES = "   UPDATE_DISPLAY_NAMES";
    static final String UPDATE_DIMENSION = "   UPDATE_DIMENSION = ";
    static final String OUTCUBE = "   OUTCUBE                = ";
    static final String OUTSCHEMA = "   OUTSCHEMA              = ";
    static final String METASVR = "   METASVR";
    static final String HOST = "      HOST        = ";
    static final String PORT = "      PORT        = ";
    static final String REPOSITORY = "      REPOSITORY  = ";
    static final String OLAP_SCHEMA = "      OLAP_SCHEMA = ";
    static final String DROP_AGGREGATION = "   DROP_AGGREGATION";
    static final String USER_DEFINED_TRANSLATIONS = "   USER_DEFINED_TRANSLATIONS";
    static final String RUN = "   RUN;";
    static final String FORMAT = "   FORMAT ";
    static final String CALCULATEDMEMBER = "Calculated Member";
    static final String NAMEDSET = "Named Set";
    static final String MEMBER = "         Member ";
    static final String SET = "         Set ";
    static final String AS = " AS ";
    static final String REACHTHRUTABLE = "ReachthruTable";
    static final String LOADTABLE = "LoadTable";
    static final String SECURITY_SUBSET_PROC = "   SECURITY_SUBSET        = YES";
    static final String SECURITY_SUBSET_PROC_NO = "   SECURITY_SUBSET        = NO";
    static final String SECURITY_SUBSET = "SECURITY_SUBSET";
    static final String SORTSEQ = "   SORTSEQ = LINGUISTIC";
    static final String OPEN_PARENTHESIS = "                       (";
    static final String COLLATION = "                         COLLATION = ";
    static final String LOCALE = "                         LOCALE = ";
    static final String CLOSE_PARENTHESIS = "                       )";
    static final String CUBETABELIBREF = "   CUBETABLELIBREF        = ";
    static final String CUBETABLECAPPREF = "   CUBETABLECAPPREF       = ";
    static final String CUBE_MLSID = "   MLSID                  = ";
    static final String REORGANIZE_LEVELS = "   REORGANIZE_LEVELS ";
    static final String REORGANIZE_LEVEL = "   REORGANIZE_LEVEL ";
    static final String DIMENSION = "   DIMENSION ";
    static final String DIMTABELIBREF = "   DIMTABLELIBREF  = ";
    static final String HIERARCHY = "   HIERARCHY ";
    static final String LEVEL = "   LEVEL ";
    static final String MEASURE = "   MEASURE ";
    static final String MEMBER_PROPERTY = "   PROPERTY ";
    static final String CAPTION_EQUALS = "     CAPTION = '";
    static final String UPDATE_DESC_EQUALS = "     DESCRIPTION = '";
    static final String DEFAULT_MEMBER_EQUALS = "     DEFAULT_MEMBER = ";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String VALIDVARNAMESYNTAX = "OPTIONS VALIDVARNAME=ANY;";
    public static final String DIMKEYS_TERSE = "TERSE";
    public static final String DIMKEYS_VERBOSE = "VERBOSE";
    public static final String DIMKEYS_ERROR = "ERROR";
    public static final String MLS_CAPTION_TABLE = "CaptionTableObject";
    public static final String MLS_CAPTION_NAME = "_CaptionTable";
    public static final String MAX_RETRY_ATTEMPT_KEY = "ProcOlap.MaxRetry";
    public static final String MAX_RETRY_SECONDS_KEY = "ProcOlap.MaxWait";
    public static final String MIN_RETRY_SECONDS_KEY = "ProcOlap.MinWait";
    public static final String RECONNECT_TYPE_KEY = "ProcOlap.ReconnectType";
    public static StringBuffer XML_SELECT;
    public static StringBuffer XML_SELECT_SHARED_DIM;
    public static final String REPLACE_TYPE = "_REPLACE_TYPE_";
    public static final String REPLACE_REPOSITORY = "_REPLACE_REPOSITORY_TEMPLATE_";
    public static final String REPLACE_ASSOCIATED = "_REPLACE_ASSOCIATED_TEMPLATE_";
    public static final String REPLACE_ID = "_REPLACE_ID_TEMPLATE_";
    public static final String REPLACE_SEARCH = "_REPLACE_SEARCH_TEMPLATE_";
    public static final String TEMPLATE = "<Templates></Templates>";
    private static final int MAX_ATTEMPTS = 20;
    private static final String preferredCubeName = "CUBE";
    private static final String preferredDimensionName = "DIMENSION";
    private static final String preferredDefaultName = "CUBEOBJECT";
    private static Map preferredNames;
    private static final int FLAGS = 8320;
    private static WorkspaceFile fileAppDefaults;
    private static final String DEFAULT_OLAPSCHEMA = "CubeStudio.DefaultOLAPSchema";
    private static final String DEFAULT_FOLDER = "LastSelectedTreeIDGroupPanel";
    static final String INCLUDE_CALCULATED_MEMBERS = "INCLUDE_CALCULATED_MEMBERS";
    static final String NOINCLUDE_CALCULATED_MEMBERS = "NOINCLUDE_CALCULATED_MEMBERS";
    public static final String CUBE_PUBLIC_TYPE = "Cube";
    public static final String CUBE_VERSION_MAJOR_NUMBER = "4";
    public static final String CUBE_VERSION_MINOR_NUMBER = "0";
    public static final String CUBE_VERSION_MICRO_NUMBER = "0";
    public static final String SHAREDDIMENSION_CUBE_VERSION_MAJOR_NUMBER = "5";
    public static final String MLS_CUBE_VERSION_MAJOR_NUMBER = "4";
    public static final String MLS_CUBE_VERSION_MINOR_NUMBER = "1";
    public static final String DIMENSION_PUBLIC_TYPE = "Dimension";
    public static final String DIMENSION_VERSION_MAJOR_NUMBER = "4";
    public static final String DIMENSION_VERSION_MINOR_NUMBER = "0";
    public static final String DIMENSION_VERSION_MICRO_NUMBER = "0";
    public static final String SHAREDDIMENSION_PUBLIC_TYPE = "SharedDimension";
    public static final String SHAREDDIMENSION_VERSION_MAJOR_NUMBER = "1";
    public static final String SHAREDDIMENSION_VERSION_MINOR_NUMBER = "0";
    public static final String SHAREDDIMENSION_VERSION_MICRO_NUMBER = "0";
    public static final String HIERARCHY_PUBLIC_TYPE = "Hierarchy";
    public static final String HIERARCHY_VERSION_MAJOR_NUMBER = "4";
    public static final String HIERARCHY_VERSION_MINOR_NUMBER = "0";
    public static final String HIERARCHY_VERSION_MICRO_NUMBER = "0";
    public static final String LEVEL_PUBLIC_TYPE = "Level";
    public static final String LEVEL_VERSION_MAJOR_NUMBER = "4";
    public static final String LEVEL_VERSION_MINOR_NUMBER = "0";
    public static final String LEVEL_VERSION_MICRO_NUMBER = "0";
    public static final String MEASURE_PUBLIC_TYPE = "Measure";
    public static final String MEASURE_VERSION_MAJOR_NUMBER = "4";
    public static final String MEASURE_VERSION_MINOR_NUMBER = "0";
    public static final String MEASURE_VERSION_MICRO_NUMBER = "0";
    public static final String CALCULATEDMEASURE_PUBLIC_TYPE = "CalculatedMeasure";
    public static final String CALCULATEDMEASURE_VERSION_MAJOR_NUMBER = "4";
    public static final String CALCULATEDMEASURE_VERSION_MINOR_NUMBER = "0";
    public static final String CALCULATEDMEASURE_VERSION_MICRO_NUMBER = "0";
    public static final String JOB_PUBLIC_TYPE = "Job.CubeBuild";
    public static final String JOB_VERSION_MAJOR_NUMBER = "1";
    public static final String JOB_VERSION_MINOR_NUMBER = "0";
    public static final String JOB_VERSION_MICRO_NUMBER = "0";
    public static final String DATETIMELOWER = "datetime";
    public static final String DTDATELOWER = "dtdate";
    public static final String DATEAMPMLOWER = "dateampm";
    public static final String DATETIME = "DATETIME";
    public static final String DTDATE = "DTDATE";
    public static final String DATEAMPM = "DATEAMPM";
    private static int LINE_SPLIT_DEFAULT;
    private static int LINE_SPLIT_MEDIUM_NAMES;
    private static int LINE_SPLIT_LONG_NAMES;
    private static int LINE_SPLIT_VERY_LONG_NAMES;
    private static int MEDIUM_NAME;
    private static int LONG_NAME;
    private static int VERY_LONG_NAME;
    private static final String NUMBER_OF_RACKS = "NRACKS";
    private static final String OLAP_OPTION = "OLAPOption";
    private static String rackCount;
    public static final int CODEGEN_LOADTABLE_LIBREFS = 1;
    public static final int CODEGEN_EXPORT_CODE = 2;
    public static final int CODEGEN_SETUP_RC_CAPTURE = 4;
    public static final int CODEGEN_RC_CAPTURE = 8;
    public static final int CODEGEN_NOPROMPT = 16;
    public static final int CODEGEN_MIN = 0;
    public static final int CODEGEN_MAX = 31;

    public static void setDefaultOLAPSchema(OLAPSchema inputSchema) {
        String name = "";
        try {
            name = inputSchema.getName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        fileAppDefaults.setPropertyString(DEFAULT_OLAPSCHEMA, name);
    }

    public static void setDefaultFolder(Tree inputFolder) {
        String folderID = "";
        try {
            folderID = inputFolder.getFQID();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        fileAppDefaults.setPropertyString(DEFAULT_FOLDER, folderID);
    }

    public static boolean getPermission(String permission, String type, CMetadata metadataObject) {
        boolean hasPermissions = false;
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
            String credential = "";
            String resource = "OMSOBJ:" + type + "/" + metadataObject.getFQID();
            StringHolder permissionCondition = new StringHolder();
            BooleanHolder authorized = new BooleanHolder();
            security.IsAuthorized(credential, resource, permission, permissionCondition, authorized);
            hasPermissions = authorized.value;
            Workspace.getMdFactory().getConnection().closeISecurityConnection((ISecurity)security);
        }
        catch (Exception error) {
            hasPermissions = false;
        }
        return hasPermissions;
    }

    public static boolean getPermissionFromId(String permission, String type, String fqid) {
        boolean hasPermissions = false;
        try {
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
            String credential = "";
            String resource = "OMSOBJ:" + type + "/" + fqid;
            StringHolder permissionCondition = new StringHolder();
            BooleanHolder authorized = new BooleanHolder();
            security.IsAuthorized(credential, resource, permission, permissionCondition, authorized);
            hasPermissions = authorized.value;
            Workspace.getMdFactory().getConnection().closeISecurityConnection((ISecurity)security);
        }
        catch (Exception error) {
            hasPermissions = false;
        }
        return hasPermissions;
    }

    public static void setLabelTextAndMnemonic(JLabel field, String item) throws IllegalArgumentException {
        String text = Util.getLabelWithoutMnemonic((String)item);
        field.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            field.setDisplayedMnemonic(mnemonic);
            field.setDisplayedMnemonicIndex(index);
        }
    }

    private static boolean getPermissions(String permission, CMetadata inputObject) {
        boolean hasAllPermissions = true;
        StringBuffer resource = new StringBuffer();
        String mainObjectType = null;
        ArrayList<String> hierNames = new ArrayList<String>();
        ArrayList<String> levNames = new ArrayList<String>();
        try {
            int i;
            if (inputObject instanceof Cube) {
                Cube cube = (Cube)inputObject;
                String readTemplate = "<Templates><Cube><Dimensions search=\"SharedDimension\"/></Cube><SharedDimension><Hierarchies/><Levels/></SharedDimension></Templates>";
                int iOptions = 268;
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)cube, null, null, readTemplate, iOptions);
                resource.append("OMSOBJ:Cube/");
                mainObjectType = CUBE_PUBLIC_TYPE;
                AssociationList dims = cube.getDimensions();
                for (i = 0; i < dims.size(); ++i) {
                    Dimension dim = (Dimension)dims.get(i);
                    if (!(dim instanceof SharedDimension)) continue;
                    AssociationList hiers = dim.getHierarchies();
                    for (int hierNum = 0; hierNum < hiers.size(); ++hierNum) {
                        Hierarchy hier = (Hierarchy)hiers.get(hierNum);
                        hierNames.add(hier.getName());
                    }
                    AssociationList levels = dim.getLevels();
                    for (int levNum = 0; levNum < levels.size(); ++levNum) {
                        Level lev = (Level)levels.get(levNum);
                        levNames.add(lev.getName());
                    }
                }
            } else if (inputObject instanceof SharedDimension) {
                resource.append("OMSOBJ:SharedDimension/");
                mainObjectType = SHAREDDIMENSION_PUBLIC_TYPE;
            }
            resource.append(inputObject.getFQID());
            VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
            security.GetAuthorizations(mainObjectType, "", resource.toString(), permission, returnAuths);
            String[][] auths = returnAuths.value;
            for (i = auths.length - 1; i >= 0 && hasAllPermissions; --i) {
                String authorization;
                String[] object = auths[i];
                String subObjectType = object[0];
                String name = object[1];
                if (permission.equalsIgnoreCase("WriteMetadata") && mainObjectType.equalsIgnoreCase(CUBE_PUBLIC_TYPE)) {
                    if (subObjectType.equalsIgnoreCase(SHAREDDIMENSION_PUBLIC_TYPE) || subObjectType.equalsIgnoreCase(LEVEL_PUBLIC_TYPE) && levNames.contains(name) || subObjectType.equalsIgnoreCase(HIERARCHY_PUBLIC_TYPE) && hierNames.contains(name)) continue;
                    authorization = object[2];
                    hasAllPermissions = authorization.equalsIgnoreCase("Y");
                    continue;
                }
                authorization = object[2];
                hasAllPermissions = authorization.equalsIgnoreCase("Y");
            }
        }
        catch (Exception error) {
            hasAllPermissions = false;
        }
        return hasAllPermissions;
    }

    public static boolean canAdmin(OLAPCube olapCube) {
        boolean adminRights = true;
        try {
            List listOfServers = ModelUtilities.getServersForCube(olapCube);
            int size = listOfServers.size();
            for (int i = 0; i < size && adminRights; ++i) {
                LogicalServer olapServer = (LogicalServer)listOfServers.get(i);
                adminRights = ModelUtilities.getPermission("Administer", "LogicalServer", (CMetadata)olapServer);
            }
        }
        catch (OLAPException e) {
            return false;
        }
        return adminRights;
    }

    public static boolean canRead(String type, CMetadata metadataObject) {
        return ModelUtilities.getPermission("Read", type, metadataObject);
    }

    public static boolean canReadAllCubeData(CMetadata inputCube) {
        try {
            if (inputCube.getCMetadataType().equalsIgnoreCase(CUBE_PUBLIC_TYPE)) {
                return ModelUtilities.getPermissions("Read", inputCube);
            }
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static boolean canReadAllCubeMetadata(CMetadata inputCube) {
        try {
            if (inputCube.getCMetadataType().equalsIgnoreCase(CUBE_PUBLIC_TYPE)) {
                return ModelUtilities.getPermissions("ReadMetadata", inputCube);
            }
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static boolean canReadAllSharedDimensionMetadata(CMetadata inputDim) {
        try {
            if (inputDim.getCMetadataType().equalsIgnoreCase(SHAREDDIMENSION_PUBLIC_TYPE)) {
                return ModelUtilities.getPermissions("ReadMetadata", inputDim);
            }
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static boolean canWrite(String type, CMetadata metadataObject) {
        return ModelUtilities.getPermission("WriteMetadata", type, metadataObject);
    }

    public static boolean canWriteAllCubeMetadata(CMetadata cube) {
        try {
            if (cube.getCMetadataType().equalsIgnoreCase(CUBE_PUBLIC_TYPE)) {
                Job cubeJob = ModelUtilities.getJobCube((Cube)cube);
                boolean canWriteJob = true;
                if (cubeJob != null) {
                    canWriteJob = ModelUtilities.canWrite("Job", (CMetadata)cubeJob);
                }
                return ModelUtilities.getPermissions("WriteMetadata", cube) & canWriteJob;
            }
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
        catch (MdException e) {
            return false;
        }
    }

    public static boolean canWriteAllSharedDimensionMetadata(CMetadata sharedDim) {
        try {
            if (sharedDim.getCMetadataType().equalsIgnoreCase(SHAREDDIMENSION_PUBLIC_TYPE)) {
                return ModelUtilities.getPermissions("WriteMetadata", sharedDim);
            }
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static int getNumberOfItems(String template) {
        int numberOfItems = 0;
        try {
            VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
            security.GetAuthorizations("getCountNoSecurity", "", template, "", returnAuths);
            numberOfItems = Integer.valueOf(returnAuths.value[0][1]);
            Workspace.getMdFactory().getConnection().closeISecurityConnection((ISecurity)security);
        }
        catch (RemoteException error) {
            numberOfItems = 0;
        }
        catch (MdException error) {
            numberOfItems = 0;
        }
        catch (InvalidAuthType error) {
            numberOfItems = 0;
        }
        catch (InvalidCredHandle error) {
            numberOfItems = 0;
        }
        catch (NotTrustedUser error) {
            numberOfItems = 0;
        }
        catch (GenericError error) {
            numberOfItems = 0;
        }
        catch (InvalidResourceSpec error) {
            numberOfItems = 0;
        }
        return numberOfItems;
    }

    public static int getNumberOfCubeItems(String template) {
        int numberOfItems = 0;
        try {
            VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
            security.GetAuthorizations("getCountNoSecurity", "", template, "Cubes", returnAuths);
            numberOfItems = Integer.valueOf(returnAuths.value[0][1]);
            Workspace.getMdFactory().getConnection().closeISecurityConnection((ISecurity)security);
        }
        catch (RemoteException error) {
            numberOfItems = 0;
        }
        catch (MdException error) {
            numberOfItems = 0;
        }
        catch (InvalidAuthType error) {
            numberOfItems = 0;
        }
        catch (InvalidCredHandle error) {
            numberOfItems = 0;
        }
        catch (NotTrustedUser error) {
            numberOfItems = 0;
        }
        catch (GenericError error) {
            numberOfItems = 0;
        }
        catch (InvalidResourceSpec error) {
            numberOfItems = 0;
        }
        return numberOfItems;
    }

    public static WAComboBox getOLAPSchemaSelections(MdObjectStore objectStore) throws OLAPException {
        WAComboBox schemaSelection = null;
        try {
            List schemas = ModelUtilities.getOLAPSchemas(objectStore);
            String schemaName = fileAppDefaults.getPropertyString(DEFAULT_OLAPSCHEMA);
            schemaSelection = new WAComboBox(schemas.toArray());
            boolean found = false;
            for (int i = schemas.size() - 1; i >= 0 && !found; --i) {
                OLAPSchema schema = (OLAPSchema)schemas.get(i);
                if (!schema.getName().equalsIgnoreCase(schemaName)) continue;
                found = true;
                schemaSelection.setSelectedItem((Object)schema);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return schemaSelection;
    }

    public static void setButtonTextAndMnemonic(AbstractButton field, String item) {
        String text = Util.getLabelWithoutMnemonic((String)item);
        field.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            field.setMnemonic(mnemonic);
            field.setDisplayedMnemonicIndex(index);
        }
    }

    private static boolean isValidCodegenFlag(int flagName) {
        boolean retVal = false;
        if (flagName == 1 || flagName == 2 || flagName == 4 || flagName == 8 || flagName == 16) {
            retVal = true;
        }
        return retVal;
    }

    public static int setCodegenFlag(int curFlags, int flagName, boolean flagValue) {
        int flags = curFlags;
        if (!ModelUtilities.isValidCodegenFlag(flagName)) {
            Integer v = flagName;
            throw new IllegalArgumentException(v.toString() + " is not a valid OLAPCube codegen flag");
        }
        if (!ModelUtilities.isValidCodegenFlagSet(curFlags)) {
            Integer v = curFlags;
            throw new IllegalArgumentException(v.toString() + " is not a valid OLAPCube flagSet value");
        }
        if (flagValue) {
            flags |= flagName;
        } else if (flagName <= flags && ModelUtilities.isCodegenFlagEnabled(flags, flagName)) {
            flags ^= flagName;
        }
        return flags;
    }

    private static String getXMLSelectSearchTemplate(String inputName) throws MdException, RemoteException {
        String xmlSelectTemplate = "";
        String repository = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
        xmlSelectTemplate = XML_SELECT.toString();
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_REPOSITORY, repository);
        StringBuffer template = new StringBuffer();
        template.append("Cube[@Name = '");
        String normalizedName = XMLUtil.normalize((String)inputName);
        template.append(normalizedName);
        template.append("']");
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_SEARCH, Matcher.quoteReplacement(template.toString()));
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_TYPE, preferredCubeName);
        return xmlSelectTemplate;
    }

    private static String getXMLSelectSearchDimTemplate(String inputName) throws MdException, RemoteException {
        String xmlSelectTemplate = "";
        String repository = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
        xmlSelectTemplate = XML_SELECT.toString();
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_REPOSITORY, repository);
        StringBuffer template = new StringBuffer();
        template.append("SharedDimension[@Name = '");
        String normalizedName = XMLUtil.normalize((String)inputName);
        template.append(normalizedName);
        template.append("']");
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_SEARCH, Matcher.quoteReplacement(template.toString()));
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_TYPE, SHAREDDIMENSION_PUBLIC_TYPE);
        return xmlSelectTemplate;
    }

    private static String getXMLSelectSearchSharedDimCubesTemplate(OLAPSharedDimension inputDim) throws MdException, RemoteException {
        String xmlSelectTemplate = "";
        String repository = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
        String id = inputDim.getFQID();
        xmlSelectTemplate = XML_SELECT_SHARED_DIM.toString();
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_REPOSITORY, repository);
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_TYPE, SHAREDDIMENSION_PUBLIC_TYPE);
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_SEARCH, id);
        return xmlSelectTemplate;
    }

    public static boolean isCubeNameUnique(String inputCube, OLAPSchema olapSchema) {
        boolean numberOfItems = false;
        try {
            String olapSchemaID = olapSchema.getFQID();
            String xmlselect = "";
            xmlselect = ModelUtilities.getXMLSelectSearchTemplate(inputCube);
            xmlselect = xmlselect.replaceAll(REPLACE_ASSOCIATED, "[AssociatedOLAPSchema/*[@Id='");
            xmlselect = xmlselect.replaceAll(REPLACE_ID, olapSchemaID);
            numberOfItems = ModelUtilities.getNumberOfItems(xmlselect) == 0;
        }
        catch (RemoteException e) {
            numberOfItems = false;
        }
        catch (MdException e) {
            numberOfItems = false;
        }
        return numberOfItems;
    }

    private static boolean isCubeNameUnique(String inputCube, OLAPSchema inputSchema, Tree inputFolder) {
        boolean unique = true;
        unique = ModelUtilities.isCubeNameUniqueToOLAPSchema(inputCube, inputSchema) && ModelUtilities.isCubeNameUniqueToFolder(inputCube, inputFolder);
        return unique;
    }

    public static boolean isSharedDimensionNameUnique(String inputDim, OLAPSchema inputSchema, Tree inputFolder) {
        boolean unique = true;
        unique = ModelUtilities.isSharedDimensionNameUniqueToOLAPSchema(inputDim, inputSchema) && ModelUtilities.isSharedDimensionNameUniqueToFolder(inputDim, inputFolder);
        return unique;
    }

    public static boolean isCubeNameUniqueToFolder(String inputCube, Tree inputFolder) {
        if (inputFolder == null) {
            return true;
        }
        boolean nameUnique = true;
        try {
            FolderInterface folderObject = (FolderInterface)ModelUtilities.getSmartObject((CMetadata)inputFolder);
            nameUnique = !folderObject.hasDuplicate(inputCube, CUBE_PUBLIC_TYPE);
        }
        catch (RemoteException e) {
            nameUnique = false;
        }
        catch (ServiceException e) {
            nameUnique = false;
        }
        return nameUnique;
    }

    public static boolean isSharedDimensionNameUniqueToFolder(String inputDim, Tree inputFolder) {
        if (inputFolder == null) {
            return true;
        }
        boolean nameUnique = true;
        try {
            FolderInterface folderObject = (FolderInterface)ModelUtilities.getSmartObject((CMetadata)inputFolder);
            nameUnique = !folderObject.hasDuplicate(inputDim, SHAREDDIMENSION_PUBLIC_TYPE);
        }
        catch (RemoteException e) {
            nameUnique = false;
        }
        catch (ServiceException e) {
            nameUnique = false;
        }
        return nameUnique;
    }

    public static boolean isJobNameUniqueToFolder(String inputJob, Tree inputFolder) {
        boolean nameUnique = true;
        if (inputFolder == null) {
            return true;
        }
        try {
            FolderInterface folderObject = (FolderInterface)ModelUtilities.getSmartObject((CMetadata)inputFolder);
            nameUnique = !folderObject.hasDuplicate(inputJob, JOB_PUBLIC_TYPE);
        }
        catch (RemoteException e) {
            nameUnique = false;
        }
        catch (ServiceException e) {
            nameUnique = false;
        }
        return nameUnique;
    }

    public static boolean isCubeNameUniqueToOLAPSchema(String inputCube, OLAPSchema inputSchema) {
        if (inputSchema == null) {
            return true;
        }
        boolean nameUnique = false;
        try {
            String schemaID = inputSchema.getFQID();
            String xmlselect = "";
            xmlselect = ModelUtilities.getXMLSelectSearchTemplate(inputCube);
            xmlselect = xmlselect.replaceAll(REPLACE_ASSOCIATED, "[AssociatedOLAPSchema/*[@Id='");
            xmlselect = xmlselect.replaceAll(REPLACE_ID, schemaID);
            nameUnique = ModelUtilities.getNumberOfItems(xmlselect) == 0;
        }
        catch (RemoteException e) {
            nameUnique = false;
        }
        catch (MdException e) {
            nameUnique = false;
        }
        return nameUnique;
    }

    public static boolean isSharedDimensionNameUniqueToOLAPSchema(String inputDim, OLAPSchema inputSchema) {
        if (inputSchema == null) {
            return true;
        }
        boolean nameUnique = false;
        try {
            String schemaID = inputSchema.getFQID();
            String xmlselect = "";
            xmlselect = ModelUtilities.getXMLSelectSearchDimTemplate(inputDim);
            xmlselect = xmlselect.replaceAll(REPLACE_ASSOCIATED, "[AssociatedOLAPSchema/*[@Id='");
            xmlselect = xmlselect.replaceAll(REPLACE_ID, schemaID);
            nameUnique = ModelUtilities.getNumberOfItems(xmlselect) == 0;
        }
        catch (RemoteException e) {
            nameUnique = false;
        }
        catch (MdException e) {
            nameUnique = false;
        }
        return nameUnique;
    }

    public static Integer isSharedDimensionContainCubes(OLAPSharedDimension inputDim) throws OLAPException {
        try {
            String xmlselect = ModelUtilities.getXMLSelectSearchSharedDimCubesTemplate(inputDim);
            int numberOfCubes = ModelUtilities.getNumberOfCubeItems(xmlselect);
            return numberOfCubes;
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public static boolean isCurrentGeneration(Cube inputCube) throws MdException, RemoteException {
        boolean currentGeneration = true;
        if (inputCube.getNextGeneration() != null) {
            currentGeneration = false;
        }
        return currentGeneration;
    }

    public static boolean isPreviousGeneration(OLAPCube inputCube) throws MdException, RemoteException {
        boolean previousGeneration = false;
        Cube jomaCube = (Cube)inputCube.metadataObject;
        if (inputCube != null && jomaCube != null && jomaCube.getPreviousGeneration() != null) {
            previousGeneration = true;
        }
        return previousGeneration;
    }

    public static boolean isDimensionNameUnique(String inputDimension, OLAPSchema olapSchema) {
        return true;
    }

    private static int getLineSplits(List workingList) {
        int listSize = workingList.size();
        int lineSplit = LINE_SPLIT_DEFAULT;
        if (listSize != 0) {
            int length = 0;
            for (int i = workingList.size() - 1; i >= 0; --i) {
                length += workingList.get(i).toString().length();
            }
            int average = length / listSize;
            if (average > MEDIUM_NAME) {
                lineSplit = LINE_SPLIT_MEDIUM_NAMES;
            }
            if (average > LONG_NAME) {
                lineSplit = LINE_SPLIT_LONG_NAMES;
            }
            if (average > VERY_LONG_NAME) {
                lineSplit = LINE_SPLIT_VERY_LONG_NAMES;
            }
        }
        return lineSplit;
    }

    private static List getNextRow(List workingList, int lineSplit) {
        ArrayList nextRow = new ArrayList();
        for (int i = 0; i <= lineSplit && !workingList.isEmpty(); ++i) {
            nextRow.add(workingList.get(0));
            workingList.remove(0);
        }
        return nextRow;
    }

    private static StringBuffer printFormattedList(List workingList, String indentBuffer, String delimiter) {
        StringBuffer printList = new StringBuffer();
        printList.append(newline);
        int iSize = workingList.size() - 1;
        for (int i = 0; i <= iSize; ++i) {
            List temp = (List)workingList.get(i);
            printList.append(indentBuffer);
            int listSize = temp.size() - 1;
            for (int j = 0; j <= listSize; ++j) {
                if (j < listSize) {
                    printList.append(temp.get(j).toString()).append(delimiter);
                    continue;
                }
                if (j != listSize) continue;
                printList.append(temp.get(j).toString());
                printList.append(newline);
            }
        }
        return printList;
    }

    public static List getFormattedList(List workingList, int lineSplits) {
        int i;
        ArrayList<List> formattedList = new ArrayList<List>();
        int size = 0;
        size = lineSplits == 0 ? workingList.size() : workingList.size() / lineSplits;
        for (i = 0; i <= size + 1; ++i) {
            List nextRow = ModelUtilities.getNextRow(workingList, lineSplits);
            if (nextRow.isEmpty()) continue;
            formattedList.add(nextRow);
        }
        size = formattedList.size() - 1;
        if (size >= 1) {
            for (i = 0; i <= 1; ++i) {
                List lastRow;
                int lastRowSize;
                List nextToLastRow = (List)formattedList.get(size - 1);
                int nextToLastRowSize = nextToLastRow.size();
                if (nextToLastRowSize < (lastRowSize = (lastRow = (List)formattedList.get(size)).size()) + 2) continue;
                Object temp = nextToLastRow.get(nextToLastRowSize - 1);
                nextToLastRow.remove(temp);
                lastRow.add(0, temp);
            }
        }
        return formattedList;
    }

    public static StringBuffer listFormatter(OLAPList inputList, String indentBuffer, String delimiter) {
        ArrayList<StringBuffer> workingList = new ArrayList<StringBuffer>();
        for (int i = inputList.size() - 1; i >= 0; --i) {
            AbstractOLAPModel olapObject = (AbstractOLAPModel)inputList.get(i);
            workingList.add(0, ModelUtilities.getSasName(olapObject.getName()));
        }
        return ModelUtilities.stringListFormatter(workingList, indentBuffer, delimiter);
    }

    public static StringBuffer stringListFormatter(List workingList, String indentBuffer, String delimiter) {
        int lineSplits = ModelUtilities.getLineSplits(workingList);
        List formattedList = ModelUtilities.getFormattedList(workingList, lineSplits);
        return ModelUtilities.printFormattedList(formattedList, indentBuffer, delimiter);
    }

    public static String getUniqueSASNameForType(String metadataType, OLAPSchema olapSchema, Tree folder) {
        StringBuffer newName;
        if (ModelUtilities.isBlank(metadataType)) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String preferredName = (String)preferredNames.get(metadataType);
        if (ModelUtilities.isBlank(preferredName)) {
            preferredName = preferredDefaultName;
        }
        int attempts = 0;
        boolean unique = false;
        do {
            newName = new StringBuffer();
            ++attempts;
            String suffix = format.format(new Date());
            newName.append(preferredName).append(suffix);
            if (metadataType.equals(CUBE_PUBLIC_TYPE)) {
                unique = ModelUtilities.isCubeNameUnique(newName.toString(), olapSchema, folder);
                continue;
            }
            if (!metadataType.equals(DIMENSION_PUBLIC_TYPE)) continue;
            unique = ModelUtilities.isDimensionNameUnique(newName.toString(), olapSchema);
        } while (!unique && attempts < 20);
        return newName.toString();
    }

    public static boolean isBlank(String value) {
        return value == null || Strings.trimmedLength((String)value) == 0;
    }

    private static boolean isCodegenFlagEnabled(int flags, int flagName) {
        boolean retVal = false;
        int bitMask = flagName;
        if ((flags & flagName) == bitMask) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isValidCodegenFlagSet(int flags) {
        boolean retVal = false;
        if (flags >= 0 && flags <= 31) {
            retVal = true;
        }
        return retVal;
    }

    static List getCMetadataList(String metadataType, MdObjectStore objectStore) throws MdException, RemoteException, OLAPException {
        ArrayList metadataList = new ArrayList();
        List temp = null;
        int flags = 8456;
        String reposid = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
        List tempAll = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, reposid, metadataType, flags, "");
        temp = Workspace.removeCheckouts((List)tempAll);
        for (int i = temp.size() - 1; i >= 0; --i) {
            metadataList.add(0, temp.get(i));
        }
        return metadataList;
    }

    public static boolean getCodegenFlag(int curFlags, int flagName) {
        boolean flagValue = false;
        if (!ModelUtilities.isValidCodegenFlag(flagName)) {
            Integer v = flagName;
            throw new IllegalArgumentException(v.toString() + " is not a valid OLAPCube codegen flag");
        }
        if (!ModelUtilities.isValidCodegenFlagSet(curFlags)) {
            Integer v = curFlags;
            throw new IllegalArgumentException(v.toString() + " is not a valid OLAPCube flagSet value");
        }
        if ((curFlags & flagName) == flagName) {
            flagValue = true;
        }
        return flagValue;
    }

    public static Cube getCube(String inputCubeName, String inputOLAPSchemaName, MdObjectStore objectStore) throws OLAPException {
        Cube cube = null;
        List cubes = ModelUtilities.getCubesByOLAPSchema(ModelUtilities.getOLAPSchema(inputOLAPSchemaName, objectStore));
        int i = cubes.size() - 1;
        while (i >= 0 & cube == null) {
            cube = (Cube)cubes.get(i);
            try {
                if (!cube.getName().equalsIgnoreCase(inputCubeName)) {
                    cube = null;
                }
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            --i;
        }
        return cube;
    }

    public static Cube getCube(String inputCubeName, OLAPSchema inputOLAPSchema) throws OLAPException {
        Cube cube = null;
        List cubes = ModelUtilities.getCubesByOLAPSchema(inputOLAPSchema);
        int i = cubes.size() - 1;
        while (i >= 0 & cube == null) {
            cube = (Cube)cubes.get(i);
            try {
                if (!cube.getName().equalsIgnoreCase(inputCubeName)) {
                    cube = null;
                }
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            --i;
        }
        return cube;
    }

    public static Cube getCubeFromJob(Job jomaJob) throws RemoteException, MdException {
        Object target;
        ClassifierMap map;
        AssociationList targets;
        TransformationStep step;
        AssociationList transformations;
        TransformationActivity activity;
        AssociationList steps;
        Cube jomaCube = null;
        AssociationList activities = jomaJob.getJobActivities();
        if (!(activities.isEmpty() || (steps = (activity = (TransformationActivity)activities.get(0)).getSteps()).isEmpty() || (transformations = (step = (TransformationStep)steps.get(0)).getTransformations()).isEmpty() || (targets = (map = (ClassifierMap)transformations.get(0)).getClassifierTargets()).isEmpty() || !((target = targets.get(0)) instanceof Cube))) {
            jomaCube = (Cube)target;
        }
        return jomaCube;
    }

    public static List getCubes(MdObjectStore objectStore) throws OLAPException {
        List cubeList = null;
        try {
            cubeList = ModelUtilities.getCMetadataList(CUBE_PUBLIC_TYPE, objectStore);
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        ModelUtilities.sort(cubeList);
        return Collections.unmodifiableList(cubeList);
    }

    public static List getCubesByOLAPSchema(OLAPSchema schema) throws OLAPException {
        AssociationList cubeList = null;
        ArrayList<Object> cubeListByOLAPSchema = new ArrayList<Object>();
        try {
            cubeList = schema.getCubes(true);
            for (int i = cubeList.size() - 1; i >= 0; --i) {
                cubeListByOLAPSchema.add(cubeList.get(i));
            }
            ModelUtilities.sort(cubeListByOLAPSchema);
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return Collections.unmodifiableList(cubeListByOLAPSchema);
    }

    public static List getCubesByOLAPSchema(String inputOLAPSchemaName, MdObjectStore objectStore) throws OLAPException {
        OLAPSchema schema = ModelUtilities.getOLAPSchema(inputOLAPSchemaName, objectStore);
        List cubesBySchema = null;
        cubesBySchema = schema == null ? EMPTY_LIST : ModelUtilities.getCubesByOLAPSchema(schema);
        return cubesBySchema;
    }

    public static Job getJobCube(Cube jomaCube) throws MdException, RemoteException {
        TransformationActivity activity;
        AssociationList jobs;
        TransformationStep step;
        AssociationList activities;
        ClassifierMap loadMap;
        AssociationList steps;
        AssociationList classifierMaps;
        Job job = null;
        if (!(jomaCube == null || (classifierMaps = jomaCube.getTargetClassifierMaps()).isEmpty() || (steps = (loadMap = (ClassifierMap)classifierMaps.get(0)).getSteps()).isEmpty() || (activities = (step = (TransformationStep)steps.get(0)).getActivities()).isEmpty() || (jobs = (activity = (TransformationActivity)activities.get(0)).getJobs()).isEmpty() || (activities = (job = (Job)jobs.get(0)).getJobActivities()).size() <= 1)) {
            job = null;
        }
        return job;
    }

    public static List getOLAPSchemas(MdObjectStore objectStore) throws OLAPException {
        List olapSchemaList = null;
        try {
            olapSchemaList = ModelUtilities.getCMetadataList("OLAPSchema", objectStore);
            ModelUtilities.sort(olapSchemaList);
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return Collections.unmodifiableList(olapSchemaList);
    }

    public static Tree getDefaultFolder(MdObjectStore objectStore) {
        Tree folder = null;
        try {
            String defaultID = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(DEFAULT_FOLDER);
            if (defaultID.length() != 0) {
                String options = "<XMLSELECT search=\"@Id='" + defaultID + "'\"/>";
                int objCount = Workspace.getMdFactory().getOMIUtil().doesObjectExist("A0000001." + defaultID.substring(0, 8), "Tree", options);
                if (objCount > 0) {
                    folder = (Tree)Workspace.getMdFactory().createComplexMetadataObject(objectStore, "", "Tree", defaultID);
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)folder, null, null, "", 8);
                }
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (MdException mdException) {
            // empty catch block
        }
        return folder;
    }

    public static Tree getDefaultFolder(OLAPSchema schema, MdObjectStore objectStore) throws OLAPException {
        Tree folder = null;
        folder = ModelUtilities.getDefaultFolder(objectStore);
        if (folder == null) {
            if (schema == null) {
                schema = ModelUtilities.getDefaultOLAPSchema(objectStore);
            }
            if (schema != null) {
                try {
                    AssociationList trees = schema.getTrees(false);
                    if (trees.isEmpty()) {
                        trees = schema.getTrees(true);
                    }
                    if (!trees.isEmpty()) {
                        folder = (Tree)trees.get(0);
                    }
                }
                catch (MdException trees) {
                }
                catch (RemoteException trees) {
                    // empty catch block
                }
            }
            if (folder == null) {
                try {
                    folder = WsMetadataUtil.getDefaultFolder((MdObjectStore)objectStore);
                }
                catch (MdException e) {
                    folder = null;
                }
                catch (RemoteException e) {
                    folder = null;
                }
                catch (ServiceException e) {
                    folder = null;
                }
            }
        }
        return folder;
    }

    public static OLAPSchema getDefaultOLAPSchema(MdObjectStore objectStore) throws OLAPException {
        OLAPSchema schema = null;
        try {
            List schemas = ModelUtilities.getOLAPSchemas(objectStore);
            String schemaName = fileAppDefaults.getPropertyString(DEFAULT_OLAPSCHEMA);
            if (!ModelUtilities.isBlank(schemaName)) {
                for (int i = schemas.size() - 1; i >= 0 && schema == null; --i) {
                    schema = (OLAPSchema)schemas.get(i);
                    if (schema.getName().equalsIgnoreCase(schemaName)) continue;
                    schema = null;
                }
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return schema;
    }

    public static OLAPSchema getOLAPSchema(String inputOLAPSchemaName, MdObjectStore objectStore) throws OLAPException {
        OLAPSchema schema = null;
        List olapSchemas = ModelUtilities.getOLAPSchemas(objectStore);
        int i = olapSchemas.size() - 1;
        while (i >= 0 & schema == null) {
            schema = (OLAPSchema)olapSchemas.get(i);
            try {
                if (!schema.getName().equalsIgnoreCase(inputOLAPSchemaName)) {
                    schema = null;
                }
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            --i;
        }
        return schema;
    }

    public static String getRepositoryShortFQID(Tree inputObject) throws OLAPException {
        String repositoryShortFQID = ModelUtilities.getRepositoryFQID(inputObject).substring(9, 17);
        return repositoryShortFQID;
    }

    public static String getRepositoryName(Tree inputObject) throws OLAPException {
        String repositoryName = "";
        try {
            String repositoryFQID = ModelUtilities.getRepositoryFQID(inputObject);
            repositoryName = Workspace.getMdFactory().getRepositoryUtil().getRepositoryName(repositoryFQID);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return repositoryName;
    }

    public static String getRepositoryFQID(Tree inputObject) throws OLAPException {
        String repositoryFQID = "";
        try {
            repositoryFQID = Workspace.getMdFactory().getOMIUtil().getReposIdFromMetadataObject((CMetadata)inputObject);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return repositoryFQID;
    }

    public static String getRepositoryFoundationFQID() throws OLAPException {
        String foundationFQID = "";
        try {
            foundationFQID = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return foundationFQID;
    }

    public static StringBuffer getSasName(String inputName) {
        StringBuffer sasName = new StringBuffer();
        if (!ModelUtilities.isBlank(inputName)) {
            StringBuffer validVarnameDelimiter = new StringBuffer();
            StringBuffer validVarnameQuote = new StringBuffer();
            boolean found = false;
            int i = Strings.trimmedLength((String)inputName) - 1;
            while (i > -1 & !found) {
                if (i == 0 && latinFirstCharacters.indexOf(inputName.charAt(i)) < 0) {
                    validVarnameQuote.append("'");
                    validVarnameDelimiter.append("n");
                    found = true;
                } else if (latinSASCharacters.indexOf(inputName.charAt(i)) < 0) {
                    validVarnameQuote.append("'");
                    validVarnameDelimiter.append("n");
                    found = true;
                }
                --i;
            }
            if (!found && inputName.indexOf(32) >= 0) {
                validVarnameQuote.append("'");
                validVarnameDelimiter.append("n");
            }
            sasName.append(validVarnameQuote).append(ModelUtilities.internalQuote(inputName)).append(validVarnameQuote).append(validVarnameDelimiter);
        }
        return sasName;
    }

    public static List getServersForCube(OLAPCube cube) throws OLAPException {
        return ModelUtilities.getServersForCube((Cube)cube.metadataObject);
    }

    public static String getRackCountForCube(Cube cube) throws OLAPException {
        Aggregation jomaAggregation = null;
        try {
            AssociationList jomaAggregations = cube.getAggregations();
            boolean foundNWAY = false;
            int size1 = jomaAggregations.size();
            for (int i1 = 0; i1 < size1 && !foundNWAY; ++i1) {
                jomaAggregation = (Aggregation)jomaAggregations.elementAt(i1);
                if (jomaAggregation.getNway() != 1) continue;
                foundNWAY = true;
            }
            if (jomaAggregation != null) {
                AssociationList properties = jomaAggregation.getProperties();
                boolean found = false;
                int size12 = properties.size();
                for (int i1 = 0; i1 < size12 && !found; ++i1) {
                    Property property = (Property)properties.elementAt(i1);
                    if (!(property.getPropertyName().equalsIgnoreCase(NUMBER_OF_RACKS) & property.getPropertyRole().equalsIgnoreCase(OLAP_OPTION))) continue;
                    rackCount = property.getDefaultValue();
                    found = true;
                }
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return rackCount;
    }

    public static String getReconnectionString() {
        WorkspaceFile m_appDefaultsFile;
        StringBuffer code = new StringBuffer();
        Workspace workspace = Workspace.getWorkspace();
        if (workspace != null && (m_appDefaultsFile = Workspace.getWorkspace().getAppDefaultsFile()) != null) {
            String retries = m_appDefaultsFile.getPropertyString(MAX_RETRY_ATTEMPT_KEY, "3");
            code.append(newline).append(MAX_RETRIES).append(retries);
            String max = m_appDefaultsFile.getPropertyString(MAX_RETRY_SECONDS_KEY, "60");
            code.append(newline).append(MAX_RETRY_WAIT).append(max);
            String min = m_appDefaultsFile.getPropertyString(MIN_RETRY_SECONDS_KEY, "30");
            code.append(newline).append(MIN_RETRY_WAIT).append(min);
        }
        return code.toString();
    }

    public static MetadataInterface getSmartObject(CMetadata cm) throws ServiceException, RemoteException {
        ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
        String sFQID = cm.getFQID();
        String sType = cm.getCMetadataType();
        String sKey = sFQID + "/" + sType;
        MetadataInterface mi = server.fetch(sKey, false);
        return mi;
    }

    public static List getServersForCube(Cube cube) throws OLAPException {
        ArrayList<LogicalServer> servers = new ArrayList<LogicalServer>();
        try {
            String name = cube.getName();
            AssociationList schemas = cube.getAssociatedOLAPSchemas(true);
            if (schemas.isEmpty()) {
                throw new OLAPException(bundle.formatString("OlapServer.NoSchemaForCube.fmt.txt", (Object)name), 0);
            }
            OLAPSchema schema = (OLAPSchema)schemas.get(0);
            AssociationList contexts = schema.getDeployedComponents(true);
            if (contexts.isEmpty()) {
                throw new OLAPException(bundle.getString("OlapServer.NoServersAvailable.txt"), 0);
            }
            int numContexts = contexts.size();
            for (int i = 0; i < numContexts; ++i) {
                ServerContext context = (ServerContext)contexts.get(i);
                AssociationList contextLogicals = context.getUsingComponents(true);
                for (int j = 0; j < contextLogicals.size(); ++j) {
                    LogicalServer server1 = (LogicalServer)contextLogicals.elementAt(j);
                    if (!server1.getClassIdentifier().equals("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) continue;
                    servers.add(server1);
                }
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return servers;
    }

    public static String generateTableName(PhysicalTable physicalTable) throws OLAPException {
        String name = " ";
        if (physicalTable != null) {
            StringBuffer tableName = null;
            try {
                SASLibrary library = LibraryUtil.getLibrary((DataTable)physicalTable, null);
                String libraryName = "";
                if (library != null) {
                    libraryName = library.getLibref();
                }
                tableName = new StringBuffer();
                tableName.append(libraryName).append(".").append(physicalTable.getSASTableName());
                name = tableName.toString();
            }
            catch (MdException mdError) {
                throw new OLAPException(mdError.getLocalizedMessage(), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return name;
    }

    public static void verifyPublicTypeName(String inputName) throws OLAPException {
        try {
            Names.validateOMRObjectName((String)inputName, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            throw new OLAPException(e.getLocalizedMessage(), 0);
        }
    }

    public static boolean isDeleteAllowed(Object[] objs) {
        boolean allObjsDeleteable = false;
        if (objs != null && objs.length > 0) {
            allObjsDeleteable = true;
            for (int i = 0; i < objs.length; ++i) {
                allObjsDeleteable &= ModelUtilities.isDeleteAllowed(objs[i]);
            }
        }
        return allObjsDeleteable;
    }

    public static boolean isDeleteAllowed(Object obj) {
        boolean returnValue = false;
        if (obj != null) {
            try {
                if (obj instanceof SimpleObject) {
                    LogicalObjectInterface lo = ObjectConverter.getInstance().convertToLogicalObject((SimpleObject)obj);
                    returnValue = lo.isDeleteAllowed();
                } else if (obj instanceof LogicalObjectInterface) {
                    returnValue = ((LogicalObjectInterface)obj).isDeleteAllowed();
                }
            }
            catch (MdException me) {
                Workspace.getDefaultLogger().error((Object)me.getLocalizedMessage(), (Throwable)me);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (LogicalTypeException e) {
                Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }

    public static boolean isRenameAllowed(Object[] objs) {
        boolean allObjsRenameable = false;
        if (objs != null && objs.length > 0) {
            allObjsRenameable = true;
            for (int i = 0; i < objs.length; ++i) {
                allObjsRenameable &= ModelUtilities.isRenameAllowed(objs[i]);
            }
        }
        return allObjsRenameable;
    }

    public static boolean isRenameAllowed(Object obj) {
        boolean returnValue = false;
        if (obj != null) {
            try {
                if (obj instanceof SimpleObject) {
                    LogicalObjectInterface lo = ObjectConverter.getInstance().convertToLogicalObject((SimpleObject)obj);
                    returnValue = lo.isRenameAllowed();
                } else if (obj instanceof LogicalObjectInterface) {
                    returnValue = ((LogicalObjectInterface)obj).isRenameAllowed();
                }
            }
            catch (MdException me) {
                Workspace.getDefaultLogger().error((Object)me.getLocalizedMessage(), (Throwable)me);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (LogicalTypeException e) {
                Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }

    public static String internalQuote(String input) {
        String quoted = null;
        quoted = input != null && input.indexOf("'") >= 0 ? input.replaceAll("'", "''") : input;
        return quoted;
    }

    public static StringBuffer quotePath(String inputPath) {
        boolean alreadyQuoted;
        StringBuffer path = new StringBuffer();
        boolean bl = alreadyQuoted = inputPath.startsWith("'") && inputPath.endsWith("'") || inputPath.startsWith(String.valueOf('\"')) && inputPath.endsWith(String.valueOf('\"'));
        if (!alreadyQuoted) {
            path.append("'").append(ModelUtilities.internalQuote(inputPath)).append("'");
        } else {
            path.append(inputPath);
        }
        return path;
    }

    public static String formatPath(String inputPath) {
        StringBuffer formattedString = new StringBuffer();
        if (!ModelUtilities.isBlank(inputPath)) {
            formattedString.append("(");
            String fixedString = ModelUtilities.trim(inputPath);
            if (fixedString.startsWith("(") && (fixedString = fixedString.substring(1)).endsWith(")")) {
                fixedString = fixedString.substring(0, fixedString.length() - 1);
            }
            String delimiter = String.valueOf('\"');
            if (fixedString.startsWith("'")) {
                delimiter = "'";
            }
            String[] inputPaths = fixedString.split(delimiter);
            for (int i = 0; i < inputPaths.length; ++i) {
                String nextDirectory = inputPaths[i];
                if (ModelUtilities.isBlank(nextDirectory)) continue;
                formattedString.append(" \"").append(nextDirectory).append('\"');
            }
            formattedString.append(")");
        }
        return formattedString.toString();
    }

    public static void sort(List sorted) {
        int i;
        ArrayList<ComparableObject> sortList = new ArrayList<ComparableObject>();
        for (i = sorted.size() - 1; i >= 0; --i) {
            sortList.add(new ComparableObject(sorted.get(i)));
        }
        Collections.sort(sortList);
        sorted.clear();
        for (i = sortList.size() - 1; i >= 0; --i) {
            ComparableObject sortedObject = (ComparableObject)sortList.get(i);
            sorted.add(0, sortedObject.getObject());
        }
    }

    public static String trim(String input) {
        if (!ModelUtilities.isBlank(input)) {
            input = input.trim();
            String tempInput = Strings.removeWhitespace((String)input);
            int index = input.indexOf(tempInput.charAt(0));
            input = input.substring(index, input.length());
        }
        return input;
    }

    public static String generateBlockCommentStart(String commentTxt) {
        StringBuilder builder = new StringBuilder();
        builder.append("/********    ");
        builder.append(commentTxt);
        builder.append(newline);
        return builder.toString();
    }

    public static String generateBlockCommentEnd() {
        StringBuilder builder = new StringBuilder();
        builder.append(newline);
        builder.append("********    ");
        builder.append(bundle.getString("ModelUtilities.Codegen.BlockCommentEnd.txt"));
        builder.append("    ********/");
        builder.append(newline);
        builder.append(newline);
        builder.append(newline);
        return builder.toString();
    }

    static {
        LINE_SPLIT_DEFAULT = 4;
        LINE_SPLIT_MEDIUM_NAMES = 2;
        LINE_SPLIT_LONG_NAMES = 1;
        LINE_SPLIT_VERY_LONG_NAMES = 0;
        MEDIUM_NAME = 10;
        LONG_NAME = 20;
        VERY_LONG_NAME = 30;
        rackCount = "1";
        formats = new String[16];
        ModelUtilities.formats[0] = "";
        ModelUtilities.formats[1] = "BEST15.";
        ModelUtilities.formats[2] = "COMMA15.";
        ModelUtilities.formats[3] = "COMMAX15.";
        ModelUtilities.formats[4] = "DOLLAR15.";
        ModelUtilities.formats[5] = "DOLLARX15.";
        ModelUtilities.formats[6] = "NEGPAREN15.";
        ModelUtilities.formats[7] = "PERCENT6.";
        ModelUtilities.formats[8] = "15.0";
        ModelUtilities.formats[9] = "WORDF10.";
        ModelUtilities.formats[10] = "WORDS10.";
        ModelUtilities.formats[11] = "YEN15.0";
        ModelUtilities.formats[12] = "EURO15.";
        ModelUtilities.formats[13] = "EUROX15.";
        ModelUtilities.formats[14] = "NLMNY15.";
        ModelUtilities.formats[15] = "NLNUMI15.";
        characterFormat = new String[3];
        ModelUtilities.characterFormat[0] = "$8.";
        ModelUtilities.characterFormat[1] = "$CHAR8.";
        ModelUtilities.characterFormat[2] = "$VARYING8.";
        numericFormats = new String[23];
        ModelUtilities.numericFormats[0] = "BEST15.";
        ModelUtilities.numericFormats[1] = "COMMA15.";
        ModelUtilities.numericFormats[2] = "COMMAX15.";
        ModelUtilities.numericFormats[3] = "DATE7.";
        ModelUtilities.numericFormats[4] = "DAY2.";
        ModelUtilities.numericFormats[5] = "DDMMYYD8.";
        ModelUtilities.numericFormats[6] = "DDMMYYP8.";
        ModelUtilities.numericFormats[7] = "DDMMYYS8.";
        ModelUtilities.numericFormats[8] = "DESDFWKX30.";
        ModelUtilities.numericFormats[9] = "EURDFDD30.";
        ModelUtilities.numericFormats[10] = "EURDFWKX30.";
        ModelUtilities.numericFormats[11] = "FRSDFWKX30.";
        ModelUtilities.numericFormats[12] = "ITADFWKX30.";
        ModelUtilities.numericFormats[13] = "MONNAME9.";
        ModelUtilities.numericFormats[14] = "NLDATE30.";
        ModelUtilities.numericFormats[15] = "NLMNY15.";
        ModelUtilities.numericFormats[16] = "NLNUMI15.";
        ModelUtilities.numericFormats[17] = "QTR1.";
        ModelUtilities.numericFormats[18] = "WEEKV3.";
        ModelUtilities.numericFormats[19] = "YEAR4.";
        ModelUtilities.numericFormats[20] = "YYMMDDD8.";
        ModelUtilities.numericFormats[21] = "YYMMDDP8.";
        ModelUtilities.numericFormats[22] = "YYMMDDS8.";
        dateCheck = new ArrayList(22);
        dateCheck.add("DATE");
        dateCheck.add("NLDATE");
        dateCheck.add("YYMMDD");
        dateCheck.add("DDMMYY");
        dateCheck.add("EURFWDX");
        dateCheck.add("DESDFWKX");
        dateCheck.add("FRSDFWK");
        dateCheck.add("ITADFWKX");
        dateCheck.add("EURDFWKX");
        dateCheck.add("YYMMDD");
        dateCheck.add("MMDDYY");
        dateCheck.add("date");
        dateCheck.add("nldate");
        dateCheck.add("yymmdd");
        dateCheck.add("ddmmyy");
        dateCheck.add("eurfwdx");
        dateCheck.add("desdfwkx");
        dateCheck.add("frsdfwk");
        dateCheck.add("itadfwkx");
        dateCheck.add("eurdfwkx");
        dateCheck.add("yymmdd");
        dateCheck.add("mmddyy");
        EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
        preferredNames = new HashMap();
        preferredNames.put(CUBE_PUBLIC_TYPE, preferredCubeName);
        preferredNames.put(DIMENSION_PUBLIC_TYPE, preferredDimensionName);
        XML_SELECT = new StringBuffer();
        XML_SELECT.append("<GetMetadataObjects><Reposid>");
        XML_SELECT.append(REPLACE_REPOSITORY);
        XML_SELECT.append("</Reposid><Type>");
        XML_SELECT.append(REPLACE_TYPE);
        XML_SELECT.append("</Type><Objects/><NS>SAS</NS><Flags>");
        XML_SELECT.append(8320);
        XML_SELECT.append("</Flags><Options>");
        XML_SELECT.append("<XMLSelect search=\"");
        XML_SELECT.append(REPLACE_SEARCH);
        XML_SELECT.append(REPLACE_ASSOCIATED);
        XML_SELECT.append(REPLACE_ID);
        XML_SELECT.append("']]\"/>");
        XML_SELECT.append(TEMPLATE);
        XML_SELECT.append("</Options>");
        XML_SELECT.append("</GetMetadataObjects>");
        XML_SELECT_SHARED_DIM = new StringBuffer();
        XML_SELECT_SHARED_DIM.append("<GetMetadataObjects><Reposid>");
        XML_SELECT_SHARED_DIM.append(REPLACE_REPOSITORY);
        XML_SELECT_SHARED_DIM.append("</Reposid><Type>");
        XML_SELECT_SHARED_DIM.append(REPLACE_TYPE);
        XML_SELECT_SHARED_DIM.append("</Type><Objects/><NS>SAS</NS><Flags>");
        XML_SELECT_SHARED_DIM.append(388);
        XML_SELECT_SHARED_DIM.append("</Flags><Options>");
        XML_SELECT_SHARED_DIM.append("<XMLSelect search=\"*[@Id='");
        XML_SELECT_SHARED_DIM.append(REPLACE_SEARCH);
        XML_SELECT_SHARED_DIM.append("']\"/>");
        XML_SELECT_SHARED_DIM.append("<Templates><SharedDimension><Cubes/></SharedDimension></Templates>");
        XML_SELECT_SHARED_DIM.append("</Options>");
        XML_SELECT_SHARED_DIM.append("</GetMetadataObjects>");
        fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
    }

    private static class ComparableObject
    implements Comparable {
        Object compareObject;

        ComparableObject(Object inputCompareObject) {
            this.compareObject = inputCompareObject;
        }

        Object getObject() {
            return this.compareObject;
        }

        public int compareTo(Object obj) {
            int compnum = this.toString().compareToIgnoreCase(obj.toString());
            return compnum;
        }

        public String toString() {
            return this.compareObject.toString();
        }
    }
}

