/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.LogicalColumn;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.Root;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.util.UsageVersion;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MeasureSet {
    static WAdminResource bundle = new WAdminResource(MeasureSet.class);
    private List deleteList;
    private OLAPList derivedMeasures;
    private OLAPList groupNames;
    private OLAPList storedMeasures;
    private OLAPList measures;
    private OLAPList nuniqueMeasures;
    private boolean metadataUpdated;
    private OLAPCube owningCube;
    private Map measureLists;
    private Map logicalColumns;
    private Map measuresByColumn;
    private Map nuniqueMeasuresByLevelHierarchy;
    private boolean autoRestore;
    public static final int MAXIMUM_MEASURES = 1024;
    public static final String MEASURE_DIMENSION_NAME = "Measures";
    private boolean synching;
    Map mappedMeasures;
    private OLAPList unmappedMeasures;
    private Dimension measuresDimension;
    private static final OLAPList emptyList = new OLAPList(OLAPMeasure.class);

    MeasureSet(OLAPCube inputOwningCube) throws OLAPException {
        this.owningCube = inputOwningCube;
        AggregationSet aggregationSet = this.owningCube.getAggregationSet();
        if (aggregationSet.hasStoredAggregations() == null) {
            aggregationSet.setHasStoredAggregations(false);
        }
        this.getMeasures();
        this.getStoredMeasures();
        this.getDerivedMeasures();
        this.getNUniqueMeasures();
        this.getGroupNames();
        for (int i = this.groupNames.size() - 1; i >= 0; --i) {
            this.getStoredMeasuresByGroupName((String)this.groupNames.get(i));
            this.getDerivedMeasuresByGroupName((String)this.groupNames.get(i));
        }
        this.autoRestore = true;
        this.synching = false;
    }

    void autoAdd() throws OLAPException {
        if (this.autoRestore) {
            for (String key : this.measureLists.keySet()) {
                OLAPList autoDeleted = null;
                if (key.indexOf("auto") < 0) continue;
                autoDeleted = (OLAPList)this.measureLists.get(key);
                for (int j = autoDeleted.size() - 1; j >= 0; --j) {
                    OLAPMeasure measure = (OLAPMeasure)autoDeleted.get(j);
                    measure.add();
                }
            }
        }
    }

    void autoAdd(String inputGroupName) throws OLAPException {
        if (this.autoRestore) {
            OLAPList possibleDerived;
            OLAPList storedByGroupName;
            OLAPList autoDeleted = this.getAutoDeletedByGroupName(inputGroupName);
            autoDeleted.setModifiable(true);
            if (!autoDeleted.isEmpty() && (storedByGroupName = (OLAPList)this.measureLists.get("stored" + inputGroupName)) != null && (possibleDerived = this.getPossibleDerivedStatisticsByGroupName(inputGroupName)) != null && possibleDerived.size() > 0) {
                for (int i = autoDeleted.size() - 1; i >= 0; --i) {
                    OLAPMeasure measure = (OLAPMeasure)autoDeleted.get(i);
                    measure.setDeleted(false);
                    Statistic statistic = measure.getStatistic();
                    if (statistic != null && possibleDerived.contains(statistic)) {
                        OLAPList derivedByGroup = (OLAPList)this.measureLists.get("derived" + inputGroupName);
                        ArrayList<Statistic> currentDerivedStatistics = new ArrayList<Statistic>();
                        for (int j = derivedByGroup.size() - 1; j >= 0; --j) {
                            OLAPMeasure derivedMeasure = (OLAPMeasure)derivedByGroup.get(j);
                            Statistic derivedStatistic = derivedMeasure.getStatistic();
                            if (derivedStatistic == null) continue;
                            currentDerivedStatistics.add(derivedStatistic);
                        }
                        if (!currentDerivedStatistics.contains(statistic)) {
                            measure.setDeleted(false);
                            OLAPList derived = (OLAPList)this.measureLists.get("derived");
                            this.measures.getTheList().add(measure);
                            List javaList = derived.getTheList();
                            javaList.add(measure);
                            javaList = derivedByGroup.getTheList();
                            javaList.add(measure);
                            OLAPColumn tempInputColumn = measure.getInputColumn();
                            if (tempInputColumn != null) {
                                OLAPList tempList = this.getMeasuresByColumn(tempInputColumn);
                                javaList = tempList.getTheList();
                                javaList.add(measure);
                            }
                            if (measure.metadataObject != null && this.deleteList != null) {
                                this.deleteList.remove(measure.metadataObject);
                            }
                        }
                        autoDeleted.getTheList().remove(measure);
                    }
                    if (!autoDeleted.contains(measure)) continue;
                    measure.setDeleted(true);
                }
            }
            autoDeleted.setModifiable(false);
        }
    }

    private void autoDelete(String inputGroupName) throws OLAPException {
        OLAPList statistics = this.getPossibleDerivedStatisticsByGroupName(inputGroupName);
        OLAPList derivedByGroupName = this.getDerivedMeasuresByGroupName(inputGroupName);
        for (int j = derivedByGroupName.size() - 1; j >= 0; --j) {
            OLAPMeasure measure = (OLAPMeasure)derivedByGroupName.get(j);
            if (statistics.indexOf(measure.getStatistic()) >= 0) continue;
            OLAPList autoDeleted = null;
            if (this.autoRestore) {
                autoDeleted = this.getAutoDeletedByGroupName(measure.getGroupName());
                autoDeleted.setModifiable(true);
                if (!autoDeleted.contains(measure)) {
                    autoDeleted.getTheList().add(measure);
                }
            }
            this.measures.getTheList().remove(measure);
            this.derivedMeasures.getTheList().remove(measure);
            if (this.deleteList == null) {
                this.deleteList = new ArrayList();
            }
            this.deleteList.add(measure.metadataObject);
            List derivedMeasuresByGroupName = this.getDerivedMeasuresByGroupName(inputGroupName).getTheList();
            derivedMeasuresByGroupName.remove(measure);
            OLAPColumn column = measure.getInputColumn();
            if (column != null) {
                List tempMeasuresByColumn = this.getMeasuresByColumn(measure.getInputColumn()).getTheList();
                tempMeasuresByColumn.remove(measure);
            }
            measure.setDeleted(true);
            if (!this.autoRestore) continue;
            autoDeleted.setModifiable(false);
        }
    }

    void clear(OLAPMeasure measure) throws OLAPException {
        OLAPList derived;
        if (this.storedMeasures == null) {
            this.getStoredMeasures();
        }
        this.storedMeasures.getTheList().remove(measure);
        if (this.derivedMeasures == null) {
            this.getDerivedMeasures();
        }
        this.derivedMeasures.getTheList().remove(measure);
        String groupName = measure.getGroupName();
        OLAPList stored = this.getStoredMeasuresByGroupName(groupName);
        if (stored != null) {
            stored.getTheList().remove(measure);
        }
        if ((derived = this.getDerivedMeasuresByGroupName(groupName)) != null) {
            derived.getTheList().remove(measure);
        }
    }

    void clearMapTable() {
        if (this.mappedMeasures != null) {
            this.mappedMeasures.clear();
            this.mappedMeasures = null;
        }
        if (this.unmappedMeasures != null) {
            this.unmappedMeasures.getTheList().clear();
            this.unmappedMeasures = null;
        }
    }

    void clearMeasuresByColumn(OLAPMeasure inputMeasure) {
        if (this.measuresByColumn != null) {
            Collection columnMeasures = this.measuresByColumn.values();
            for (OLAPList tempColumnMeasures : columnMeasures) {
                tempColumnMeasures.getTheList().remove(inputMeasure);
            }
        }
    }

    private OLAPMeasure createOLAPMeasure(Measure inputJomaMeasure) throws OLAPException {
        LoadTable loadTable;
        OLAPMeasure measure = new OLAPMeasure(inputJomaMeasure, this);
        TableSet tableSet = this.owningCube.getTableSet();
        if (tableSet.isLoadClassicSAS() && (loadTable = tableSet.getLoadTable()).getTable() != null) {
            List availableNumericColumns = loadTable.getAvailableNumericColumns().getTheList();
            OLAPColumn column = measure.getInputColumn();
            if (column != null) {
                availableNumericColumns.remove(column);
            }
        }
        this.metadataUpdated = true;
        return measure;
    }

    public OLAPMeasure createOLAPMeasure(OLAPColumn inputColumn) throws OLAPException {
        TableSet tableSet;
        if (inputColumn == null & !(tableSet = this.owningCube.getTableSet()).isLoadClassicSAS()) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Use a null input column to create derived measures for Fully Summarized input.  Otherwise, the null input column is invalid.");
            }
            throw new IllegalArgumentException("Illegal argument passed to the createOLAPMeasure method.");
        }
        OLAPMeasure measure = new OLAPMeasure(inputColumn, this);
        if (tableSet.isLoadClassicSAS()) {
            LoadTable loadTable = tableSet.getLoadTable();
            if (loadTable == null) {
                throw new IllegalStateException("The LoadTable must exist when creating Classic SAS measures.");
            }
            List availableNumericColumns = loadTable.getAvailableNumericColumns().getTheList();
            OLAPColumn column = measure.getInputColumn();
            if (column != null) {
                availableNumericColumns.remove(column);
            }
        }
        this.getMeasures().add(measure);
        return measure;
    }

    public OLAPMeasure createOLAPMeasure(OLAPLevel inputLevel, OLAPHierarchy inputHierarchy) throws OLAPException {
        OLAPMeasure measure = new OLAPMeasure(inputLevel, inputHierarchy, this);
        this.getMeasures().add(measure);
        if (this.nuniqueMeasuresByLevelHierarchy == null) {
            this.nuniqueMeasuresByLevelHierarchy = new HashMap();
        }
        this.nuniqueMeasuresByLevelHierarchy.put(inputLevel.toString() + inputHierarchy.toString(), measure);
        return measure;
    }

    void delete(OLAPMeasure olapMeasure) throws OLAPException {
        if (olapMeasure.metadataObject != null) {
            this.getDeleteList().add(olapMeasure.metadataObject);
        }
        if (this.getMeasures().indexOf(olapMeasure) >= 0) {
            this.measures.remove(olapMeasure);
        }
    }

    StringBuffer generateCode() throws OLAPException {
        StringBuffer measureStatements = new StringBuffer();
        if (this.measures == null) {
            this.getMeasures();
        }
        int size = this.measures.size();
        for (int i = 0; i < size; ++i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            measureStatements.append(measure.generateCode());
            if (i >= size - 1) continue;
            measureStatements.append(ModelUtilities.newline);
        }
        return measureStatements;
    }

    public OLAPList getAutoDeletedByGroupName(String inputGroupName) {
        OLAPList autoDeleted;
        if (this.measureLists == null) {
            this.measureLists = new HashMap();
        }
        if ((autoDeleted = (OLAPList)this.measureLists.get("auto" + inputGroupName)) == null) {
            autoDeleted = new OLAPList(OLAPMeasure.class);
            this.measureLists.put("auto" + inputGroupName, autoDeleted);
        }
        autoDeleted.setModifiable(false);
        return autoDeleted;
    }

    public OLAPMeasure getDefaultMeasure() throws OLAPException {
        OLAPMeasure measure = null;
        if (this.measures == null) {
            this.getMeasures();
        }
        measure = (OLAPMeasure)this.measures.get(0);
        return measure;
    }

    List getDeleteList() {
        if (this.deleteList == null) {
            this.deleteList = new ArrayList();
        }
        return this.deleteList;
    }

    public OLAPList getDerivedMeasures() throws OLAPException {
        if (this.derivedMeasures == null) {
            this.derivedMeasures = new OLAPList(OLAPMeasure.class);
            if (this.measureLists == null) {
                this.measureLists = new HashMap();
            }
            this.measureLists.put("derived", this.derivedMeasures);
            this.derivedMeasures.setModifiable(false);
            if (this.measures == null) {
                this.getMeasures();
            }
            for (int i = this.measures.size() - 1; i >= 0; --i) {
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                Boolean stored = measure.isStoredStatistic();
                if (stored == null || stored.booleanValue()) continue;
                this.derivedMeasures.getTheList().add(0, measure);
            }
        }
        return this.derivedMeasures;
    }

    public OLAPMeasure getNUniqueMeasure(OLAPLevel inLevel, OLAPHierarchy inHierarchy) throws OLAPException {
        OLAPMeasure nuniqueMeasure = null;
        if (this.nuniqueMeasuresByLevelHierarchy == null) {
            this.nuniqueMeasuresByLevelHierarchy = new HashMap();
            if (this.nuniqueMeasures == null) {
                this.getNUniqueMeasures();
            }
            for (int i = this.nuniqueMeasures.size() - 1; i >= 0; --i) {
                OLAPMeasure measure = (OLAPMeasure)this.nuniqueMeasures.get(i);
                this.nuniqueMeasuresByLevelHierarchy.put(measure.getLevel().toString() + measure.getHierarchy().toString(), measure);
            }
        }
        nuniqueMeasure = (OLAPMeasure)this.nuniqueMeasuresByLevelHierarchy.get(inLevel.toString() + inHierarchy.toString());
        return nuniqueMeasure;
    }

    public OLAPList getNUniqueMeasures() throws OLAPException {
        if (this.nuniqueMeasures == null) {
            this.nuniqueMeasures = new OLAPList(OLAPMeasure.class);
            if (this.measureLists == null) {
                this.measureLists = new HashMap();
            }
            if (this.measures == null) {
                this.getMeasures();
            }
            this.measureLists.put("nunique", this.nuniqueMeasures);
            for (int i = this.measures.size() - 1; i >= 0; --i) {
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                Boolean stored = measure.isStoredStatistic();
                if (stored == null || stored.booleanValue() || !measure.getStatistic().getName().equals("NUNIQUE")) continue;
                this.nuniqueMeasures.getTheList().add(0, measure);
            }
        }
        return this.nuniqueMeasures;
    }

    public OLAPList getDerivedMeasuresByGroupName(String inputGroupName) throws OLAPException {
        return this.getDerivedMeasuresByGroupNameForced(inputGroupName);
    }

    private OLAPList getDerivedMeasuresByGroupNameForced(String inputGroupName) throws OLAPException {
        OLAPList derivedMeasuresByGroupName;
        if (this.measureLists == null) {
            this.measureLists = new HashMap();
        }
        if ((derivedMeasuresByGroupName = (OLAPList)this.measureLists.get("derived" + inputGroupName)) == null) {
            derivedMeasuresByGroupName = this.getMeasuresByGroupName(this.getDerivedMeasures(), inputGroupName);
            this.measureLists.put("derived" + inputGroupName, derivedMeasuresByGroupName);
        }
        derivedMeasuresByGroupName.setModifiable(false);
        return derivedMeasuresByGroupName;
    }

    public OLAPList getGroupNames() throws OLAPException {
        if (this.groupNames == null) {
            this.groupNames = new OLAPList(String.class);
            if (this.measureLists == null) {
                this.measureLists = new HashMap();
            }
            this.measureLists.put("groupNames", this.groupNames);
        } else {
            this.groupNames.clear();
        }
        for (int i = this.getMeasures().size() - 1; i >= 0; --i) {
            String tempGroupName;
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            if (measure.isNunique().booleanValue() || ModelUtilities.isBlank(tempGroupName = measure.getGroupName()) || this.groupNames.indexOf(tempGroupName) >= 0) continue;
            this.groupNames.add(tempGroupName);
        }
        return this.groupNames;
    }

    LogicalColumn getLogicalColumn(String inputGroupName) throws OLAPException {
        LogicalColumn logicalColumn;
        if (this.logicalColumns == null) {
            this.logicalColumns = new HashMap();
        }
        if ((logicalColumn = (LogicalColumn)this.logicalColumns.get(inputGroupName)) == null) {
            logicalColumn = (LogicalColumn)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "LogicalColumn", this.owningCube.getRepositoryShortFQID());
            try {
                logicalColumn.setName(inputGroupName);
                logicalColumn.setColumnName(inputGroupName);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.logicalColumns.put(inputGroupName, logicalColumn);
        }
        return logicalColumn;
    }

    public OLAPMeasure getMeasure(String groupName, Statistic statistic) throws OLAPException {
        OLAPMeasure measure = null;
        OLAPList measuresByGroup = this.getStoredMeasuresByGroupName(groupName);
        for (int i = measuresByGroup.size() - 1; i >= 0 && measure == null; --i) {
            measure = (OLAPMeasure)measuresByGroup.get(i);
            if (measure.getStatistic().equals(statistic)) continue;
            measure = null;
        }
        return measure;
    }

    public OLAPMeasure getMeasure(String measureName) throws OLAPException {
        OLAPMeasure measure = null;
        int i = this.getMeasures().size() - 1;
        while (i >= 0 & measure == null) {
            measure = (OLAPMeasure)this.measures.get(i);
            if (!measure.getName().equalsIgnoreCase(measureName)) {
                measure = null;
            }
            --i;
        }
        return measure;
    }

    OLAPMeasure getMeasure(Measure inputMeasure) throws OLAPException {
        OLAPMeasure measure = null;
        int i = this.getMeasures().size() - 1;
        while (i >= 0 & measure == null) {
            measure = (OLAPMeasure)this.measures.get(i);
            if ((Measure)measure.metadataObject != inputMeasure) {
                measure = null;
            }
            --i;
        }
        return measure;
    }

    public Column getMappedMeasure(OLAPMeasure inputMeasure) {
        Column mappedColumn = null;
        if (this.mappedMeasures != null && inputMeasure != null) {
            mappedColumn = (Column)this.mappedMeasures.get(inputMeasure);
        }
        return mappedColumn;
    }

    StringBuffer getMappedRatio() {
        StringBuffer message = new StringBuffer();
        if (this.mappedMeasures != null) {
            int mappedSize = this.mappedMeasures.size();
            int unmappedSize = this.unmappedMeasures.size();
            message.append(bundle.formatString("OLAPMeasure.MappedMeasuresRatio.fmt.txt", (Object)String.valueOf(mappedSize), (Object)String.valueOf(mappedSize + unmappedSize)));
        }
        return message;
    }

    int getMapTableSize() throws OLAPException {
        int i;
        int size = 0;
        if (this.mappedMeasures != null) {
            size = this.mappedMeasures.size();
        }
        this.getNUniqueMeasures();
        DimensionSet dimensionSet = this.owningCube.getDimensionSet();
        for (i = this.nuniqueMeasures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)this.nuniqueMeasures.get(i);
            OLAPLevel level = measure.getLevel();
            Column column = dimensionSet.getMappedLevel(level);
            if (column == null) continue;
            ++size;
        }
        if (this.owningCube.getTableSet().isLoadClassicSAS()) {
            this.getDerivedMeasures();
            for (i = this.derivedMeasures.size() - 1; i >= 0; --i) {
                OLAPMeasure derivedMeasure = (OLAPMeasure)this.derivedMeasures.get(i);
                OLAPList statList = new OLAPList(Statistic.class);
                statList.add(derivedMeasure.getStatistic());
                String groupName = derivedMeasure.getGroupName();
                OLAPList statistics = Statistic.getRequiredStoredStatistics(statList);
                boolean storedMapped = true;
                for (int j = statistics.size() - 1; j >= 0 && storedMapped; --j) {
                    Statistic statistic = (Statistic)statistics.get(j);
                    OLAPMeasure storedMeasure = this.getMeasure(groupName, statistic);
                    if (storedMeasure == null) continue;
                    storedMapped = this.mappedMeasures.containsKey(storedMeasure);
                }
                if (!storedMapped) continue;
                ++size;
            }
        }
        return size;
    }

    public OLAPMeasure getMeasure(OLAPColumn inputColumn, Statistic inputStatistic) {
        OLAPMeasure measure = null;
        OLAPList tempMeasuresByColumn = this.getMeasuresByColumn(inputColumn);
        if (tempMeasuresByColumn != null) {
            int i = tempMeasuresByColumn.size() - 1;
            while (i >= 0 & measure == null) {
                measure = (OLAPMeasure)tempMeasuresByColumn.get(i);
                Statistic statistic = measure.getStatistic();
                if (!statistic.equals(inputStatistic)) {
                    measure = null;
                }
                --i;
            }
        }
        return measure;
    }

    Dimension getMeasuresDimension() throws OLAPException {
        try {
            if (this.measuresDimension == null) {
                Cube cube = (Cube)this.owningCube.metadataObject;
                AssociationList dimensions = cube.getDimensions(false);
                int size = dimensions.size();
                for (int i = 0; i < size && this.measuresDimension == null; ++i) {
                    this.measuresDimension = (Dimension)dimensions.elementAt(i);
                    if (this.measuresDimension.getDimensionType().equalsIgnoreCase("MEASURES")) continue;
                    this.measuresDimension = null;
                }
                if (this.measuresDimension == null) {
                    this.measuresDimension = (Dimension)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Dimension", this.owningCube.getRepositoryShortFQID());
                    this.measuresDimension.setName(MEASURE_DIMENSION_NAME);
                    this.measuresDimension.setDimensionType("MEASURES");
                    this.measuresDimension.setDesc(bundle.getString("OLAPMeasure.MeasureDimensionName.txt"));
                    dimensions.add((Object)this.measuresDimension);
                }
                if (ModelUtilities.isBlank(this.measuresDimension.getPublicType())) {
                    this.measuresDimension.setPublicType("Dimension");
                    UsageVersion usageVersion = new UsageVersion(Integer.valueOf("4").intValue(), Integer.valueOf("0").intValue(), Integer.valueOf("0").intValue());
                    this.measuresDimension.setUsageVersion(usageVersion.encode());
                }
            }
            this.measuresDimension.setName(MEASURE_DIMENSION_NAME);
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return this.measuresDimension;
    }

    public String getMeasuresDimensionName() throws OLAPException {
        String dimensionName = "";
        try {
            dimensionName = this.getMeasuresDimension().getName();
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return dimensionName;
    }

    Map getMeasureLists() {
        if (this.measureLists == null) {
            this.measureLists = new HashMap();
        }
        return this.measureLists;
    }

    public OLAPList getMeasures() throws OLAPException {
        if (this.measures == null) {
            this.measures = new OLAPList(OLAPMeasure.class);
            try {
                if (this.owningCube.metadataObject != null) {
                    Cube jomaCube = (Cube)this.owningCube.metadataObject;
                    AssociationList jomaMeasures = jomaCube.getMeasures(false);
                    for (int i = jomaMeasures.size() - 1; i >= 0; --i) {
                        Root measure = (Root)jomaMeasures.get(i);
                        if (measure instanceof CalculatedMeasure) continue;
                        this.measures.add(0, this.createOLAPMeasure((Measure)measure));
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.measures;
    }

    public OLAPList getMeasuresByColumn(OLAPColumn inputColumn) {
        OLAPList byColumn = null;
        if (inputColumn != null) {
            if (this.measuresByColumn == null) {
                this.measuresByColumn = new HashMap();
            }
            if ((byColumn = (OLAPList)this.measuresByColumn.get(inputColumn)) == null) {
                byColumn = new OLAPList(OLAPMeasure.class);
                byColumn.setModifiable(false);
                this.measuresByColumn.put(inputColumn, byColumn);
            }
        }
        return byColumn;
    }

    private OLAPList getMeasuresByGroupName(OLAPList inputMeasures, String inputGroupName) throws OLAPException {
        OLAPList byGroupNameMeasures = new OLAPList(OLAPMeasure.class);
        byGroupNameMeasures.setModifiable(false);
        for (int i = inputMeasures.size() - 1; i >= 0; --i) {
            String tempGroupName;
            OLAPMeasure measure = (OLAPMeasure)inputMeasures.get(i);
            if (measure.isNunique().booleanValue() || !(tempGroupName = measure.getGroupName()).equalsIgnoreCase(inputGroupName)) continue;
            byGroupNameMeasures.getTheList().add(0, measure);
        }
        return byGroupNameMeasures;
    }

    boolean getMetadataUpdated() {
        return this.metadataUpdated;
    }

    public OLAPCube getOwningCube() {
        return this.owningCube;
    }

    public OLAPList getPossibleDerivedStatisticsByGroupName(String groupName) throws OLAPException {
        OLAPList storedMeasuresByGroup = this.getStoredMeasuresByGroupName(groupName);
        OLAPList storedStatistics = new OLAPList(Statistic.class);
        for (int i = storedMeasuresByGroup.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)storedMeasuresByGroup.get(i);
            storedStatistics.add(measure.getStatistic());
        }
        OLAPList possibleDerivedStatistics = Statistic.getPossibleDerivedStatistics(storedStatistics);
        return possibleDerivedStatistics;
    }

    public OLAPList getStoredMeasures() throws OLAPException {
        if (this.storedMeasures == null) {
            this.storedMeasures = new OLAPList(OLAPMeasure.class);
            if (this.measureLists == null) {
                this.measureLists = new HashMap();
            }
            this.measureLists.put("stored", this.storedMeasures);
            this.storedMeasures.setModifiable(false);
            this.getMeasures();
            for (int i = this.measures.size() - 1; i >= 0; --i) {
                Boolean stored;
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                if (measure.isNunique().booleanValue() || (stored = measure.isStoredStatistic()) == null || !stored.booleanValue()) continue;
                this.storedMeasures.getTheList().add(0, measure);
            }
        }
        return this.storedMeasures;
    }

    public OLAPList getStoredMeasuresByGroupName(String inputGroupName) throws OLAPException {
        OLAPList storedMeasuresByGroupName = null;
        if (!ModelUtilities.isBlank(inputGroupName)) {
            if (this.measureLists == null) {
                this.measureLists = new HashMap();
            }
            if ((storedMeasuresByGroupName = (OLAPList)this.measureLists.get("stored" + inputGroupName)) == null) {
                storedMeasuresByGroupName = this.getMeasuresByGroupName(this.getStoredMeasures(), inputGroupName);
                storedMeasuresByGroupName.setModifiable(false);
                this.measureLists.put("stored" + inputGroupName, storedMeasuresByGroupName);
            }
        }
        if (storedMeasuresByGroupName == null) {
            storedMeasuresByGroupName = emptyList;
        }
        return storedMeasuresByGroupName;
    }

    OLAPList getUnmappedMeasures() throws OLAPException {
        if (this.mappedMeasures != null && this.unmappedMeasures == null) {
            TableSet tableSet = this.owningCube.getTableSet();
            boolean classicSAS = tableSet.isLoadClassicSAS();
            this.unmappedMeasures = new OLAPList(OLAPMeasure.class);
            for (int i = this.measures.size() - 1; i >= 0; --i) {
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                Boolean stored = measure.isStoredStatistic();
                if (measure.isNunique().booleanValue() || classicSAS && (!classicSAS || stored == null || !stored.booleanValue()) || this.mappedMeasures.containsKey(measure)) continue;
                this.unmappedMeasures.getTheList().add(measure);
            }
            this.unmappedMeasures.sort();
            this.unmappedMeasures.setModifiable(false);
        }
        return this.unmappedMeasures;
    }

    boolean hasOneValidMappedMeasure() throws OLAPException {
        boolean oneValidMappedMeasure = true;
        if (this.mappedMeasures != null) {
            oneValidMappedMeasure = false;
            TableSet tableSet = this.owningCube.getTableSet();
            boolean classicSAS = tableSet.isLoadClassicSAS();
            for (int i = this.measures.size() - 1; i >= 0 && !oneValidMappedMeasure; --i) {
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                Boolean stored = measure.isStoredStatistic();
                if (measure.isNunique().booleanValue() || classicSAS && (!classicSAS || stored == null || !stored.booleanValue())) continue;
                Column column = (Column)this.mappedMeasures.get(measure);
                oneValidMappedMeasure = column != null;
            }
        }
        return oneValidMappedMeasure;
    }

    public boolean hasAutoDeletedDerivedMeasures() throws OLAPException {
        boolean autoDeletedDerivedMeasures = false;
        if (this.groupNames == null) {
            this.getGroupNames();
        }
        int i = this.groupNames.size() - 1;
        while (i >= 0 & !autoDeletedDerivedMeasures) {
            OLAPList deletedMeasures = this.getAutoDeletedByGroupName((String)this.groupNames.get(i));
            autoDeletedDerivedMeasures = !deletedMeasures.isEmpty();
            --i;
        }
        return autoDeletedDerivedMeasures;
    }

    public StringBuffer isRolapOutOfSynch() throws OLAPException {
        StringBuffer outOfSynch = new StringBuffer();
        AggregationSet aggregationSet = this.owningCube.getAggregationSet();
        Boolean storedAggregations = aggregationSet.hasStoredAggregations();
        if (storedAggregations != null && storedAggregations.booleanValue()) {
            this.getGroupNames();
            int i = this.groupNames.size() - 1;
            while (i >= 0 & outOfSynch.length() == 0) {
                String groupName = (String)this.groupNames.get(i);
                OLAPList derivedMeasuresByGroupName = this.getDerivedMeasuresByGroupNameForced(groupName);
                if (derivedMeasuresByGroupName.size() > 0) {
                    OLAPList possibleDerivedStatistics = this.getPossibleDerivedStatisticsByGroupName(groupName);
                    int j = derivedMeasuresByGroupName.size() - 1;
                    while (j >= 0 & outOfSynch.length() == 0) {
                        OLAPMeasure measure = (OLAPMeasure)derivedMeasuresByGroupName.get(j);
                        Statistic statistic = measure.getStatistic();
                        if (possibleDerivedStatistics.indexOf(statistic) < 0) {
                            OLAPList outOfSynchStatistic = new OLAPList(Statistic.class);
                            ArrayList<Statistic> currentStoredStatistics = new ArrayList<Statistic>();
                            outOfSynchStatistic.add(statistic);
                            OLAPList requiredStatistics = Statistic.getRequiredStoredStatistics(outOfSynchStatistic);
                            OLAPList thisStoredMeasures = this.getStoredMeasuresByGroupName(groupName);
                            for (int k = thisStoredMeasures.size() - 1; k >= 0; --k) {
                                OLAPMeasure thisMeasure = (OLAPMeasure)thisStoredMeasures.get(k);
                                currentStoredStatistics.add(thisMeasure.getStatistic());
                            }
                            StringBuffer required = new StringBuffer();
                            int size = requiredStatistics.size();
                            for (int k = 0; k < size; ++k) {
                                Statistic tempStatistic = (Statistic)requiredStatistics.get(k);
                                if (currentStoredStatistics.contains(tempStatistic)) continue;
                                required.append(tempStatistic.toString());
                                if (k >= size - 1) continue;
                                required.append(", ");
                            }
                            outOfSynch.append(bundle.formatString("OLAPMeasure.MeasureDerivedStatNotPossible.fmt.txt", (Object)groupName, (Object)required.toString(), (Object)statistic.getLabel()));
                        }
                        --j;
                    }
                }
                --i;
            }
        }
        return outOfSynch;
    }

    void mapMeasure(OLAPMeasure inputMeasure, Column inputColumn) throws OLAPException {
        Column mappedColumn;
        if (this.mappedMeasures == null) {
            this.mappedMeasures = new HashMap();
        }
        if ((mappedColumn = (Column)this.mappedMeasures.get(inputMeasure)) != null && mappedColumn != inputColumn) {
            TableSet tableSet = this.owningCube.getTableSet();
            try {
                LoadTable loadTable = tableSet.getLoadTable();
                loadTable.setIsMapChanged(true);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        this.mappedMeasures.put(inputMeasure, inputColumn);
        this.unmappedMeasures.getTheList().remove(inputMeasure);
    }

    void mapTable(Map mappedTable) throws OLAPException {
        if (this.mappedMeasures == null) {
            this.mappedMeasures = new HashMap();
        }
        TableSet tableSet = this.owningCube.getTableSet();
        boolean classicSAS = tableSet.isLoadClassicSAS();
        for (int i = this.measures.size() - 1; i >= 0; --i) {
            String columnName;
            Column newColumn;
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            Boolean stored = measure.isStoredStatistic();
            if (measure.isNunique().booleanValue() || classicSAS && (!classicSAS || stored == null || !stored.booleanValue())) continue;
            OLAPColumn column = measure.getInputColumn();
            if (column == null && tableSet.isLoadClassicSAS()) {
                AggregationSet aggregationSet = this.owningCube.getAggregationSet();
                OLAPList tables = aggregationSet.getTables();
                for (int j = tables.size() - 1; j >= 0 && column == null; --j) {
                    AggregationTable table = (AggregationTable)tables.get(j);
                    column = measure.getAggregateColumn(table);
                }
            }
            if (column == null || (newColumn = (Column)mappedTable.get(columnName = column.getSASColumnName().toUpperCase())) == null) continue;
            this.mappedMeasures.put(measure, newColumn);
        }
        this.getUnmappedMeasures();
    }

    void removeUnmappedStructure() throws OLAPException {
        if (this.unmappedMeasures != null && !this.unmappedMeasures.isEmpty()) {
            List messages = this.owningCube.getCubeMessage();
            for (int i = this.unmappedMeasures.size() - 1; i >= 0; --i) {
                OLAPMeasure measure = (OLAPMeasure)this.unmappedMeasures.get(i);
                messages.add(bundle.formatString("OLAPMeasure.MissingLoadTableColumn2.fmt.txt", (Object)measure.getName()));
                measure.delete();
                this.unmappedMeasures.getTheList().remove(measure);
            }
        }
    }

    public void reset() throws OLAPException {
        if (this.measures == null) {
            this.getMeasures();
        }
        for (int i = this.measures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            if (measure.isNewObject()) continue;
            if (this.deleteList == null) {
                this.deleteList = new ArrayList();
            }
            this.deleteList.add(measure.metadataObject);
        }
        this.measures.clear();
        if (this.derivedMeasures != null) {
            this.derivedMeasures.getTheList().clear();
        }
        if (this.groupNames != null) {
            this.groupNames.clear();
        }
        if (this.measureLists != null) {
            for (OLAPList list : this.measureLists.values()) {
                list.getTheList().clear();
                Object var2_3 = null;
            }
            this.measureLists.clear();
        }
        if (this.measures != null) {
            this.measures.clear();
        }
        this.metadataUpdated = false;
        if (this.storedMeasures != null) {
            this.storedMeasures.getTheList().clear();
        }
        if (this.nuniqueMeasures != null) {
            this.nuniqueMeasures.getTheList().clear();
        }
    }

    public void setAutoRestore(boolean inputAutoRestore) {
        this.autoRestore = inputAutoRestore;
    }

    public void setDefaultMeasure(OLAPMeasure inputMeasure) {
        List javaMeasures = this.measures.getTheList();
        javaMeasures.remove(inputMeasure);
        javaMeasures.add(0, inputMeasure);
    }

    public void setGroupNames(String fromGroupName, String toGroupName) throws OLAPException {
        TableSet tableSet = this.owningCube.getTableSet();
        if (tableSet.isLoadClassicSAS()) {
            List auto;
            if (toGroupName == null || ModelUtilities.isBlank(toGroupName)) {
                throw new IllegalArgumentException("The groupname must not be blank.");
            }
            this.verifyGroupName(fromGroupName, toGroupName);
            if (this.measures == null) {
                this.getMeasures();
            }
            for (int i = this.measures.size() - 1; i >= 0; --i) {
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                if (measure.isNunique().booleanValue() || !measure.getGroupName().equalsIgnoreCase(fromGroupName)) continue;
                measure.setGroupNameForce(toGroupName);
            }
            String fromStored = "stored" + fromGroupName;
            String fromDerived = "derived" + fromGroupName;
            String toStored = "stored" + toGroupName;
            String toDerived = "derived" + toGroupName;
            String toAuto = "auto" + toGroupName;
            String fromAuto = "auto" + fromGroupName;
            OLAPList stored = (OLAPList)this.measureLists.get(fromStored);
            OLAPList derived = (OLAPList)this.measureLists.get(fromDerived);
            if (stored != null) {
                this.measureLists.put(toStored, stored);
            }
            if (derived != null) {
                this.measureLists.put(toDerived, derived);
            }
            if ((auto = (List)this.measureLists.get(fromAuto)) != null) {
                this.measureLists.put(toAuto, auto);
            }
            this.measureLists.remove(fromStored);
            this.measureLists.remove(fromDerived);
            this.measureLists.remove(fromAuto);
            this.groupNames.getTheList().remove(fromGroupName);
            this.groupNames.getTheList().add(toGroupName);
            this.synchRolap();
        }
    }

    void setLogicalColumn(String inputGroupName, LogicalColumn inputLogicalColumn) {
        if (this.logicalColumns == null) {
            this.logicalColumns = new HashMap();
        }
        this.logicalColumns.put(inputGroupName, inputLogicalColumn);
    }

    void setMapToStructure() throws OLAPException {
        TableSet tableSet = this.owningCube.getTableSet();
        boolean classicSAS = tableSet.isLoadClassicSAS();
        for (int i = this.measures.size() - 1; i >= 0; --i) {
            Column jomaColumn;
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            Boolean stored = measure.isStoredStatistic();
            if (classicSAS && (!classicSAS || stored == null || !stored.booleanValue()) || this.mappedMeasures == null || (jomaColumn = (Column)this.mappedMeasures.get(measure)) == null) continue;
            LoadTable loadTable = this.owningCube.getTableSet().getLoadTable();
            OLAPColumn olapColumn = loadTable.getColumn(jomaColumn);
            measure.setColumn(olapColumn);
        }
        this.synchRolap();
        this.synchNuniqueLevel();
        this.synchNuniqueHierarchy();
        if (this.mappedMeasures != null) {
            this.mappedMeasures.clear();
            this.mappedMeasures = null;
        }
        if (this.unmappedMeasures != null) {
            this.unmappedMeasures.getTheList().clear();
            this.unmappedMeasures = null;
        }
    }

    void setVerifiedAggregates(boolean inputVerifiedAggregates) throws OLAPException {
        if (this.measures == null) {
            this.getMeasures();
        }
        for (int i = this.measures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            if (measure.isNunique().booleanValue()) continue;
            measure.setVerifiedAggregates(inputVerifiedAggregates);
        }
    }

    public void synchNuniqueLevel() throws OLAPException {
        Map dimensionLevels = this.owningCube.getDimensionSet().getLevels();
        this.nuniqueMeasures = this.getNUniqueMeasures();
        for (int i = 0; i < this.nuniqueMeasures.size(); ++i) {
            boolean found = false;
            OLAPMeasure measure = (OLAPMeasure)this.nuniqueMeasures.get(i);
            OLAPLevel NuniqueLevel = measure.getLevel();
            Iterator t = dimensionLevels.values().iterator();
            while (t.hasNext() && !found) {
                List listOfLevels = (List)t.next();
                if (!listOfLevels.contains(NuniqueLevel)) continue;
                found = true;
            }
            if (found) continue;
            measure.delete();
        }
    }

    public void synchNuniqueHierarchy() throws OLAPException {
        OLAPList allHierarchies = this.owningCube.getDimensionSet().getHierarchies();
        this.nuniqueMeasures = this.getNUniqueMeasures();
        for (int i = this.nuniqueMeasures.size() - 1; i > -1; --i) {
            OLAPHierarchy NuniqueHierarchy;
            boolean delete_flag = false;
            OLAPMeasure measure = (OLAPMeasure)this.nuniqueMeasures.get(i);
            OLAPLevel NuniqueLevel = measure.getLevel();
            if (NuniqueLevel == null | (NuniqueHierarchy = measure.getHierarchy()) == null) {
                delete_flag = true;
            } else if (!allHierarchies.contains(NuniqueHierarchy)) {
                delete_flag = true;
            } else {
                OLAPList hierLevels = NuniqueHierarchy.getLevels();
                if (!hierLevels.contains(NuniqueLevel)) {
                    delete_flag = true;
                }
            }
            if (!delete_flag) continue;
            measure.delete();
        }
    }

    void synchRolap() throws OLAPException {
        if (!this.synching) {
            this.synching = true;
            AggregationSet aggregationSet = this.owningCube.getAggregationSet();
            Boolean hasStoredAggregations = aggregationSet.hasStoredAggregations();
            if (hasStoredAggregations != null && hasStoredAggregations.booleanValue()) {
                this.getGroupNames();
                for (int i = this.groupNames.size() - 1; i >= 0; --i) {
                    String groupName = (String)this.groupNames.get(i);
                    this.autoDelete(groupName);
                    this.autoAdd(groupName);
                }
                aggregationSet.resetAggregationTables();
            }
            this.synching = false;
        }
    }

    private void updateMetadataDefaultMeasure() throws OLAPException {
        Measure jomaDefaultMeasure = (Measure)this.getDefaultMeasure().metadataObject;
        Cube jomaCube = (Cube)this.owningCube.metadataObject;
        try {
            AssociationList jomaMeasures = jomaCube.getMeasures(false);
            jomaMeasures.remove((Object)jomaDefaultMeasure);
            jomaMeasures.insertElementAt((Object)jomaDefaultMeasure, 0);
            this.getMeasuresDimension();
            jomaMeasures = this.measuresDimension.getMeasures(false);
            jomaMeasures.remove((Object)jomaDefaultMeasure);
            jomaMeasures.insertElementAt((Object)jomaDefaultMeasure, 0);
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    void updateMetadata() throws OLAPException {
        int i;
        this.metadataUpdated = true;
        this.owningCube.getAggregationSet().cleanseTables();
        int size = this.measures.size();
        for (i = 0; i < size; ++i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            measure.updateMetadata();
        }
        if (!this.measures.isEmpty()) {
            this.updateMetadataDefaultMeasure();
        }
        for (i = this.getDeleteList().size() - 1; i >= 0; --i) {
            Measure jomaMeasure = (Measure)this.deleteList.get(i);
            this.deleteList.remove(jomaMeasure);
            if (jomaMeasure == null) continue;
            try {
                Workspace.getMdFactory().deletePublicObject((CMetadata)jomaMeasure, "<Template TemplateName=\"Measure\"><Measure><AccessControls><AccessControlTemplate TemplateExpand=\"CONNECT\"/><AccessControlEntry/></AccessControls><Extensions/><Keywords/><Notes/><Properties/><PropertySets/><TargetFeatureMaps/><TargetTransformations/></Measure><AccessControlEntry><AssociatedCondition/><Permissions><Permission TemplateExpand=\"connect\" ConnectionAction=\"W\"/></Permissions><Identities><Identity TemplateExpand=\"connect\" ConnectionAction=\"W\" /></Identities></AccessControlEntry><Property><StoredConfiguration/><OwningType/></Property><PropertySet><SetProperties/></PropertySet><PropertyType><ArrayTypes/></PropertyType></Template>");
                continue;
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
    }

    public void verifyAggregates() throws OLAPException {
        AggregationSet aggregationSet = this.owningCube.getAggregationSet();
        Boolean storedAggregations = aggregationSet.hasStoredAggregations();
        TableSet tableSet = this.owningCube.getTableSet();
        if (!tableSet.isLoadClassicSAS() & (storedAggregations != null && storedAggregations != false)) {
            if (this.measures == null) {
                this.getMeasures();
            }
            for (int i = this.measures.size() - 1; i >= 0; --i) {
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                Boolean storedMeasure = measure.isStoredStatistic();
                if (storedMeasure == null || !storedMeasure.booleanValue() || measure.isNunique().booleanValue()) continue;
                measure.verifyAggregates();
            }
        }
    }

    void verifyAggregates(OLAPMeasure inputMeasure) throws OLAPException {
        AggregationSet aggregationSet = this.owningCube.getAggregationSet();
        Boolean storedAggregations = aggregationSet.hasStoredAggregations();
        Boolean storedStatistic = inputMeasure.isStoredStatistic();
        if (storedStatistic != null && storedStatistic.booleanValue() && storedAggregations != null && storedAggregations.booleanValue()) {
            OLAPTable tableUsed = null;
            OLAPList tables = aggregationSet.getTables();
            int i = tables.size() - 1;
            while (i >= 0 & tableUsed == null) {
                AggregationTable table = (AggregationTable)tables.get(i);
                OLAPList aggregations = aggregationSet.getAggregationsByTable(table);
                if (aggregations.size() > 0) {
                    tableUsed = table;
                }
                --i;
            }
            if (tableUsed != null) {
                OLAPColumn controlColumn = inputMeasure.getAggregateColumn((AggregationTable)tableUsed);
                if (controlColumn == null) {
                    String name = "";
                    try {
                        name = tableUsed.getTable().getName();
                        throw new OLAPException(bundle.formatString("OLAPMeasure.NoAggregateColumn.fmt.txt", (Object)inputMeasure.getName(), (Object)name), 0);
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                    }
                }
                if (this.measures == null) {
                    this.getMeasures();
                }
                for (int i2 = this.measures.size() - 1; i2 >= 0; --i2) {
                    OLAPColumn variableColumn;
                    OLAPMeasure measure = (OLAPMeasure)this.measures.get(i2);
                    if (measure.equals(inputMeasure) || !controlColumn.equals(variableColumn = measure.getAggregateColumn((AggregationTable)tableUsed))) continue;
                    throw new OLAPException(bundle.getString("OLAPMeasure.CannotShareAggregateColumn.txt"), 0);
                }
            }
        }
    }

    void verifyDuplicateMappedMeasures() throws OLAPException {
        block8: {
            TableSet tableSet = this.owningCube.getTableSet();
            if (this.mappedMeasures == null) break block8;
            if (tableSet.isLoadClassicSAS()) {
                Collection values = this.mappedMeasures.values();
                ArrayList<Column> tempMappedMeasuress = new ArrayList<Column>();
                for (Column column : values) {
                    if (!tempMappedMeasuress.contains(column)) {
                        tempMappedMeasuress.add(column);
                        continue;
                    }
                    try {
                        throw new OLAPException(bundle.formatString("OLAPMeasure.MultipleMappedMeasures.fmt.txt", (Object)column.getName()), 0);
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                    }
                }
            } else {
                HashMap<Statistic, Column> mappedStatistics = new HashMap<Statistic, Column>();
                for (int i = this.measures.size() - 1; i >= 0; --i) {
                    OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                    Column mappedColumn = (Column)this.mappedMeasures.get(measure);
                    if (mappedColumn == null) continue;
                    Statistic statistic = measure.getStatistic();
                    Column mappedStatistic = (Column)mappedStatistics.get(statistic);
                    if (mappedStatistic == null) {
                        mappedStatistics.put(statistic, mappedStatistic);
                        continue;
                    }
                    throw new OLAPException(bundle.getString("OLAPMeasure.MultipleMappedStatistics.txt"), 0);
                }
            }
        }
    }

    private void verifyGroupName(List fromGroupName, List toGroupName, String fromName, String toName) throws OLAPException {
        OLAPMeasure measure;
        int i;
        ArrayList<Statistic> fromStatistics = new ArrayList<Statistic>();
        ArrayList<Statistic> toStatistics = new ArrayList<Statistic>();
        for (i = fromGroupName.size() - 1; i >= 0; --i) {
            measure = (OLAPMeasure)fromGroupName.get(i);
            fromStatistics.add(measure.getStatistic());
        }
        for (i = toGroupName.size() - 1; i >= 0; --i) {
            measure = (OLAPMeasure)toGroupName.get(i);
            toStatistics.add(measure.getStatistic());
        }
        for (i = fromStatistics.size() - 1; i >= 0; --i) {
            Statistic statistic = (Statistic)fromStatistics.get(i);
            if (toStatistics.indexOf(statistic) < 0) continue;
            throw new OLAPException(bundle.formatString("OLAPMeasure.InvalidGroupName.fmt.txt", (Object)fromName, (Object)toName), 0);
        }
    }

    private void verifyGroupName(OLAPList inputMeasures, OLAPMeasure inputMeasure) throws OLAPException {
        Statistic statistic = inputMeasure.getStatistic();
        for (int i = inputMeasures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)inputMeasures.get(i);
            if (measure.equals(inputMeasure)) continue;
            String analysisGroup = inputMeasure.getGroupName();
            Statistic measureStatistic = measure.getStatistic();
            if (measureStatistic == null || measureStatistic != statistic) continue;
            throw new OLAPException(bundle.formatString("OLAPMeasure.DuplicateStatisticAnalysisGroup.fmt.txt", (Object)statistic.getName(), (Object)analysisGroup), 0);
        }
    }

    void verifyGroupName(OLAPMeasure inputMeasure, String inputGroupName) throws OLAPException {
        Statistic statistic = inputMeasure.getStatistic();
        if (statistic != null) {
            OLAPList stored = this.getStoredMeasuresByGroupName(inputGroupName);
            OLAPList derived = this.getDerivedMeasuresByGroupName(inputGroupName);
            this.verifyGroupName(stored, inputMeasure);
            this.verifyGroupName(derived, inputMeasure);
        }
    }

    private void verifyGroupName(String fromGroupName, String toGroupName) throws OLAPException {
        OLAPList fromMeasures = this.getStoredMeasuresByGroupName(fromGroupName);
        OLAPList toMeasures = this.getStoredMeasuresByGroupName(toGroupName);
        this.verifyGroupName(fromMeasures, toMeasures, fromGroupName, toGroupName);
        fromMeasures = this.getDerivedMeasuresByGroupName(fromGroupName);
        toMeasures = this.getStoredMeasuresByGroupName(toGroupName);
        this.verifyGroupName(fromMeasures, toMeasures, fromGroupName, toGroupName);
    }

    void verifyInputColumn(OLAPMeasure inputMeasure) throws OLAPException {
        TableSet tableSet = this.owningCube.getTableSet();
        if (tableSet.isLoadClassicSAS()) {
            if (this.measures == null) {
                this.getMeasures();
            }
            OLAPColumn column = inputMeasure.getInputColumn();
            for (int i = this.measures.size() - 1; i >= 0; --i) {
                OLAPColumn testColumn;
                Boolean storedStatistic;
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                if (measure.isNunique().booleanValue() || (storedStatistic = measure.isStoredStatistic()) == null || !storedStatistic.booleanValue() || !(testColumn = measure.getInputColumn()).equals(column)) continue;
                throw new OLAPException(bundle.getString("OLAPMeasure.CannotShareAggregateColumn.txt"), 0);
            }
        }
    }

    public StringBuffer verifyMetadata() throws OLAPException {
        StringBuffer errorMessage = new StringBuffer();
        if (this.measures == null) {
            this.getMeasures();
        }
        for (int i = this.measures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            StringBuffer msg = measure.verifyMetadata();
            if (msg == null || msg.length() <= 0) continue;
            errorMessage.append(msg);
        }
        if (!ModelUtilities.isBlank(errorMessage.toString())) {
            this.synchRolap();
        }
        try {
            this.verifyMeasuresExist();
        }
        catch (OLAPException error) {
            errorMessage.append(error.getLocalizedMessage());
        }
        return errorMessage;
    }

    void verifyMappedAggregateColumns() throws OLAPException {
        AggregationSet aggregationSet = this.owningCube.getAggregationSet();
        OLAPList tables = aggregationSet.getTables();
        if (tables.size() > 1) {
            this.mappedMeasures.keySet().iterator();
            for (OLAPMeasure measure : this.mappedMeasures.keySet()) {
                Column mappedColumn = (Column)this.mappedMeasures.get(measure);
                for (int j = tables.size() - 1; j >= 0; --j) {
                    AggregationTable table = (AggregationTable)tables.get(j);
                    if (table.isLoadTable() && (!table.isLoadTable() || table.getTable() == null)) continue;
                    OLAPColumn aggregateColumn = null;
                    try {
                        aggregateColumn = table.getColumn(mappedColumn.getSASColumnName());
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                    }
                    if (aggregateColumn != null) continue;
                    throw new OLAPException(bundle.getString("LoadTable.NoAggregateMeasures.txt"), 0);
                }
            }
        }
    }

    void verifyMaximumMeasures() throws OLAPException {
        if (this.measures == null) {
            this.getMeasures();
        }
        if (this.measures.size() == 1024) {
            throw new OLAPException(bundle.getString("OLAPMeasure.TooManyMeasuresPerCube.txt"), 0);
        }
    }

    public void verifyMeasuresExist() throws OLAPException {
        if (this.measures == null) {
            this.getMeasures();
        }
        if (this.nuniqueMeasures == null) {
            this.getNUniqueMeasures();
        }
        if (this.measures.isEmpty() || this.measures.size() == this.nuniqueMeasures.size()) {
            throw new OLAPException(bundle.getString("OLAPMeasure.NoMeasures.txt"), 0);
        }
    }

    public void verifyStatistics() throws OLAPException {
        this.getMeasures();
        for (int i = this.measures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            if (measure.isNunique().booleanValue()) continue;
            measure.verifyStatistic();
        }
    }

    public void verifyGroupNames() throws OLAPException {
        this.getMeasures();
        for (int i = this.measures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            if (measure.isNunique().booleanValue()) continue;
            measure.verifyGroupName();
        }
    }

    void verifyUniqueColumn(OLAPMeasure inputMeasure) throws OLAPException {
        if (this.storedMeasures == null) {
            this.getStoredMeasures();
        }
        for (int i = this.storedMeasures.size() - 1; i >= 0; --i) {
            OLAPColumn inputMeasureColumn;
            OLAPColumn measureColumn;
            OLAPMeasure measure = (OLAPMeasure)this.storedMeasures.get(i);
            if (measure.isNunique().booleanValue() || measure.equals(inputMeasure) || !(measureColumn = measure.getInputColumn()).equals(inputMeasureColumn = inputMeasure.getInputColumn())) continue;
            throw new OLAPException(bundle.getString("OLAPMeasure.CannotShareAggregateColumn.txt"), 0);
        }
    }

    void verifyUniqueName(OLAPMeasure inputMeasure) throws OLAPException {
        String inputName = inputMeasure.getName();
        if (this.measures == null) {
            this.getMeasures();
        }
        for (int i = this.measures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            if (measure == inputMeasure || !measure.getName().equalsIgnoreCase(inputName)) continue;
            throw new OLAPException(bundle.getString("OLAPMeasure.DuplicateMeasureName.txt"), 0);
        }
    }

    static {
        emptyList.setModifiable(false);
    }
}

