/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class MLSCaptionTable
extends OLAPTable {
    private OLAPCube owningCube;
    private OLAPDimension dimension;
    private boolean isDimension;

    MLSCaptionTable(TableSet inputOLAPTableSet, PhysicalTable inputTable) throws OLAPException {
        this.tableSet = inputOLAPTableSet;
        this.owningCube = this.tableSet.getOwningCube();
        this.table = inputTable;
        List tables = this.tableSet.getTables();
        tables.add(this);
    }

    MLSCaptionTable(TableSet inputOLAPTableSet, PhysicalTable inputTable, OLAPDimension inputDim) throws OLAPException {
        this.tableSet = inputOLAPTableSet;
        this.owningCube = this.tableSet.getOwningCube();
        this.isDimension = true;
        this.dimension = inputDim;
        this.table = inputTable;
        List tables = this.tableSet.getTables();
        tables.add(this);
    }

    @Override
    public boolean isLoadTable() {
        return false;
    }

    public void setTable(PhysicalTable inTable) throws OLAPException {
        try {
            List tables = this.tableSet.getTables();
            tables.remove(this.table);
            this.table = inTable;
            tables.add(this.table);
            this.name = this.table.getSASTableName();
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    void updateMetadata() throws OLAPException {
        try {
            CustomAssociation custom = null;
            AssociationList customs = null;
            String nameOfObject = null;
            Option tableOptions = null;
            if (this.isDimension) {
                Dimension jomaDim = (Dimension)this.dimension.metadataObject;
                customs = jomaDim.getCustomAssociations();
                nameOfObject = jomaDim.getName();
                tableOptions = this.owningCube.getOptionsSet().getOption(this.dimension, this.dimension.getName() + "_cappref", "OLAP UDT");
            } else {
                Cube jomaCube = (Cube)this.owningCube.metadataObject;
                customs = jomaCube.getCustomAssociations();
                nameOfObject = jomaCube.getName();
                tableOptions = this.owningCube.getOptionsSet().getOption(this.owningCube, this.owningCube.getName() + "_cappref", "OLAP UDT");
            }
            int i = 0;
            int size = customs.size();
            while (i < size & custom == null) {
                CustomAssociation nextCustom;
                CMetadata object = (CMetadata)customs.elementAt(i);
                if (object.getCMetadataType().equalsIgnoreCase("CustomAssociation") && (nextCustom = (CustomAssociation)object).getPartnerName().equals("CaptionTableObject")) {
                    custom = nextCustom;
                }
                ++i;
            }
            if (custom == null) {
                custom = (CustomAssociation)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "CustomAssociation", this.getRepositoryShortFQID());
                custom.setName(nameOfObject + "_CaptionTable");
                custom.setisOwned(0);
                custom.setPartnerName("CaptionTableObject");
                customs.add((Object)custom);
            }
            AssociationList associatedObjects = custom.getAssociatedObjects();
            associatedObjects.clear();
            associatedObjects.add((Object)this.table);
            if (tableOptions != null) {
                tableOptions.updateMetadata();
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }
}

