/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.OLAPProperty;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AbstractInputTable;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LoadTable
extends AbstractInputTable {
    private OLAPList availableNumericColumns;
    private OLAPCube owningCube;
    private PhysicalTable mappedTable;
    private Map mappedTableColumns;
    private boolean isMapChanged;
    private static final String TRANSFORMATION_PROPERTY_NAME = "CLASS";
    private static final String TRANSFORMATION_PROPERTY_DESC = "TRANSFORMATIONSTEP";
    private static final String CODE_GENERATION_LOCATION = "com.sas.olapadmin.designer.model.CodeGeneration";
    private static final String CONNECTION = "OLAPCubeConnection";

    LoadTable(TableSet inputOLAPTableSet, PhysicalTable inputTable) throws OLAPException {
        this.tableSet = inputOLAPTableSet;
        this.owningCube = this.tableSet.getOwningCube();
        this.table = inputTable;
        this.setLoadTable(true);
        AggregationSet aggregationSet = this.owningCube.getAggregationSet();
        aggregationSet.setLoadTable(this);
        this.tableSet.setLoadTable(this);
        if (inputTable != null) {
            this.setSources(inputTable);
        }
        if (this.tableSet.isLoadClassicSAS()) {
            this.owningCube.getAggregationSet().setNwayGenerated(true);
        }
    }

    public void clearMap() throws OLAPException {
        this.mappedTable = null;
        if (this.mappedTableColumns != null) {
            this.mappedTableColumns.clear();
            this.mappedTableColumns = null;
        }
        this.owningCube.getDimensionSet().clearMapTable();
        this.owningCube.getMeasureSet().clearMapTable();
        this.owningCube.getOLAPMemberPropertySet().clearMapTable();
        this.owningCube.clearCubeMessage();
    }

    private void setMaps() throws OLAPException {
        try {
            ClassifierMap tempClassifierMap;
            Cube jomaCube = (Cube)this.owningCube.metadataObject;
            this.maps = jomaCube.getTargetClassifierMaps(false);
            if (!this.maps.isEmpty() && this.sources.indexOf((Object)(tempClassifierMap = (ClassifierMap)this.maps.get(0))) < 0) {
                this.sources.add((Object)tempClassifierMap);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void setSources(PhysicalTable inputTable) throws OLAPException {
        if (!this.tableSet.getTables().contains(this)) {
            this.tableSet.getTables().add(this);
        }
        this.tableSet.getLoadType();
        if (this.tableSet.isLoadStarSchema()) {
            this.setTemplate("<Templates><Column><ForeignKeyAssociations/></Column><ForeignKey><KeyedColumns/><KeyAssociations/><PartnerUniqueKey/></ForeignKey></Templates>");
            this.setTableAssociations(MetadataTemplate.getFactTableAssociations());
        }
        this.owningCube = this.tableSet.getOwningCube();
        if (this.owningCube.metadataObject != null) {
            try {
                if (inputTable != null) {
                    this.sources = inputTable.getSourceClassifierMaps(false);
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
    }

    @Override
    ClassifierMap createClassifierMap() throws OLAPException {
        super.createClassifierMap();
        String loadType = this.tableSet.getLoadType();
        try {
            if (loadType.equalsIgnoreCase(TableSet.FULLY_SUMMARIZED)) {
                this.classifierMap.setTransformRole("NWAY");
            } else if (loadType.equalsIgnoreCase(TableSet.DETAIL_TABLE)) {
                this.classifierMap.setTransformRole("BASE");
            } else {
                this.classifierMap.setTransformRole("STARFACT");
            }
            MdObjectStore objectStore = this.owningCube.getObjectStore();
            String shortFQID = this.owningCube.getRepositoryShortFQID();
            Property connectionProperty = (Property)MetadataTemplate.createMetadata(objectStore, "Property", shortFQID);
            connectionProperty.setName(CONNECTION);
            connectionProperty.setPropertyName(CONNECTION);
            connectionProperty.setPropertyRole(CONNECTION);
            connectionProperty.setSQLType(12);
            StringBuffer defaultValue = new StringBuffer();
            defaultValue.append(this.owningCube.getName()).append("/").append(this.owningCube.getAssociatedOLAPSchema().getName());
            connectionProperty.setDefaultValue(defaultValue.toString());
            AssociationList properties = this.classifierMap.getProperties(false);
            properties.add((Object)connectionProperty);
            TransformationStep transformationStep = (TransformationStep)MetadataTemplate.createMetadata(objectStore, "TransformationStep", shortFQID);
            Property transformationProperty = (Property)MetadataTemplate.createMetadata(objectStore, "Property", shortFQID);
            TransformationActivity transformationActivity = (TransformationActivity)MetadataTemplate.createMetadata(objectStore, "TransformationActivity", shortFQID);
            Job job = (Job)MetadataTemplate.createMetadata(objectStore, "Job", shortFQID);
            this.classifierMap.setIsActive(1);
            transformationStep.setName(this.owningCube.getName());
            transformationStep.getTransformations(false).addElement((Object)this.classifierMap);
            transformationStep.getActivities(false).addElement((Object)transformationActivity);
            transformationStep.getProperties(false).addElement((Object)transformationProperty);
            transformationStep.setIsActive(1);
            transformationStep.setIsUserDefined(0);
            transformationProperty.setName(TRANSFORMATION_PROPERTY_NAME);
            transformationProperty.setPropertyName(TRANSFORMATION_PROPERTY_NAME);
            transformationProperty.setDesc(TRANSFORMATION_PROPERTY_DESC);
            transformationProperty.setSQLType(OptionSet.OWNING_TYPE_STRING.intValue());
            transformationProperty.setDefaultValue(CODE_GENERATION_LOCATION);
            transformationProperty.setPropertyRole(TRANSFORMATION_PROPERTY_DESC);
            transformationActivity.setName(this.owningCube.getName());
            transformationActivity.getJobs(false).addElement((Object)job);
            job.setName(this.owningCube.getName());
            job.setIsActive(1);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return this.classifierMap;
    }

    public OLAPList getAvailableNumericColumns() throws OLAPException {
        if (this.availableNumericColumns == null) {
            this.availableNumericColumns = new OLAPList(OLAPColumn.class);
        }
        if (this.availableNumericColumns.isEmpty()) {
            List numericColumns = this.getAllNumericColumns();
            for (int i = numericColumns.size() - 1; i >= 0; --i) {
                this.availableNumericColumns.getTheList().add(numericColumns.get(i));
            }
            this.availableNumericColumns.sort();
            this.availableNumericColumns.setModifiable(false);
        }
        return this.availableNumericColumns;
    }

    @Override
    ClassifierMap getClassifierMap() throws OLAPException {
        if (this.classifierMap == null) {
            if (this.maps == null) {
                this.setMaps();
            }
            super.getClassifierMap();
            try {
                ArrayList<String> associations = new ArrayList<String>();
                associations.add("ClassifierSources");
                associations.add("ClassifierTargets");
                associations.add("FeatureMaps");
                associations.add("TransformationSources");
                associations.add("TransformationTargets");
                associations.add("Properties");
                associations.add("Notes");
                associations.add("SourceCode");
                associations.add("Steps");
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.classifierMap, null, associations, null, 8);
            }
            catch (MdException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
        return this.classifierMap;
    }

    AssociationList getForeignKeys() throws OLAPException {
        AssociationList foreignKeys = null;
        try {
            this.getMetadata();
            foreignKeys = this.table.getForeignKeys(false);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return foreignKeys;
    }

    public Column getMappedFactKey(OLAPDimension inputDimension) {
        return this.owningCube.getDimensionSet().getMappedFactKey(inputDimension);
    }

    public Column getMappedLevel(OLAPLevel inputLevel) {
        return this.owningCube.getDimensionSet().getMappedLevel(inputLevel);
    }

    public Column getMappedOLAPMemberProperty(OLAPMemberProperty inputMemberProperty) {
        return this.owningCube.getOLAPMemberPropertySet().getMappedMemberProperty(inputMemberProperty);
    }

    public Column getMappedMeasure(OLAPMeasure inputMeasure) throws OLAPException {
        return this.owningCube.getMeasureSet().getMappedMeasure(inputMeasure);
    }

    public String getTableOptions() throws OLAPException {
        return this.owningCube.getTableOptions();
    }

    public OLAPList getUnmappedFactKeys() throws OLAPException {
        return this.owningCube.getDimensionSet().getUnmappedFactKeys();
    }

    public OLAPList getUnmappedLevels() throws OLAPException {
        return this.owningCube.getDimensionSet().getUnmappedLevels();
    }

    public OLAPList getUnmappedMeasures() throws OLAPException {
        return this.owningCube.getMeasureSet().getUnmappedMeasures();
    }

    public OLAPList getUnmappedOLAPMemberProperties() throws OLAPException {
        return this.owningCube.getOLAPMemberPropertySet().getUnmappedOLAPMemberProperties();
    }

    public PhysicalTable getMappedTable() {
        return this.mappedTable;
    }

    public List getMappedTableStructureChanges() throws OLAPException {
        OLAPList tempMeasures;
        OLAPList tempMemberProperties;
        OLAPDimension dimension;
        List changes = this.owningCube.getCubeMessage();
        changes.clear();
        OLAPList tempLevels = this.getUnmappedLevels();
        OLAPList tempFactKeys = this.getUnmappedFactKeys();
        if (tempLevels != null) {
            for (int i = tempLevels.size() - 1; i >= 0; --i) {
                OLAPLevel level = (OLAPLevel)tempLevels.get(i);
                dimension = level.getDimension();
                try {
                    changes.add(bundle.formatString("LoadTable.LevelWillBeRemoved.fmt.txt", (Object)level.getName(), (Object)this.mappedTable.getName(), (Object)dimension.getName()));
                    continue;
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
            }
        }
        List dimensions = this.owningCube.getDimensionSet().getAllCubeDimensions();
        for (int i = dimensions.size() - 1; i >= 0; --i) {
            dimension = (OLAPDimension)dimensions.get(i);
            if (tempFactKeys != null && tempFactKeys.indexOf(dimension) >= 0) {
                changes.add(bundle.formatString("LoadTable.DimensionMissingFactKey.fmt.txt", (Object)dimension.getName()));
                continue;
            }
            OLAPList hierarchies = dimension.getHierarchies();
            int hierarchyCount = 0;
            for (int j = hierarchies.size() - 1; j >= 0; --j) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(j);
                OLAPList hierarchyLevels = hierarchy.getLevels();
                int hierarchyLevelCount = 0;
                for (int k = hierarchyLevels.size() - 1; k >= 0; --k) {
                    OLAPLevel hierarchyLevel = (OLAPLevel)hierarchyLevels.get(k);
                    if (tempLevels.indexOf(hierarchyLevel) < 0) continue;
                    ++hierarchyLevelCount;
                }
                if (hierarchyLevelCount != hierarchyLevels.size()) continue;
                try {
                    ++hierarchyCount;
                    changes.add(bundle.formatString("OLAPHierarchy.HierarchyWillBeRemoved.fmt.txt", (Object)hierarchy.getName(), (Object)this.mappedTable.getName(), (Object)dimension.getName()));
                    continue;
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
            }
            if (hierarchyCount != hierarchies.size()) continue;
            changes.add(bundle.formatString("OLAPDimension.DimensionWillBeRemoved.fmt.txt", (Object)dimension.getName()));
        }
        if (changes.size() > 0) {
            changes.add(bundle.getString("DimensionSet.Reset.Aggregations.txt"));
        }
        if ((tempMemberProperties = this.getUnmappedOLAPMemberProperties()) != null) {
            for (int i = tempMemberProperties.size() - 1; i >= 0; --i) {
                OLAPMemberProperty property = (OLAPMemberProperty)tempMemberProperties.get(i);
                try {
                    changes.add(bundle.formatString("LoadTable.OLAPPropertyWillBeRemoved.fmt.txt", (Object)property.getName(), (Object)this.mappedTable.getName()));
                    continue;
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
            }
        }
        if ((tempMeasures = this.getUnmappedMeasures()) != null) {
            for (int i = tempMeasures.size() - 1; i >= 0; --i) {
                OLAPMeasure measure = (OLAPMeasure)tempMeasures.get(i);
                changes.add(bundle.formatString("OLAPMeasure.MeasureWillBeRemoved.fmt.txt", (Object)measure.getName()));
            }
        }
        return changes;
    }

    public StringBuffer getMappedMessage() throws OLAPException {
        StringBuffer message = new StringBuffer();
        if (this.mappedTable != null) {
            this.owningCube.clearCubeVerifyMessage();
            this.mapTable(this.mappedTable);
            if (!this.isPerfectMap() || this.isMapChanged()) {
                DimensionSet dimensionSet = this.owningCube.getDimensionSet();
                MeasureSet measureSet = this.owningCube.getMeasureSet();
                OLAPMemberPropertySet propertySet = this.owningCube.getOLAPMemberPropertySet();
                message.append(bundle.getString("LoadTable.MappingInformation.intro.txt"));
                message.append(ModelUtilities.newline).append(ModelUtilities.newline);
                message.append(dimensionSet.getMappedRatio());
                message.append(measureSet.getMappedRatio());
                message.append(propertySet.getMappedRatio());
                message.append(ModelUtilities.newline);
            }
        }
        return message;
    }

    public boolean isMapChanged() {
        return this.isMapChanged;
    }

    public boolean isPerfectMap() {
        boolean perfectMap = true;
        try {
            if (this.mappedTable != null) {
                DimensionSet dimensionSet = this.owningCube.getDimensionSet();
                MeasureSet measureSet = this.owningCube.getMeasureSet();
                OLAPMemberPropertySet propertySet = this.owningCube.getOLAPMemberPropertySet();
                OLAPList unMappedFactKeys = dimensionSet.getUnmappedFactKeys();
                OLAPList unMappedLevels = dimensionSet.getUnmappedLevels();
                OLAPList unMappedMeasures = measureSet.getUnmappedMeasures();
                OLAPList unMappedProperties = propertySet.getUnmappedOLAPMemberProperties();
                if (unMappedFactKeys != null) {
                    perfectMap = unMappedFactKeys.isEmpty();
                }
                if (unMappedLevels != null) {
                    boolean bl = perfectMap = perfectMap && unMappedLevels.isEmpty();
                }
                if (unMappedMeasures != null) {
                    boolean bl = perfectMap = perfectMap && unMappedMeasures.isEmpty();
                }
                if (unMappedProperties != null) {
                    perfectMap = perfectMap && unMappedProperties.isEmpty();
                }
            }
        }
        catch (OLAPException error) {
            perfectMap = false;
        }
        return perfectMap;
    }

    @Override
    public boolean isSimilar(PhysicalTable inputTable) throws OLAPException {
        boolean similar;
        boolean bl = similar = inputTable != null && this.table != null;
        if (similar) {
            similar = false;
            if (!this.owningCube.hasStructure()) {
                similar = super.isSimilar(inputTable);
            } else {
                similar = this.equals(inputTable);
                if (!similar) {
                    String olapColumnName;
                    int i;
                    Map inputColumnMap = this.getColumnMap(inputTable);
                    similar = true;
                    DimensionSet dimensionSet = this.owningCube.getDimensionSet();
                    MeasureSet measureSet = this.owningCube.getMeasureSet();
                    OLAPMemberPropertySet memberPropertySet = this.owningCube.getOLAPMemberPropertySet();
                    List dimensions = dimensionSet.getAllCubeDimensions();
                    OLAPList measures = measureSet.getMeasures();
                    List memberProperties = memberPropertySet.getOLAPPropertiesByTable(this);
                    for (i = dimensions.size() - 1; i >= 0 && similar; --i) {
                        boolean checkDimension;
                        OLAPDimension dimension = (OLAPDimension)dimensions.get(i);
                        boolean bl2 = checkDimension = !this.tableSet.isLoadStarSchema();
                        if (!checkDimension && !dimension.isShared()) {
                            DimensionTable dimensionTable = dimension.getTable();
                            checkDimension = dimensionTable.equals(this);
                        }
                        if (checkDimension) {
                            OLAPList levels = dimension.getLevels();
                            for (int j = levels.size() - 1; j >= 0 && similar; --j) {
                                String olapColumnName2;
                                Column column;
                                OLAPLevel olapLevel = (OLAPLevel)levels.get(j);
                                OLAPColumn olapColumn = olapLevel.getColumn();
                                similar = olapColumn != null ? (column = (Column)inputColumnMap.get(olapColumnName2 = olapColumn.getSASColumnName().toUpperCase())) != null : false;
                            }
                        }
                        if (!this.tableSet.isLoadStarSchema()) continue;
                        OLAPColumn olapColumn = null;
                        if (!dimension.isShared()) {
                            olapColumn = dimension.getFactKey();
                        } else {
                            OLAPSharedDimension sharedDim = (OLAPSharedDimension)dimension;
                            olapColumn = sharedDim.getSharedDimensionFactKey(this.owningCube);
                        }
                        if (olapColumn == null || !similar) continue;
                        String olapColumnName3 = olapColumn.getSASColumnName().toUpperCase();
                        Column column = (Column)inputColumnMap.get(olapColumnName3);
                        similar = column != null;
                    }
                    if (similar) {
                        for (i = measures.size() - 1; i >= 0 && similar; --i) {
                            OLAPColumn olapColumn;
                            OLAPMeasure measure = (OLAPMeasure)measures.get(i);
                            if (!measure.isStoredStatistic().booleanValue() || (olapColumn = measure.getInputColumn()) == null) continue;
                            olapColumnName = olapColumn.getSASColumnName().toUpperCase();
                            Column column = (Column)inputColumnMap.get(olapColumnName);
                            similar = column != null;
                        }
                    }
                    if (similar) {
                        for (i = memberProperties.size() - 1; i >= 0 && similar; --i) {
                            OLAPMemberProperty memberProperty = (OLAPMemberProperty)memberProperties.get(i);
                            OLAPColumn olapColumn = memberProperty.getColumn();
                            olapColumnName = olapColumn.getSASColumnName().toUpperCase();
                            Column column = (Column)inputColumnMap.get(olapColumnName);
                            similar = column != null;
                        }
                    }
                }
            }
        }
        return similar;
    }

    void setIsMapChanged(boolean mapChanged) {
        this.isMapChanged = mapChanged;
    }

    public void mapFactKey(OLAPDimension inputDimension, Column inputColumn) throws OLAPException {
        if (this.mappedTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Set a table to be mapped before mapping Cube Structure.");
            }
            throw new IllegalStateException("An illegal use of the mapFactKey was encountered.");
        }
        this.owningCube.getDimensionSet().mapFactKey(inputDimension, inputColumn);
    }

    public void mapLevel(OLAPLevel inputLevel, Column inputColumn) throws OLAPException {
        if (this.mappedTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Set a table to be mapped before mapping Cube Structure.");
            }
            throw new IllegalStateException("An illegal use of the mapFactKey was encountered.");
        }
        this.owningCube.getDimensionSet().mapLevel(inputLevel, inputColumn);
    }

    public boolean mapHasValidStructure() throws OLAPException {
        DimensionSet dimensionSet = this.owningCube.getDimensionSet();
        MeasureSet measureSet = this.owningCube.getMeasureSet();
        return dimensionSet.hasOneValidMappedLevel() || measureSet.hasOneValidMappedMeasure();
    }

    public void mapMeasure(OLAPMeasure inputMeasure, Column inputColumn) throws OLAPException {
        try {
            if (!inputColumn.getSASColumnType().equalsIgnoreCase(OLAPTable.numeric)) {
                if (Workspace.isDebug()) {
                    Workspace.getDefaultLogger().debug((Object)"Measures must be mapped to numeric columns.");
                }
                throw new IllegalArgumentException("Illegal argument passed to the mapMeasure method");
            }
            if (this.mappedTable == null) {
                throw new IllegalStateException("Set a table to be mapped before mapping Cube Structure.");
            }
            if (inputMeasure.isNunique() != null && inputMeasure.isNunique().booleanValue()) {
                throw new OLAPException(bundle.getString("LoadTable.CannotMapNuniqueMeasure.txt"), 0);
            }
            this.owningCube.getMeasureSet().mapMeasure(inputMeasure, inputColumn);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public void mapOLAPMemberProperty(OLAPMemberProperty inputMemberProperty, Column inputColumn) throws OLAPException {
        if (this.mappedTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Set a table to be mapped before mapping Cube Structure.");
            }
            throw new IllegalStateException("An illegal use of the mapOLAPMemberProperty method was encountered.");
        }
        this.owningCube.getOLAPMemberPropertySet().mapMemberProperty(inputMemberProperty, inputColumn);
    }

    public void mapTable(PhysicalTable inputTable) throws OLAPException {
        if (inputTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The input table to be mapped cannot be null.");
            }
            throw new IllegalArgumentException("Illegal argument passed to the isSimilar method.");
        }
        if (this.equals(inputTable)) {
            try {
                String debug = "The LoadTable.mapTable() method cannot map a table that is already the loadtable.";
                throw new OLAPException(bundle.formatString("LoadTable.MapTableSameTable.fmt.txt", (Object)inputTable.getName()), 0, debug);
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
        if (this.mappedTable != null && this.mappedTable != inputTable) {
            this.clearMap();
        }
        if (!this.isSimilar(inputTable)) {
            DimensionSet dimensionSet = this.owningCube.getDimensionSet();
            MeasureSet measureSet = this.owningCube.getMeasureSet();
            OLAPMemberPropertySet memberPropertySet = this.owningCube.getOLAPMemberPropertySet();
            if (this.mappedTable == null) {
                this.mappedTable = inputTable;
                this.mappedTableColumns = this.getColumnMap(this.mappedTable);
                dimensionSet.mapTable(this.mappedTableColumns);
                measureSet.mapTable(this.mappedTableColumns);
                memberPropertySet.mapTable(this.mappedTableColumns);
            }
        }
    }

    private void removeUnmappedStructure() throws OLAPException {
        this.owningCube.getOLAPMemberPropertySet().removeUnmappedStructure();
        this.owningCube.getDimensionSet().removeUnmappedStructure();
        this.owningCube.getMeasureSet().removeUnmappedStructure();
    }

    @Override
    void reset(PhysicalTable inputTable, boolean similar) throws OLAPException {
        super.reset(inputTable, similar);
        if (!similar) {
            this.owningCube.reset();
        } else {
            this.table = inputTable;
            this.setSources(this.table);
            this.owningCube.getDimensionSet().resetDimensionKeys(this, this.table);
        }
        if (this.availableNumericColumns != null && !this.availableNumericColumns.isEmpty()) {
            this.availableNumericColumns.setModifiable(true);
            this.availableNumericColumns.clear();
            this.getAvailableNumericColumns();
        }
    }

    private void setJobName(Job job) throws OLAPException {
        try {
            if (job != null && !this.owningCube.isNewObject()) {
                String originalJobName = job.getName();
                String originalCubeName = this.owningCube.getOriginalName();
                String cubeName = this.owningCube.getName();
                if (originalJobName.equals(originalCubeName)) {
                    job.setName(cubeName);
                }
            }
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void setActivityName(TransformationActivity activity) throws OLAPException {
        try {
            if (activity != null && !this.owningCube.isNewObject()) {
                String originalActivityName = activity.getName();
                String originalCubeName = this.owningCube.getOriginalName();
                String cubeName = this.owningCube.getName();
                if (originalActivityName.equals(originalCubeName)) {
                    activity.setName(cubeName);
                }
            }
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void setStepName(TransformationStep step) throws OLAPException {
        try {
            if (step != null && !this.owningCube.isNewObject()) {
                String originalStepName = step.getName();
                String originalCubeName = this.owningCube.getOriginalName();
                String cubeName = this.owningCube.getName();
                if (originalStepName.equals(originalCubeName)) {
                    step.setName(cubeName);
                }
            }
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    @Override
    void setMapToTable(PhysicalTable inputTable, Map inputColumns) throws OLAPException {
        super.setMapToTable(inputTable, inputColumns);
        this.setSources(inputTable);
        if (this.availableNumericColumns != null) {
            this.availableNumericColumns.getTheList().clear();
            this.getAvailableNumericColumns();
            MeasureSet measureSet = this.owningCube.getMeasureSet();
            OLAPList measures = this.owningCube.getMeasureSet().getMeasures();
            for (int i = measures.size() - 1; i >= 0; --i) {
                OLAPMeasure measure = (OLAPMeasure)measures.get(i);
                Column column = measureSet.getMappedMeasure(measure);
                if (column == null || !this.tableSet.isLoadClassicSAS()) continue;
                OLAPColumn olapColumn = null;
                try {
                    olapColumn = this.getColumn(column.getSASColumnName());
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
                this.availableNumericColumns.getTheList().remove(olapColumn);
            }
        }
        if (this.tableSet.isLoadClassicSAS()) {
            AggregationSet aggregationSet = this.owningCube.getAggregationSet();
            OLAPAggregation defaultAggregation = aggregationSet.getDefaultAggregation();
            AggregationTable aggregationTable = defaultAggregation.getAggregationTable();
            defaultAggregation.setAggregationTable(aggregationTable);
            aggregationTable.setSources(this.table);
        }
    }

    private void setMapToStructure() throws OLAPException {
        this.tableSet.setMapToStructure();
        this.owningCube.getDimensionSet().setMapToStructure();
        this.owningCube.getMeasureSet().setMapToStructure();
        this.owningCube.getOLAPMemberPropertySet().setMapToStructure();
    }

    void setSources() throws OLAPException {
        try {
            this.sources = this.mappedTable.getSourceClassifierMaps(false);
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    void setTable(PhysicalTable inputTable) throws OLAPException {
        if (this.mappedTable != null) {
            this.owningCube.setErrorLevel(-1);
            this.verifyMappedStructure();
            StringBuffer message = this.getMappedMessage();
            this.owningCube.clearCubeVerifyMessage();
            StringBuffer cubeMessage = this.owningCube.getCubeVerifyMessage();
            cubeMessage.append(message);
            this.setMapToTable(this.mappedTable, this.mappedTableColumns);
            this.removeUnmappedStructure();
            this.setMapToStructure();
        } else if (!this.equals(inputTable)) {
            this.reset(inputTable, this.isSimilar(inputTable));
        }
    }

    public void setTableOptions(String inputOption) throws OLAPException {
        this.owningCube.setTableOptions(inputOption);
    }

    private void updateMetadataJob() throws OLAPException {
        try {
            AssociationList jobs;
            AssociationList stepActivities;
            TransformationActivity transformationActivity = null;
            Job job = null;
            TransformationStep transformationStep = (TransformationStep)this.classifierMap.getSteps().get(0);
            AssociationList stepProperties = transformationStep.getProperties(false);
            if (stepProperties.isEmpty()) {
                stepProperties = transformationStep.getProperties(true);
            }
            if (!stepProperties.isEmpty()) {
                Property transformationProperty = (Property)stepProperties.get(0);
                MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)transformationProperty, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
            }
            if ((stepActivities = transformationStep.getActivities(false)).isEmpty()) {
                stepActivities = transformationStep.getActivities(true);
            }
            if ((jobs = (transformationActivity = (TransformationActivity)stepActivities.get(0)).getJobs(false)).isEmpty()) {
                jobs = transformationActivity.getJobs(true);
            }
            job = (Job)jobs.get(0);
            job.setPublicType("Job.CubeBuild");
            UsageVersion usageVersion = new UsageVersion(Integer.valueOf(this.getJobVersionNumber()).intValue(), Integer.valueOf(this.getJobMinorNumber()).intValue(), Integer.valueOf(this.getJobMicroNumber()).intValue());
            job.setUsageVersion(usageVersion.encode());
            AssociationList trees = job.getTrees(true);
            if (trees.isEmpty()) {
                trees.add((Object)this.owningCube.getFolder());
            } else {
                Tree originalCubeTree;
                Tree currentTree = (Tree)trees.get(0);
                if (currentTree.equals(originalCubeTree = this.owningCube.getOriginalFolder())) {
                    trees.clear();
                    trees.add((Object)this.owningCube.getFolder());
                }
            }
            AssociationList jobProperties = job.getProperties(false);
            if (jobProperties.isEmpty()) {
                jobProperties = job.getProperties(true);
            }
            if (!jobProperties.isEmpty()) {
                Property property = (Property)jobProperties.get(0);
                MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
            }
            this.setJobName(job);
            this.setActivityName(transformationActivity);
            this.setStepName(transformationStep);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    void updateMetadata() throws OLAPException {
        if (this.sources == null) {
            this.setSources(this.table);
        }
        this.setMaps();
        this.updateMetadataClassifierMap();
        this.updateMetadataJob();
    }

    private void updateMetadataClassifierMap() throws OLAPException {
        try {
            this.getClassifierMap();
            if (this.classifierMap == null) {
                this.classifierMap = this.createClassifierMap();
            } else {
                AssociationList classifierSources = this.classifierMap.getClassifierSources(false);
                PhysicalTable classifierMapTable = null;
                if (!classifierSources.isEmpty()) {
                    classifierMapTable = (PhysicalTable)classifierSources.get(0);
                }
                if (classifierMapTable != null && classifierMapTable != this.table || classifierSources.isEmpty()) {
                    classifierSources.clear();
                    classifierSources.add((Object)this.table);
                    AssociationList featureMaps = this.classifierMap.getFeatureMaps();
                    for (int i = featureMaps.size() - 1; i >= 0; --i) {
                        OLAPMemberPropertySet propertySet;
                        OLAPMemberProperty property;
                        FeatureMap featureMap = (FeatureMap)featureMaps.get(i);
                        AssociationList featureSources = featureMap.getFeatureSources();
                        AssociationList featureTargets = featureMap.getFeatureTargets();
                        if (featureTargets.isEmpty()) continue;
                        CMetadata metadataObject = (CMetadata)featureTargets.get(0);
                        OLAPColumn olapColumn = null;
                        if (metadataObject instanceof Measure) {
                            MeasureSet measureSet = this.owningCube.getMeasureSet();
                            OLAPMeasure measure = measureSet.getMeasure((Measure)metadataObject);
                            if (measure != null) {
                                olapColumn = measure.getInputColumn();
                            }
                        } else if (metadataObject instanceof Level) {
                            DimensionSet dimensionSet = this.owningCube.getDimensionSet();
                            OLAPLevel level = dimensionSet.getLevel((Level)metadataObject);
                            if (level != null) {
                                olapColumn = level.getColumn();
                            }
                        } else if (metadataObject instanceof OLAPProperty && (property = (propertySet = this.owningCube.getOLAPMemberPropertySet()).getOLAPMemberProperty((OLAPProperty)metadataObject)) != null) {
                            olapColumn = property.getColumn();
                        }
                        if (olapColumn == null) continue;
                        featureSources.clear();
                        featureSources.add((Object)olapColumn.metadataObject);
                    }
                }
            }
            AssociationList properties = this.classifierMap.getProperties(false);
            Property connectionProperty = null;
            if (!properties.isEmpty()) {
                connectionProperty = (Property)properties.get(0);
            } else {
                connectionProperty = (Property)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Property", this.owningCube.getRepositoryShortFQID());
                connectionProperty.setName(CONNECTION);
                connectionProperty.setPropertyName(CONNECTION);
                connectionProperty.setPropertyRole(CONNECTION);
                connectionProperty.setSQLType(12);
                properties.add((Object)connectionProperty);
            }
            StringBuffer defaultValue = new StringBuffer();
            defaultValue.append(this.owningCube.getName()).append("/").append(this.owningCube.getAssociatedOLAPSchema().getName());
            connectionProperty.setDefaultValue(defaultValue.toString());
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private String getJobVersionNumber() {
        return "1";
    }

    private String getJobMinorNumber() {
        return "0";
    }

    private String getJobMicroNumber() {
        return "0";
    }

    void verifyMappedStructure() throws OLAPException {
        MeasureSet measureSet = this.owningCube.getMeasureSet();
        boolean validStructure = this.mapHasValidStructure();
        if (!validStructure) {
            try {
                throw new OLAPException(bundle.formatString("LoadTable.MappedTableNotValidStructure.fmt.txt", (Object)this.mappedTable.getName()), 0);
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
        measureSet.verifyDuplicateMappedMeasures();
        if (this.tableSet.isLoadClassicSAS()) {
            measureSet.verifyMappedAggregateColumns();
        }
    }
}

