/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractInputTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.Map;

public class DimensionTable
extends AbstractInputTable {
    private LoadTable loadTable;

    DimensionTable(TableSet inputTableSet, PhysicalTable inputTable) throws OLAPException {
        this.tableSet = inputTableSet;
        if (inputTable != null) {
            this.setSources(inputTable);
        }
    }

    @Override
    ClassifierMap createClassifierMap() throws OLAPException {
        if (!this.isLoadTable()) {
            super.createClassifierMap();
            try {
                this.classifierMap.setName("STARDIM");
                this.classifierMap.setTransformRole("STARDIM");
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        } else {
            this.loadTable = this.tableSet.getLoadTable();
            this.classifierMap = this.loadTable.getClassifierMap();
            if (this.classifierMap == null) {
                this.classifierMap = this.loadTable.createClassifierMap();
            }
        }
        return this.classifierMap;
    }

    @Override
    public boolean isSimilar(PhysicalTable inputTable) throws OLAPException {
        if (Workspace.isDebug()) {
            Workspace.getDefaultLogger().debug((Object)"You must specify an OLAPDImension to check if a table is similar to this dimension table.  Use DimensionTable.isSimilar(OLAPDimension, PhysicalTable) and pass in a valid OLAPDimension object.");
        }
        throw new UnsupportedOperationException("DimentionsTable isSimilar (table) method is unsupported.");
    }

    @Override
    ClassifierMap getClassifierMap() throws OLAPException {
        if (this.classifierMap == null) {
            if (this.maps == null) {
                this.setMaps();
            }
            super.getClassifierMap();
        }
        return this.classifierMap;
    }

    public boolean isSimilar(OLAPDimension dimension, PhysicalTable inputTable) throws OLAPException {
        boolean similar;
        if (dimension == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The OLAPDimension parameter cannot be null, and must be an OLAPDimension that has not been deleted.");
            }
            throw new IllegalArgumentException("Illegal argument passed to the isSimilar method.");
        }
        boolean bl = similar = inputTable != null;
        if (similar && !(similar = this.equals(inputTable))) {
            similar = true;
            OLAPList levels = dimension.getLevels();
            if (levels.isEmpty()) {
                similar = super.isSimilar(inputTable);
            } else {
                OLAPColumn dimensionKey;
                similar = true;
                Map inputColumnMap = this.getColumnMap(inputTable);
                for (int i = levels.size() - 1; i >= 0 && similar; --i) {
                    OLAPLevel olapLevel = (OLAPLevel)levels.get(i);
                    OLAPColumn olapColumn = olapLevel.getColumn();
                    String olapColumnName = olapColumn.getSASColumnName().toUpperCase();
                    Column column = (Column)inputColumnMap.get(olapColumnName);
                    boolean bl2 = similar = column != null;
                    if (!similar) continue;
                    OLAPList olapProperties = olapLevel.getOLAPProperties();
                    for (int j = olapProperties.size() - 1; j >= 0 && similar; --j) {
                        OLAPMemberProperty property = (OLAPMemberProperty)olapProperties.get(j);
                        OLAPColumn propertyColumn = property.getColumn();
                        String propertyColumnName = propertyColumn.getSASColumnName().toUpperCase();
                        Column inputPropertyColumn = (Column)inputColumnMap.get(propertyColumnName);
                        similar = inputPropertyColumn != null;
                    }
                }
                if (similar && (dimensionKey = dimension.getDimensionKey()) != null) {
                    String keyColumnName = dimensionKey.getSASColumnName().toUpperCase();
                    Column inputKeyColumn = (Column)inputColumnMap.get(keyColumnName);
                    similar = inputKeyColumn != null;
                }
            }
        }
        return similar;
    }

    private void setMaps() throws OLAPException {
        try {
            Cube jomaCube = (Cube)this.tableSet.getOwningCube().metadataObject;
            this.maps = this.loadTable != null && this.loadTable.equals(this) ? jomaCube.getTargetClassifierMaps(false) : jomaCube.getTargetTransformations(false);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    void setSources(PhysicalTable inputTable) throws OLAPException {
        try {
            this.table = inputTable;
            this.loadTable = this.tableSet.getLoadTable();
            this.tableSet.getTables().add(this);
            if (this.loadTable != null && this.loadTable.equals(this)) {
                this.sources = inputTable.getSourceClassifierMaps(false);
                this.setLoadTable(true);
                this.columns = this.loadTable.getColumns();
            } else {
                this.setLoadTable(false);
                this.setMetadataUtilOptions(8204);
                this.setTableAssociations(MetadataTemplate.getDimensionTableAssociations());
                this.setTemplate("<Templates><Column><UniqueKeyAssociations/></Column><UniqueKey><KeyedColumns/><ForeignKeys/></UniqueKey><ForeignKey><KeyedColumns/></ForeignKey></Templates>");
                this.sources = inputTable.getSourceTransformations(false);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    void updateMetadata() throws OLAPException {
        this.setMaps();
    }
}

