/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AggregationSet {
    private static WAdminResource bundle = new WAdminResource(AggregationSet.class);
    private OLAPList addedAggregations;
    private OLAPList aggregations;
    private Map aggregationsByTable;
    private List autoDeletedAggregations;
    private List autoDeletedAggregationTables;
    private List drillPaths;
    private List deleteList;
    private OLAPList droppedAggregations;
    private OLAPList generatedAggregations;
    private Boolean hasStoredAggregations;
    private LoadTable loadTable;
    private Boolean nwayGenerated;
    private OLAPCube owningCube;
    private OLAPList performanceAggregations;
    private OLAPList storedAggregations;
    private OLAPList tables;
    private OLAPAggregation defaultAggregation;
    private boolean resetAggregationLevels;
    private boolean resettingAggregationTables;
    private List coalescedAggregations;
    private boolean aggregationTuning;

    AggregationSet(OLAPCube inputOwningCube) {
        this.owningCube = inputOwningCube;
        this.resettingAggregationTables = false;
        this.aggregationTuning = false;
    }

    void addAggregationByTable(OLAPAggregation aggregation, AggregationTable table) throws OLAPException {
        this.getAggregationsByTable(table);
        OLAPList aggregationTables = (OLAPList)this.aggregationsByTable.get(table);
        if (aggregationTables.indexOf(aggregation) < 0) {
            aggregationTables.getTheList().add(aggregation);
        }
    }

    void cleanseTables() throws OLAPException {
        if (this.tables == null) {
            this.getTables();
        }
        if (this.storedAggregations == null) {
            this.getStoredAggregations();
        }
        List javaTables = this.tables.getTheList();
        javaTables.clear();
        for (int i = this.storedAggregations.size() - 1; i >= 0; --i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.storedAggregations.get(i);
            AggregationTable table = aggregation.getAggregationTable();
            if (javaTables.contains(table)) continue;
            javaTables.add(table);
        }
    }

    public OLAPAggregation createOLAPAggregation() throws OLAPException {
        OLAPAggregation olapAggregation = new OLAPAggregation();
        if (this.aggregations == null) {
            this.getAggregations();
        }
        olapAggregation.setAggregationSet(this);
        olapAggregation.setOwningCube(this.owningCube);
        this.aggregations.add(olapAggregation);
        if (this.isAggregationTuning()) {
            this.getAddedAggregations();
            this.addedAggregations.getTheList().add(olapAggregation);
        }
        return olapAggregation;
    }

    private OLAPAggregation createOLAPAggregation(Aggregation inputJomaAggregation) throws OLAPException {
        OLAPAggregation olapAggregation = new OLAPAggregation(inputJomaAggregation, this.owningCube);
        olapAggregation.setAggregationSet(this);
        return olapAggregation;
    }

    void delete(OLAPAggregation deleteAggregation) throws OLAPException {
        if (this.aggregations == null) {
            this.getAggregations();
        }
        this.aggregations.remove(deleteAggregation);
    }

    public OLAPCube getOwningCube() {
        return this.owningCube;
    }

    StringBuffer generateCode() throws OLAPException {
        if (this.resetAggregationLevels) {
            this.resetLevels();
        }
        StringBuffer aggregationStatements = new StringBuffer();
        if (this.aggregations == null) {
            this.getAggregations();
        }
        int size = this.aggregations.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                aggregationStatements.append(ModelUtilities.newline);
            }
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(i);
            aggregationStatements.append(aggregation.generateCode());
            if (i >= size - 1) continue;
            aggregationStatements.append(ModelUtilities.newline);
        }
        return aggregationStatements;
    }

    public StringBuffer generateCoalesceCode(boolean saveProcCode) throws OLAPException {
        StringBuffer aggregationStatements = new StringBuffer();
        aggregationStatements.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        aggregationStatements.append(this.owningCube.generateCodeProcOlapCubeEquals(this.owningCube.getFolder(), false).append(ModelUtilities.newline));
        aggregationStatements.append("   COALESCE_AGGREGATIONS ").append(ModelUtilities.newline);
        Integer concurrent = this.owningCube.getPerformanceOptionConcurrent();
        if (this.owningCube.changedPerformanceConcurrent && concurrent != null) {
            aggregationStatements.append("   CONCURRENT             = ").append(concurrent).append(ModelUtilities.newline);
        }
        Integer indexsortsize = this.owningCube.getPerformanceOptionIndexSortSize();
        if (this.owningCube.changedPerformanceIndexSortSize && indexsortsize != null) {
            aggregationStatements.append("   INDEXSORTSIZE          = ").append(indexsortsize).append(ModelUtilities.newline);
        }
        Integer maxthreads = this.owningCube.getPerformanceOptionMaxThreads();
        if (this.owningCube.changedPerformanceMaxThreads && maxthreads != null) {
            aggregationStatements.append("   MAXTHREADS             = ").append(maxthreads).append(ModelUtilities.newline);
        }
        aggregationStatements.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        aggregationStatements.append(this.owningCube.generateCodeMetasrvStatement(this.owningCube.getAssociatedOLAPSchema(), saveProcCode));
        aggregationStatements.append(ModelUtilities.newline);
        aggregationStatements.append("   RUN;");
        return aggregationStatements;
    }

    public OLAPList getAddedAggregations() {
        if (!this.owningCube.physicallyExists()) {
            throw new IllegalStateException("Illegal use of the getAddAggregations() method.  The physical cube must exist.");
        }
        if (this.addedAggregations == null) {
            this.addedAggregations = new OLAPList(OLAPAggregation.class);
            this.aggregationTuning = true;
            this.addedAggregations.setModifiable(false);
        }
        return this.addedAggregations;
    }

    public OLAPAggregation getAggregation(String inputName) throws OLAPException {
        OLAPAggregation aggregation = null;
        if (this.aggregations == null) {
            this.getAggregations();
        }
        int i = this.aggregations.size() - 1;
        while (i >= 0 & aggregation == null) {
            aggregation = (OLAPAggregation)this.aggregations.get(i);
            if (!aggregation.getName().equalsIgnoreCase(inputName)) {
                aggregation = null;
            }
            --i;
        }
        return aggregation;
    }

    public OLAPList getAggregations() throws OLAPException {
        try {
            if (this.aggregations == null) {
                this.aggregations = new OLAPList(OLAPAggregation.class);
                if (this.owningCube.metadataObject != null) {
                    Cube cube = (Cube)this.owningCube.metadataObject;
                    AssociationList jomaAggregations = cube.getAggregations(false);
                    int size = jomaAggregations.size();
                    for (int i = 0; i < size; ++i) {
                        Aggregation jomaAggregation = (Aggregation)jomaAggregations.elementAt(i);
                        OLAPAggregation olapAggregation = this.createOLAPAggregation(jomaAggregation);
                        if (olapAggregation.isNway()) {
                            this.aggregations.add(0, olapAggregation);
                            this.defaultAggregation = olapAggregation;
                            OLAPList nwayLevels = this.defaultAggregation.getLevels();
                            nwayLevels.setModifiable(false);
                            continue;
                        }
                        this.aggregations.add(olapAggregation);
                    }
                }
            }
            if (this.defaultAggregation == null & !this.owningCube.isNewObject()) {
                this.setNwayGenerated(false);
            }
            if (this.aggregations.size() == 0 & this.nwayGenerated == null && !this.owningCube.getTableSet().isLoadClassicSAS()) {
                this.setNwayGenerated(true);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return this.aggregations;
    }

    public OLAPList getAggregationsByTable(AggregationTable table) throws OLAPException {
        OLAPList tempAggregations;
        if (this.aggregationsByTable == null) {
            this.setAggregationsByTable();
        }
        if ((tempAggregations = (OLAPList)this.aggregationsByTable.get(table)) == null) {
            tempAggregations = new OLAPList(OLAPAggregation.class);
            tempAggregations.setModifiable(false);
            this.aggregationsByTable.put(table, tempAggregations);
        }
        return tempAggregations;
    }

    List getDeleteList() {
        if (this.deleteList == null) {
            this.deleteList = new ArrayList();
        }
        return this.deleteList;
    }

    private List getDrillPaths() throws OLAPException {
        if (this.drillPaths == null) {
            this.drillPaths = new ArrayList();
        } else {
            this.drillPaths.clear();
        }
        boolean foundNway = false;
        if (this.aggregations == null) {
            this.getAggregations();
        }
        for (int i = this.aggregations.size() - 1; i >= 0; --i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(i);
            this.drillPaths.add(aggregation.getLevels());
            if (!aggregation.isNway()) continue;
            foundNway = true;
        }
        if (!foundNway) {
            this.drillPaths.add(this.getNwayDrillPathFromDimensionSet());
        }
        return this.drillPaths;
    }

    public List getCoalescedAggregations() {
        if (this.coalescedAggregations == null) {
            this.coalescedAggregations = new ArrayList();
        }
        return this.coalescedAggregations;
    }

    public OLAPAggregation getDefaultAggregation() throws OLAPException {
        if (this.defaultAggregation == null) {
            if (this.aggregations == null) {
                this.getAggregations();
            }
            OLAPAggregation aggregation = null;
            if (!this.aggregations.isEmpty() && (aggregation = (OLAPAggregation)this.aggregations.get(0)).isNway()) {
                this.defaultAggregation = aggregation;
            }
        }
        return this.defaultAggregation;
    }

    public OLAPList getDroppedAggregations() {
        if (!this.owningCube.physicallyExists()) {
            throw new IllegalStateException("Illegal use of the getDroppedAggregations() method.  The physical cube must exist.");
        }
        if (this.droppedAggregations == null) {
            this.droppedAggregations = new OLAPList(OLAPAggregation.class);
            this.aggregationTuning = true;
            this.droppedAggregations.setModifiable(false);
        }
        return this.droppedAggregations;
    }

    boolean isDropAggregationList(OLAPList inputList) {
        return inputList == this.droppedAggregations;
    }

    boolean isAddAggregationList(OLAPList inputList) {
        return inputList == this.addedAggregations;
    }

    boolean isAggregationList(OLAPList inputList) {
        return inputList == this.aggregations;
    }

    boolean isAggregationTuning() {
        return this.aggregationTuning;
    }

    public void setIsAggregationTuning(boolean inputAggregationTuning) {
        this.aggregationTuning = inputAggregationTuning;
    }

    public OLAPList getGeneratedAggregations() throws OLAPException {
        if (this.generatedAggregations == null) {
            this.generatedAggregations = new OLAPList(OLAPAggregation.class);
            this.generatedAggregations.setModifiable(false);
        }
        if (this.aggregations == null) {
            this.getAggregations();
        }
        int size = this.aggregations.size();
        for (int i = 0; i < size; ++i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(i);
            if (!(aggregation.getType().equals("MOLAP") & this.generatedAggregations.indexOf(aggregation) < 0)) continue;
            if (aggregation.isNway()) {
                this.generatedAggregations.getTheList().add(0, aggregation);
                continue;
            }
            this.generatedAggregations.getTheList().add(aggregation);
        }
        return this.generatedAggregations;
    }

    LoadTable getLoadTable() {
        return this.loadTable;
    }

    public OLAPList getNwayDrillPath() throws OLAPException {
        OLAPList nwayDrillPath = null;
        if (this.defaultAggregation == null) {
            this.getDefaultAggregation();
        }
        if (this.defaultAggregation != null) {
            nwayDrillPath = this.defaultAggregation.getLevelsForce();
        }
        if (nwayDrillPath == null || nwayDrillPath.isEmpty()) {
            nwayDrillPath = this.getNwayDrillPathFromDimensionSet();
        }
        return nwayDrillPath;
    }

    OLAPList getNwayDrillPathFromDimensionSet() throws OLAPException {
        OLAPList nwayDrillPath = new OLAPList(OLAPLevel.class);
        DimensionSet dimensionSet = this.owningCube.getDimensionSet();
        Map levels = dimensionSet.getLevels();
        for (List listOfLevels : levels.values()) {
            int size = listOfLevels.size();
            for (int t = 0; t < size; ++t) {
                nwayDrillPath.add(listOfLevels.get(t));
            }
        }
        nwayDrillPath.setModifiable(false);
        return nwayDrillPath;
    }

    public OLAPList getPerformanceAggregations() throws OLAPException {
        if (this.performanceAggregations == null) {
            this.performanceAggregations = new OLAPList(OLAPAggregation.class);
            this.performanceAggregations.setModifiable(false);
        }
        if (this.aggregations == null) {
            this.getAggregations();
        }
        for (int i = 0; i < this.aggregations.size(); ++i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(i);
            boolean hasPerformanceOptions = aggregation.hasPerformanceOptions();
            if (hasPerformanceOptions & this.performanceAggregations.indexOf(aggregation) < 0) {
                this.performanceAggregations.getTheList().add(aggregation);
                continue;
            }
            if (!(!hasPerformanceOptions & this.performanceAggregations.indexOf(aggregation) >= 0)) continue;
            this.performanceAggregations.getTheList().remove(aggregation);
        }
        return this.performanceAggregations;
    }

    public Map getRacksPerAggregation() throws OLAPException {
        OLAPList allAggregations = this.owningCube.getAggregationSet().getGeneratedAggregations();
        HashMap racksPerAggregation = new HashMap();
        int size = allAggregations.size();
        for (int j = 0; j < size; ++j) {
            List<OLAPAggregation> newRack;
            OLAPAggregation aggregation = (OLAPAggregation)allAggregations.get(j);
            Integer racksNumber = aggregation.getNumberOfRacks();
            if (racksNumber == null) continue;
            String racks = racksNumber.toString();
            if (racksNumber <= 1) continue;
            if (!racksPerAggregation.containsKey(racks)) {
                newRack = new ArrayList<OLAPAggregation>();
                newRack.add(aggregation);
                racksPerAggregation.put(racks, newRack);
                continue;
            }
            newRack = (List)racksPerAggregation.get(racks);
            newRack.add(aggregation);
        }
        return racksPerAggregation;
    }

    public OLAPList getStoredAggregations() throws OLAPException {
        if (this.storedAggregations == null) {
            this.storedAggregations = new OLAPList(OLAPAggregation.class);
            this.storedAggregations.setModifiable(false);
        }
        if (this.aggregations == null) {
            this.getAggregations();
        }
        int size = this.aggregations.size();
        for (int i = 0; i < size; ++i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(i);
            if (!(aggregation.getType().equals("ROLAP") & this.storedAggregations.indexOf(aggregation) < 0)) continue;
            this.storedAggregations.getTheList().add(aggregation);
        }
        return this.storedAggregations;
    }

    public OLAPList getTables() throws OLAPException {
        if (this.tables == null) {
            this.tables = new OLAPList(AggregationTable.class);
            if (this.storedAggregations == null) {
                this.getStoredAggregations();
            }
            boolean checkColumns = false;
            LoadTable loadtable = this.owningCube.getTableSet().getLoadTable();
            if (loadtable != null) {
                PhysicalTable physicalLoadTable = loadtable.getTable();
                checkColumns = physicalLoadTable != null;
            }
            int size = this.storedAggregations.size();
            for (int i = 0; i < size; ++i) {
                OLAPAggregation aggregation = (OLAPAggregation)this.storedAggregations.get(i);
                AggregationTable table = aggregation.getAggregationTable();
                boolean columnsOK = true;
                if (table != null && checkColumns) {
                    columnsOK = table.hasValidAggregateColumns();
                }
                if (table == null || this.tables.indexOf(table) >= 0 || !columnsOK) continue;
                this.tables.add(table);
            }
        }
        return this.tables;
    }

    public Boolean hasStoredAggregations() throws OLAPException {
        if (this.hasStoredAggregations == null & !this.owningCube.isNewObject()) {
            TableSet tableSet = this.owningCube.getTableSet();
            if (tableSet.isLoadClassicSAS()) {
                this.hasStoredAggregations = true;
            } else {
                if (this.storedAggregations == null) {
                    this.getStoredAggregations();
                }
                this.hasStoredAggregations = this.storedAggregations.size() > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        }
        return this.hasStoredAggregations;
    }

    public boolean isNWAYGenerated() throws OLAPException {
        boolean generate = false;
        if (this.nwayGenerated == null) {
            try {
                Cube jomaCube = (Cube)this.owningCube.metadataObject;
                AssociationList properties = jomaCube.getProperties(false);
                if (properties.size() == 0) {
                    generate = true;
                }
                int i = properties.size() - 1;
                while (i >= 0 & !generate) {
                    Property property = (Property)properties.elementAt(i);
                    if (property.getPropertyName().equalsIgnoreCase("NO_NWAY")) {
                        generate = property.getDefaultValue().equalsIgnoreCase("NO");
                    }
                    --i;
                }
                this.setNwayGenerated(generate);
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else {
            generate = this.nwayGenerated;
        }
        return generate;
    }

    public boolean isResetLevels() {
        return this.resetAggregationLevels;
    }

    void removeFromAggregationByTables(OLAPAggregation aggregation, AggregationTable inputTable) throws OLAPException {
        boolean found = false;
        int i = 0;
        int size = this.tables.size();
        while (i < size & !found) {
            AggregationTable aggregationTable = (AggregationTable)this.tables.get(i);
            if (aggregationTable != inputTable) {
                this.getAggregationsByTable(aggregationTable);
                OLAPList tempAggregations = (OLAPList)this.aggregationsByTable.get(aggregationTable);
                tempAggregations.getTheList().remove(aggregation);
            }
            ++i;
        }
    }

    private void removeInvalidAggregations(AggregationTable inputTable) throws OLAPException {
        if (this.storedAggregations == null) {
            this.getStoredAggregations();
        }
        for (int i = this.storedAggregations.size() - 1; i >= 0; --i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.storedAggregations.get(i);
            AggregationTable table = aggregation.getAggregationTable();
            if (!table.equals(inputTable)) continue;
            aggregation.delete();
            if (this.autoDeletedAggregations == null) {
                this.autoDeletedAggregations = new ArrayList();
            }
            this.autoDeletedAggregations.add(aggregation);
        }
    }

    public void reset() throws OLAPException {
        if (this.aggregations == null) {
            this.getAggregations();
        }
        for (int i = this.aggregations.size() - 1; i >= 0; --i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(i);
            if (aggregation.isNway()) {
                this.defaultAggregation = aggregation;
            }
            if (aggregation.isNewObject()) continue;
            if (this.deleteList == null) {
                this.deleteList = new ArrayList();
            }
            this.deleteList.add(aggregation.metadataObject);
        }
        this.aggregations.clear();
        this.defaultAggregation = null;
        if (this.aggregationsByTable != null) {
            this.aggregationsByTable.clear();
        }
        if (this.drillPaths != null) {
            this.drillPaths.clear();
        }
        if (this.generatedAggregations != null) {
            this.generatedAggregations.getTheList().clear();
        }
        if (this.performanceAggregations != null) {
            this.performanceAggregations.getTheList().clear();
        }
        if (this.storedAggregations != null) {
            this.storedAggregations.getTheList().clear();
        }
        if (this.tables != null) {
            this.tables.clear();
        }
        this.setNwayGenerated(true);
    }

    void resetAggregationTables() throws OLAPException {
        if (!this.resettingAggregationTables) {
            AggregationTable table;
            int i;
            this.resettingAggregationTables = true;
            ArrayList<AggregationTable> tempTables = new ArrayList<AggregationTable>();
            if (this.tables == null) {
                this.getTables();
            }
            int size = this.tables.size();
            for (i = 0; i < size; ++i) {
                table = (AggregationTable)this.tables.get(i);
                tempTables.add(table);
                table.setValidAggregateColumns(null);
            }
            this.tables.clear();
            size = tempTables.size();
            for (i = 0; i < size; ++i) {
                table = (AggregationTable)tempTables.get(i);
                try {
                    this.tables.add(table);
                    continue;
                }
                catch (IllegalArgumentException error) {
                    this.removeInvalidAggregations(table);
                    if (this.autoDeletedAggregationTables == null) {
                        this.autoDeletedAggregationTables = new ArrayList();
                    }
                    this.autoDeletedAggregationTables.add(table);
                }
            }
            if (this.autoDeletedAggregationTables != null) {
                for (i = this.autoDeletedAggregationTables.size() - 1; i >= 0; --i) {
                    AggregationTable table2 = (AggregationTable)this.autoDeletedAggregationTables.get(i);
                    if (this.tables.contains(table2)) continue;
                    try {
                        table2.setValidAggregateColumns(null);
                        this.tables.add(table2);
                        if (this.autoDeletedAggregations == null) continue;
                        for (int j = this.autoDeletedAggregations.size() - 1; j >= 0; --j) {
                            OLAPAggregation aggregation = (OLAPAggregation)this.autoDeletedAggregations.get(j);
                            AggregationTable tempTable = aggregation.getAggregationTable();
                            if (!tempTable.equals(table2)) continue;
                            aggregation.add();
                        }
                        continue;
                    }
                    catch (IllegalArgumentException error) {
                        table2.setValidAggregateColumns(false);
                    }
                }
            }
            this.resettingAggregationTables = false;
        }
    }

    private void resetDefaultLevels(OLAPAggregation aggregation) throws OLAPException {
        if (aggregation.isNway()) {
            DimensionSet dimensionSet = this.owningCube.getDimensionSet();
            OLAPList aggregationLevels = aggregation.getLevels();
            aggregationLevels.setModifiable(false);
            aggregationLevels.getTheList().clear();
            List allDimensions = dimensionSet.getAllCubeDimensions();
            int iSize = allDimensions.size();
            for (int i = 0; i < iSize; ++i) {
                OLAPDimension dimension = (OLAPDimension)allDimensions.get(i);
                OLAPList dimensionLevels = dimension.getLevels();
                int jSize = dimensionLevels.size();
                for (int j = 0; j < jSize; ++j) {
                    aggregationLevels.getTheList().add(dimensionLevels.get(j));
                }
            }
        }
    }

    public void resetLevels() throws OLAPException {
        if (this.resetAggregationLevels) {
            this.resetAggregationLevels = false;
            if (this.aggregations == null) {
                this.getAggregations();
            }
            if (!this.aggregations.isEmpty()) {
                OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(0);
                if (aggregation.isNway()) {
                    this.resetDefaultLevels(aggregation);
                } else {
                    this.resetLevels(aggregation);
                }
                aggregation.resetVerifiedLevels();
                for (int i = this.aggregations.size() - 1; i >= 1; --i) {
                    aggregation = (OLAPAggregation)this.aggregations.get(i);
                    this.resetLevels(aggregation);
                    aggregation.resetVerifiedLevels();
                    aggregation.resetHierarchyLevels();
                }
            }
            if (this.tables == null) {
                this.getTables();
            }
            for (int i = this.tables.size() - 1; i >= 0; --i) {
                AggregationTable table = (AggregationTable)this.tables.get(i);
                table.resetPossibleLevels();
            }
        }
    }

    private void resetLevels(OLAPAggregation aggregation) throws OLAPException {
        OLAPList aggregationLevels = aggregation.getLevels();
        DimensionSet dimensionSet = this.owningCube.getDimensionSet();
        Map dimensionLevels = dimensionSet.getLevels();
        boolean found = false;
        for (int i = aggregationLevels.size() - 1; i >= 0; --i) {
            found = false;
            OLAPLevel level = (OLAPLevel)aggregationLevels.get(i);
            Iterator t = dimensionLevels.values().iterator();
            while (t.hasNext() & !found) {
                List listOfLevels = (List)t.next();
                if (listOfLevels == null || !listOfLevels.contains(level)) continue;
                found = true;
            }
            if (found) continue;
            aggregationLevels.getTheList().remove(level);
        }
        if (aggregationLevels.isEmpty()) {
            aggregation.delete();
        } else {
            try {
                aggregation.verifyDrillPath();
                aggregation.verifyDuplicated();
            }
            catch (OLAPException olapError) {
                aggregation.delete();
            }
        }
    }

    public void resetStoredAggregations() throws OLAPException {
        if (this.storedAggregations == null) {
            this.getStoredAggregations();
        }
        for (int i = this.storedAggregations.size() - 1; i >= 0; --i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.storedAggregations.get(i);
            aggregation.delete();
        }
        if (this.aggregationsByTable != null) {
            this.aggregationsByTable.clear();
        }
        this.getDrillPaths().clear();
        this.getTables().clear();
    }

    private void setAggregationsByTable() throws OLAPException {
        if (this.aggregationsByTable == null) {
            this.aggregationsByTable = new HashMap();
            if (this.storedAggregations == null) {
                this.getStoredAggregations();
            }
            int size = this.storedAggregations.size();
            for (int i = 0; i < size; ++i) {
                OLAPAggregation aggregation = (OLAPAggregation)this.storedAggregations.get(i);
                AggregationTable aggregationTable = aggregation.getAggregationTable();
                OLAPList tempAggregationsByTable = (OLAPList)this.aggregationsByTable.get(aggregationTable);
                if (tempAggregationsByTable == null) {
                    tempAggregationsByTable = new OLAPList(OLAPAggregation.class);
                    tempAggregationsByTable.setModifiable(false);
                    tempAggregationsByTable.getTheList().add(aggregation);
                    this.aggregationsByTable.put(aggregationTable, tempAggregationsByTable);
                    continue;
                }
                tempAggregationsByTable.getTheList().add(aggregation);
            }
        }
    }

    public void setHasStoredAggregations(boolean hasAggregations) throws OLAPException {
        TableSet tableSet = this.owningCube.getTableSet();
        if (tableSet.isLoadClassicSAS()) {
            this.hasStoredAggregations = true;
        } else {
            boolean isInitialized = this.hasStoredAggregations != null;
            this.hasStoredAggregations = hasAggregations;
            if (isInitialized) {
                MeasureSet measureSet = this.owningCube.getMeasureSet();
                if (hasAggregations) {
                    measureSet.synchRolap();
                } else {
                    measureSet.autoAdd();
                }
            }
        }
    }

    void setLoadTable(LoadTable inputLoadTable) {
        this.loadTable = inputLoadTable;
    }

    public void setNwayGenerated(boolean inputNwayGenerated) throws OLAPException {
        OLAPAggregation aggregation;
        TableSet tableSet = this.owningCube.getTableSet();
        boolean isClassicSAS = tableSet.isLoadClassicSAS();
        if (isClassicSAS) {
            if (this.loadTable == null) {
                this.loadTable = tableSet.getLoadTable();
            }
            if (this.loadTable == null) {
                throw new IllegalStateException("The input type is fully summarized.  The load table needs to be set before setting that the NWAY is generated.");
            }
            if (!inputNwayGenerated) {
                throw new OLAPException(bundle.getString("OLAPAggregation.CannotTurnOffNWAY.txt"), 0);
            }
        }
        if (this.aggregations == null) {
            this.getAggregations();
        }
        if (this.storedAggregations == null) {
            this.getStoredAggregations();
        }
        if (this.generatedAggregations == null) {
            this.getGeneratedAggregations();
        }
        if ((aggregation = this.defaultAggregation) == null & this.aggregations.size() > 0) {
            aggregation = (OLAPAggregation)this.aggregations.get(0);
        }
        if (inputNwayGenerated) {
            if (aggregation == null) {
                aggregation = this.createOLAPAggregation();
                aggregation.setName(bundle.getString("OLAPAggregation.DefaultNway.Name.txt"));
                aggregation.setIsNway(true);
                this.resetDefaultLevels(aggregation);
                this.defaultAggregation = aggregation;
                this.defaultAggregation.resetVerifiedLevels();
                if (isClassicSAS) {
                    if (this.loadTable == null) {
                        this.loadTable = tableSet.getLoadTable();
                    }
                    AggregationTable aggregationTable = tableSet.getAggregationTable(this.loadTable.getTable());
                    this.defaultAggregation.setAggregationTable(aggregationTable);
                }
            }
            if (aggregation != null && !aggregation.isNway()) {
                if (this.defaultAggregation != null) {
                    if (this.aggregations.indexOf(this.defaultAggregation) < 0) {
                        this.aggregations.add(0, this.defaultAggregation);
                        Aggregation jomaAggregation = (Aggregation)this.defaultAggregation.metadataObject;
                        this.deleteList.remove(jomaAggregation);
                    }
                } else {
                    this.defaultAggregation = this.createOLAPAggregation();
                    this.defaultAggregation.setName(bundle.getString("OLAPAggregation.DefaultNway.Name.txt"));
                    this.defaultAggregation.setIsNway(true);
                    this.resetDefaultLevels(this.defaultAggregation);
                    this.defaultAggregation.resetVerifiedLevels();
                }
            } else {
                this.defaultAggregation = aggregation;
            }
            this.aggregations.getTheList().remove(this.defaultAggregation);
            this.aggregations.getTheList().add(0, this.defaultAggregation);
            AggregationTable table = this.defaultAggregation.hiddenGetAggregationTable();
            if (table == null) {
                this.generatedAggregations.getTheList().remove(this.defaultAggregation);
                this.generatedAggregations.getTheList().add(0, this.defaultAggregation);
            } else {
                this.storedAggregations.getTheList().remove(this.defaultAggregation);
                this.storedAggregations.getTheList().add(0, this.defaultAggregation);
            }
            this.defaultAggregation.setDeleted(false);
        } else if (aggregation != null && aggregation.isNway()) {
            if (this.defaultAggregation == null) {
                this.defaultAggregation = aggregation;
            }
            this.aggregations.getTheList().remove(aggregation);
            this.generatedAggregations.getTheList().remove(aggregation);
            this.getDeleteList();
            if (aggregation.metadataObject != null && !this.deleteList.contains(aggregation.metadataObject)) {
                this.deleteList.add(aggregation.metadataObject);
            }
            aggregation.setDeleted(true);
        }
        this.nwayGenerated = inputNwayGenerated;
    }

    public void setResetLevels(boolean inputResetAggregationLevels) throws OLAPException {
        this.resetAggregationLevels = inputResetAggregationLevels;
        if (this.resetAggregationLevels) {
            if (this.aggregations == null) {
                this.getAggregations();
            }
            for (int i = this.aggregations.size() - 1; i >= 0; --i) {
                OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(i);
                aggregation.setVerifyLevels(false);
            }
        }
    }

    private void updateMetadata(OLAPList inputAggregations, List remainingClassifierMaps, List remainingLevels) throws OLAPException {
        int size = inputAggregations.size();
        for (int i = 0; i < size; ++i) {
            OLAPAggregation aggregation = (OLAPAggregation)inputAggregations.get(i);
            aggregation.updateMetadata();
            AggregationTable table = aggregation.getAggregationTable();
            if (table == null) continue;
            ClassifierMap classifierMap = table.getClassifierMap();
            if (classifierMap != null && remainingClassifierMaps.indexOf(classifierMap) < 0) {
                remainingClassifierMaps.add(classifierMap);
            }
            OLAPList levels = aggregation.getLevels();
            for (int j = levels.size() - 1; j >= 0; --j) {
                OLAPLevel olapLevel = (OLAPLevel)levels.get(j);
                Level jomaLevel = (Level)olapLevel.metadataObject;
                if (remainingLevels.indexOf(jomaLevel) >= 0) continue;
                remainingLevels.add(jomaLevel);
            }
        }
    }

    private List getSources(FeatureMap featureMap) throws MdException, RemoteException {
        int i;
        ArrayList<Object> sources = new ArrayList<Object>();
        AssociationList featureSources = featureMap.getFeatureSources();
        AssociationList transformationSources = featureMap.getTransformationSources();
        for (i = featureSources.size() - 1; i >= 0; --i) {
            sources.add(featureSources.get(i));
        }
        for (i = transformationSources.size() - 1; i >= 0; --i) {
            sources.add(transformationSources.get(i));
        }
        return sources;
    }

    void updateMetadata() throws OLAPException {
        int i;
        this.cleanseTables();
        if (this.resetAggregationLevels) {
            this.resetLevels();
        }
        ArrayList remainingClassifierMaps = new ArrayList();
        ArrayList remainingAggregationTableLevels = new ArrayList();
        Cube cube = (Cube)this.owningCube.metadataObject;
        AssociationList properties = null;
        Property noNway = null;
        try {
            properties = cube.getProperties(false);
            int i2 = properties.size() - 1;
            while (i2 >= 0 & noNway == null) {
                Property property = (Property)properties.elementAt(i2);
                if (property.getName().equals("NO_NWAY")) {
                    noNway = property;
                }
                --i2;
            }
            if (noNway == null) {
                noNway = (Property)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Property", this.owningCube.getRepositoryShortFQID());
                noNway.setName("NO_NWAY");
                noNway.setPropertyName("NO_NWAY");
                noNway.setDesc("NO_NWAY");
                int metadataVersion = Workspace.getMetadataServerVersionNumber();
                if (metadataVersion >= 9200) {
                    noNway.setSQLType(OptionSet.OWNING_TYPE_STRING.intValue());
                } else {
                    OptionSet optionSet = this.owningCube.getOptionsSet();
                    noNway.setOwningType(optionSet.getOwningType(OptionSet.OWNING_TYPE_STRING));
                }
                properties.addElement((Object)noNway);
            }
            if (this.isNWAYGenerated()) {
                noNway.setDefaultValue("NO");
            } else {
                noNway.setDefaultValue("YES");
            }
            if (this.storedAggregations == null) {
                this.getStoredAggregations();
            }
            if (this.generatedAggregations == null) {
                this.getGeneratedAggregations();
            }
            this.updateMetadata(this.generatedAggregations, remainingClassifierMaps, remainingAggregationTableLevels);
            this.updateMetadata(this.storedAggregations, remainingClassifierMaps, remainingAggregationTableLevels);
            TableSet tableSet = this.owningCube.getTableSet();
            List classifierMaps = tableSet.getClassifierMaps();
            for (int i3 = classifierMaps.size() - 1; i3 >= 0; --i3) {
                ClassifierMap classifierMap = (ClassifierMap)classifierMaps.get(i3);
                if (!classifierMap.getTransformRole().equalsIgnoreCase("AGGREGATE") || remainingClassifierMaps.indexOf(classifierMap) >= 0) continue;
                MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)classifierMap, "<Templates><SourceCode/><FeatureMaps/></Templates>", bundle.getString("MdException.GenericError.txt"));
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        try {
            for (i = remainingAggregationTableLevels.size() - 1; i >= 0; --i) {
                Level level = (Level)remainingAggregationTableLevels.get(i);
                AssociationList featureMaps = level.getTargetFeatureMaps();
                ArrayList<Column> columnList = new ArrayList<Column>();
                for (int j = featureMaps.size() - 1; j >= 0; --j) {
                    FeatureMap featureMap = (FeatureMap)featureMaps.elementAt(j);
                    List sources = this.getSources(featureMap);
                    Column column = null;
                    if (sources.size() > 0) {
                        column = (Column)sources.get(0);
                    }
                    if (columnList.indexOf(column) < 0) {
                        columnList.add(column);
                        continue;
                    }
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)featureMap, "", bundle.getString("MdException.GenericError.txt"));
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        for (i = this.getDeleteList().size() - 1; i >= 0; --i) {
            Aggregation aggregation = (Aggregation)this.deleteList.get(i);
            this.deleteList.remove(aggregation);
            if (aggregation == null) continue;
            MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)aggregation, "<Templates><Properties><StoredConfiguration/></Properties><CustomAssociations/></Templates>", "");
        }
        if (this.storedAggregations == null) {
            this.getStoredAggregations();
        }
        if (this.storedAggregations.isEmpty()) {
            this.owningCube.setType("MOLAP");
        } else {
            this.owningCube.setType("HOLAP");
        }
    }

    void verifyDrillPath(OLAPList inputDrillPath, String aggregationName) throws OLAPException {
        int i;
        DimensionSet dimensionSet = this.owningCube.getDimensionSet();
        Map drillPathOrder = dimensionSet.getDrillOrder();
        if (inputDrillPath.isEmpty()) {
            throw new OLAPException(bundle.formatString("OLAPAggregation.NoLevels.fmt.txt", (Object)aggregationName), 0);
        }
        for (i = inputDrillPath.size() - 1; i >= 0; --i) {
            try {
                OLAPLevel level = (OLAPLevel)inputDrillPath.get(i);
                if (level == null) {
                    throw new OLAPException(bundle.formatString("OLAPAggregation.LevelNotNull.fmt.txt", (Object)aggregationName), 0);
                }
                if (inputDrillPath.indexOf(level) == inputDrillPath.lastIndexOf(level)) continue;
                throw new OLAPException(bundle.formatString("OLAPAggregation.DuplicateLevel.fmt.txt", (Object)level.getName(), (Object)aggregationName), 0);
            }
            catch (ClassCastException error) {
                throw new OLAPException(bundle.getString("OLAPAggregation.OnlyOLAPLevel.txt"), 0);
            }
        }
        int iSize = inputDrillPath.size();
        for (i = 0; i < iSize; ++i) {
            OLAPLevel level = (OLAPLevel)inputDrillPath.get(i);
            String levelName = level.getName();
            List levels = (List)drillPathOrder.get(levelName);
            if (levels != null) {
                boolean found = false;
                int j = 0;
                int jSize = levels.size();
                while (j < jSize & !found) {
                    OLAPLevel validLevel = (OLAPLevel)levels.get(j);
                    found = inputDrillPath.contains(validLevel);
                    ++j;
                }
                if (found) continue;
                throw new OLAPException(bundle.formatString("OLAPAggregation.DrillOrder.Incorrect.fmt.txt", (Object)level.getName()), 0);
            }
            throw new OLAPException(bundle.formatString("OLAPAggregation.DrillOrder.Incorrect.fmt.txt", (Object)level.getName()), 0);
        }
    }

    private boolean isDrillPathDefault(OLAPList inputDrillPath) throws OLAPException {
        return this.getNwayDrillPath().size() == inputDrillPath.size();
    }

    private boolean isDrillPathDefault(int inputDrillPath) throws OLAPException {
        return this.getNwayDrillPath().size() == inputDrillPath;
    }

    void verifyDuplicated(OLAPList inputDrillPath, String aggregationName) throws OLAPException {
        int inputDrillSize = inputDrillPath.size();
        if (inputDrillPath.indexOf(null) >= 0) {
            throw new OLAPException(bundle.formatString("OLAPAggregation.LevelNotNull.fmt.txt", (Object)aggregationName), 0);
        }
        String aggregationString = inputDrillPath.toString();
        if (inputDrillSize > 0) {
            for (int i = this.getDrillPaths().size() - 1; i >= 0; --i) {
                OLAPList drillPath = (OLAPList)this.drillPaths.get(i);
                if (drillPath == inputDrillPath) continue;
                if (drillPath.equals(inputDrillPath)) {
                    if (this.isDrillPathDefault(inputDrillPath)) {
                        throw new OLAPException(bundle.formatString("OLAPAggregation.DefaultDrillOrder.Duplicated.fmt.txt", (Object)aggregationName), 0);
                    }
                    throw new OLAPException(bundle.getString("OLAPAggregation.DrillOrder.Duplicated.txt"), 0);
                }
                int existingSize = drillPath.size();
                int drillSize = 0;
                if (existingSize != inputDrillSize) continue;
                for (int j = 0; j < existingSize; ++j) {
                    OLAPLevel aggrLevel = (OLAPLevel)drillPath.get(j);
                    if (aggregationString.indexOf(aggrLevel.getName()) < 0) continue;
                    ++drillSize;
                }
                if (drillSize != inputDrillSize) continue;
                if (this.isDrillPathDefault(inputDrillSize)) {
                    throw new OLAPException(bundle.formatString("OLAPAggregation.DefaultDrillOrder.Duplicated.fmt.txt", (Object)aggregationName), 0);
                }
                throw new OLAPException(bundle.getString("OLAPAggregation.DrillOrder.Duplicated.txt"), 0);
            }
        }
    }

    public StringBuffer verifyMetadata() throws OLAPException {
        Aggregation jomaAggregation;
        int i;
        StringBuffer errorMessage = new StringBuffer();
        if (this.aggregations == null) {
            this.getAggregations();
        }
        for (i = this.aggregations.size() - 1; i >= 0; --i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(i);
            jomaAggregation = (Aggregation)aggregation.metadataObject;
            try {
                if (jomaAggregation.getNway() != 0) continue;
                errorMessage.append(aggregation.verifyMetadata());
                continue;
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        if (this.storedAggregations == null) {
            this.getStoredAggregations();
        }
        for (i = this.storedAggregations.size() - 1; i >= 0; --i) {
            OLAPAggregation olapAggregation = (OLAPAggregation)this.storedAggregations.get(i);
            jomaAggregation = (Aggregation)olapAggregation.metadataObject;
            AssociationList properties = null;
            try {
                properties = jomaAggregation.getProperties(false);
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            StringBuffer procPropertyName = new StringBuffer();
            try {
                procPropertyName.append(jomaAggregation.getName()).append("_options");
                StringBuffer newPropertyName = new StringBuffer();
                newPropertyName.append("AggregationTable").append("_options");
                for (int j = properties.size() - 1; j >= 0; --j) {
                    Property property = (Property)properties.get(j);
                    String jomaPropertyName = property.getPropertyName();
                    if (!(jomaPropertyName.equals(procPropertyName.toString()) | jomaPropertyName.equals("_options"))) continue;
                    property.setName(newPropertyName.toString());
                    property.setPropertyName(newPropertyName.toString());
                    property.setDesc(newPropertyName.toString());
                }
                continue;
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return errorMessage;
    }

    void verifyUniqueName(OLAPAggregation inputAggregation) throws OLAPException {
        String inputName = inputAggregation.getName();
        if (this.aggregations == null) {
            this.getAggregations();
        }
        for (int i = this.aggregations.size() - 1; i >= 0; --i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregations.get(i);
            if (aggregation == inputAggregation || !aggregation.getName().equalsIgnoreCase(inputName)) continue;
            throw new OLAPException(bundle.getString("OLAPAggregation.DuplicateName.txt"), null, 0);
        }
    }
}

