/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.DefinedMemberSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractOLAPModel
implements Comparable {
    private static WAdminResource bundle = new WAdminResource(AbstractOLAPModel.class);
    boolean changedDescription;
    boolean changedName;
    private boolean changedNotes;
    boolean changedMLSID;
    boolean deleted;
    boolean deleteMLSId;
    String description;
    Root metadataObject;
    String name;
    String notes;
    static final String OLAP_DESCRIPTION = "OLAP Description";
    protected OLAPCube owningCube;
    protected OLAPSharedDimension owningSharedDimension;
    protected Option MLSId;
    static final String PLAIN_TEXT = "Plain Text";
    String fqid;
    private String shortFQID;
    private TextStore notesTextStore;
    private boolean undo = true;
    OptionSet optionSet;
    TableSet tableSet;
    OLAPMemberPropertySet propertySet;
    DimensionSet dimensionSet;
    AggregationSet aggregationSet;
    MeasureSet measureSet;
    DefinedMemberSet definedMemberSet;
    List allChanges;
    Map currentChanges;
    private boolean dontAllowCurrentChanges;
    private Map firstMap;
    private List listChanges;

    public void apply() {
        this.verifyDeleted();
        if (this.allChanges == null) {
            this.allChanges = new ArrayList();
            this.firstMap = new HashMap();
            this.allChanges.add(this.firstMap);
        }
        if (this.currentChanges != null && !this.currentChanges.isEmpty()) {
            this.allChanges.remove(0);
            this.firstMap = this.currentChanges;
            this.allChanges.add(this.firstMap);
        }
        int size = this.allChanges.size();
        for (int i = 1; i < size; ++i) {
            this.allChanges.remove(i);
        }
        this.currentChanges = new HashMap();
        this.listChanges = null;
    }

    public boolean isUndo() {
        return this.undo;
    }

    public void setUndo(boolean inUndo) {
        this.undo = inUndo;
    }

    public void clear() throws OLAPException {
        this.verifyDeleted();
        this.name = null;
        this.description = null;
        this.notes = null;
        this.changedDescription = false;
        this.changedName = false;
        this.changedNotes = false;
    }

    public int compareTo(Object obj) {
        int compnum = this.toString().compareTo(obj.toString());
        return compnum;
    }

    public String getDesc() {
        this.verifyDeleted();
        if (!this.changedDescription & this.metadataObject != null) {
            try {
                this.description = this.metadataObject.getDesc();
            }
            catch (RemoteException e) {
                this.description = "";
            }
        }
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public String getName() {
        if (!this.changedName & this.metadataObject != null) {
            try {
                this.name = this.metadataObject.getName();
            }
            catch (RemoteException e) {
                this.name = "";
            }
        }
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public Integer getMLSID() throws OLAPException {
        Integer returnOption = null;
        if (this.MLSId == null && this.metadataObject != null && !this.deleteMLSId) {
            this.MLSId = this.optionSet.getOption(this, "MLSID", "OLAP UDT");
        }
        if (this.MLSId != null) {
            this.MLSId.setPropertyOption(true);
            returnOption = Integer.valueOf(this.MLSId.getDefaultValue());
        }
        return returnOption;
    }

    public String getNotes() throws OLAPException {
        this.verifyDeleted();
        if (!this.changedNotes & this.metadataObject != null) {
            try {
                AssociationList notesList = null;
                TextStore text = null;
                boolean found = false;
                if (notesList == null) {
                    notesList = this.metadataObject.getNotes(false);
                }
                int i = 0;
                int size = notesList.size();
                while (i < size & !found) {
                    text = (TextStore)notesList.elementAt(i);
                    String role = text.getTextRole();
                    if (role.equals(OLAP_DESCRIPTION)) {
                        found = true;
                        this.notesTextStore = text;
                    }
                    ++i;
                }
                if (this.notesTextStore != null) {
                    this.notes = this.notesTextStore.getStoredText();
                }
            }
            catch (MdException MdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), MdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        if (this.notes == null) {
            this.notes = "";
        }
        return this.notes;
    }

    public OLAPCube getOwningCube() {
        this.verifyDeleted();
        return this.owningCube;
    }

    public OLAPSharedDimension getOwningSharedDimension() {
        return this.owningSharedDimension;
    }

    public boolean isNewObject() {
        this.verifyDeleted();
        boolean newObject = true;
        if (this.metadataObject != null) {
            try {
                newObject = this.metadataObject.isNewObject();
            }
            catch (RemoteException e) {
                newObject = false;
            }
        }
        return newObject;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isMetadataUpdated() {
        this.verifyDeleted();
        return this.changedName || this.changedDescription || this.changedNotes || this.changedMLSID;
    }

    public void setDesc(String inputDescription) {
        this.verifyDeleted();
        this.changedDescription = true;
        this.description = inputDescription;
    }

    void setDeleted(boolean inputDeleted) {
        this.deleted = inputDeleted;
    }

    public void revert() throws OLAPException {
        this.verifyDeleted();
        this.dontAllowCurrentChanges = true;
        if (this.allChanges == null) {
            return;
        }
        if (this.firstMap != null && this.firstMap.size() > 0) {
            Object[] keys = this.firstMap.keySet().toArray();
            for (int i = keys.length - 1; i >= 0; --i) {
                Method method = (Method)keys[i];
                Object[] parameters = (Object[])this.firstMap.get(method);
                try {
                    method.invoke((Object)this, parameters);
                    continue;
                }
                catch (IllegalAccessException error) {
                    throw new OLAPException(error.getLocalizedMessage(), 0);
                }
                catch (InvocationTargetException error) {
                    throw new OLAPException(error.getLocalizedMessage(), 0);
                }
            }
        }
        this.allChanges = null;
        this.currentChanges = null;
    }

    public void setName(String inputName) {
        this.verifyDeleted();
        this.changedName = inputName != null;
        this.name = inputName;
    }

    public void setNotes(String inputNotes) {
        this.verifyDeleted();
        this.changedNotes = true;
        this.notes = inputNotes;
    }

    void setOwningCube(OLAPCube inputCube) {
        this.owningCube = inputCube;
    }

    void setOwningSharedDimension(OLAPSharedDimension inputDim) {
        this.owningSharedDimension = inputDim;
    }

    void setTableSet(TableSet inputTableSet) {
        this.tableSet = inputTableSet;
    }

    void setOptionSet(OptionSet inputOptionSet) {
        this.optionSet = inputOptionSet;
    }

    void setOLAPMemberPropertySet(OLAPMemberPropertySet inputOLAPMemberPropertySet) {
        this.propertySet = inputOLAPMemberPropertySet;
    }

    void setDimensionSet(DimensionSet inputDimensionSet) {
        this.dimensionSet = inputDimensionSet;
    }

    public void setMLSID(Integer inputMlsId) throws OLAPException {
        this.MLSId = this.optionSet.getOption(this, "MLSID", "OLAP UDT");
        this.changedMLSID = true;
        if (inputMlsId != null) {
            this.verifyMLSId(inputMlsId);
            this.deleteMLSId = false;
            if (this.MLSId == null) {
                this.MLSId = new Option(this.optionSet, this);
                this.MLSId.setName("MLSID");
                this.MLSId.setDesc("MLSID");
                this.MLSId.setPropertyRole("OLAP UDT");
                this.MLSId.setPropertyName("MLSID");
                this.MLSId.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.MLSId.setPropertyOption(true);
            }
            this.MLSId.setDefaultValue(inputMlsId.toString());
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.MLSId) >= 0) {
                objectOptions.remove(this.MLSId);
            }
            this.MLSId = null;
            this.deleteMLSId = true;
        }
    }

    public String toString() {
        return this.getName();
    }

    public void verifyName() throws OLAPException {
        this.verifyDeleted();
        this.name = this.getName();
        if (this.name == null || ModelUtilities.isBlank(this.name)) {
            throw new OLAPException(bundle.getString("Model.NameRequired.txt"), null, 0);
        }
    }

    public void verifySASName() throws OLAPException {
        this.verifyDeleted();
        this.name = this.getName();
        if (this.name.length() > 32) {
            throw new OLAPException(bundle.getString("Model.SASName.txt"), null, 0);
        }
    }

    public void updateMetadata() throws OLAPException {
        this.verifyDeleted();
        try {
            if (this.changedDescription) {
                this.metadataObject.setDesc(this.description);
                this.changedDescription = false;
            }
            if (this.changedName) {
                this.metadataObject.setName(this.name);
                this.changedName = false;
            }
            if (this.changedNotes) {
                this.updateNotesMetadata();
                this.changedNotes = false;
            }
            if (this.deleteMLSId && this.MLSId == null && this.metadataObject != null) {
                AssociationList properties = this.metadataObject.getProperties();
                boolean found = false;
                int size = properties.size();
                for (int i = 0; i < size && !found; ++i) {
                    Property property = (Property)properties.elementAt(i);
                    if (property == null || !property.getPropertyName().equals("MLSID")) continue;
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                    found = true;
                }
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    private void updateNotesMetadata() throws OLAPException {
        AssociationList notesList = null;
        try {
            String tempNotes = this.getNotes();
            if (ModelUtilities.isBlank(tempNotes) && this.notesTextStore != null) {
                if (this.owningCube != null) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)this.notesTextStore, "", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.owningSharedDimension != null) {
                    MetadataTemplate.deleteMetadata(this.owningSharedDimension.getObjectStore(), (CMetadata)this.notesTextStore, "", bundle.getString("MdException.GenericError.txt"));
                }
                this.notesTextStore = null;
            } else if (!ModelUtilities.isBlank(tempNotes) && this.notesTextStore == null) {
                if (this.owningCube != null) {
                    this.notesTextStore = (TextStore)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "TextStore", this.owningCube.getRepositoryShortFQID());
                }
                if (this.owningSharedDimension != null) {
                    this.notesTextStore = (TextStore)MetadataTemplate.createMetadata(this.owningSharedDimension.getObjectStore(), "TextStore", this.owningSharedDimension.getRepositoryShortFQID());
                }
                this.notesTextStore.setName(OLAP_DESCRIPTION);
                this.notesTextStore.setTextRole(OLAP_DESCRIPTION);
                this.notesTextStore.setTextType(PLAIN_TEXT);
                notesList = this.metadataObject.getNotes(false);
                notesList.addElement((Object)this.notesTextStore);
            }
            if (this.notesTextStore != null) {
                this.notesTextStore.setStoredText(tempNotes);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    public void undo() {
        this.verifyDeleted();
        this.dontAllowCurrentChanges = true;
        this.undoListChanges();
        if (this.currentChanges != null && !this.currentChanges.isEmpty()) {
            Object[] keys = this.currentChanges.keySet().toArray();
            for (int i = keys.length - 1; i >= 0; --i) {
                Method method = (Method)keys[i];
                Object valueOfField = null;
                int j = this.allChanges.size() - 1;
                while (j >= 0 & valueOfField == null) {
                    Map previousChanges = (Map)this.allChanges.get(j);
                    valueOfField = previousChanges.get(method);
                    --j;
                }
                Object[] parameters = new Object[]{valueOfField};
                try {
                    method.invoke((Object)this, parameters);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        if (this.allChanges != null && this.allChanges.size() > 1) {
            this.currentChanges = (Map)this.allChanges.get(this.allChanges.size() - 1);
            this.allChanges.remove(this.currentChanges);
        } else {
            this.allChanges = null;
            this.currentChanges = null;
        }
        this.dontAllowCurrentChanges = false;
    }

    public void undoListChanges() {
        this.verifyDeleted();
        if (this.listChanges != null && !this.listChanges.isEmpty()) {
            Object[] parameter = null;
            for (int i = this.listChanges.size() - 1; i >= 0; --i) {
                ListChangeModel listChangeObject = (ListChangeModel)this.listChanges.get(i);
                OLAPList listObject = (OLAPList)listChangeObject.getListObject();
                listObject.allowUndoSetup = false;
                Method methodField = listChangeObject.getMethod();
                Object objectField = listChangeObject.getObject();
                int location = listChangeObject.getLocation();
                parameter = location > -1 ? new Object[]{new Integer(location), objectField} : new Object[]{objectField};
                try {
                    methodField.invoke((Object)listObject, parameter);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                listObject.allowUndoSetup = true;
            }
            this.listChanges = null;
        }
    }

    public String getFQID() {
        this.verifyDeleted();
        if (this.metadataObject != null && ModelUtilities.isBlank(this.fqid)) {
            try {
                this.fqid = this.metadataObject.getFQID();
            }
            catch (RemoteException e) {
                this.fqid = "";
            }
        }
        return this.fqid;
    }

    public String getRepositoryFQID() throws OLAPException {
        this.verifyDeleted();
        String repositoryFQID = "";
        if (this.owningCube != null) {
            Tree folder = this.owningCube.getFolder();
            if (Workspace.getWorkspace().isChangeManagementOn()) {
                try {
                    repositoryFQID = Workspace.getMdFactory().getOMIUtil().getReposIdFromMetadataObject((CMetadata)this.owningCube.metadataObject);
                }
                catch (RemoteException e) {
                    repositoryFQID = "";
                }
            } else {
                repositoryFQID = ModelUtilities.getRepositoryFQID(folder);
            }
        }
        return repositoryFQID;
    }

    public String getRepositoryName() throws OLAPException {
        String repositoryName = "";
        try {
            String repositoryFQID = this.getRepositoryFQID();
            if (!ModelUtilities.isBlank(repositoryFQID)) {
                repositoryName = Workspace.getMdFactory().getRepositoryUtil().getRepositoryName(repositoryFQID);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return repositoryName;
    }

    public String getRepositoryShortFQID() throws OLAPException {
        this.verifyDeleted();
        String repositoryShortFQID = "";
        if (this.owningCube != null) {
            try {
                Tree folder = this.owningCube.getFolder();
                if (folder != null) {
                    repositoryShortFQID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getProjectRepositoryId() : ModelUtilities.getRepositoryFQID(folder).substring(9, 17);
                }
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
        return repositoryShortFQID;
    }

    public String getShortFQID() {
        this.verifyDeleted();
        if (this.metadataObject != null && ModelUtilities.isBlank(this.shortFQID)) {
            if (ModelUtilities.isBlank(this.fqid)) {
                this.getFQID();
            }
            this.shortFQID = this.fqid.substring(9, 17);
        }
        return this.shortFQID;
    }

    void setUpChanges(String inputMethodName, Class inputParameter, Object inputValue) {
        if (!this.dontAllowCurrentChanges) {
            boolean nullAllowed = true;
            if (inputParameter.equals(Integer.class)) {
                nullAllowed = false;
            }
            if (this.currentChanges == null) {
                this.currentChanges = new HashMap();
            }
            if (this.allChanges == null) {
                this.allChanges = new ArrayList();
                if (this.firstMap == null) {
                    this.firstMap = new HashMap();
                }
                this.allChanges.add(this.firstMap);
            }
            Method method = null;
            try {
                Class[] parameters = new Class[]{inputParameter};
                method = this.getClass().getMethod(inputMethodName, parameters);
            }
            catch (NoSuchMethodException parameters) {
            }
            catch (SecurityException parameters) {
                // empty catch block
            }
            try {
                if (method == null) {
                    Method[] methods = this.getClass().getDeclaredMethods();
                    int i = methods.length - 1;
                    while (i >= 0 & method == null) {
                        Method tempMethod = methods[i];
                        if (tempMethod.getName().equals(inputMethodName)) {
                            method = tempMethod;
                        }
                        --i;
                    }
                }
            }
            catch (SecurityException methods) {
                // empty catch block
            }
            if (method != null) {
                this.currentChanges.put(method, inputValue);
                if (!this.firstMap.containsKey(method)) {
                    if (nullAllowed) {
                        this.firstMap.put(method, null);
                    } else {
                        Integer convertType = new Integer(0);
                        this.firstMap.put(method, convertType);
                    }
                }
            }
        }
    }

    void setUpListChanges(String inputMethodName, Object inputValue, OLAPList inputList, int location) {
        if (inputList.allowUndoSetup) {
            try {
                if (this.listChanges == null) {
                    this.listChanges = new ArrayList();
                }
                Method method = null;
                Class[] parameters = null;
                parameters = location > -1 ? new Class[]{Integer.TYPE, Object.class} : new Class[]{Object.class};
                method = inputList.getClass().getMethod(inputMethodName, parameters);
                ListChangeModel changeModel = new ListChangeModel(method, inputValue, inputList, location);
                this.listChanges.add(changeModel);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    void verifyDeleted() {
        if (this.deleted) {
            if (!ModelUtilities.isBlank(this.name)) {
                throw new IllegalStateException(this.name + " is deleted.  Use its add() method to set back into the OLAP Cube.");
            }
            if (ModelUtilities.isBlank(this.name)) {
                throw new IllegalStateException("The olap object is deleted.  Use its add() method to set back into the OLAP Cube.");
            }
        }
    }

    public void verifyMLSId(Integer inputMLSId) throws OLAPException {
        if (inputMLSId != null && inputMLSId < 1) {
            throw new OLAPException(bundle.getString("Model.MLSID.Value.txt"), null, 0);
        }
    }

    class ListChangeModel {
        private Method method;
        private Object object;
        private OLAPList list;
        private int location;

        ListChangeModel(Method inputMethod, Object inputObject, OLAPList inputList, int inputLocation) {
            this.method = inputMethod;
            this.object = inputObject;
            this.list = inputList;
            this.location = inputLocation;
        }

        private Method getMethod() {
            return this.method;
        }

        private Object getObject() {
            return this.object;
        }

        private Object getListObject() {
            return this.list;
        }

        private int getLocation() {
            return this.location;
        }
    }
}

