/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.TableClassifierMap;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

abstract class AbstractInputTable
extends TableClassifierMap {
    static WAdminResource bundle = new WAdminResource(AbstractInputTable.class);
    private List availableColumns;

    AbstractInputTable() {
    }

    @Override
    void reset(PhysicalTable inputTable, boolean similar) throws OLAPException {
        super.reset(inputTable, similar);
    }

    @Override
    void setMapToTable(PhysicalTable inputTable, Map inputColumns) throws OLAPException {
        super.setMapToTable(inputTable, inputColumns);
        if (this.availableColumns != null) {
            this.availableColumns.clear();
            this.getColumns();
            OLAPCube owningCube = this.tableSet.getOwningCube();
            DimensionSet dimensionSet = owningCube.getDimensionSet();
            Collection levels = dimensionSet.getLevels().values();
            ArrayList<OLAPColumn> levelColumns = new ArrayList<OLAPColumn>();
            for (List listOfLevels : levels) {
                int size = listOfLevels.size();
                for (int j = 0; j < size; ++j) {
                    OLAPLevel level = (OLAPLevel)listOfLevels.get(j);
                    Column jomaColumn = dimensionSet.getMappedLevel(level);
                    if (jomaColumn == null) continue;
                    try {
                        OLAPColumn olapColumn = this.getColumn(jomaColumn.getSASColumnName());
                        levelColumns.add(olapColumn);
                        continue;
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                    }
                }
            }
        }
    }
}

