/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.environment.xml;

import com.sas.svcs.environment.Environment;
import com.sas.svcs.environment.EnvironmentManager;
import com.sas.svcs.environment.EnvironmentManagerInitializationException;
import com.sas.svcs.environment.xml.BasicErrorHandler;
import com.sas.svcs.environment.xml.EnvironmentContentHandler;
import com.sas.svcs.environment.xml.EnvironmentResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlEnvironmentManager
implements EnvironmentManager {
    private static final String SAX_FEATURES_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String SAX_FEATURES_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String APACHE_FEATURES_SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    private static final String SAS_ENVIRONMENT_SCHEMA = "http://www.sas.com/xml/schema/sas-environments-9.2";
    private static final String SAS_ENVIRONMENT_SCHEMA_94 = "http://www.sas.com/xml/schema/sas-environments-9.4";
    public static final String ENVIRONMENT_SYSTEM_PROPERTY = "env.definition.location";
    private Logger logger = LogManager.getLogger(this.getClass());
    private Map<String, Environment> environments = new HashMap<String, Environment>();
    private Environment defaultEnvironment;
    private String location;

    public XmlEnvironmentManager() {
        this(System.getProperty(ENVIRONMENT_SYSTEM_PROPERTY));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlEnvironmentManager(String loc) {
        this.location = loc;
        InputStream is = null;
        try {
            URL url = new URL(this.location);
            is = url.openStream();
            this.init(is);
            this.close(is);
            return;
        }
        catch (MalformedURLException e) {
            try {
                this.logger.fatal("Unable to properly initialize EnvironmentManager (MalformedURLException) using the provided URL (" + this.location + ")", (Throwable)e);
                throw new EnvironmentManagerInitializationException("Malformed URL: " + this.location, e, 1);
                catch (IOException e2) {
                    this.logger.fatal("Unable to properly initialize EnvironmentManager (IOException) using the provided URL (" + this.location + ")", (Throwable)e2);
                    throw new EnvironmentManagerInitializationException("Unable to open URL: " + this.location, e2, 2);
                }
            }
            catch (Throwable throwable) {
                this.close(is);
                throw throwable;
            }
        }
    }

    public XmlEnvironmentManager(InputStream s) {
        this.init(s);
    }

    @Override
    public Map<String, Environment> getEnvironments() {
        return this.environments;
    }

    @Override
    public Environment getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    private void init(InputStream is) {
        try {
            EnvironmentContentHandler environmentHandler = new EnvironmentContentHandler();
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            final EnvironmentResolver sasxsd = new EnvironmentResolver(this.getClass().getClassLoader());
            InputSource insrc = sasxsd.resolveEntity("", SAS_ENVIRONMENT_SCHEMA);
            InputSource insrc94 = sasxsd.resolveEntity("", SAS_ENVIRONMENT_SCHEMA_94);
            factory.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    LSInput impl = new LSInput(){
                        String baseURI;
                        InputStream byteStream;
                        Reader characterStream;
                        String encoding;
                        String publicId;
                        String systemId;

                        @Override
                        public String getBaseURI() {
                            return this.baseURI;
                        }

                        @Override
                        public InputStream getByteStream() {
                            return this.byteStream;
                        }

                        @Override
                        public boolean getCertifiedText() {
                            return false;
                        }

                        @Override
                        public Reader getCharacterStream() {
                            return this.characterStream;
                        }

                        @Override
                        public String getEncoding() {
                            return this.encoding;
                        }

                        @Override
                        public String getPublicId() {
                            return this.publicId;
                        }

                        @Override
                        public String getStringData() {
                            return null;
                        }

                        @Override
                        public String getSystemId() {
                            return this.systemId;
                        }

                        @Override
                        public void setBaseURI(String baseURI) {
                            this.baseURI = baseURI;
                        }

                        @Override
                        public void setByteStream(InputStream byteStream) {
                            this.byteStream = byteStream;
                        }

                        @Override
                        public void setCertifiedText(boolean certifiedText) {
                        }

                        @Override
                        public void setCharacterStream(Reader characterStream) {
                            this.characterStream = characterStream;
                        }

                        @Override
                        public void setEncoding(String encoding) {
                            this.encoding = encoding;
                        }

                        @Override
                        public void setPublicId(String publicId) {
                            this.publicId = publicId;
                        }

                        @Override
                        public void setStringData(String stringData) {
                        }

                        @Override
                        public void setSystemId(String systemId) {
                            this.systemId = systemId;
                        }
                    };
                    try {
                        impl.setBaseURI(baseURI);
                        InputSource source = sasxsd.resolveEntity(publicId, systemId);
                        impl.setByteStream(source.getByteStream());
                        impl.setEncoding("UTF-8");
                        impl.setPublicId(publicId);
                        impl.setSystemId(systemId);
                    }
                    catch (Exception e) {
                        XmlEnvironmentManager.this.logger.fatal("Unable to properly initialize EnvironmentManager due to a failure in the resource resolver: " + e.getMessage(), (Throwable)e);
                    }
                    return impl;
                }
            });
            StreamSource schemaFile = new StreamSource(insrc.getByteStream());
            StreamSource schemaFile94 = new StreamSource(insrc94.getByteStream());
            Schema schema = factory.newSchema(new Source[]{schemaFile, schemaFile94});
            ValidatorHandler validationHandler = schema.newValidatorHandler();
            validationHandler.setContentHandler(environmentHandler);
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(true);
            XMLReader reader = parserFactory.newSAXParser().getXMLReader();
            reader.setEntityResolver(sasxsd);
            reader.setContentHandler(validationHandler);
            reader.setErrorHandler(new BasicErrorHandler());
            reader.setFeature(SAX_FEATURES_VALIDATION, true);
            reader.setFeature(SAX_FEATURES_NAMESPACES, true);
            reader.setFeature(APACHE_FEATURES_SCHEMA_VALIDATION, true);
            reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            reader.parse(new InputSource(is));
            List<Environment> envs = environmentHandler.getEnvironments();
            if (null == envs || envs.isEmpty()) {
                throw new EnvironmentManagerInitializationException("No SAS environment definitions have been found in the specified resource.");
            }
            for (Environment e : envs) {
                this.environments.put(e.getName(), e);
                if (!e.isDefault()) continue;
                this.defaultEnvironment = e;
            }
        }
        catch (IOException e) {
            this.logger.fatal("Unable to properly initialize EnvironmentManager due to IOException reading the specified resource.", (Throwable)e);
            throw new EnvironmentManagerInitializationException("Unable to open resource.", e, 2);
        }
        catch (ParserConfigurationException e) {
            this.logger.fatal("Unable to properly initialize EnvironmentManager due to a ParserConfigurationException. ", (Throwable)e);
            throw new EnvironmentManagerInitializationException("Unable to parse environment definition resource.", e, 3);
        }
        catch (SAXException e) {
            System.out.println(e.getMessage());
            this.logger.fatal("Unable to properly initialize EnvironmentManager due to a SAXException reading the specified resource.", (Throwable)e);
            throw new EnvironmentManagerInitializationException("SAX parser is unable to parse environment definition resource.", e, 3);
        }
    }

    private void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Unable to close stream:", (Throwable)e);
        }
    }
}

