/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.environment.xml;

import com.sas.svcs.environment.Component;
import com.sas.svcs.environment.Environment;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class EnvironmentContentHandler
implements ContentHandler {
    private static final String XSD_ENVIRONMENT = "environment";
    private static final String XSD_DESCRIPTION = "desc";
    private static final String XSD_BLOCK_DESCRIPTION = "block-desc";
    private static final String XSD_TOOLTIP = "tooltip";
    private static final String XSD_SERVICE_REGISTRY = "service-registry";
    private static final String XSD_COMPONENT = "component";
    private static final String XSD_IOM_HOST = "host";
    private static final String XSD_IOM_PORT = "port";
    private static final String XSD_NAMING_INITIAL = "java-naming-factory-initial";
    private static final String XSD_NAMING_URL = "java-naming-provider-url";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DEFAULT = "default";
    private static final String ATTR_LANG = "lang";
    private static final String ATTR_INTERFACE_TYPE = "interface-type";
    private static final String ATTR_PLATFORM_VERSION = "platform-version";
    private List<Environment> environments;
    private Environment environment;
    private Component component;
    private StringBuffer elementContent;
    private String interfaceType;
    private Locale locale;

    public List<Environment> getEnvironments() {
        return this.environments;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.elementContent.append(new String(ch, start, length));
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (localName.equals(XSD_ENVIRONMENT)) {
            if (null == this.environments) {
                this.environments = new ArrayList<Environment>();
            }
            this.environments.add(this.environment);
        } else if (localName.equals(XSD_DESCRIPTION)) {
            if (this.locale != null) {
                this.environment.setDescription(this.locale, this.elementContent.toString());
                this.locale = null;
            } else {
                this.environment.setDescription(this.elementContent.toString());
            }
        } else if (localName.equals(XSD_BLOCK_DESCRIPTION)) {
            if (this.locale != null) {
                this.environment.setBlockDescription(this.locale, this.elementContent.toString());
                this.locale = null;
            } else {
                this.environment.setBlockDescription(this.elementContent.toString());
            }
        } else if (localName.equals(XSD_TOOLTIP)) {
            if (this.locale != null) {
                this.environment.setTooltip(this.locale, this.elementContent.toString());
                this.locale = null;
            } else {
                this.environment.setTooltip(this.elementContent.toString());
            }
        } else if (localName.equals(XSD_SERVICE_REGISTRY)) {
            String url = this.elementContent.toString();
            if ("java".equals(this.interfaceType)) {
                this.environment.setServiceRegistry(url);
            }
            this.environment.addRegistry(this.interfaceType, url);
        } else if (localName.equals(XSD_COMPONENT)) {
            this.environment.setComponent(this.component);
        } else if (localName.equals(XSD_NAMING_INITIAL)) {
            this.component.setInitialContext(this.elementContent.toString());
        } else if (localName.equals(XSD_NAMING_URL)) {
            this.component.setProviderUrl(this.elementContent.toString());
        } else if (localName.equals(XSD_IOM_HOST)) {
            this.environment.setIOMServerHost(this.elementContent.toString());
        } else if (localName.equals(XSD_IOM_PORT)) {
            int port = 0;
            try {
                port = Integer.parseInt(this.elementContent.toString());
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("Unable to parse <iom-client-connection><port> value.");
            }
            this.environment.setIOMServerPort(port);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.elementContent = new StringBuffer();
        if (localName.equals(XSD_ENVIRONMENT)) {
            String version;
            String ename = atts.getValue("", ATTR_NAME);
            this.environment = new Environment(ename);
            String def = atts.getValue("", ATTR_DEFAULT);
            if ("true".equalsIgnoreCase(def)) {
                this.environment.setDefault(true);
            }
            if (null != (version = atts.getValue("", ATTR_PLATFORM_VERSION))) {
                this.environment.setPlatformVersion(version);
            }
        } else if (localName.equals(XSD_DESCRIPTION) || localName.equals(XSD_BLOCK_DESCRIPTION) || localName.equals(XSD_TOOLTIP)) {
            String lang = atts.getValue("http://www.w3.org/XML/1998/namespace", ATTR_LANG);
            if (null != lang) {
                this.locale = LocaleUtils.toLocale((String)lang.replace('-', '_'));
            }
        } else if (localName.equals(XSD_COMPONENT)) {
            String cname = atts.getValue("", ATTR_NAME);
            this.component = new Component(cname);
        } else if (localName.equals(XSD_SERVICE_REGISTRY)) {
            this.interfaceType = atts.getValue("", ATTR_INTERFACE_TYPE);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

