/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public abstract class ValueCompiler {
    public void compilePush(CompilerService compiler, Value value) {
        try {
            AtomicValue item;
            SequenceIterator iter = value.iterate();
            while ((item = (AtomicValue)iter.next()) != null) {
                ValueCompiler vc = compiler.getValueCompiler((Value)item);
                compiler.emit(compiler.getOutputterVariableName() + ".append(" + vc.compileToItem(compiler, item) + ", 0, 0);");
            }
        }
        catch (XPathException e) {
            throw new AssertionError((Object)"Failed to compile literal value");
        }
    }

    public String compileToItem(CompilerService compiler, AtomicValue value) {
        String initializer = this.toJavaExpression(value, compiler);
        if (value.getTypeLabel().isBuiltInType()) {
            return compiler.emitInstanceVariable(this.getJavaClass(value), null, initializer, 3, true, true, null, null);
        }
        return compiler.emitInstanceVariable(this.getJavaClass(value), null, initializer, 3, false, false, null, null);
    }

    public String compileToIterator(CompilerService compiler, Value val) {
        try {
            if (val instanceof AtomicValue) {
                AtomicValue av = (AtomicValue)val;
                String var = "s" + compiler.getUniqueNumber();
                compiler.declare(SequenceIterator.class, var, "SingletonIterator.makeIterator(" + this.toJavaExpression(av, compiler) + ")", true);
                return var;
            }
            int len = val.getLength();
            int n = compiler.getUniqueNumber();
            String arrayVar = "items" + n;
            compiler.emit("AtomicValue[] " + arrayVar + " = new AtomicValue[" + len + "];");
            for (int i = 0; i < len; ++i) {
                AtomicValue av = (AtomicValue)val.itemAt(i);
                ValueCompiler vc = compiler.getValueCompiler((Value)av);
                compiler.emit(arrayVar + "[" + i + "] = " + compiler.cast(vc.compileToItem(compiler, av), AtomicValue.class) + ";");
            }
            String iterVar = "seq" + n;
            compiler.declare(SequenceIterator.class, iterVar, "new ArrayIterator(" + arrayVar + ")", true);
            return iterVar;
        }
        catch (XPathException e) {
            throw new AssertionError((Object)"Failed to compile literal value");
        }
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Value expr, ReturnAction options) {
        throw new UnsupportedOperationException("Effective Boolean Value not defined for value type " + expr.getClass().getName());
    }

    public String compileToCharSequence(CompilerService compiler, AtomicValue av) {
        String itemVar = this.compileToItem(compiler, av);
        return itemVar + ".getStringValueCS()";
    }

    public abstract String toJavaExpression(AtomicValue var1, CompilerService var2);

    public Class getJavaClass(AtomicValue value) {
        return value.getClass();
    }
}

