/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.sort.TupleExpression;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public class TupleExpressionCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        TupleExpression exp = (TupleExpression)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = "tuple" + n;
        String arrayVar = "values" + n;
        Expression[] components = exp.getComponents();
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append("{");
        for (int i = 0; i < components.length; ++i) {
            String c;
            if (Cardinality.allowsMany((int)components[i].getCardinality())) {
                c = compiler.compileToValueRepresentation(components[i]);
                sb.append("Value.asValue(" + c + ")");
            } else {
                c = compiler.compileToItem(components[i]);
                sb.append("Value.asValue(" + c + ")");
            }
            if (i == components.length - 1) {
                sb.append("}");
                continue;
            }
            sb.append(", ");
        }
        compiler.declare(Value[].class, arrayVar, sb.toString(), true);
        compiler.emit("ObjectValue " + resultVar + " = new ObjectValue(" + arrayVar + ");");
        return resultVar;
    }
}

