/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.functions.regex.JRegularExpression;
import net.sf.saxon.functions.regex.RegularExpression;
import net.sf.saxon.om.SequenceIterator;

public class TokenizeCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        String patternVar;
        Tokenize exp = (Tokenize)expr;
        Expression[] args = exp.getArguments();
        int n = compiler.getUniqueNumber();
        String argVar = compiler.compileToCharSequence(args[0]);
        if (exp.getCompiledRegularExpression() != null) {
            JRegularExpression jregex = (JRegularExpression)exp.getCompiledRegularExpression();
            String translated = jregex.getJavaRegularExpression();
            int flagBits = jregex.getFlagBits();
            patternVar = compiler.compileRegularExpression(translated, flagBits);
        } else {
            String regexVar = compiler.compileToCharSequence(args[1]);
            String flagsVar = exp.getNumberOfArguments() == 3 ? compiler.compileToCharSequence(args[2]) : "\"\"";
            patternVar = "regex" + n;
            compiler.declare(RegularExpression.class, patternVar, "new JRegularExpression(" + regexVar + ",  RegularExpression.XPATH30, JRegularExpression.setFlags(" + flagsVar + "))", true);
            compiler.emit("if (" + patternVar + ".matches(\"\")) {");
            compiler.emitDynamicError("The regular expression in tokenize() must not be one that matches a zero-length string", "FORX0003");
            compiler.emit("}");
        }
        String resultVar = "tok" + n;
        compiler.declare(SequenceIterator.class, resultVar, patternVar + ".tokenize(" + argVar + ")", true);
        return resultVar;
    }
}

