/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.instruct.UserFunction;

public class TailCallLoopCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        TailCallLoop exp = (TailCallLoop)expr;
        if (exp.getContainingFunction().isTailRecursive()) {
            this.prelude(compiler, exp);
            String out = compiler.compileToIterator(exp.getBaseExpression());
            compiler.emit("if (!doTailCall) return " + out + ";");
            this.postlude(compiler);
            return null;
        }
        return compiler.compileToIterator(exp.getBaseExpression());
    }

    private void prelude(CompilerService compiler, TailCallLoop exp) {
        UserFunction uf = exp.getContainingFunction();
        compiler.emit("while (true) {");
        compiler.emit("boolean doTailCall = false;");
        int args = uf.getNumberOfArguments();
        for (int a = 0; a < args; ++a) {
            String paramName = compiler.getXPathVariableName(a);
            String finalParamName = paramName + "Final";
            Class argClass = compiler.getJavaClassForFunctionParameter(uf, a);
            compiler.declare(argClass, finalParamName, paramName, true);
            compiler.setXPathVariableName(a, finalParamName);
        }
    }

    private void postlude(CompilerService compiler) {
        compiler.emit("}");
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        TailCallLoop exp = (TailCallLoop)expr;
        if (exp.getContainingFunction().isTailRecursive()) {
            this.prelude(compiler, exp);
            String out = compiler.compileToItem(exp.getBaseExpression());
            compiler.emit("if (!doTailCall) return " + out + ";");
            this.postlude(compiler);
            return null;
        }
        return compiler.compileToItem(exp.getBaseExpression());
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, LoopAction action) {
        TailCallLoop exp = (TailCallLoop)expr;
        if (exp.getContainingFunction().isTailRecursive()) {
            this.prelude(compiler, exp);
            compiler.compileAsLoop(exp.getBaseExpression(), action);
            compiler.emit("if (!doTailCall) return;");
            this.postlude(compiler);
        } else {
            compiler.compileAsLoop(exp.getBaseExpression(), action);
        }
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        TailCallLoop exp = (TailCallLoop)expr;
        if (exp.getContainingFunction().isTailRecursive()) {
            this.prelude(compiler, exp);
            compiler.compilePush(exp.getBaseExpression());
            compiler.emit("if (!doTailCall) return;");
            this.postlude(compiler);
        } else {
            compiler.compilePush(exp.getBaseExpression());
        }
    }
}

