/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.Subsequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;

public class SubsequenceCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        Subsequence exp = (Subsequence)expr;
        Expression[] arguments = exp.getArguments();
        Expression base = arguments[0];
        String baseVar = compiler.compileToIterator(base);
        int n = compiler.getUniqueNumber();
        String resultVar = "subseq" + n;
        if (exp.getNumberOfArguments() == 2) {
            String startExp = this.compileArgument(arguments[1], compiler);
            compiler.declare(SequenceIterator.class, resultVar, "TailIterator.make(" + baseVar + ", (int)" + startExp + ")", true);
        } else {
            String startExp = this.compileArgument(arguments[1], compiler);
            String lengthExp = this.compileArgument(arguments[2], compiler);
            compiler.declare(SequenceIterator.class, resultVar, "SubsequenceIterator.make(" + baseVar + ", (int)" + startExp + ", (int)(" + startExp + " + " + lengthExp + " - 1))", true);
        }
        return resultVar;
    }

    private String compileArgument(Expression arg, CompilerService compiler) {
        String startExp;
        Value argVal;
        Value value = argVal = arg instanceof Literal ? ((Literal)arg).getValue() : null;
        if (argVal instanceof Int64Value) {
            startExp = ((Int64Value)argVal).getStringValue();
        } else if (argVal instanceof NumericValue) {
            try {
                startExp = ((NumericValue)argVal).round(0).longValue() + "";
            }
            catch (XPathException err) {
                throw new UnsupportedOperationException(err.getMessage());
            }
        } else {
            TypeHierarchy th = compiler.getTypeHierarchy();
            startExp = th.isSubType(arg.getItemType(th), (ItemType)BuiltInAtomicType.INTEGER) ? compiler.cast(compiler.compileToItem(arg), NumericValue.class) + ".longValue()" : compiler.cast(compiler.compileToItem(arg), NumericValue.class) + ".round(0).longValue()";
        }
        return startExp;
    }
}

