/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class StringValueCompiler
extends ValueCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Value expr, ReturnAction options) {
        compiler.emit(options.output(compiler, ((StringValue)expr).isZeroLength() ? "false" : "true"));
        return options.getVariableName();
    }

    public String compileToCharSequence(CompilerService compiler, AtomicValue exp) {
        return CompilerService.javaEscape(((StringValue)exp).getStringValue());
    }

    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        AtomicType type = value.getTypeLabel();
        String strVal = CompilerService.javaEscape(((StringValue)value).getStringValue());
        if (type.equals(BuiltInAtomicType.STRING)) {
            return "StringValue.makeStringValue(" + strVal + ")";
        }
        if (type instanceof BuiltInAtomicType) {
            return "(StringValue)StringValue.makeRestrictedString(" + strVal + ", (BuiltInAtomicType)" + compiler.compileItemType((ItemType)value.getTypeLabel()) + ", null)";
        }
        return "(StringValue)StringValue.makeStringValue(" + strVal + ")" + ".copyAsSubType((AtomicType)" + compiler.compileItemType((ItemType)value.getTypeLabel()) + ")";
    }
}

