/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.AtomicSequenceConverterCompiler;
import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.om.Item;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class StringJoinCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        Value sepVal;
        StringJoin exp = (StringJoin)expr;
        String inVar = compiler.compileToIterator(exp.getArguments()[0]);
        int n = compiler.getUniqueNumber();
        String outVar = "m" + n;
        String firstVar = "first" + n;
        String nextVar = "next" + n;
        String buffVar = "sb" + n;
        String sepVar = "sep" + n;
        compiler.declare(Item.class, outVar, null, false);
        compiler.declare(Item.class, firstVar, inVar + ".next()", true);
        compiler.emit("if (" + firstVar + " == null) {");
        compiler.emit(outVar + " = StringValue.EMPTY_STRING;");
        compiler.emit("} else {");
        compiler.declare(Item.class, nextVar, inVar + ".next()", false);
        compiler.emit("if (" + nextVar + " == null) {");
        compiler.emit(outVar + " = (StringValue)" + firstVar + ";");
        compiler.emit("} else {");
        compiler.declare(FastStringBuffer.class, buffVar, "new FastStringBuffer(256)", true);
        compiler.emit(buffVar + ".append(" + firstVar + ".getStringValueCS());");
        Expression sepExp = exp.getArguments()[1];
        Value value = sepVal = sepExp instanceof Literal ? ((Literal)sepExp).getValue() : null;
        if (sepVal instanceof StringValue) {
            compiler.declare(CharSequence.class, sepVar, compiler.compileToCharSequence(sepExp), true);
        } else {
            String sepVarItem = compiler.compileToItem(sepExp);
            compiler.declare(CharSequence.class, sepVar, sepVarItem + ".getStringValueCS()", true);
        }
        compiler.emit(buffVar + ".append(" + sepVar + ");");
        compiler.emit(buffVar + ".append(" + nextVar + ".getStringValueCS());");
        compiler.emit("while (true) {");
        compiler.assign(nextVar, inVar + ".next()");
        compiler.emit("if (" + nextVar + " == null) {");
        compiler.assign(outVar, "new StringValue(" + buffVar + ".condense())");
        compiler.emit("break;");
        compiler.emit("} // end if");
        compiler.emit(buffVar + ".append(" + sepVar + ");");
        compiler.emit(buffVar + ".append(" + nextVar + ".getStringValueCS());");
        compiler.emit("} // end while");
        compiler.assign(outVar, "new StringValue(" + buffVar + ")");
        compiler.emit("} // end if");
        compiler.emit("} // end if");
        return outVar;
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        Expression arg;
        Value sepVal;
        final StringJoin exp = (StringJoin)expr;
        String fixedSeparator = null;
        Expression sepExp = exp.getArguments()[1];
        Value value = sepVal = sepExp instanceof Literal ? ((Literal)sepExp).getValue() : null;
        if (sepVal instanceof StringValue) {
            fixedSeparator = CompilerService.javaEscape(((StringValue)sepVal).getStringValueCS());
        }
        final boolean fixedSep = fixedSeparator != null;
        int n = compiler.getUniqueNumber();
        final String countVar = "j" + n;
        final String sepVar = fixedSeparator == null ? "sep" + n : fixedSeparator;
        final String resultVar = "str" + n;
        compiler.declare(Integer.TYPE, countVar, "0", false);
        compiler.declare(CharSequence.class, resultVar, "\"\"", false);
        if (!fixedSep) {
            compiler.declare(CharSequence.class, sepVar, "null", false);
        }
        final boolean unboxed = (arg = exp.getArguments()[0]) instanceof AtomicSequenceConverter && ((AtomicSequenceConverter)arg).getRequiredPrimitiveType().equals((Object)BuiltInAtomicType.STRING);
        LoopAction innerAction = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.emit(countVar + "++;");
                compiler.emit("if (" + countVar + " == 1) {");
                compiler.assign(resultVar, itemVar + (unboxed ? "" : ".getStringValueCS()"));
                compiler.emit("} else {");
                compiler.emit("if (" + countVar + " == 2) {");
                if (!fixedSep) {
                    String s = compiler.compileToCharSequence(exp.getArguments()[1]);
                    compiler.assign(sepVar, s);
                }
                compiler.assign(resultVar, "new FastStringBuffer(" + resultVar + ")");
                compiler.emit("}");
                compiler.emit("((FastStringBuffer)" + resultVar + ").append(" + sepVar + ");");
                compiler.emit("((FastStringBuffer)" + resultVar + ").append(" + itemVar + (unboxed ? "" : ".getStringValueCS()") + ");");
                compiler.emit("}");
            }
        };
        if (unboxed) {
            AtomicSequenceConverterCompiler.compileAsCharSequenceLoop(compiler, (AtomicSequenceConverter)arg, innerAction);
        } else {
            compiler.compileAsLoop(arg, innerAction);
        }
        return resultVar;
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, final LoopAction action) {
        final StringJoin exp = (StringJoin)expr;
        int n = compiler.getUniqueNumber();
        final String countVar = "j" + n;
        final String sepVar = "sep" + n;
        compiler.emit("int " + countVar + " = 0;");
        compiler.emit("CharSequence " + sepVar + " = null;");
        LoopAction innerAction = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.emit(countVar + "++;");
                compiler.emit("if (" + countVar + " == 1) {");
                action.compileAction(compiler, itemVar);
                compiler.emit("} else if (" + countVar + " == 2) {");
                String s = compiler.compileToCharSequence(exp.getArguments()[1]);
                compiler.emit(sepVar + " = " + s + ";");
                compiler.emit(compiler.getOutputterVariableName() + ".append(" + sepVar + ");");
                action.compileAction(compiler, itemVar);
                compiler.emit("} else {");
                action.compileAction(compiler, itemVar);
                compiler.emit("}");
            }
        };
        compiler.compileAsLoop(exp.getArguments()[0], innerAction);
    }
}

