/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public abstract class SingletonExpressionCompiler
extends ExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression exp) {
        String var = this.compileToItem(compiler, exp);
        if (Cardinality.allowsZero((int)exp.getCardinality())) {
            compiler.emit("if (" + var + " != null) { ");
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + var + ", 0, NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        } else {
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + var + ", 0, NodeInfo.ALL_NAMESPACES);");
        }
    }

    public String compileToIterator(CompilerService compiler, Expression exp) {
        String itemVar = this.compileToItem(compiler, exp);
        String var = "s" + compiler.getUniqueNumber();
        compiler.declare(SequenceIterator.class, var, "SingletonIterator.makeIterator(" + itemVar + ")", true);
        return var;
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction options) {
        ItemType type;
        TypeHierarchy th = compiler.getTypeHierarchy();
        if (th.isSubType(type = expr.getItemType(th), (ItemType)BuiltInAtomicType.BOOLEAN)) {
            String var = compiler.compileToItem(expr);
            String jexp = compiler.cast(var, BooleanValue.class) + ".getBooleanValue()";
            if (Cardinality.allowsZero((int)expr.getCardinality())) {
                jexp = "(" + var + "==null ? false : " + jexp + ")";
            }
            compiler.emit(options.output(compiler, jexp));
        } else if (th.isSubType(type, (ItemType)BuiltInAtomicType.NUMERIC)) {
            String var = compiler.compileToItem(expr);
            String jexp = compiler.cast(var, NumericValue.class) + ".effectiveBooleanValue()";
            if (Cardinality.allowsZero((int)expr.getCardinality())) {
                jexp = "(" + var + "==null ? false : " + jexp + ")";
            }
            compiler.emit(options.output(compiler, jexp));
        } else if (th.isSubType(type, (ItemType)BuiltInAtomicType.STRING) || th.isSubType(type, (ItemType)BuiltInAtomicType.ANY_URI) || th.isSubType(type, (ItemType)BuiltInAtomicType.UNTYPED_ATOMIC)) {
            String var = compiler.compileToItem(expr);
            String jexp = compiler.cast(var, StringValue.class) + ".getStringValueCS().length() > 0";
            if (Cardinality.allowsZero((int)expr.getCardinality())) {
                jexp = "(" + var + "==null ? false : " + jexp + ")";
            }
            compiler.emit(options.output(compiler, jexp));
        } else {
            String iterVar = this.compileToIterator(compiler, expr);
            compiler.emit(options.output(compiler, "ExpressionTool.effectiveBooleanValue(" + iterVar + ");"));
        }
        return options.getVariableName();
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        return this.compileToItem(compiler, expr) + ".getStringValueCS()";
    }
}

