/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaAssignment;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import com.saxonica.codegen.ValueComparisonCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SingletonComparison;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.ComparableAtomicValueComparer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class SingletonComparisonCompiler
extends ToBooleanCompiler {
    public String compileToItem(CompilerService compiler, Expression exp) {
        return super.compileToItem(compiler, exp);
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        boolean conditional;
        SingletonComparison exp = (SingletonComparison)expr;
        TypeHierarchy th = compiler.getTypeHierarchy();
        int n = compiler.getUniqueNumber();
        Expression[] op = exp.getOperands();
        int[] c = new int[]{op[0].getCardinality(), op[1].getCardinality()};
        AtomicComparer comparer = exp.getAtomicComparer();
        int operator = exp.getOperator();
        String[] opvar = new String[]{compiler.compileToItem(op[0]), compiler.compileToItem(op[1])};
        if (result instanceof JavaDeclaration) {
            compiler.declare(Boolean.TYPE, result.getVariableName(), "false", false);
            result = new JavaAssignment(Boolean.TYPE, result.getVariableName());
        }
        boolean[] emptiable = new boolean[]{Cardinality.allowsZero((int)c[0]), Cardinality.allowsZero((int)c[1])};
        boolean bl = conditional = emptiable[0] || emptiable[1];
        if (conditional) {
            String cond = emptiable[0] ? (emptiable[1] ? opvar[0] + "==null || " + opvar[1] + "==null" : opvar[0] + "==null") : opvar[1] + "==null";
            compiler.emit("if (" + cond + ") {");
            compiler.emit(result.output(compiler, "false"));
            compiler.emit("} else {");
            conditional = true;
        }
        String varConv0 = this.convertOperand(compiler, 0, n, op, opvar);
        String varConv1 = this.convertOperand(compiler, 1, n, op, opvar);
        String s = SingletonComparisonCompiler.compileComparison(comparer, varConv0, compiler, varConv1, operator);
        ItemType t0 = op[0].getItemType(th).getPrimitiveItemType();
        ItemType t1 = op[1].getItemType(th).getPrimitiveItemType();
        s = ValueComparisonCompiler.adjustForNaN(compiler, t0, varConv0, operator, s);
        s = ValueComparisonCompiler.adjustForNaN(compiler, t1, varConv1, operator, s);
        compiler.emit(result.output(compiler, s));
        if (conditional) {
            compiler.emit("}");
        }
        return result.getVariableName();
    }

    private String convertOperand(CompilerService compiler, int arg, int n, Expression[] operands, String[] opvar) {
        boolean mayBeNumeric;
        int other = 1 - arg;
        TypeHierarchy th = compiler.getTypeHierarchy();
        int[] relUntyped = new int[]{th.relationship(operands[0].getItemType(th), (ItemType)BuiltInAtomicType.UNTYPED_ATOMIC), th.relationship(operands[1].getItemType(th), (ItemType)BuiltInAtomicType.UNTYPED_ATOMIC)};
        boolean[] mayBeUntyped = new boolean[]{relUntyped[0] != 4, relUntyped[1] != 4};
        boolean[] isUntyped = new boolean[2];
        isUntyped[0] = relUntyped[0] == 0;
        boolean bl = isUntyped[1] = relUntyped[1] == 0;
        if (!mayBeUntyped[arg]) {
            return opvar[arg];
        }
        boolean conditionalConversion = !isUntyped[arg] || mayBeUntyped[other] && !isUntyped[other];
        String castToAtomic = compiler.cast(opvar[arg], AtomicValue.class);
        String otherType = compiler.cast(opvar[other], AtomicValue.class) + ".getPrimitiveType()";
        int relNumeric = th.relationship(operands[other].getItemType(th), (ItemType)BuiltInAtomicType.NUMERIC);
        boolean isNumeric = relNumeric == 0 || relNumeric == 2;
        boolean bl2 = mayBeNumeric = relNumeric != 4;
        String targetType = isNumeric ? "BuiltInAtomicType.DOUBLE" : (mayBeNumeric ? "(" + opvar[other] + " instanceof NumericValue ? BuiltInAtomicType.DOUBLE : " + otherType + ")" : otherType);
        String convertExp = castToAtomic + ".convert(" + targetType + ", " + compiler.getContextVariableName() + ")";
        String opvarConv = "conv" + arg + n;
        compiler.declare(AtomicValue.class, opvarConv, castToAtomic, false);
        if (conditionalConversion) {
            String guard = "";
            if (mayBeUntyped[other]) {
                guard = " && !(" + opvar[other] + " instanceof UntypedAtomicValue)";
            }
            compiler.emit("if ((" + opvar[arg] + " instanceof UntypedAtomicValue) " + guard + ") {");
            compiler.assign(opvarConv, convertExp);
            compiler.emit("}");
        } else {
            compiler.assign(opvarConv, convertExp);
        }
        return opvarConv;
    }

    protected static String compileComparison(AtomicComparer comparer, String op0var, CompilerService compiler, String op1var, int operator) {
        if (comparer instanceof CodepointCollatingComparer) {
            return SingletonComparisonCompiler.compileCodepointComparison(op0var, compiler, op1var, operator);
        }
        if (comparer instanceof ComparableAtomicValueComparer) {
            return SingletonComparisonCompiler.compileComparableAtomicComparison(compiler, op0var, op1var, operator);
        }
        return SingletonComparisonCompiler.compileAtomicValueComparison(comparer, compiler, op0var, op1var, operator);
    }

    private static String compileCodepointComparison(String op0var, CompilerService compiler, String op1var, int operator) {
        String cast0 = compiler.cast(op0var, StringValue.class);
        String cast1 = compiler.cast(op1var, StringValue.class);
        switch (operator) {
            case 50: {
                return cast0 + ".codepointEquals(" + cast1 + ")";
            }
            case 51: {
                return "!" + cast0 + ".codepointEquals(" + cast1 + ")";
            }
            case 52: {
                return "CodepointCollator.getInstance().compareCS(" + cast0 + ".getStringValueCS(), " + cast1 + ".getStringValueCS()) > 0";
            }
            case 53: {
                return "CodepointCollator.getInstance().compareCS(" + cast0 + ".getStringValueCS(), " + cast1 + ".getStringValueCS()) < 0";
            }
            case 54: {
                return "CodepointCollator.getInstance().compareCS(" + cast0 + ".getStringValueCS(), " + cast1 + ".getStringValueCS()) >= 0";
            }
            case 55: {
                return "CodepointCollator.getInstance().compareCS(" + cast0 + ".getStringValueCS(), " + cast1 + ".getStringValueCS()) <= 0";
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + operator);
    }

    private static String compileAtomicValueComparison(AtomicComparer comparer, CompilerService compiler, String op0var, String op1var, int operator) {
        String compVar = compiler.compileAtomicComparer(comparer);
        String cast0 = compiler.cast(op0var, AtomicValue.class);
        String cast1 = compiler.cast(op1var, AtomicValue.class);
        switch (operator) {
            case 50: {
                return compVar + ".comparesEqual(" + cast0 + ", " + cast1 + ")";
            }
            case 51: {
                return "!" + compVar + ".comparesEqual(" + cast0 + ", " + cast1 + ")";
            }
            case 52: {
                return compVar + ".compareAtomicValues(" + cast0 + ", " + cast1 + ") > 0";
            }
            case 53: {
                return compVar + ".compareAtomicValues(" + cast0 + ", " + cast1 + ") < 0";
            }
            case 54: {
                return compVar + ".compareAtomicValues(" + cast0 + ", " + cast1 + ") >= 0";
            }
            case 55: {
                return compVar + ".compareAtomicValues(" + cast0 + ", " + cast1 + ") <= 0";
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + operator);
    }

    private static String compileComparableAtomicComparison(CompilerService compiler, String op0var, String op1var, int operator) {
        String cast0 = compiler.cast(op0var, Comparable.class);
        String cast1 = compiler.cast(op1var, Comparable.class);
        switch (operator) {
            case 50: {
                return cast0 + ".equals(" + cast1 + ")";
            }
            case 51: {
                return "!" + cast0 + ".equals(" + cast1 + ")";
            }
            case 52: {
                return cast0 + ".compareTo(" + cast1 + ") > 0";
            }
            case 53: {
                return cast0 + ".compareTo(" + cast1 + ") < 0";
            }
            case 54: {
                return cast0 + ".compareTo(" + cast1 + ") >= 0";
            }
            case 55: {
                return cast0 + ".compareTo(" + cast1 + ") <= 0";
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + operator);
    }
}

