/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ContextItemCompiler;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.tree.iter.AxisIterator;

public class RootExpressionCompiler
extends ExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression expr) {
        String rootVar = this.compileDocumentRoot(compiler);
        compiler.emit(compiler.getOutputterVariableName() + ".append(" + rootVar + ");");
    }

    private String compileDocumentRoot(CompilerService compiler) {
        int n = compiler.getUniqueNumber();
        String rootVar = "root" + n;
        compiler.declare(DocumentInfo.class, rootVar, ContextItemCompiler.compileGetContextNode(compiler) + ".getDocumentRoot()", true);
        compiler.emit("if (" + rootVar + " == null) {");
        compiler.emitDynamicError("The context node is in a tree whose root is not a document node", "XPDY0050");
        compiler.emit("}");
        return rootVar;
    }

    public String compileToIterator(CompilerService compiler, Expression expr) {
        String rootVar = this.compileDocumentRoot(compiler);
        String rootIterVar = rootVar + "iter";
        compiler.declare(AxisIterator.class, rootIterVar, "SingleNodeIterator.makeIterator(" + rootVar + ")", true);
        return rootIterVar;
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        return this.compileDocumentRoot(compiler);
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        this.compileDocumentRoot(compiler);
        compiler.emit(result.output(compiler, "true"));
        return result.getVariableName();
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        String rootVar = this.compileDocumentRoot(compiler);
        String rootStringVar = rootVar + "sv";
        compiler.declare(String.class, rootStringVar, rootVar + ".getStringValueCS()", true);
        return rootStringVar;
    }
}

