/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.Replace;
import net.sf.saxon.functions.regex.JRegularExpression;
import net.sf.saxon.functions.regex.RegularExpression;
import net.sf.saxon.value.StringValue;

public class ReplaceCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        String patternVar;
        Replace exp = (Replace)expr;
        Expression[] args = exp.getArguments();
        int n = compiler.getUniqueNumber();
        String argVar = compiler.compileToCharSequence(args[0]);
        String repVar = compiler.compileToCharSequence(args[2]);
        if (exp.getCompiledRegularExpression() != null) {
            JRegularExpression jregex = (JRegularExpression)exp.getCompiledRegularExpression();
            String translated = jregex.getJavaRegularExpression();
            int flagBits = jregex.getFlagBits();
            patternVar = compiler.compileRegularExpression(translated, flagBits);
        } else {
            String regexVar = compiler.compileToCharSequence(args[1]);
            String flagsVar = exp.getNumberOfArguments() == 4 ? compiler.compileToCharSequence(args[3]) : "\"\"";
            patternVar = "regex" + n;
            compiler.declare(RegularExpression.class, patternVar, "new JRegularExpression(" + regexVar + ", RegularExpression.XPATH30, JRegularExpression.setFlags(" + flagsVar + "))", true);
            compiler.emit("if (" + patternVar + ".matches(\"\")) {");
            compiler.emitDynamicError("The regular expression in replace() must not be one that matches a zero-length string", "FORX0003");
            compiler.emit("}");
        }
        String msgVar = "msg" + n;
        compiler.declare(String.class, msgVar, "Replace.checkReplacement(" + repVar + ")", true);
        compiler.emit("if (" + msgVar + " != null ) {");
        compiler.emit("dynamicError(" + msgVar + ", \"FORX0004\", " + compiler.getContextVariableName() + ");");
        compiler.emit("}");
        String resultVar = "rep" + n;
        compiler.declare(StringValue.class, resultVar, "StringValue.makeStringValue(" + patternVar + ".replace(" + argVar + ", " + repVar + "))", true);
        return resultVar;
    }
}

