/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class RangeExpressionCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        RangeExpression exp = (RangeExpression)expr;
        Expression[] operands = exp.getOperands();
        int n = compiler.getUniqueNumber();
        int closers = 0;
        String resultVar = "range" + n;
        compiler.declare(SequenceIterator.class, resultVar, null, false);
        String op0Var = compiler.compileToItem(operands[0]);
        if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
            compiler.emit("if (" + op0Var + " == null) {");
            compiler.emit(resultVar + " = EmptyIterator.getInstance();");
            compiler.emit("} else {");
            ++closers;
        }
        String op1Var = compiler.compileToItem(operands[1]);
        if (Cardinality.allowsZero((int)operands[1].getCardinality())) {
            compiler.emit("if (" + op1Var + " == null) {");
            compiler.emit(resultVar + " = EmptyIterator.getInstance();");
            compiler.emit("} else {");
            ++closers;
        }
        String vm = op0Var + "m" + n;
        compiler.declare(NumericValue.class, vm, compiler.cast(op0Var, NumericValue.class), true);
        String vn = op1Var + "n" + n;
        compiler.declare(NumericValue.class, vn, compiler.cast(op1Var, NumericValue.class), true);
        compiler.emit(resultVar + " = new RangeIterator(" + vm + ".longValue(), " + vn + ".longValue());");
        for (int i = 0; i < closers; ++i) {
            compiler.emit("}");
        }
        return resultVar;
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, LoopAction action) {
        RangeExpression exp = (RangeExpression)expr;
        Expression[] operands = exp.getOperands();
        int n = compiler.getUniqueNumber();
        int closers = 0;
        String op0Var = compiler.compileToItem(operands[0]);
        if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
            compiler.emit("if (" + op0Var + " == null) {");
            compiler.emit("// no action");
            compiler.emit("} else {");
            ++closers;
        }
        String op1Var = compiler.compileToItem(operands[1]);
        if (Cardinality.allowsZero((int)operands[1].getCardinality())) {
            compiler.emit("if (" + op1Var + " == null) {");
            compiler.emit("// no action");
            compiler.emit("} else {");
            ++closers;
        }
        String startVar = "start" + n;
        String endVar = "end" + n;
        compiler.declare(Long.TYPE, startVar, "((NumericValue)" + compiler.cast(op0Var, AtomicValue.class) + ").longValue();", true);
        compiler.declare(Long.TYPE, endVar, "((NumericValue)" + compiler.cast(op1Var, AtomicValue.class) + ").longValue();", true);
        String intVar = "i" + n;
        String boxedVar = "ival" + n;
        compiler.emit("if (" + startVar + " <= " + endVar + ") {");
        compiler.emit("for (long " + intVar + "=" + startVar + "; " + intVar + "<=" + endVar + "; " + intVar + "++) {");
        compiler.declare(Int64Value.class, boxedVar, "Int64Value.makeIntegerValue(" + intVar + ")", true);
        action.compileAction(compiler, boxedVar);
        closers += 2;
        for (int i = 0; i < closers; ++i) {
            compiler.emit("}");
        }
    }
}

