/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaAssignment;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.QuantifiedExpression;

public class QuantifiedExpressionCompiler
extends ToBooleanCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        String jexp;
        final QuantifiedExpression exp = (QuantifiedExpression)expr;
        final int n = compiler.getUniqueNumber();
        String resultVar = result.getVariableName();
        String string = jexp = exp.getOperator() == 31 ? "false" : "true";
        if (result instanceof JavaDeclaration) {
            compiler.declare(Boolean.TYPE, resultVar, jexp, false);
            result = new JavaAssignment(Boolean.TYPE, resultVar);
        } else if (result instanceof JavaAssignment) {
            compiler.assign(resultVar, jexp);
        }
        final ReturnAction result2 = result;
        LoopAction loopAction = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.setXPathVariableName(exp.getLocalSlotNumber(), itemVar);
                String satisfiesVar = compiler.compileToEffectiveBooleanValue(exp.getAction(), new JavaDeclaration(Boolean.TYPE, "satis" + n));
                compiler.emit("if (" + (exp.getOperator() == 31 ? "" : "!") + satisfiesVar + ") {");
                compiler.emit(result2.output(compiler, exp.getOperator() == 31 ? "true" : "false"));
                compiler.emit("break;");
                compiler.emit("}");
            }
        };
        compiler.compileAsLoop(exp.getSequence(), loopAction);
        return result2.getVariableName();
    }
}

