/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.QNameFn;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class QNameFnCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        String lexVar;
        QNameFn exp = (QNameFn)expr;
        Expression nsArg = exp.getArguments()[0];
        Expression lexArg = exp.getArguments()[1];
        Value lexVal = lexArg instanceof Literal ? ((Literal)lexArg).getValue() : null;
        int n = compiler.getUniqueNumber();
        String nsVar = compiler.compileToCharSequence(nsArg);
        if (!this.isString(nsVar, compiler) && !nsVar.equals("null")) {
            nsVar = nsVar + ".toString()";
        }
        if (!this.isString(lexVar = compiler.compileToCharSequence(lexArg), compiler) && !lexVar.equals("null")) {
            lexVar = lexVar + ".toString()";
        }
        String partsVar = "parts" + n;
        String resultVar = "qname" + n;
        String checkerVar = "checker" + n;
        compiler.declare(NameChecker.class, checkerVar, "config.getNameChecker()", true);
        String partsExp = checkerVar + ".checkQNameParts(" + lexVar + ")";
        if (lexVal instanceof StringValue) {
            try {
                String[] parts = compiler.getConfiguration().getNameChecker().getQNameParts(((StringValue)lexVal).getStringValueCS());
                compiler.declare(QNameValue.class, resultVar, "new QNameValue(" + CompilerService.javaEscape(parts[0]) + ", " + nsVar + ", " + CompilerService.javaEscape(parts[1]) + ", " + "BuiltInAtomicType.QNAME, " + "config.getNameChecker())", true);
                return resultVar;
            }
            catch (QNameException err) {
                // empty catch block
            }
        }
        compiler.declare(String[].class, partsVar, partsExp, true);
        compiler.declare(QNameValue.class, resultVar, "new QNameValue(" + partsVar + "[0], " + nsVar + ", " + partsVar + "[1], " + "BuiltInAtomicType.QNAME, " + checkerVar + ")", true);
        return resultVar;
    }

    private boolean isString(String var, CompilerService compiler) {
        return var.charAt(0) == '\"' || compiler.isInstance(var, String.class) || var.endsWith(".getStringValue()");
    }
}

